/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.cmd.function.CallDepthChangeInfo;
import ghidra.app.cmd.function.RemoveStackDepthChangeCommand;
import ghidra.app.cmd.function.SetFunctionPurgeCommand;
import ghidra.app.cmd.function.SetStackDepthChangeCommand;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.util.HelpLocation;

class SetStackDepthChangeAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    SetStackDepthChangeAction(FunctionPlugin plugin) {
        super("Set Stack Depth Change", plugin.getName());
        this.funcPlugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Function", "Set Stack Depth Change..."}, null, "Function"));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Program program = context.getProgram();
        Address address = context.getAddress();
        Instruction instr = program.getListing().getInstructionAt(address);
        int oldStackDepthChange = 0;
        Address callToAddress = this.getFunctionCallAddress(instr);
        Integer change = CallDepthChangeInfo.getStackDepthChange(program, address);
        if (change != null) {
            oldStackDepthChange = change;
        } else {
            FunctionManager functionMgr = program.getFunctionManager();
            Function toFunction = callToAddress != null ? functionMgr.getFunctionAt(callToAddress) : null;
            Function func = functionMgr.getFunctionContaining(address);
            if (toFunction != null) {
                oldStackDepthChange = -toFunction.getStackPurgeSize();
            } else if (func != null) {
                CallDepthChangeInfo callInfo = new CallDepthChangeInfo(func);
                if (instr != null && (oldStackDepthChange = callInfo.getInstructionStackDepthChange(instr)) == Integer.MAX_VALUE) {
                    oldStackDepthChange = 0;
                }
            }
        }
        String title = "Set Stack Depth Change at " + address.toString();
        NumberInputDialog dialog = new NumberInputDialog(title, "Stack Depth Change", Integer.valueOf(oldStackDepthChange), Integer.MIN_VALUE, Integer.MAX_VALUE, false);
        if (!dialog.show()) {
            return;
        }
        int stackDepthChange = dialog.getValue();
        this.setStackDepthChange(program, address, stackDepthChange, callToAddress);
    }

    private Address getFunctionCallAddress(Instruction instr) {
        if (instr != null && instr.getFlowType().isCall()) {
            Reference[] refs;
            Program program = instr.getProgram();
            FunctionManager functionMgr = program.getFunctionManager();
            for (Reference ref : refs = program.getReferenceManager().getReferencesFrom(instr.getMinAddress())) {
                Address toAddr = ref.getToAddress();
                if (functionMgr.getFunctionAt(toAddr) == null) continue;
                return toAddr;
            }
        }
        return null;
    }

    private void setStackDepthChange(Program program, Address address, int newStackDepthChange, Address callToAddress) {
        if (callToAddress == null) {
            this.setStackDepthChange(program, address, newStackDepthChange);
            return;
        }
        int result = this.showPurgeQuestionDialog(this.funcPlugin.getTool(), address, callToAddress);
        switch (result) {
            case 1: {
                this.setStackDepthChange(program, address, newStackDepthChange);
                break;
            }
            case 2: {
                this.setFunctionPurge(program, address, newStackDepthChange, callToAddress);
                break;
            }
        }
    }

    private void setFunctionPurge(Program program, Address fromAddress, int newFunctionPurgeSize, Address callToAddress) {
        Function function = program.getFunctionManager().getFunctionAt(callToAddress);
        if (function == null) {
            return;
        }
        SetFunctionPurgeCommand purgeCmd = new SetFunctionPurgeCommand(function, newFunctionPurgeSize);
        Integer dephtChange = CallDepthChangeInfo.getStackDepthChange(program, fromAddress);
        if (dephtChange != null) {
            CompoundCmd compoundCmd = new CompoundCmd("Set Function Purge via StackDepthChange");
            compoundCmd.add((Command)new RemoveStackDepthChangeCommand(program, fromAddress));
            compoundCmd.add((Command)purgeCmd);
            this.funcPlugin.execute(program, (Command)compoundCmd);
        } else {
            this.funcPlugin.execute(program, purgeCmd);
        }
    }

    private int showPurgeQuestionDialog(PluginTool tool, Address currentAddress, Address functionAddress) {
        String message = "If this function changes the stack depth (or purge) the same for all calls to the function,\nthen you should globally set the function purge which affects all calls to the function.\n \nIf each call to the function affects the stack depth differently, then you should\nlocally set the stack depth change at the current Call instruction only.\n \n \nChoose Global to set the function purge for the Function at " + functionAddress.toString() + ".\nChoose Local to set the stack depth change for this call only at " + currentAddress.toString() + ".";
        StackChangeOptionDialog dialog = new StackChangeOptionDialog(message);
        dialog.show();
        return dialog.getResult();
    }

    private void setStackDepthChange(Program program, Address address, int newStackDepthChange) {
        this.funcPlugin.execute(program, new SetStackDepthChangeCommand(program, address, newStackDepthChange));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        Address address = context.getAddress();
        return !context.hasSelection() && address != null;
    }

    private class StackChangeOptionDialog
    extends OptionDialog {
        StackChangeOptionDialog(String message) {
            super("Stack Depth Change or Function Purge?", message, "Local", "Global", 3, null, true);
            this.setHelpLocation(new HelpLocation(SetStackDepthChangeAction.this.funcPlugin.getName(), "Set_Stack_Depth_Change"));
        }
    }
}

