/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.OptionDialog;
import docking.widgets.tree.GTree;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeTreeNode;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import java.awt.Component;
import java.io.IOException;
import javax.swing.tree.TreePath;

public class DeleteArchiveAction
extends DockingAction {
    public DeleteArchiveAction(DataTypeManagerPlugin plugin) {
        super("Delete Archive", plugin.getName());
        this.setPopupMenuData(new MenuData(new String[]{"Delete Archive"}, null, "Edit"));
        this.setKeyBindingData(new KeyBindingData(127, 0));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return false;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        if (!(node instanceof FileArchiveNode)) {
            return false;
        }
        return ((ArchiveNode)node).isModifiable();
    }

    public boolean isAddToPopup(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        TreePath[] selectionPaths = gtree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return false;
        }
        DataTypeTreeNode node = (DataTypeTreeNode)((Object)selectionPaths[0].getLastPathComponent());
        if (!(node instanceof FileArchiveNode)) {
            return false;
        }
        return node instanceof FileArchiveNode;
    }

    public void actionPerformed(ActionContext context) {
        TreePath[] selectionPaths;
        FileArchiveNode node;
        GTree gTree = (GTree)context.getContextObject();
        if (OptionDialog.showOptionDialogWithCancelAsDefaultButton((Component)gTree, (String)"Confirm Delete Operation", (String)("<html><b>Are you sure you want to delete archive: " + HTMLUtilities.escapeHTML((String)(node = (FileArchiveNode)((Object)(selectionPaths = gTree.getSelectionPaths())[0].getLastPathComponent())).getName()) + "?<br><br><font color=\"red\">(WARNING: This action will permanently delete the file from disk.)</font></b>"), (String)"Yes", (int)3) != 1) {
            return;
        }
        try {
            ((FileArchive)node.getArchive()).delete();
        }
        catch (IOException e1) {
            Msg.showError((Object)((Object)this), null, (String)"Error", (Object)"Error deleting data type archive.", (Throwable)e1);
        }
    }
}

