/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.module;

import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.NotFoundException;

public class ReorderModuleCmd
implements Command {
    private String moduleName;
    private String childName;
    private int index;
    private String statusMsg;
    private String treeName;

    public ReorderModuleCmd(String treeName, String parentModuleName, String childName, int index) {
        this.treeName = treeName;
        this.moduleName = parentModuleName;
        this.childName = childName;
        this.index = index;
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        Listing listing = program.getListing();
        ProgramModule m = listing.getModule(this.treeName, this.moduleName);
        try {
            m.moveChild(this.childName, this.index);
            return true;
        }
        catch (NotFoundException e) {
            this.statusMsg = e.getMessage();
            return false;
        }
    }

    public String getStatusMsg() {
        return this.statusMsg;
    }

    public String getName() {
        return "Reorder";
    }
}

