/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.internal.GTreeSelectionModel;
import docking.widgets.tree.support.GTreeSelectionEvent;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;

public class GTreeSelectNodeByNameTask
extends GTreeTask {
    private final String[] names;
    private final JTree jTree;
    private GTreeSelectionEvent.EventOrigin origin;

    public GTreeSelectNodeByNameTask(GTree gTree, JTree jTree, String[] names, GTreeSelectionEvent.EventOrigin origin) {
        super(gTree);
        this.jTree = jTree;
        this.names = names;
        this.origin = origin;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Selecting paths");
        GTreeNode node = this.tree.getViewRoot();
        String rootName = this.names[0];
        if (!node.getName().equals(rootName)) {
            Msg.debug((Object)((Object)this), (Object)("When selecting paths by name the first path element must be the name of the root node - path: " + StringUtils.join((Object[])this.names, (char)'.')));
            return;
        }
        for (int i = 1; i < this.names.length; ++i) {
            monitor.checkCanceled();
            node = this.findNodeByName(node, this.names[i], monitor);
            if (node != null) continue;
            Msg.debug((Object)((Object)this), (Object)("Could not find node to select - path: " + StringUtils.join((Object[])this.names, (char)'.')));
            return;
        }
        this.selectPath(node.getTreePath(), monitor);
    }

    private GTreeNode findNodeByName(GTreeNode node, String name, TaskMonitor monitor) throws CancelledException {
        for (GTreeNode child : node.getChildren()) {
            monitor.checkCanceled();
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    private void selectPath(TreePath treePath, TaskMonitor monitor) {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            GTreeSelectionModel selectionModel = this.tree.getGTSelectionModel();
            selectionModel.setSelectionPaths(new TreePath[]{treePath}, this.origin);
            this.jTree.scrollPathToVisible(treePath);
        });
    }
}

