/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.fieldpanel;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import java.math.BigInteger;
import java.util.Iterator;

public class LayoutModelIterator
implements Iterator<Layout> {
    private LayoutModel layoutModel;
    private BigInteger index;
    private BigInteger lastIndex;

    public LayoutModelIterator(LayoutModel layoutModel) {
        this(layoutModel, BigInteger.ZERO);
    }

    public LayoutModelIterator(LayoutModel layoutModel, BigInteger startIndex) {
        this.layoutModel = layoutModel;
        this.index = startIndex;
    }

    public BigInteger getIndex() {
        return this.lastIndex;
    }

    public BigInteger getNextIndex() {
        return this.layoutModel.getIndexAfter(this.lastIndex);
    }

    public BigInteger getPreviousIndex() {
        return this.layoutModel.getIndexBefore(this.lastIndex);
    }

    @Override
    public boolean hasNext() {
        return this.index != null;
    }

    @Override
    public Layout next() {
        Layout result = this.layoutModel.getLayout(this.index);
        this.lastIndex = this.index;
        this.index = this.layoutModel.getIndexAfter(this.index);
        return result;
    }
}

