/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.cpio;

import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.cpio.CpioFileSystem;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.factory.GFileSystemFactoryByteProvider;
import ghidra.formats.gfilesystem.factory.GFileSystemProbeBytesOnly;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;

public class CpioFileSystemFactory
implements GFileSystemFactoryByteProvider<CpioFileSystem>,
GFileSystemProbeBytesOnly {
    public CpioFileSystem create(FSRLRoot targetFSRL, ByteProvider byteProvider, FileSystemService fsService, TaskMonitor monitor) throws IOException, CancelledException {
        CpioFileSystem fs = new CpioFileSystem(targetFSRL, byteProvider, fsService, monitor);
        return fs;
    }

    public int getBytesRequired() {
        return 6;
    }

    public boolean probeStartBytes(FSRL containerFSRL, byte[] startBytes) {
        return CpioArchiveInputStream.matches((byte[])startBytes, (int)startBytes.length);
    }
}

