/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatree;

import docking.widgets.tree.GTreeNode;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.main.datatree.DomainFolderNode;
import ghidra.framework.model.DomainFileFilter;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ServerInfo;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class DomainFolderRootNode
extends DomainFolderNode {
    private static final ImageIcon CLOSED_PROJECT = ResourceManager.loadImage((String)"images/closedSmallFolder.png");
    private static final ImageIcon OPEN_PROJECT = ResourceManager.loadImage((String)"images/openSmallFolder.png");
    private String projectName;
    private String toolTipText;

    DomainFolderRootNode(String projectName, DomainFolder rootFolder, ProjectData projectData, DomainFileFilter filter) {
        super(rootFolder, filter);
        this.projectName = projectName;
        this.toolTipText = this.getToolTip(projectData);
    }

    @Override
    public String getName() {
        if (this.projectName == null) {
            return "NO ACTIVE PROJECT";
        }
        return this.projectName;
    }

    void setName(String newName) {
        this.projectName = newName;
        this.fireNodeChanged(null, (GTreeNode)this);
    }

    @Override
    public String getToolTip() {
        return this.toolTipText;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_PROJECT : CLOSED_PROJECT;
    }

    private String getToolTip(ProjectData projectData) {
        RepositoryAdapter repository = projectData.getRepository();
        File dir = projectData.getProjectLocator().getProjectDir();
        Object toolTip = dir.getAbsolutePath();
        if (!this.getDomainFolder().isInWritableProject() && repository != null) {
            ServerInfo info = repository.getServerInfo();
            Object serverName = "";
            if (info != null) {
                serverName = info.getServerName() + ", ";
            }
            toolTip = (String)toolTip + " [" + (String)serverName + repository.getName() + "]";
        }
        return toolTip;
    }
}

