/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms.sugiyama;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.sugiyama.AccumulatorTree;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LE;
import org.jungrapht.visualization.layout.algorithms.sugiyama.LV;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelCross<V, E> {
    private static final Logger log = LoggerFactory.getLogger(LevelCross.class);
    private List<LE<V, E>> edges;
    private int levelSize;
    private int levelRank;
    private int successorLevelSize;
    private int successorLevelRank;
    private AccumulatorTree levelTree;
    private AccumulatorTree successorTree;

    public LevelCross(Graph<LV<V>, LE<V, E>> graph, int levelSize, int levelRank, int successorLevelSize, int successorLevelRank) {
        this(new ArrayList<LE<V, E>>(graph.edgeSet()), levelSize, levelRank, successorLevelSize, successorLevelRank);
    }

    public LevelCross(List<LE<V, E>> edgeList, int levelSize, int levelRank, int successorLevelSize, int successorLevelRank) {
        this.edges = edgeList;
        this.levelSize = levelSize;
        this.levelRank = levelRank;
        this.successorLevelSize = successorLevelSize;
        this.successorLevelRank = successorLevelRank;
        this.levelTree = new AccumulatorTree(levelSize);
        this.successorTree = new AccumulatorTree(successorLevelSize);
    }

    public AccumulatorTree getLevelTree() {
        return this.levelTree;
    }

    public AccumulatorTree getSuccessorTree() {
        return this.successorTree;
    }

    boolean isTop(LE<V, E> edge) {
        return edge.getSource().getIndex() < edge.getTarget().getIndex();
    }

    boolean isBottom(LE<V, E> edge) {
        return edge.getSource().getIndex() > edge.getTarget().getIndex();
    }

    boolean isPair(LE<V, E> edge) {
        return edge.getSource().getIndex() == edge.getTarget().getIndex();
    }

    boolean isRight(LE<V, E> edge, int sweepPos) {
        return edge.getSource().getIndex() == sweepPos && this.isTop(edge) || edge.getTarget().getIndex() == sweepPos && this.isBottom(edge);
    }

    boolean isTrailing(LE<V, E> edge, int sweepPos) {
        return edge.getSource().getIndex() < sweepPos && sweepPos < edge.getTarget().getIndex() || edge.getTarget().getIndex() < sweepPos && sweepPos < edge.getSource().getIndex();
    }

    boolean isTrailingTop(LE<V, E> edge, int sweepPos) {
        return edge.getSource().getIndex() < sweepPos && sweepPos < edge.getTarget().getIndex();
    }

    boolean isTrailingBottom(LE<V, E> edge, int sweepPos) {
        return edge.getTarget().getIndex() < sweepPos && sweepPos < edge.getSource().getIndex();
    }

    public int levelCross() {
        int max = Arrays.stream(this.levelTree.tree).max().getAsInt();
        if (max != 0) {
            throw new IllegalArgumentException("max " + max + " should be 0");
        }
        ArrayList<LE> rightTop = new ArrayList<LE>();
        ArrayList<LE> rightBottom = new ArrayList<LE>();
        ArrayList<LE> topTrailing = new ArrayList<LE>();
        ArrayList<LE> bottomTrailing = new ArrayList<LE>();
        int count = 0;
        for (int sweepPosition = 0; sweepPosition < Math.min(this.levelSize, this.successorLevelSize); ++sweepPosition) {
            for (LE edge : topTrailing) {
                if (edge.getTarget().getIndex() != sweepPosition) continue;
                this.successorTree.subtractEdge(edge.getTarget().getIndex());
            }
            for (LE edge : bottomTrailing) {
                if (edge.getSource().getIndex() != sweepPosition) continue;
                this.levelTree.subtractEdge(edge.getSource().getIndex());
            }
            for (LE edge : rightTop) {
                if (!this.isTrailingTop(edge, sweepPosition)) continue;
                topTrailing.add(edge);
                this.successorTree.addEdge(edge.getTarget().getIndex());
            }
            for (LE edge : rightBottom) {
                if (!this.isTrailingBottom(edge, sweepPosition)) continue;
                bottomTrailing.add(edge);
                this.levelTree.addEdge(edge.getSource().getIndex());
            }
            List filteredEdges = this.edges.stream().filter(e -> e.getSource().getRank() == this.levelRank).filter(e -> e.getTarget().getRank() == this.successorLevelRank).collect(Collectors.toList());
            int pair = 0;
            int Rt = 0;
            int Rb = 0;
            int same = 0;
            rightTop.clear();
            rightBottom.clear();
            int sweepPos = sweepPosition;
            List topEdges = this.edges.stream().filter(e -> this.levelRank == e.getSource().getRank()).filter(e -> e.getSource().getIndex() == sweepPos).collect(Collectors.toList());
            for (LE edge : topEdges) {
                int Li = sweepPosition;
                int x = edge.getTarget().getIndex();
                if (this.isRight(edge, sweepPosition)) {
                    rightTop.add(edge);
                    ++Rt;
                } else if (this.isPair(edge)) {
                    ++pair;
                }
                same += this.successorTree.countEdges(x, this.successorTree.last);
            }
            int trb = this.levelTree.tree[0];
            int trt = this.successorTree.tree[0];
            List bottomEdges = this.edges.stream().filter(e -> this.successorLevelRank == e.getTarget().getRank()).filter(e -> e.getTarget().getIndex() == sweepPos).collect(Collectors.toList());
            for (LE edge : bottomEdges) {
                int x = edge.getSource().getIndex();
                int Mi = sweepPosition;
                if (!this.isRight(edge, sweepPosition)) continue;
                rightBottom.add(edge);
                ++Rb;
                same += this.levelTree.countEdges(x, this.levelTree.last);
            }
            count += trt * Rb + trb * (Rt + pair) + Rt * Rb + same;
        }
        return count;
    }

    public String toString() {
        return "LevelCross{\nedges=" + this.edges + "\nlevelSize=" + this.levelSize + "\nsuccessorLevelSize=" + this.successorLevelSize + "\nlevelRank=" + this.levelRank + "\nsuccessorLevelRank=" + this.successorLevelRank + "\nlevelTree=" + this.levelTree + "\nsuccessorTree=" + this.successorTree + "}";
    }
}

