/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Collections2;
import generic.CatenatedCollection;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.AbstractDBTraceSymbolSingleTypeWithAddressView;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.database.symbol.DBTraceSymbolMultipleTypesView;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbolWithAddressView;
import ghidra.util.LockHold;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

public class DBTraceSymbolMultipleTypesWithAddressView<T extends AbstractDBTraceSymbol>
extends DBTraceSymbolMultipleTypesView<T>
implements TraceSymbolWithAddressView<T> {
    public DBTraceSymbolMultipleTypesWithAddressView(DBTraceSymbolManager manager, Collection<? extends AbstractDBTraceSymbolSingleTypeWithAddressView<? extends T>> parts) {
        super(manager, parts);
    }

    @SafeVarargs
    public DBTraceSymbolMultipleTypesWithAddressView(DBTraceSymbolManager manager, AbstractDBTraceSymbolSingleTypeWithAddressView<? extends T> ... parts) {
        super(manager, parts);
    }

    protected Collection<? extends AbstractDBTraceSymbolSingleTypeWithAddressView<? extends T>> getParts() {
        return this.parts;
    }

    @Override
    public T getChildWithNameAt(String name, Address address, TraceNamespaceSymbol parent) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            for (AbstractDBTraceSymbolSingleTypeWithAddressView<T> p : this.getParts()) {
                T symbol = p.getChildWithNameAt(name, address, parent);
                if (symbol == null) continue;
                T t = symbol;
                return t;
            }
            Iterator<AbstractDBTraceSymbolSingleTypeWithAddressView<T>> iterator = null;
            return (T)iterator;
        }
    }

    @Override
    public Collection<? extends T> getIntersecting(AddressRange range, boolean includeDynamicSymbols) {
        return new CatenatedCollection(Collections2.transform(this.getParts(), p -> p.getIntersecting(range, includeDynamicSymbols)));
    }

    @Override
    public Collection<? extends T> getAt(Address address, boolean includeDynamicSymbols) {
        return this.getIntersecting((AddressRange)new AddressRangeImpl(address, address), includeDynamicSymbols);
    }
}

