/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.symbol;

import com.google.common.collect.Range;
import db.DBRecord;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SymbolType;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.symbol.AbstractDBTraceSymbol;
import ghidra.trace.database.symbol.DBTraceSymbolManager;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.Collection;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceNamespaceSymbol
extends AbstractDBTraceSymbol
implements TraceNamespaceSymbol {
    protected static final String TABLE_NAME = "Namespaces";
    protected final AddressSet allAddresses;

    public DBTraceNamespaceSymbol(DBTraceSymbolManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(manager, store, record);
        this.allAddresses = manager.trace.getBaseAddressFactory().getAddressSet();
    }

    @Override
    protected DBTraceNamespaceSymbol checkCircular(DBTraceNamespaceSymbol newParent) throws CircularDependencyException {
        DBTraceNamespaceSymbol global = this.manager.getGlobalNamespace();
        DBTraceNamespaceSymbol p = newParent;
        while (p != global) {
            if (p == this) {
                throw new CircularDependencyException();
            }
            p = p.parent;
        }
        return super.checkCircular(newParent);
    }

    @Override
    public Range<Long> getLifespan() {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        Range<Long> range = super.getLifespan();
        if (range != null) {
            min = DBTraceUtils.lowerEndpoint(range);
            max = DBTraceUtils.upperEndpoint(range);
        }
        for (AbstractDBTraceSymbol abstractDBTraceSymbol : this.getChildren()) {
            range = abstractDBTraceSymbol.getLifespan();
            if (range == null) continue;
            min = Math.min(min, DBTraceUtils.lowerEndpoint(range));
            max = Math.min(max, DBTraceUtils.upperEndpoint(range));
        }
        if (min > max) {
            return null;
        }
        return DBTraceUtils.toRange(min, max);
    }

    @Override
    public AddressSet getAddressSet() {
        if (this.isGlobal()) {
            return this.allAddresses;
        }
        AddressSet result = super.getAddressSet();
        return result;
    }

    public SymbolType getSymbolType() {
        if (this.parentID == -1L) {
            return SymbolType.GLOBAL;
        }
        return SymbolType.NAMESPACE;
    }

    public AddressSetView getBody() {
        return this.getAddressSet();
    }

    public void setParentNamespace(Namespace parentNamespace) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.setNamespace(parentNamespace);
    }

    public boolean setPrimary() {
        return false;
    }

    public Collection<? extends AbstractDBTraceSymbol> getChildren() {
        return this.manager.allSymbols.getChildren(this);
    }

    @Override
    public boolean delete() {
        boolean success = true;
        for (AbstractDBTraceSymbol abstractDBTraceSymbol : this.getChildren()) {
            success &= abstractDBTraceSymbol.delete();
        }
        if (success) {
            super.delete();
        }
        return success;
    }

    protected void doGetPath(ArrayList<String> list) {
        if (this.parent != this.manager.globalNamespace) {
            this.parent.doGetPath(list);
        }
        list.add(this.name);
    }

    public boolean isPrimary() {
        return this.isGlobal();
    }
}

