/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.map;

import com.google.common.collect.Range;
import db.BinaryField;
import db.DBHandle;
import db.DBRecord;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMap;
import ghidra.trace.database.map.DBTraceAddressSnapRangePropertyMapTree;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.map.TracePropertyMap;
import ghidra.util.LockHold;
import ghidra.util.ObjectStorage;
import ghidra.util.ObjectStorageStreamAdapter;
import ghidra.util.Saveable;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.DBOpenMode;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public abstract class AbstractDBTracePropertyMap<T, DR extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<T>>
extends DBTraceAddressSnapRangePropertyMap<T, DR>
implements TracePropertyMap<T> {
    public AbstractDBTracePropertyMap(String name, DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, Class<DR> dataType, DBTraceAddressSnapRangePropertyMap.DBTraceAddressSnapRangePropertyMapDataFactory<T, DR> dataFactory) throws IOException, VersionException {
        super(name, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, dataType, dataFactory);
    }

    protected void makeWay(Map.Entry<TraceAddressSnapRange, T> entry, Range<Long> span) {
        this.makeWay((DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData)entry.getKey(), span);
    }

    protected void makeWay(DR data, Range<Long> span) {
        DBTraceUtils.makeWay(data, span, (d, s) -> d.doSetLifespan((Range<Long>)s), d -> this.deleteData(d));
    }

    @Override
    public void set(Range<Long> lifespan, Address address, T value) {
        this.put(address, lifespan, value);
    }

    @Override
    public T get(long snap, Address address) {
        return (T)this.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.at(address, snap)).firstValue();
    }

    @Override
    public void clear(Range<Long> span, AddressRange range) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (Map.Entry entry : this.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(range, span)).entries()) {
                this.makeWay((DR)entry, span);
            }
        }
    }

    @Override
    public T put(TraceAddressSnapRange shape, T value) {
        assert (shape.getRange().getLength() == 1L);
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            for (Map.Entry entry : this.reduce(DBTraceAddressSnapRangePropertyMapTree.TraceAddressSnapRangeQuery.intersecting(shape)).entries()) {
                this.makeWay((DR)entry, shape.getLifespan());
            }
            Iterator<Object> iterator = super.put(shape, value);
            return (T)iterator;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceVoidPropertyMapEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<Void> {
        public DBTraceVoidPropertyMapEntry(DBTraceAddressSnapRangePropertyMapTree<Void, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(Void value) {
        }

        protected Void getRecordValue() {
            return null;
        }
    }

    public static class DBTraceVoidPropertyMap
    extends AbstractDBTracePropertyMap<Void, DBTraceVoidPropertyMapEntry> {
        public DBTraceVoidPropertyMap(String name, DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
            super(name, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceVoidPropertyMapEntry.class, DBTraceVoidPropertyMapEntry::new);
        }

        @Override
        public Class<Void> getValueClass() {
            return Void.class;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceStringPropertyMapEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<String> {
        static final String VALUE_COLUMN_NAME = "Value";
        @DBAnnotatedColumn(value="Value")
        static DBObjectColumn VALUE_COLUMN;
        @DBAnnotatedField(column="Value")
        String value;

        public DBTraceStringPropertyMapEntry(DBTraceAddressSnapRangePropertyMapTree<String, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(String value) {
            assert (value != null);
            this.value = value;
            this.update(VALUE_COLUMN);
        }

        protected String getRecordValue() {
            return this.value;
        }
    }

    public static class DBTraceStringPropertyMap
    extends AbstractDBTracePropertyMap<String, DBTraceStringPropertyMapEntry> {
        public DBTraceStringPropertyMap(String name, DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
            super(name, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceStringPropertyMapEntry.class, DBTraceStringPropertyMapEntry::new);
        }

        @Override
        public Class<String> getValueClass() {
            return String.class;
        }
    }

    public static class SaveableDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<Saveable, DBTraceSaveablePropertyMapEntry<?>, BinaryField> {
        public SaveableDBFieldCodec(Class<DBTraceSaveablePropertyMapEntry<?>> objectType, Field field, int column) {
            super(Saveable.class, objectType, BinaryField.class, field, column);
        }

        private byte[] encode(Saveable value) throws AssertionError {
            if (value == null) {
                return null;
            }
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ObjectStorageStreamAdapter objStorage = new ObjectStorageStreamAdapter(new ObjectOutputStream(os));
                value.save((ObjectStorage)objStorage);
                return os.toByteArray();
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
        }

        public void store(Saveable value, BinaryField f) {
            f.setBinaryData(this.encode(value));
        }

        protected void doStore(DBTraceSaveablePropertyMapEntry<?> obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            record.setBinaryData(this.column, this.encode((Saveable)this.getValue((DBAnnotatedObject)obj)));
        }

        protected void doLoad(DBTraceSaveablePropertyMapEntry<?> obj, DBRecord record) throws IllegalArgumentException, IllegalAccessException {
            byte[] enc = record.getBinaryData(this.column);
            if (enc == null) {
                this.setValue((DBAnnotatedObject)obj, null);
            }
            try {
                Saveable value = (Saveable)this.getValue((DBAnnotatedObject)obj);
                if (value == null) {
                    value = (Saveable)obj.valueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    this.setValue((DBAnnotatedObject)obj, value);
                }
                ObjectStorageStreamAdapter objStorage = new ObjectStorageStreamAdapter(new ObjectInputStream(new ByteArrayInputStream(enc)));
                value.restore((ObjectStorage)objStorage);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            catch (InstantiationException | SecurityException | InvocationTargetException e) {
                throw new RuntimeException("Could not instantiate saveable of type " + obj.valueClass);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Saveable must have a default constructor");
            }
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceSaveablePropertyMapEntry<T extends Saveable>
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<T> {
        static final String VALUE_COLUMN_NAME = "Value";
        @DBAnnotatedColumn(value="Value")
        static DBObjectColumn VALUE_COLUMN;
        @DBAnnotatedField(column="Value", codec=SaveableDBFieldCodec.class)
        T value;
        protected Class<T> valueClass;

        public DBTraceSaveablePropertyMapEntry(DBTraceAddressSnapRangePropertyMapTree<T, ?> tree, DBCachedObjectStore<?> store, DBRecord record, Class<T> valueClass) {
            super(tree, store, record);
            this.valueClass = valueClass;
        }

        protected void setRecordValue(T value) {
            assert (value != null);
            this.value = value;
            this.update(VALUE_COLUMN);
        }

        protected T getRecordValue() {
            return this.value;
        }
    }

    public static class DBTraceSaveablePropertyMap<T extends Saveable>
    extends AbstractDBTracePropertyMap<T, DBTraceSaveablePropertyMapEntry<T>> {
        protected final Class<T> valueClass;

        protected static <T extends Saveable> Class<DBTraceSaveablePropertyMapEntry<T>> getEntryClass(Class<T> valueClass) {
            return DBTraceSaveablePropertyMapEntry.class;
        }

        public DBTraceSaveablePropertyMap(String name, DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager, Class<T> valueClass) throws IOException, VersionException {
            super(name, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceSaveablePropertyMap.getEntryClass(valueClass), (t, s, r) -> new DBTraceSaveablePropertyMapEntry(t, s, r, valueClass));
            this.valueClass = valueClass;
        }

        @Override
        public Class<T> getValueClass() {
            return this.valueClass;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceLongPropertyMapEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<Long> {
        static final String VALUE_COLUMN_NAME = "Value";
        @DBAnnotatedColumn(value="Value")
        static DBObjectColumn VALUE_COLUMN;
        @DBAnnotatedField(column="Value")
        long value;

        public DBTraceLongPropertyMapEntry(DBTraceAddressSnapRangePropertyMapTree<Long, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(Long value) {
            assert (value != null);
            this.value = value;
            this.update(VALUE_COLUMN);
        }

        protected Long getRecordValue() {
            return this.value;
        }
    }

    public static class DBTraceLongPropertyMap
    extends AbstractDBTracePropertyMap<Long, DBTraceLongPropertyMapEntry> {
        public DBTraceLongPropertyMap(String name, DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
            super(name, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceLongPropertyMapEntry.class, DBTraceLongPropertyMapEntry::new);
        }

        @Override
        public Class<Long> getValueClass() {
            return Long.class;
        }
    }

    @DBAnnotatedObjectInfo(version=0)
    public static class DBTraceIntPropertyMapEntry
    extends DBTraceAddressSnapRangePropertyMapTree.AbstractDBTraceAddressSnapRangePropertyMapData<Integer> {
        static final String VALUE_COLUMN_NAME = "Value";
        @DBAnnotatedColumn(value="Value")
        static DBObjectColumn VALUE_COLUMN;
        @DBAnnotatedField(column="Value")
        int value;

        public DBTraceIntPropertyMapEntry(DBTraceAddressSnapRangePropertyMapTree<Integer, ?> tree, DBCachedObjectStore<?> store, DBRecord record) {
            super(tree, store, record);
        }

        protected void setRecordValue(Integer value) {
            assert (value != null);
            this.value = value;
            this.update(VALUE_COLUMN);
        }

        protected Integer getRecordValue() {
            return this.value;
        }
    }

    public static class DBTraceIntPropertyMap
    extends AbstractDBTracePropertyMap<Integer, DBTraceIntPropertyMapEntry> {
        public DBTraceIntPropertyMap(String name, DBHandle dbh, DBOpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws IOException, VersionException {
            super(name, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager, DBTraceIntPropertyMapEntry.class, DBTraceIntPropertyMapEntry::new);
        }

        @Override
        public Class<Integer> getValueClass() {
            return Integer.class;
        }
    }
}

