/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.modules;

import com.google.common.collect.Range;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.events.ProgramOpenedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceOpenedPluginEvent;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.app.plugin.core.debug.utils.DomainFolderChangeAdapter;
import ghidra.app.plugin.core.debug.utils.ProgramLocationUtils;
import ghidra.app.plugin.core.debug.utils.ProgramURLUtils;
import ghidra.app.services.DebuggerStaticMappingChangeListener;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgramManager;
import ghidra.async.AsyncDebouncer;
import ghidra.async.AsyncTimer;
import ghidra.framework.data.OpenedDomainFile;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.store.FileSystem;
import ghidra.generic.util.datastruct.TreeValueSortedMap;
import ghidra.generic.util.datastruct.ValueSortedMap;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.model.DefaultTraceLocation;
import ghidra.trace.model.DefaultTraceSnap;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.TraceSnap;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.modules.TraceStaticMapping;
import ghidra.trace.model.modules.TraceStaticMappingManager;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.util.TraceChangeType;
import ghidra.util.Msg;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.database.spatial.rect.Rectangle2D;
import ghidra.util.datastruct.ListenerSet;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

@PluginInfo(shortDescription="Debugger static mapping manager", description="Track and manage static mappings (program-trace relocations)", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={ProgramOpenedPluginEvent.class, ProgramClosedPluginEvent.class, TraceOpenedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={ProgramManager.class, DebuggerTraceManagerService.class}, servicesProvided={DebuggerStaticMappingService.class})
public class DebuggerStaticMappingServicePlugin
extends Plugin
implements DebuggerStaticMappingService,
DomainFolderChangeAdapter {
    private final Map<Trace, InfoPerTrace> trackedTraceInfo = new HashMap<Trace, InfoPerTrace>();
    private final Map<URL, InfoPerProgram> trackedProgramInfo = new HashMap<URL, InfoPerProgram>();
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private ProgramManager programManager;
    private final AutoService.Wiring autoWiring;
    private final Object lock = new Object();
    private final AsyncDebouncer<Void> changeDebouncer = new AsyncDebouncer(AsyncTimer.DEFAULT_TIMER, 100L);
    private final ListenerSet<DebuggerStaticMappingChangeListener> changeListeners = new ListenerSet(DebuggerStaticMappingChangeListener.class);
    private Set<Trace> affectedTraces = new HashSet<Trace>();
    private Set<Program> affectedPrograms = new HashSet<Program>();

    public DebuggerStaticMappingServicePlugin(PluginTool tool) {
        super(tool);
        this.autoWiring = AutoService.wireServicesProvidedAndConsumed((Plugin)this);
        this.changeDebouncer.addListener(this::fireChangeListeners);
        tool.getProject().getProjectData().addDomainFolderChangeListener((DomainFolderChangeListener)this);
    }

    protected void dispose() {
        this.tool.getProject().getProjectData().removeDomainFolderChangeListener((DomainFolderChangeListener)this);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListeners(Void v) {
        Set<Program> programs;
        Set<Trace> traces;
        Set<Trace> set = this.affectedTraces;
        synchronized (set) {
            traces = Collections.unmodifiableSet(this.affectedTraces);
            programs = Collections.unmodifiableSet(this.affectedPrograms);
            this.affectedTraces = new HashSet<Trace>();
            this.affectedPrograms = new HashSet<Program>();
        }
        ((DebuggerStaticMappingChangeListener)this.changeListeners.fire).mappingsChanged(traces, programs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceAffected(Trace trace) {
        Set<Trace> set = this.affectedTraces;
        synchronized (set) {
            this.affectedTraces.add(trace);
            this.changeDebouncer.contact(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programAffected(Program program) {
        Set<Trace> set = this.affectedTraces;
        synchronized (set) {
            this.affectedPrograms.add(program);
            this.changeDebouncer.contact(null);
        }
    }

    @Override
    public void addChangeListener(DebuggerStaticMappingChangeListener l) {
        this.changeListeners.add((Object)l);
    }

    @Override
    public void removeChangeListener(DebuggerStaticMappingChangeListener l) {
        this.changeListeners.remove((Object)l);
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramOpenedPluginEvent) {
            ProgramOpenedPluginEvent openedEvt = (ProgramOpenedPluginEvent)event;
            this.programOpened(openedEvt.getProgram());
        } else if (event instanceof ProgramClosedPluginEvent) {
            ProgramClosedPluginEvent closedEvt = (ProgramClosedPluginEvent)event;
            this.programClosed(closedEvt.getProgram());
        } else if (event instanceof TraceOpenedPluginEvent) {
            TraceOpenedPluginEvent openedEvt = (TraceOpenedPluginEvent)event;
            this.traceOpened(openedEvt.getTrace());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent closedEvt = (TraceClosedPluginEvent)event;
            this.traceClosed(closedEvt.getTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programOpened(Program program) {
        Object object = this.lock;
        synchronized (object) {
            if (program instanceof TraceProgramView) {
                return;
            }
            URL url = ProgramURLUtils.getUrlFromProgram(program);
            if (url == null) {
                return;
            }
            InfoPerProgram newInfo = new InfoPerProgram(program);
            InfoPerProgram mustBeNull = this.trackedProgramInfo.put(url, newInfo);
            assert (mustBeNull == null);
            for (InfoPerTrace info : this.trackedTraceInfo.values()) {
                if (!info.programOpened(program, newInfo)) continue;
                this.programAffected(program);
                this.traceAffected(info.trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void programClosed(Program program) {
        Object object = this.lock;
        synchronized (object) {
            if (program instanceof TraceProgramView) {
                return;
            }
            Iterator<InfoPerProgram> it = this.trackedProgramInfo.values().iterator();
            while (it.hasNext()) {
                InfoPerProgram infoPerProgram = it.next();
                if (infoPerProgram.program != program) continue;
                it.remove();
            }
            for (InfoPerTrace infoPerTrace : this.trackedTraceInfo.values()) {
                if (!infoPerTrace.programClosed(program)) continue;
                this.traceAffected(infoPerTrace.trace);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
        if (object instanceof Program) {
            Program program = (Program)object;
            Object object2 = this.lock;
            synchronized (object2) {
                this.programClosed(program);
                int i = ArrayUtils.indexOf((Object[])this.programManager.getAllOpenPrograms(), (Object)program);
                if (i >= 0) {
                    this.programOpened(program);
                }
            }
        }
    }

    private void doAffectedByTraceOpened(Trace trace) {
        for (InfoPerProgram info : this.trackedProgramInfo.values()) {
            if (!info.isMappedInTrace(trace)) continue;
            this.traceAffected(trace);
            this.programAffected(info.program);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceOpened(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            if (trace.isClosed()) {
                Msg.warn((Object)this, (Object)"Got traceOpened for a close trace");
                return;
            }
            InfoPerTrace newInfo = new InfoPerTrace(trace);
            InfoPerTrace mustBeNull = this.trackedTraceInfo.put(trace, newInfo);
            assert (mustBeNull == null);
            this.doAffectedByTraceOpened(trace);
        }
    }

    private void doAffectedByTraceClosed(Trace trace) {
        for (InfoPerProgram info : this.trackedProgramInfo.values()) {
            if (!info.traceClosed(trace)) continue;
            this.programAffected(info.program);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traceClosed(Trace trace) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace traceInfo = this.trackedTraceInfo.remove(trace);
            if (traceInfo == null) {
                Msg.warn((Object)this, (Object)"Got traceClosed without/before traceOpened");
                return;
            }
            traceInfo.dispose();
            this.doAffectedByTraceClosed(trace);
        }
    }

    @Override
    public void addMapping(TraceLocation from, ProgramLocation to, long length, boolean truncateExisting) throws TraceConflictedMappingException {
        Program tp = to.getProgram();
        if (tp instanceof TraceProgramView) {
            throw new IllegalArgumentException("Mapping destination cannot be a " + TraceProgramView.class.getSimpleName());
        }
        TraceStaticMappingManager manager = from.getTrace().getStaticMappingManager();
        URL toURL = ProgramURLUtils.getUrlFromProgram(tp);
        if (toURL == null) {
            this.noProject();
        }
        Address fromAddress = from.getAddress();
        Address toAddress = to.getByteAddress();
        long maxFromLengthMinus1 = fromAddress.getAddressSpace().getMaxAddress().subtract(fromAddress);
        long maxToLengthMinus1 = toAddress.getAddressSpace().getMaxAddress().subtract(toAddress);
        if (Long.compareUnsigned(length - 1L, maxFromLengthMinus1) > 0) {
            throw new IllegalArgumentException("Length would cause address overflow in trace");
        }
        if (Long.compareUnsigned(length - 1L, maxToLengthMinus1) > 0) {
            throw new IllegalArgumentException("Length would cause address overflow in program");
        }
        Address end = fromAddress.addWrap(length - 1L);
        AddressRangeImpl range = new AddressRangeImpl(fromAddress, end);
        Range fromLifespan = from.getLifespan();
        if (truncateExisting) {
            long truncEnd = DBTraceUtils.lowerEndpoint((Range)fromLifespan) - 1L;
            for (TraceStaticMapping existing : List.copyOf(manager.findAllOverlapping((AddressRange)range, fromLifespan))) {
                existing.delete();
                if (!fromLifespan.hasLowerBound() || Long.compare(existing.getStartSnap(), truncEnd) > 0) continue;
                manager.add(existing.getTraceAddressRange(), Range.closed((Comparable)Long.valueOf(existing.getStartSnap()), (Comparable)Long.valueOf(truncEnd)), existing.getStaticProgramURL(), existing.getStaticAddress());
            }
        }
        manager.add((AddressRange)range, fromLifespan, toURL, toAddress.toString(true));
    }

    protected static AddressRange clippedRange(Trace trace, String spaceName, long min, long max) {
        AddressSpace space = trace.getBaseAddressFactory().getAddressSpace(spaceName);
        if (space == null) {
            return null;
        }
        Address spaceMax = space.getMaxAddress();
        if (Long.compareUnsigned(min, spaceMax.getOffset()) > 0) {
            return null;
        }
        if (Long.compareUnsigned(max, spaceMax.getOffset()) > 0) {
            return new AddressRangeImpl(space.getAddress(min), spaceMax);
        }
        return new AddressRangeImpl(space.getAddress(min), space.getAddress(max));
    }

    @Override
    public void addIdentityMapping(Trace from, Program toProgram, Range<Long> lifespan, boolean truncateExisting) {
        try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)from, (String)"Add identity mappings", (boolean)false);){
            this.doAddIdentityMapping(from, toProgram, lifespan, truncateExisting);
            tid.commit();
        }
    }

    protected void doAddIdentityMapping(Trace from, Program toProgram, Range<Long> lifespan, boolean truncateExisting) {
        HashMap<String, Address> mins = new HashMap<String, Address>();
        HashMap<String, Address> maxs = new HashMap<String, Address>();
        for (AddressRange range : toProgram.getMemory().getAddressRanges()) {
            mins.compute(range.getAddressSpace().getName(), (n, min) -> {
                Address can = range.getMinAddress();
                if (min == null || can.compareTo(min) < 0) {
                    return can;
                }
                return min;
            });
            maxs.compute(range.getAddressSpace().getName(), (n, max) -> {
                Address can = range.getMaxAddress();
                if (max == null || can.compareTo(max) > 0) {
                    return can;
                }
                return max;
            });
        }
        for (String name : mins.keySet()) {
            AddressRange range = DebuggerStaticMappingServicePlugin.clippedRange(from, name, ((Address)mins.get(name)).getOffset(), ((Address)maxs.get(name)).getOffset());
            if (range == null) continue;
            try {
                this.addMapping((TraceLocation)new DefaultTraceLocation(from, null, lifespan, range.getMinAddress()), new ProgramLocation(toProgram, (Address)mins.get(name)), range.getLength(), truncateExisting);
            }
            catch (TraceConflictedMappingException e) {
                Msg.error((Object)this, (Object)("Could not add identity mapping " + range + ": " + e.getMessage()));
            }
        }
    }

    @Override
    public void addModuleMapping(TraceModule from, long length, Program toProgram, boolean truncateExisting) throws TraceConflictedMappingException {
        DefaultTraceLocation fromLoc = new DefaultTraceLocation(from.getTrace(), null, from.getLifespan(), from.getBase());
        ProgramLocation toLoc = new ProgramLocation(toProgram, toProgram.getImageBase());
        this.addMapping((TraceLocation)fromLoc, toLoc, length, truncateExisting);
    }

    @Override
    public void addModuleMappings(Collection<DebuggerStaticMappingService.ModuleMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        LinkedHashMap<Trace, Set> byTrace = new LinkedHashMap<Trace, Set>();
        for (DebuggerStaticMappingService.ModuleMapEntry moduleMapEntry : entries) {
            Set subCol = byTrace.computeIfAbsent(moduleMapEntry.getModule().getTrace(), t -> new LinkedHashSet());
            subCol.add(moduleMapEntry);
        }
        for (Map.Entry entry : byTrace.entrySet()) {
            Trace trace = (Trace)entry.getKey();
            UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Add module mappings", (boolean)false);
            try {
                this.doAddModuleMappings(trace, (Collection)entry.getValue(), monitor, truncateExisting);
                tid.commit();
            }
            finally {
                if (tid == null) continue;
                tid.close();
            }
        }
    }

    protected void doAddModuleMappings(Trace trace, Collection<DebuggerStaticMappingService.ModuleMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        for (DebuggerStaticMappingService.ModuleMapEntry ent : entries) {
            monitor.checkCanceled();
            try {
                DebuggerStaticMappingUtils.addModuleMapping(ent.getModule(), ent.getModuleRange().getLength(), ent.getProgram(), truncateExisting);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Could not add mapping " + ent + ": " + e.getMessage()));
            }
        }
    }

    @Override
    public void addSectionMappings(Collection<DebuggerStaticMappingService.SectionMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        LinkedHashMap<Trace, Set> byTrace = new LinkedHashMap<Trace, Set>();
        for (DebuggerStaticMappingService.SectionMapEntry sectionMapEntry : entries) {
            Set subCol = byTrace.computeIfAbsent(sectionMapEntry.getSection().getTrace(), t -> new LinkedHashSet());
            subCol.add(sectionMapEntry);
        }
        for (Map.Entry entry : byTrace.entrySet()) {
            Trace trace = (Trace)entry.getKey();
            UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)trace, (String)"Add section mappings", (boolean)false);
            try {
                this.doAddSectionMappings(trace, (Collection)entry.getValue(), monitor, truncateExisting);
                tid.commit();
            }
            finally {
                if (tid == null) continue;
                tid.close();
            }
        }
    }

    protected void doAddSectionMappings(Trace trace, Collection<DebuggerStaticMappingService.SectionMapEntry> entries, TaskMonitor monitor, boolean truncateExisting) throws CancelledException {
        for (DebuggerStaticMappingService.SectionMapEntry ent : entries) {
            monitor.checkCanceled();
            try {
                DebuggerStaticMappingUtils.addSectionMapping(ent.getSection(), ent.getProgram(), ent.getBlock(), truncateExisting);
            }
            catch (Exception e) {
                Msg.error((Object)this, (Object)("Could not add mapping " + ent + ": " + e.getMessage()));
            }
        }
    }

    protected <T> T noTraceInfo() {
        Msg.warn((Object)this, (Object)"The given trace is not open in this tool (or the service hasn't received and processed the open-trace event, yet)");
        return null;
    }

    protected <T> T noProgramInfo() {
        Msg.warn((Object)this, (Object)"The given program is not open in this tool (or the service hasn't received and processed the open-program event, yet)");
        return null;
    }

    protected <T> T noProject() {
        return DebuggerStaticMappingUtils.noProject(this);
    }

    protected InfoPerTrace requireTrackedInfo(Trace trace) {
        InfoPerTrace info = this.trackedTraceInfo.get(trace);
        if (info == null) {
            return (InfoPerTrace)((Object)this.noTraceInfo());
        }
        return info;
    }

    protected InfoPerProgram requireTrackedInfo(Program program) {
        URL url = ProgramURLUtils.getUrlFromProgram(program);
        if (url == null) {
            return (InfoPerProgram)this.noProject();
        }
        InfoPerProgram info = this.trackedProgramInfo.get(url);
        if (info == null) {
            return (InfoPerProgram)this.noProgramInfo();
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Program> getOpenMappedProgramsAtSnap(Trace trace, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            return info.getOpenMappedProgramsAtSnap(snap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramLocation getOpenMappedLocation(TraceLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(loc.getTrace());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedLocations(loc.getAddress(), (Range<Long>)loc.getLifespan());
        }
    }

    protected long getNonScratchSnap(TraceProgramView view) {
        return (Long)view.getViewport().getTop(s -> s >= 0L ? s : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramLocation getStaticLocationFromDynamic(ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            loc = ProgramLocationUtils.fixLocation(loc, true);
            TraceProgramView view = (TraceProgramView)loc.getProgram();
            Trace trace = view.getTrace();
            DefaultTraceLocation tloc = new DefaultTraceLocation(trace, null, Range.singleton((Comparable)Long.valueOf(this.getNonScratchSnap(view))), loc.getByteAddress());
            ProgramLocation mapped = this.getOpenMappedLocation((TraceLocation)tloc);
            if (mapped == null) {
                return null;
            }
            return ProgramLocationUtils.replaceAddress(loc, mapped.getProgram(), mapped.getByteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<TraceLocation> getOpenMappedLocations(ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(loc.getProgram());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedTraceLocations(loc.getByteAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TraceLocation getOpenMappedLocation(Trace trace, ProgramLocation loc, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(loc.getProgram());
            if (info == null) {
                return null;
            }
            return info.getOpenMappedTraceLocation(trace, loc.getByteAddress(), snap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProgramLocation getDynamicLocationFromStatic(TraceProgramView view, ProgramLocation loc) {
        Object object = this.lock;
        synchronized (object) {
            TraceLocation tloc = this.getOpenMappedLocation(view.getTrace(), loc, this.getNonScratchSnap(view));
            if (tloc == null) {
                return null;
            }
            return ProgramLocationUtils.replaceAddress(loc, (Program)view, tloc.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(Trace trace, AddressSetView set, long snap) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            return info.getOpenMappedViews(set, (Range<Long>)Range.singleton((Comparable)Long.valueOf(snap)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<TraceSnap, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(Program program, AddressSetView set) {
        Object object = this.lock;
        synchronized (object) {
            InfoPerProgram info = this.requireTrackedInfo(program);
            if (info == null) {
                return null;
            }
            return info.getOpenMappedViews(set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Program> openMappedProgramsInView(Trace trace, AddressSetView set, long snap, Set<Exception> failures) {
        Set<URL> urls;
        Object object = this.lock;
        synchronized (object) {
            InfoPerTrace info = this.requireTrackedInfo(trace);
            if (info == null) {
                return null;
            }
            urls = info.getMappedProgramURLsInView(set, (Range<Long>)Range.singleton((Comparable)Long.valueOf(snap)));
        }
        HashSet<Program> result = new HashSet<Program>();
        for (URL url : urls) {
            try {
                Program program = ProgramURLUtils.openHackedUpGhidraURL(this.programManager, this.tool.getProject(), url, 2);
                result.add(program);
            }
            catch (Exception e) {
                if (failures == null) {
                    throw e;
                }
                failures.add(e);
            }
        }
        return result;
    }

    protected String normalizePath(String path) {
        path = path.replace('\\', '/');
        while (path.startsWith(FileSystem.SEPARATOR)) {
            path = path.substring(1);
        }
        return path;
    }

    protected DomainFile resolve(DomainFolder folder, String path) {
        StringBuilder fullPath = new StringBuilder(folder.getPathname());
        if (!fullPath.toString().endsWith(FileSystem.SEPARATOR)) {
            fullPath.append('/');
        }
        fullPath.append(path);
        return folder.getProjectData().getFile(fullPath.toString());
    }

    public Set<DomainFile> doFindPrograms(String modulePath, DomainFolder folder) {
        while (folder != null) {
            DomainFile found = this.resolve(folder, modulePath);
            if (found != null) {
                return Set.of(found);
            }
            folder = folder.getParent();
        }
        return Set.of();
    }

    public Set<DomainFile> doFindProgramsByPathOrName(String modulePath, DomainFolder folder) {
        Set<DomainFile> found = this.doFindPrograms(modulePath, folder);
        if (!found.isEmpty()) {
            return found;
        }
        int idx = modulePath.lastIndexOf(FileSystem.SEPARATOR);
        if (idx == -1) {
            return Set.of();
        }
        found = this.doFindPrograms(modulePath.substring(idx + 1), folder);
        if (!found.isEmpty()) {
            return found;
        }
        return Set.of();
    }

    public Set<DomainFile> doFindProgramsByPathOrName(String modulePath, Project project) {
        return this.doFindProgramsByPathOrName(modulePath, project.getProjectData().getRootFolder());
    }

    @Override
    public Set<DomainFile> findProbableModulePrograms(TraceModule module) {
        DomainFile df = module.getTrace().getDomainFile();
        String modulePath = this.normalizePath(module.getName());
        if (df == null) {
            return this.doFindProgramsByPathOrName(modulePath, this.tool.getProject());
        }
        DomainFolder parent = df.getParent();
        if (parent == null) {
            return this.doFindProgramsByPathOrName(modulePath, this.tool.getProject());
        }
        return this.doFindProgramsByPathOrName(modulePath, parent);
    }

    protected void doCollectLibraries(ProjectData project, Program cur, Set<Program> col, TaskMonitor monitor) throws CancelledException {
        if (!col.add(cur)) {
            return;
        }
        ExternalManager externs = cur.getExternalManager();
        for (String extName : externs.getExternalLibraryNames()) {
            monitor.checkCanceled();
            Library lib = externs.getExternalLibrary(extName);
            String libPath = lib.getAssociatedProgramPath();
            if (libPath == null) continue;
            DomainFile libFile = project.getFile(libPath);
            if (libFile == null) {
                Msg.info((Object)this, (Object)("Referenced external program not found: " + libPath));
                continue;
            }
            try (OpenedDomainFile program = OpenedDomainFile.open(Program.class, (DomainFile)libFile, (TaskMonitor)monitor);){
                this.doCollectLibraries(project, (Program)program.content, col, monitor);
            }
            catch (ClassCastException e) {
                Msg.info((Object)this, (Object)("Referenced external program is not a program: " + libPath + " is " + libFile.getDomainObjectClass()));
            }
            catch (CancelledException | VersionException | IOException e) {
                Msg.info((Object)this, (Object)("Referenced external program could not be opened: " + (Exception)e));
            }
        }
    }

    @Override
    public Set<Program> collectLibraries(Program seed, TaskMonitor monitor) throws CancelledException {
        LinkedHashSet<Program> result = new LinkedHashSet<Program>();
        this.doCollectLibraries(seed.getDomainFile().getParent().getProjectData(), seed, result, monitor);
        return result;
    }

    @Override
    public PluginModuleMapProposal proposeModuleMap(TraceModule module, Program program) {
        return new PluginModuleMapProposal(module, program);
    }

    @Override
    public PluginModuleMapProposal proposeModuleMap(TraceModule module, Collection<? extends Program> programs) {
        double bestScore = -1.0;
        PluginModuleMapProposal bestMap = null;
        for (Program program : programs) {
            PluginModuleMapProposal map = this.proposeModuleMap(module, program);
            double score = map.computeScore();
            if (score == bestScore && this.programManager != null && this.programManager.getCurrentProgram() == program) {
                bestMap = map;
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestMap = map;
        }
        return bestMap;
    }

    @Override
    public Map<TraceModule, DebuggerStaticMappingService.ModuleMapProposal> proposeModuleMaps(Collection<? extends TraceModule> modules, Collection<? extends Program> programs) {
        LinkedHashMap<TraceModule, DebuggerStaticMappingService.ModuleMapProposal> result = new LinkedHashMap<TraceModule, DebuggerStaticMappingService.ModuleMapProposal>();
        for (TraceModule traceModule : modules) {
            String moduleName = DebuggerStaticMappingServicePlugin.getLastLower(traceModule.getName());
            Set probable = programs.stream().filter(p -> this.namesContain((Program)p, moduleName)).collect(Collectors.toSet());
            DebuggerStaticMappingService.ModuleMapProposal map = this.proposeModuleMap(traceModule, (Collection)probable);
            if (map == null) continue;
            result.put(traceModule, map);
        }
        return result;
    }

    @Override
    public PluginSectionMapProposal proposeSectionMap(TraceSection section, Program program, MemoryBlock block) {
        return new PluginSectionMapProposal(section, program, block);
    }

    @Override
    public PluginSectionMapProposal proposeSectionMap(TraceModule module, Program program) {
        return new PluginSectionMapProposal(module, program);
    }

    @Override
    public PluginSectionMapProposal proposeSectionMap(TraceModule module, Collection<? extends Program> programs) {
        double bestScore = -1.0;
        PluginSectionMapProposal bestMap = null;
        for (Program program : programs) {
            PluginSectionMapProposal map = this.proposeSectionMap(module, program);
            double score = map.computeScore();
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestMap = map;
        }
        return bestMap;
    }

    protected static String getLastLower(String path) {
        return new File(path).getName().toLowerCase();
    }

    protected boolean namesContain(Program program, String moduleLowerName) {
        String execName;
        DomainFile df = program.getDomainFile();
        if (df == null || df.getProjectLocator() == null) {
            return false;
        }
        String programName = DebuggerStaticMappingServicePlugin.getLastLower(program.getName());
        if (programName.contains(moduleLowerName)) {
            return true;
        }
        String exePath = program.getExecutablePath();
        if (exePath != null && (execName = DebuggerStaticMappingServicePlugin.getLastLower(exePath)).contains(moduleLowerName)) {
            return true;
        }
        String fileName = df.getName().toLowerCase();
        return fileName.contains(moduleLowerName);
    }

    @Override
    public Map<TraceModule, DebuggerStaticMappingService.SectionMapProposal> proposeSectionMaps(Collection<? extends TraceModule> modules, Collection<? extends Program> programs) {
        LinkedHashMap<TraceModule, DebuggerStaticMappingService.SectionMapProposal> result = new LinkedHashMap<TraceModule, DebuggerStaticMappingService.SectionMapProposal>();
        for (TraceModule traceModule : modules) {
            String moduleName = DebuggerStaticMappingServicePlugin.getLastLower(traceModule.getName());
            Set probable = programs.stream().filter(p -> this.namesContain((Program)p, moduleName)).collect(Collectors.toSet());
            DebuggerStaticMappingService.SectionMapProposal map = this.proposeSectionMap(traceModule, (Collection)probable);
            if (map == null) continue;
            result.put(traceModule, map);
        }
        return result;
    }

    protected class InfoPerProgram
    implements DomainObjectListener {
        private Program program;
        private ValueSortedMap<MappingEntry, Address> inbound = TreeValueSortedMap.createWithNaturalOrder();

        public InfoPerProgram(Program program) {
            this.program = program;
            program.addListener((DomainObjectListener)this);
            this.loadInboundEntries();
        }

        public void domainObjectChanged(DomainObjectChangedEvent ev) {
            if (ev.containsEvent(2)) {
                DebuggerStaticMappingServicePlugin.this.programClosed(this.program);
                DebuggerStaticMappingServicePlugin.this.programOpened(this.program);
            }
        }

        protected void loadInboundEntries() {
            for (InfoPerTrace traceInfo : DebuggerStaticMappingServicePlugin.this.trackedTraceInfo.values()) {
                for (MappingEntry out : traceInfo.outbound.values()) {
                    if (out.program != this.program) continue;
                    this.inbound.put((Object)out, (Object)out.getStaticAddress());
                }
            }
        }

        public boolean isMappedInTrace(Trace trace) {
            for (MappingEntry me : this.inbound.keySet()) {
                if (!Objects.equals(trace, me.getTrace())) continue;
                return true;
            }
            return false;
        }

        public boolean traceClosed(Trace trace) {
            HashSet<MappingEntry> updates = new HashSet<MappingEntry>();
            for (Map.Entry ent : this.inbound.entrySet()) {
                MappingEntry me = (MappingEntry)ent.getKey();
                if (!Objects.equals(trace, me.getTrace())) continue;
                updates.add(me);
            }
            return this.inbound.keySet().removeAll(updates);
        }

        public Set<TraceLocation> getOpenMappedTraceLocations(Address address) {
            HashSet<TraceLocation> result = new HashSet<TraceLocation>();
            for (Map.Entry inPreceding : this.inbound.headMapByValue((Object)address, true).entrySet()) {
                MappingEntry me;
                Address start = (Address)inPreceding.getValue();
                if (start == null || !(me = (MappingEntry)inPreceding.getKey()).isInProgramRange(address)) continue;
                result.add(me.mapProgramAddressToTraceLocation(address));
            }
            return result;
        }

        public TraceLocation getOpenMappedTraceLocation(Trace trace, Address address, long snap) {
            for (Map.Entry inPreceding : this.inbound.headMapByValue((Object)address, true).entrySet()) {
                MappingEntry me;
                Address start = (Address)inPreceding.getValue();
                if (start == null || (me = (MappingEntry)inPreceding.getKey()).getTrace() != trace || !me.isInProgramRange(address) || !me.isInTraceLifespan(snap)) continue;
                return me.mapProgramAddressToTraceLocation(address);
            }
            return null;
        }

        protected void collectOpenMappedViews(AddressRange rng, Map<TraceSnap, Collection<DebuggerStaticMappingService.MappedAddressRange>> result) {
            for (Map.Entry inPreceeding : this.inbound.headMapByValue((Object)rng.getMaxAddress(), true).entrySet()) {
                MappingEntry me;
                Address start = (Address)inPreceeding.getValue();
                if (start == null || !(me = (MappingEntry)inPreceeding.getKey()).isInProgramRange(rng)) continue;
                AddressRange srcRange = me.staticRange.intersect(rng);
                AddressRange dstRange = me.mapProgramRangeToTrace(rng);
                result.computeIfAbsent(me.getTraceSnap(), p -> new TreeSet()).add(new DebuggerStaticMappingService.MappedAddressRange(srcRange, dstRange));
            }
        }

        public Map<TraceSnap, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(AddressSetView set) {
            HashMap<TraceSnap, Collection<DebuggerStaticMappingService.MappedAddressRange>> result = new HashMap<TraceSnap, Collection<DebuggerStaticMappingService.MappedAddressRange>>();
            for (AddressRange rng : set) {
                this.collectOpenMappedViews(rng, result);
            }
            return Collections.unmodifiableMap(result);
        }
    }

    protected class InfoPerTrace
    extends TraceDomainObjectListener {
        private Trace trace;
        private Map<TraceAddressSnapRange, MappingEntry> outbound = new HashMap<TraceAddressSnapRange, MappingEntry>();

        public InfoPerTrace(Trace trace) {
            this.trace = trace;
            this.listenForUntyped(4, e -> this.objectRestored());
            this.listenFor((TraceChangeType)Trace.TraceStaticMappingChangeType.ADDED, this::staticMappingAdded);
            this.listenFor((TraceChangeType)Trace.TraceStaticMappingChangeType.DELETED, this::staticMappingDeleted);
            trace.addListener((DomainObjectListener)this);
            this.loadOutboundEntries();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void objectRestored() {
            Object object = DebuggerStaticMappingServicePlugin.this.lock;
            synchronized (object) {
                DebuggerStaticMappingServicePlugin.this.doAffectedByTraceClosed(this.trace);
                this.outbound.clear();
                this.loadOutboundEntries();
                DebuggerStaticMappingServicePlugin.this.doAffectedByTraceOpened(this.trace);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void staticMappingAdded(TraceStaticMapping mapping) {
            Object object = DebuggerStaticMappingServicePlugin.this.lock;
            synchronized (object) {
                MappingEntry me = new MappingEntry(mapping);
                this.putOutboundAndInboundEntries(me);
                if (me.program != null) {
                    DebuggerStaticMappingServicePlugin.this.traceAffected(this.trace);
                    DebuggerStaticMappingServicePlugin.this.programAffected(me.program);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void staticMappingDeleted(TraceStaticMapping mapping) {
            Object object = DebuggerStaticMappingServicePlugin.this.lock;
            synchronized (object) {
                MappingEntry me = this.outbound.get(new ImmutableTraceAddressSnapRange(mapping.getTraceAddressRange(), mapping.getLifespan()));
                if (me == null) {
                    Msg.warn((Object)((Object)this), (Object)"It appears I lost track of something that just got removed");
                    return;
                }
                Program program = me.program;
                this.removeOutboundAndInboundEntries(me);
                if (program != null) {
                    DebuggerStaticMappingServicePlugin.this.traceAffected(this.trace);
                    DebuggerStaticMappingServicePlugin.this.programAffected(program);
                }
            }
        }

        public void dispose() {
            this.trace.removeListener((DomainObjectListener)this);
        }

        protected void putOutboundAndInboundEntries(MappingEntry me) {
            this.outbound.put(me.getTraceAddressSnapRange(), me);
            InfoPerProgram destInfo = DebuggerStaticMappingServicePlugin.this.trackedProgramInfo.get(me.getStaticProgramURL());
            if (destInfo == null) {
                return;
            }
            me.programOpened(destInfo.program);
            destInfo.inbound.put((Object)me, (Object)me.getStaticAddress());
        }

        protected void removeOutboundAndInboundEntries(MappingEntry me) {
            this.outbound.remove(me.getTraceAddressSnapRange());
            InfoPerProgram destInfo = DebuggerStaticMappingServicePlugin.this.trackedProgramInfo.get(me.getStaticProgramURL());
            if (destInfo == null) {
                return;
            }
            destInfo.inbound.remove((Object)me);
        }

        protected void loadOutboundEntries() {
            TraceStaticMappingManager manager = this.trace.getStaticMappingManager();
            for (TraceStaticMapping mapping : manager.getAllEntries()) {
                this.putOutboundAndInboundEntries(new MappingEntry(mapping));
            }
        }

        public boolean programOpened(Program other, InfoPerProgram otherInfo) {
            boolean result = false;
            for (MappingEntry me : this.outbound.values()) {
                if (!me.programOpened(other)) continue;
                otherInfo.inbound.put((Object)me, (Object)me.getStaticAddress());
                result = true;
            }
            return result;
        }

        public boolean programClosed(Program other) {
            boolean result = false;
            for (MappingEntry me : this.outbound.values()) {
                result |= me.programClosed(other);
            }
            return result;
        }

        public Set<Program> getOpenMappedProgramsAtSnap(long snap) {
            HashSet<Program> result = new HashSet<Program>();
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                MappingEntry me = out.getValue();
                if (!me.isStaticProgramOpen() || !out.getKey().getLifespan().contains((Comparable)Long.valueOf(snap))) continue;
                result.add(me.program);
            }
            return result;
        }

        public ProgramLocation getOpenMappedLocations(Address address, Range<Long> span) {
            ImmutableTraceAddressSnapRange at = new ImmutableTraceAddressSnapRange(address, span);
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                MappingEntry me;
                if (!out.getKey().intersects((Rectangle2D)at) || !(me = out.getValue()).isStaticProgramOpen()) continue;
                return me.mapTraceAddressToProgramLocation(address);
            }
            return null;
        }

        protected void collectOpenMappedPrograms(AddressRange rng, Range<Long> span, Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> result) {
            ImmutableTraceAddressSnapRange tatr = new ImmutableTraceAddressSnapRange(rng, span);
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                MappingEntry me = out.getValue();
                if (me.program == null || !out.getKey().intersects((Rectangle2D)tatr)) continue;
                AddressRange srcRng = out.getKey().getRange().intersect(rng);
                AddressRange dstRng = me.mapTraceRangeToProgram(rng);
                result.computeIfAbsent(me.program, p -> new TreeSet()).add(new DebuggerStaticMappingService.MappedAddressRange(srcRng, dstRng));
            }
        }

        public Map<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> getOpenMappedViews(AddressSetView set, Range<Long> span) {
            HashMap<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>> result = new HashMap<Program, Collection<DebuggerStaticMappingService.MappedAddressRange>>();
            for (AddressRange rng : set) {
                this.collectOpenMappedPrograms(rng, span, result);
            }
            return Collections.unmodifiableMap(result);
        }

        protected void collectMappedProgramURLsInView(AddressRange rng, Range<Long> span, Set<URL> result) {
            ImmutableTraceAddressSnapRange tatr = new ImmutableTraceAddressSnapRange(rng, span);
            for (Map.Entry<TraceAddressSnapRange, MappingEntry> out : this.outbound.entrySet()) {
                if (!out.getKey().intersects((Rectangle2D)tatr)) continue;
                MappingEntry me = out.getValue();
                result.add(me.getStaticProgramURL());
            }
        }

        public Set<URL> getMappedProgramURLsInView(AddressSetView set, Range<Long> span) {
            HashSet<URL> result = new HashSet<URL>();
            for (AddressRange rng : set) {
                this.collectMappedProgramURLsInView(rng, span, result);
            }
            return Collections.unmodifiableSet(result);
        }
    }

    protected class MappingEntry {
        private final TraceStaticMapping mapping;
        private Program program;
        private AddressRange staticRange;

        public MappingEntry(TraceStaticMapping mapping) {
            this.mapping = mapping;
        }

        public Trace getTrace() {
            return this.mapping.getTrace();
        }

        public Address addOrMax(Address start, long length) {
            try {
                return start.addNoWrap(length);
            }
            catch (AddressOverflowException e) {
                Msg.warn((Object)this, (Object)"Mapping entry cause overflow in static address space");
                return start.getAddressSpace().getMaxAddress();
            }
        }

        public boolean programOpened(Program opened) {
            if (this.mapping.getStaticProgramURL().equals(ProgramURLUtils.getUrlFromProgram(opened))) {
                this.program = opened;
                Address minAddr = opened.getAddressFactory().getAddress(this.mapping.getStaticAddress());
                Address maxAddr = this.addOrMax(minAddr, this.mapping.getLength() - 1L);
                this.staticRange = new AddressRangeImpl(minAddr, maxAddr);
                return true;
            }
            return false;
        }

        public boolean programClosed(Program closed) {
            if (this.program == closed) {
                this.program = null;
                this.staticRange = null;
                return true;
            }
            return false;
        }

        public Address getTraceAddress() {
            return this.mapping.getMinTraceAddress();
        }

        public Address getStaticAddress() {
            if (this.staticRange == null) {
                return null;
            }
            return this.staticRange.getMinAddress();
        }

        public TraceSnap getTraceSnap() {
            return new DefaultTraceSnap(this.mapping.getTrace(), this.mapping.getStartSnap());
        }

        public TraceAddressSnapRange getTraceAddressSnapRange() {
            return new ImmutableTraceAddressSnapRange(this.mapping.getTraceAddressRange(), this.mapping.getLifespan());
        }

        public boolean isInTraceRange(Address address, Long snap) {
            return this.mapping.getTraceAddressRange().contains(address) && (snap == null || this.mapping.getLifespan().contains((Comparable)snap));
        }

        public boolean isInTraceRange(AddressRange rng, Long snap) {
            return this.mapping.getTraceAddressRange().intersects(rng) && (snap == null || this.mapping.getLifespan().contains((Comparable)snap));
        }

        public boolean isInTraceLifespan(long snap) {
            return this.mapping.getLifespan().contains((Comparable)Long.valueOf(snap));
        }

        public boolean isInProgramRange(Address address) {
            if (this.staticRange == null) {
                return false;
            }
            return this.staticRange.contains(address);
        }

        public boolean isInProgramRange(AddressRange rng) {
            if (this.staticRange == null) {
                return false;
            }
            return this.staticRange.intersects(rng);
        }

        protected Address mapTraceAddressToProgram(Address address) {
            assert (this.isInTraceRange(address, null));
            long offset = address.subtract(this.mapping.getMinTraceAddress());
            return this.staticRange.getMinAddress().add(offset);
        }

        public ProgramLocation mapTraceAddressToProgramLocation(Address address) {
            if (this.program == null) {
                throw new IllegalStateException("Static program is not opened");
            }
            return new ProgramLocation(this.program, this.mapTraceAddressToProgram(address));
        }

        public AddressRange mapTraceRangeToProgram(AddressRange rng) {
            assert (this.isInTraceRange(rng, null));
            AddressRange part = rng.intersect(this.mapping.getTraceAddressRange());
            Address min = this.mapTraceAddressToProgram(part.getMinAddress());
            Address max = this.mapTraceAddressToProgram(part.getMaxAddress());
            return new AddressRangeImpl(min, max);
        }

        protected Address mapProgramAddressToTrace(Address address) {
            assert (this.isInProgramRange(address));
            long offset = address.subtract(this.staticRange.getMinAddress());
            return this.mapping.getMinTraceAddress().add(offset);
        }

        protected TraceLocation mapProgramAddressToTraceLocation(Address address) {
            return new DefaultTraceLocation(this.mapping.getTrace(), null, this.mapping.getLifespan(), this.mapProgramAddressToTrace(address));
        }

        public AddressRange mapProgramRangeToTrace(AddressRange rng) {
            assert (rng.intersects(this.staticRange));
            AddressRange part = rng.intersect(this.staticRange);
            Address min = this.mapProgramAddressToTrace(part.getMinAddress());
            Address max = this.mapProgramAddressToTrace(part.getMaxAddress());
            return new AddressRangeImpl(min, max);
        }

        public boolean isStaticProgramOpen() {
            return this.program != null;
        }

        public URL getStaticProgramURL() {
            return this.mapping.getStaticProgramURL();
        }
    }

    protected static class SectionMatcher {
        private final TraceSection section;
        private MemoryBlock block;

        public SectionMatcher(TraceSection section) {
            this.section = section;
        }

        public int score() {
            if (this.section == null || this.block == null) {
                return 0;
            }
            int score = 3;
            if (this.section.getRange().getLength() == this.block.getSize()) {
                score += 10;
            }
            if ((this.section.getStart().getOffset() & 0xFFFL) == (this.block.getStart().getOffset() & 0xFFFL)) {
                score += 20;
            }
            return score;
        }
    }

    protected static class PluginSectionMapProposal
    implements DebuggerStaticMappingService.SectionMapProposal {
        private final TraceModule module;
        private final Program program;
        private final Map<String, SectionMatcher> matchers = new LinkedHashMap<String, SectionMatcher>();

        public PluginSectionMapProposal(TraceModule module, Program program) {
            this.module = module;
            this.program = program;
            this.processModule();
            this.processProgram();
        }

        public PluginSectionMapProposal(TraceSection section, Program program, MemoryBlock block) {
            this.module = section.getModule();
            this.program = program;
            this.processSection(section);
            this.processBlock(block);
        }

        @Override
        public TraceModule getModule() {
            return this.module;
        }

        @Override
        public Program getProgram() {
            return this.program;
        }

        private void processSection(TraceSection section) {
            this.matchers.put(section.getName(), new SectionMatcher(section));
        }

        private void processBlock(MemoryBlock block) {
            SectionMatcher m = this.matchers.computeIfAbsent(block.getName(), n -> new SectionMatcher(null));
            m.block = block;
        }

        private void processModule() {
            for (TraceSection section : this.module.getSections()) {
                this.processSection(section);
            }
        }

        private void processProgram() {
            for (MemoryBlock block : this.program.getMemory().getBlocks()) {
                this.processBlock(block);
            }
        }

        @Override
        public double computeScore() {
            return (double)this.matchers.values().stream().reduce(0, (s, m) -> s + m.score(), Integer::sum).intValue() / (double)this.matchers.size();
        }

        @Override
        public Map<TraceSection, DebuggerStaticMappingService.SectionMapEntry> computeMap() {
            return this.matchers.values().stream().filter(m -> m.section != null && m.block != null).collect(Collectors.toMap(m -> m.section, m -> new DebuggerStaticMappingService.SectionMapEntry(m.section, this.program, m.block)));
        }

        @Override
        public MemoryBlock getDestination(TraceSection section) {
            SectionMatcher m = this.matchers.get(section.getName());
            return m == null ? null : m.block;
        }
    }

    protected static class RegionMatcher {
        private MemoryBlock block;
        private TraceMemoryRegion region;

        public RegionMatcher(long baseOffset) {
        }

        private int score() {
            if (this.block == null || this.region == null) {
                return 0;
            }
            int score = 3;
            if (this.block.getSize() == this.region.getLength()) {
                score += 10;
            }
            return score;
        }
    }

    protected static class PluginModuleMapProposal
    implements DebuggerStaticMappingService.ModuleMapProposal {
        private final TraceModule module;
        private final Program program;
        private final NavigableMap<Long, RegionMatcher> matchers = new TreeMap<Long, RegionMatcher>();
        private Address imageBase;
        private Address moduleBase;
        private long imageSize;
        private AddressRange moduleRange;

        public PluginModuleMapProposal(TraceModule module, Program program) {
            this.module = module;
            this.program = program;
            this.processProgram();
            this.processModule();
        }

        @Override
        public TraceModule getModule() {
            return this.module;
        }

        @Override
        public Program getProgram() {
            return this.program;
        }

        private RegionMatcher getMatcher(long baseOffset) {
            return this.matchers.computeIfAbsent(baseOffset, RegionMatcher::new);
        }

        private void processProgram() {
            this.imageBase = this.program.getImageBase();
            this.imageSize = DebuggerStaticMappingService.ModuleMapEntry.computeImageSize(this.program);
            for (MemoryBlock block : this.program.getMemory().getBlocks()) {
                if (!DebuggerStaticMappingService.ModuleMapEntry.includeBlock(this.program, block)) continue;
                this.getMatcher((long)block.getStart().subtract((Address)this.imageBase)).block = block;
            }
        }

        private void processModule() {
            this.moduleBase = this.module.getBase();
            try {
                this.moduleRange = new AddressRangeImpl(this.moduleBase, this.imageSize);
            }
            catch (AddressOverflowException e) {
                return;
            }
            Iterator iterator = this.module.getTrace().getMemoryManager().getRegionsIntersecting(this.module.getLifespan(), this.moduleRange).iterator();
            while (iterator.hasNext()) {
                TraceMemoryRegion region;
                this.getMatcher((long)region.getMinAddress().subtract((Address)this.moduleBase)).region = region = (TraceMemoryRegion)iterator.next();
            }
        }

        @Override
        public double computeScore() {
            return (double)this.matchers.values().stream().reduce(0, (s, m) -> s + m.score(), Integer::sum).intValue() / (double)this.matchers.size();
        }

        @Override
        public Map<TraceModule, DebuggerStaticMappingService.ModuleMapEntry> computeMap() {
            return Map.of(this.module, new DebuggerStaticMappingService.ModuleMapEntry(this.module, this.program, this.moduleRange));
        }
    }
}

