/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.emulation;

import ghidra.app.plugin.core.debug.service.emulation.ReadsTargetMemoryPcodeExecutorState;
import ghidra.app.plugin.core.debug.service.emulation.ReadsTargetRegistersPcodeExecutorState;
import ghidra.app.services.TraceRecorder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.emu.BytesPcodeThread;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.trace.TracePcodeEmulator;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryRegisterSpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;

public class DebuggerTracePcodeEmulator
extends TracePcodeEmulator {
    protected final PluginTool tool;
    protected final TraceRecorder recorder;

    public DebuggerTracePcodeEmulator(PluginTool tool, Trace trace, long snap, TraceRecorder recorder) {
        super(trace, snap);
        this.tool = tool;
        this.recorder = recorder;
    }

    protected boolean isRegisterKnown(String threadName, Register register) {
        TraceThread thread = this.trace.getThreadManager().getLiveThreadByPath(this.snap, threadName);
        TraceMemoryRegisterSpace space = this.trace.getMemoryManager().getMemoryRegisterSpace(thread, false);
        if (space == null) {
            return false;
        }
        return space.getState(this.snap, register) == TraceMemoryState.KNOWN;
    }

    protected BytesPcodeThread createThread(String name) {
        RegisterValue context;
        BytesPcodeThread thread = super.createThread(name);
        Register contextreg = this.language.getContextBaseRegister();
        if (contextreg != Register.NO_CONTEXT && !this.isRegisterKnown(name, contextreg) && (context = this.trace.getRegisterContextManager().getValueWithDefault((Language)this.language, contextreg, this.snap, thread.getCounter())) != null) {
            thread.overrideContext(context);
        }
        return thread;
    }

    protected PcodeExecutorState<byte[]> createSharedState() {
        return new ReadsTargetMemoryPcodeExecutorState(this.tool, this.trace, this.snap, null, 0, this.recorder);
    }

    protected PcodeExecutorState<byte[]> createLocalState(PcodeThread<byte[]> emuThread) {
        TraceThread traceThread = this.trace.getThreadManager().getLiveThreadByPath(this.snap, emuThread.getName());
        return new ReadsTargetRegistersPcodeExecutorState(this.tool, this.trace, this.snap, traceThread, 0, this.recorder);
    }
}

