/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.pcode;

import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.pcode.BranchPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.DebuggerPcodeStepperPlugin;
import ghidra.app.plugin.core.debug.gui.pcode.EnumPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.FallthroughPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.OpPcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.PcodeRow;
import ghidra.app.plugin.core.debug.gui.pcode.UniqueRow;
import ghidra.app.plugin.core.debug.service.emulation.DebuggerTracePcodeEmulator;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.async.SwingExecutorService;
import ghidra.base.widgets.table.DataTypeTableCellEditor;
import ghidra.docking.settings.Settings;
import ghidra.framework.model.UndoableDomainObject;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.pcode.emu.PcodeThread;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import ghidra.trace.model.Trace;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.ColorUtils;
import ghidra.util.HTMLUtilities;
import ghidra.util.database.UndoableTransaction;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;

public class DebuggerPcodeStepperProvider
extends ComponentProviderAdapter {
    private static final FontRenderContext METRIC_FRC = new FontRenderContext(new AffineTransform(), false, false);
    private static final String BACKGROUND_COLOR = "Background Color";
    private static final String ADDRESS_COLOR = "Address Color";
    private static final String CONSTANT_COLOR = "Constant Color";
    private static final String REGISTERS_COLOR = "Registers Color";
    private static final String LABELS_LOCAL_COLOR = "Labels, Local Color";
    private static final String MNEMONIC_COLOR = "Mnemonic Color";
    protected static final Comparator<Varnode> UNIQUE_COMPARATOR = (u1, u2) -> {
        assert (u1.isUnique() && u2.isUnique());
        return u1.getAddress().compareTo((Object)u2.getAddress());
    };
    private final DebuggerPcodeStepperPlugin plugin;
    DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    DebuggerCoordinates previous = DebuggerCoordinates.NOWHERE;
    int counter;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    private DebuggerEmulationService emulationService;
    private AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Colors.Pcode Counter"}, description="Background color for the current p-code operation", help=@HelpInfo(anchor="colors"))
    private Color counterColor = DebuggerResources.DEFAULT_COLOR_PCODE_COUNTER;
    private Color backgroundColor;
    private Color cursorColor;
    private Color addressColor;
    private Color constantColor;
    private Color registerColor;
    private Color uniqueColor;
    private Color opColor;
    private AutoOptions.Wiring autoOptionsWiring;
    String style = "<html>";
    JSplitPane mainPanel = new JSplitPane(1);
    GhidraTable uniqueTable;
    UniqueTableModel uniqueTableModel = new UniqueTableModel();
    GhidraTableFilterPanel<UniqueRow> uniqueFilterPanel;
    GhidraTable pcodeTable;
    PcodeTableModel pcodeTableModel = new PcodeTableModel();
    JLabel instructionLabel;
    DockingAction actionStepBackward;
    DockingAction actionStepForward;

    protected static String createColoredStyle(String cls, Color color) {
        if (color == null) {
            return "";
        }
        return " ." + cls + " { color:" + HTMLUtilities.toHexString((Color)color) + "; }";
    }

    protected static boolean sameCoordinates(DebuggerCoordinates a, DebuggerCoordinates b) {
        if (!Objects.equals(a.getTrace(), b.getTrace())) {
            return false;
        }
        if (!Objects.equals(a.getTime(), b.getTime())) {
            return false;
        }
        return Objects.equals(a.getThread(), b.getThread());
    }

    public DebuggerPcodeStepperProvider(DebuggerPcodeStepperPlugin plugin) {
        super(plugin.getTool(), "Pcode Stepper", plugin.getName(), null);
        this.plugin = plugin;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)((Object)this));
        this.setIcon(DebuggerResources.ICON_PROVIDER_PCODE);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_PCODE);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.createActions();
        this.setVisible(true);
        this.contextChanged();
    }

    @AutoOptionConsumed(name={"Colors.Pcode Counter"})
    private void setCounterColor() {
        this.pcodeTableModel.fireTableDataChanged();
    }

    @AutoOptionConsumed(category={"Listing Display"}, name={"Background Color"})
    private void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        if (this.pcodeTable != null) {
            this.pcodeTable.setBackground(backgroundColor);
        }
    }

    @AutoOptionConsumed(category={"Listing Fields"}, name={"Cursor.Highlight Cursor Line Color"})
    private void setCursorColor(Color cursorColor) {
        this.cursorColor = cursorColor;
        if (this.pcodeTable != null) {
            this.pcodeTable.setSelectionBackground(cursorColor);
        }
    }

    @AutoOptionConsumed(category={"Listing Display"}, name={"Address Color"})
    private void setAddressColor(Color addressColor) {
        this.addressColor = addressColor;
        this.recomputeStyle();
    }

    @AutoOptionConsumed(category={"Listing Display"}, name={"Constant Color"})
    private void setConstantColor(Color constantColor) {
        this.constantColor = constantColor;
        this.recomputeStyle();
    }

    @AutoOptionConsumed(category={"Listing Display"}, name={"Registers Color"})
    private void setRegisterColor(Color registerColor) {
        this.registerColor = registerColor;
        this.recomputeStyle();
    }

    @AutoOptionConsumed(category={"Listing Display"}, name={"Labels, Local Color"})
    private void setUniqueColor(Color uniqueColor) {
        this.uniqueColor = uniqueColor;
        this.recomputeStyle();
    }

    @AutoOptionConsumed(category={"Listing Display"}, name={"Mnemonic Color"})
    private void setOpColor(Color opColor) {
        this.opColor = opColor;
        this.recomputeStyle();
    }

    protected void recomputeStyle() {
        StringBuilder sb = new StringBuilder("<html><head><style>");
        sb.append(DebuggerPcodeStepperProvider.createColoredStyle("address", this.addressColor));
        sb.append(DebuggerPcodeStepperProvider.createColoredStyle("constant", this.constantColor));
        sb.append(DebuggerPcodeStepperProvider.createColoredStyle("register", this.registerColor));
        sb.append(DebuggerPcodeStepperProvider.createColoredStyle("unique", this.uniqueColor));
        sb.append(DebuggerPcodeStepperProvider.createColoredStyle("op", this.opColor));
        sb.append("</style></head>");
        this.style = sb.toString();
        this.pcodeTableModel.fireTableDataChanged();
    }

    protected int computeSeqColWidth(JLabel renderer) {
        Font font = renderer.getFont();
        Insets insets = renderer.getBorder().getBorderInsets(renderer);
        return (int)font.getStringBounds("00", METRIC_FRC).getWidth() + insets.left + insets.right;
    }

    protected void buildMainPanel() {
        JPanel pcodePanel = new JPanel(new BorderLayout());
        this.pcodeTable = new GhidraTable((TableModel)((Object)this.pcodeTableModel));
        pcodePanel.add(new JScrollPane((Component)this.pcodeTable));
        this.instructionLabel = new JLabel();
        pcodePanel.add((Component)this.instructionLabel, "North");
        this.mainPanel.setLeftComponent(pcodePanel);
        JPanel uniquePanel = new JPanel(new BorderLayout());
        this.uniqueTable = new GhidraTable((TableModel)((Object)this.uniqueTableModel));
        uniquePanel.add(new JScrollPane((Component)this.uniqueTable));
        this.uniqueFilterPanel = new GhidraTableFilterPanel((JTable)this.uniqueTable, (RowObjectTableModel)this.uniqueTableModel);
        uniquePanel.add((Component)this.uniqueFilterPanel, "South");
        this.mainPanel.setRightComponent(uniquePanel);
        this.pcodeTable.setTableHeader(null);
        this.pcodeTable.setBackground(this.backgroundColor);
        this.pcodeTable.setSelectionBackground(this.cursorColor);
        this.pcodeTable.setSelectionMode(0);
        this.pcodeTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.uniqueTableModel.fireTableDataChanged();
        });
        TableColumnModel pcodeColModel = this.pcodeTable.getColumnModel();
        TableColumn seqCol = pcodeColModel.getColumn(PcodeTableColumns.SEQUENCE.ordinal());
        CounterBackgroundCellRenderer seqColRenderer = new CounterBackgroundCellRenderer();
        seqCol.setCellRenderer((TableCellRenderer)((Object)seqColRenderer));
        int seqColWidth = this.computeSeqColWidth((JLabel)((Object)seqColRenderer));
        seqCol.setMinWidth(seqColWidth);
        seqCol.setMaxWidth(seqColWidth);
        TableColumn codeCol = pcodeColModel.getColumn(PcodeTableColumns.CODE.ordinal());
        codeCol.setCellRenderer((TableCellRenderer)((Object)new PcodeCellRenderer()));
        TableColumnModel uniqueColModel = this.uniqueTable.getColumnModel();
        TableColumn refCol = uniqueColModel.getColumn(UniqueTableColumns.REF.ordinal());
        refCol.setCellRenderer((TableCellRenderer)((Object)new UniqueRefCellRenderer()));
        refCol.setMinWidth(24);
        refCol.setMaxWidth(24);
        TableColumn uniqCol = uniqueColModel.getColumn(UniqueTableColumns.UNIQUE.ordinal());
        uniqCol.setPreferredWidth(45);
        TableColumn bytesCol = uniqueColModel.getColumn(UniqueTableColumns.BYTES.ordinal());
        bytesCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        bytesCol.setPreferredWidth(65);
        TableColumn valCol = uniqueColModel.getColumn(UniqueTableColumns.VALUE.ordinal());
        valCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_BIG_HEX);
        valCol.setPreferredWidth(45);
        TableColumn typeCol = uniqueColModel.getColumn(UniqueTableColumns.TYPE.ordinal());
        typeCol.setCellEditor((TableCellEditor)((Object)new UniqueDataTypeEditor()));
        typeCol.setPreferredWidth(45);
        TableColumn reprCol = uniqueColModel.getColumn(UniqueTableColumns.REPR.ordinal());
        reprCol.setPreferredWidth(45);
    }

    protected void createActions() {
        this.actionStepBackward = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.EmulatePcodeBackwardAction.builder(this.plugin).enabledWhen(c -> this.current.getTrace() != null && this.current.getTime().pTickCount() != 0L)).onAction(c -> this.stepBackwardActivated())).buildAndInstallLocal((ComponentProvider)this);
        this.actionStepForward = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.EmulatePcodeForwardAction.builder(this.plugin).enabledWhen(c -> this.current.getThread() != null)).onAction(c -> this.stepForwardActivated())).buildAndInstallLocal((ComponentProvider)this);
    }

    private void stepBackwardActivated() {
        if (this.current.getTrace() == null) {
            return;
        }
        TraceSchedule time = this.current.getTime().steppedPcodeBackward(1);
        if (time == null) {
            return;
        }
        this.traceManager.activateTime(time);
    }

    private void stepForwardActivated() {
        if (this.current.getThread() == null) {
            return;
        }
        TraceSchedule time = this.current.getTime().steppedPcodeForward(this.current.getThread(), 1);
        this.traceManager.activateTime(time);
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        if (DebuggerPcodeStepperProvider.sameCoordinates(this.current, coordinates)) {
            this.current = coordinates;
            return;
        }
        this.previous = this.current;
        this.current = coordinates;
        this.doLoadPcodeFrame();
        this.setSubTitle(this.current.getTime().toString());
        this.contextChanged();
    }

    protected void populateSingleton(PcodeRow row) {
        this.counter = 0;
        this.pcodeTableModel.clear();
        this.pcodeTableModel.add(row);
        this.uniqueTableModel.clear();
    }

    protected void populateFromFrame(PcodeFrame frame, PcodeExecutorState<byte[]> state) {
        this.populatePcode(frame);
        this.populateUnique(frame, state);
    }

    protected void populatePcode(PcodeFrame frame) {
        Language language = this.current.getTrace().getBaseLanguage();
        int index = frame.index();
        List toAdd = frame.getCode().stream().map(op -> new OpPcodeRow(language, (PcodeOp)op, index == op.getSeqnum().getTime())).collect(Collectors.toCollection(ArrayList::new));
        if (frame.isBranch()) {
            this.counter = toAdd.size();
            toAdd.add(new BranchPcodeRow(this.counter, frame.getBranched()));
        } else if (frame.isFallThrough()) {
            this.counter = toAdd.size();
            toAdd.add(new FallthroughPcodeRow(this.counter));
        } else {
            this.counter = index;
        }
        this.pcodeTableModel.clear();
        this.pcodeTableModel.addAll(toAdd);
        this.pcodeTable.getSelectionModel().setSelectionInterval(this.counter, this.counter);
        this.pcodeTable.scrollToSelectedRow();
    }

    protected void populateUnique(PcodeFrame frame, PcodeExecutorState<byte[]> state) {
        Language language = this.current.getTrace().getBaseLanguage();
        TreeSet<Varnode> uniques = new TreeSet<Varnode>(UNIQUE_COMPARATOR);
        for (PcodeOp op : frame.getCode()) {
            Varnode out = op.getOutput();
            if (out != null && out.isUnique()) {
                uniques.add(out);
            }
            for (Varnode in : op.getInputs()) {
                if (!in.isUnique()) continue;
                uniques.add(in);
            }
        }
        List toAdd = uniques.stream().map(u -> new UniqueRow(this, language, state, (Varnode)u)).collect(Collectors.toList());
        this.uniqueTableModel.clear();
        this.uniqueTableModel.addAll(toAdd);
    }

    protected void doLoadPcodeFrame() {
        if (this.instructionLabel != null) {
            this.instructionLabel.setText("(no instruction)");
        }
        if (this.emulationService == null) {
            return;
        }
        DebuggerCoordinates current = this.current;
        Trace trace = current.getTrace();
        if (trace == null) {
            return;
        }
        if (current.getThread() == null) {
            this.populateSingleton(EnumPcodeRow.NO_THREAD);
            return;
        }
        TraceSchedule time = current.getTime();
        if (time.pTickCount() == 0L) {
            this.populateSingleton(EnumPcodeRow.DECODE);
            return;
        }
        DebuggerTracePcodeEmulator emu = this.emulationService.getCachedEmulator(trace, time);
        if (emu != null) {
            this.doLoadPcodeFrameFromEmulator(emu);
            return;
        }
        this.emulationService.backgroundEmulate(trace, time).thenAcceptAsync(__ -> {
            if (current != this.current) {
                return;
            }
            this.doLoadPcodeFrameFromEmulator(this.emulationService.getCachedEmulator(trace, time));
        }, (Executor)SwingExecutorService.INSTANCE);
    }

    protected void doLoadPcodeFrameFromEmulator(DebuggerTracePcodeEmulator emu) {
        PcodeThread thread = emu.getThread(this.current.getThread().getPath(), false);
        if (thread == null) {
            this.populateSingleton(EnumPcodeRow.DECODE);
            return;
        }
        Instruction instruction = thread.getInstruction();
        if (instruction == null) {
            this.instructionLabel.setText("(no instruction)");
        } else {
            this.instructionLabel.setText(instruction.toString());
        }
        PcodeFrame frame = thread.getFrame();
        if (frame == null) {
            this.populateSingleton(EnumPcodeRow.DECODE);
            return;
        }
        this.populateFromFrame(frame, (PcodeExecutorState<byte[]>)thread.getState());
    }

    @AutoServiceConsumed
    private void setEmulationService(DebuggerEmulationService emulationService) {
        this.doLoadPcodeFrame();
    }

    class UniqueRefCellRenderer
    extends AbstractGColumnRenderer<UniqueRow.RefType> {
        UniqueRefCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            this.setText("");
            switch ((UniqueRow.RefType)((Object)data.getValue())) {
                case NONE: {
                    this.setIcon(null);
                    break;
                }
                case READ: {
                    this.setIcon(DebuggerResources.ICON_UNIQUE_REF_READ);
                    break;
                }
                case WRITE: {
                    this.setIcon(DebuggerResources.ICON_UNIQUE_REF_WRITE);
                    break;
                }
                case READ_WRITE: {
                    this.setIcon(DebuggerResources.ICON_UNIQUE_REF_RW);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return this;
        }

        public String getFilterString(UniqueRow.RefType t, Settings settings) {
            return t.name();
        }
    }

    class PcodeCellRenderer
    extends CounterBackgroundCellRenderer {
        PcodeCellRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        protected void configureFont(JTable table, TableModel model, int column) {
            this.setFont(this.fixedWidthFont);
        }

        @Override
        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            super.getTableCellRendererComponent(data);
            this.setText(this.injectStyle(this.getText()));
            return this;
        }

        String injectStyle(String html) {
            if (StringUtils.startsWithIgnoreCase((CharSequence)html, (CharSequence)"<html>")) {
                return DebuggerPcodeStepperProvider.this.style + html.substring("<html>".length());
            }
            return html;
        }
    }

    class CounterBackgroundCellRenderer
    extends AbstractGColumnRenderer<String> {
        Color foregroundColor = this.getForeground();

        CounterBackgroundCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            boolean isCurrent;
            super.getTableCellRendererComponent(data);
            this.setForeground(DebuggerPcodeStepperProvider.this.pcodeTable.getForeground());
            boolean bl = isCurrent = DebuggerPcodeStepperProvider.this.counter == data.getRowModelIndex();
            if (data.isSelected()) {
                if (isCurrent) {
                    this.setBackground(ColorUtils.blend((Color)DebuggerPcodeStepperProvider.this.counterColor, (Color)DebuggerPcodeStepperProvider.this.cursorColor, (float)0.5f));
                }
            } else if (isCurrent) {
                this.setBackground(DebuggerPcodeStepperProvider.this.counterColor);
            } else {
                this.setBackground(DebuggerPcodeStepperProvider.this.pcodeTable.getBackground());
                this.setOpaque(true);
            }
            this.setBorder(this.noFocusBorder);
            return this;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    }

    class UniqueDataTypeEditor
    extends DataTypeTableCellEditor {
        public UniqueDataTypeEditor() {
            super(DebuggerPcodeStepperProvider.this.plugin.getTool());
        }

        protected DataType resolveSelection(DataType dataType) {
            if (dataType == null) {
                return null;
            }
            try (UndoableTransaction tid = UndoableTransaction.start((UndoableDomainObject)DebuggerPcodeStepperProvider.this.current.getTrace(), (String)"Resolve DataType", (boolean)true);){
                DataType dataType2 = DebuggerPcodeStepperProvider.this.current.getTrace().getDataTypeManager().resolve(dataType, null);
                return dataType2;
            }
        }
    }

    protected static class UniqueTableModel
    extends DefaultEnumeratedColumnTableModel<UniqueTableColumns, UniqueRow> {
        public UniqueTableModel() {
            super("Unique", UniqueTableColumns.class);
        }

        public List<UniqueTableColumns> defaultSortOrder() {
            return List.of(UniqueTableColumns.UNIQUE);
        }
    }

    protected static enum UniqueTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<UniqueTableColumns, UniqueRow>
    {
        REF("Ref", UniqueRow.RefType.class, UniqueRow::getRefType),
        UNIQUE("Unique", String.class, UniqueRow::getName),
        BYTES("Bytes", String.class, UniqueRow::getBytes),
        VALUE("Value", BigInteger.class, UniqueRow::getValue),
        TYPE("Type", DataType.class, UniqueRow::getDataType, UniqueRow::setDataType),
        REPR("Repr", String.class, UniqueRow::getValueRepresentation);

        private final String header;
        private final Function<UniqueRow, ?> getter;
        private final BiConsumer<UniqueRow, Object> setter;
        private final Class<?> cls;

        private <T> UniqueTableColumns(String header, Class<T> cls, Function<UniqueRow, T> getter, BiConsumer<UniqueRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> UniqueTableColumns(String header, Class<T> cls, Function<UniqueRow, T> getter) {
            this(header, cls, getter, null);
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(UniqueRow row) {
            return this.getter.apply(row);
        }

        public String getHeader() {
            return this.header;
        }

        public void setValueOf(UniqueRow row, Object value) {
            this.setter.accept(row, value);
        }

        public boolean isEditable(UniqueRow row) {
            return this.setter != null;
        }
    }

    protected static class PcodeTableModel
    extends DefaultEnumeratedColumnTableModel<PcodeTableColumns, PcodeRow> {
        public PcodeTableModel() {
            super("p-code", PcodeTableColumns.class);
        }

        public List<PcodeTableColumns> defaultSortOrder() {
            return List.of(PcodeTableColumns.SEQUENCE);
        }
    }

    protected static enum PcodeTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<PcodeTableColumns, PcodeRow>
    {
        SEQUENCE("Sequence", Integer.class, PcodeRow::getSequence),
        CODE("Code", String.class, PcodeRow::getCode);

        private final String header;
        private final Function<PcodeRow, ?> getter;
        private final Class<?> cls;

        private <T> PcodeTableColumns(String header, Class<T> cls, Function<PcodeRow, T> getter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(PcodeRow row) {
            return this.getter.apply(row);
        }

        public boolean isSortable() {
            return this == SEQUENCE;
        }
    }
}

