/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerStaticMappingProvider;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;

@PluginInfo(shortDescription="Debugger static mapping manager", description="GUI to manage static mappings", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, ProgramActivatedPluginEvent.class}, servicesRequired={DebuggerStaticMappingService.class, DebuggerTraceManagerService.class})
public class DebuggerStaticMappingPlugin
extends AbstractDebuggerPlugin {
    protected DebuggerStaticMappingProvider provider;

    public DebuggerStaticMappingPlugin(PluginTool tool) {
        super(tool);
    }

    @Override
    protected void init() {
        this.provider = new DebuggerStaticMappingProvider(this);
        super.init();
    }

    protected void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this.provider);
        super.dispose();
    }

    public void processEvent(PluginEvent event) {
        TraceActivatedPluginEvent ev;
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            ev = (TraceActivatedPluginEvent)event;
            this.provider.setTrace(ev.getActiveCoordinates().getTrace());
        }
        if (event instanceof ProgramActivatedPluginEvent) {
            ev = (ProgramActivatedPluginEvent)event;
            this.provider.setProgram(ev.getActiveProgram());
        }
    }
}

