/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.jar.ResourceFile;
import ghidra.app.plugin.processors.sleigh.SleighLanguageProvider;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.ExternalLanguageCompilerSpecQuery;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageCompilerSpecQuery;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageProvider;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Processor;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.task.TaskBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultLanguageService
implements LanguageService,
ChangeListener {
    private static final Logger log = LogManager.getLogger(DefaultLanguageService.class);
    private List<LanguageInfo> languageInfos = new ArrayList<LanguageInfo>();
    private HashMap<LanguageID, LanguageInfo> languageMap = new HashMap();
    private boolean searchCompleted = false;
    private static DefaultLanguageService languageService;

    public static synchronized LanguageService getLanguageService() {
        if (languageService == null) {
            languageService = new DefaultLanguageService();
        } else if (!DefaultLanguageService.languageService.searchCompleted) {
            languageService.searchForProviders();
        }
        return languageService;
    }

    public static synchronized LanguageService getLanguageService(ResourceFile sleighLdefsFile) throws Exception {
        SleighLanguageProvider provider = new SleighLanguageProvider(sleighLdefsFile);
        if (languageService == null) {
            languageService = new DefaultLanguageService(provider);
        }
        languageService.addLanguages(provider);
        return languageService;
    }

    private DefaultLanguageService() {
        this.searchForProviders();
        ClassSearcher.addChangeListener((ChangeListener)this);
    }

    private DefaultLanguageService(LanguageProvider provider) {
        this.addLanguages(provider);
    }

    private void searchForProviders() {
        List languageProviders = ClassSearcher.getInstances(LanguageProvider.class);
        this.searchCompleted = true;
        TaskBuilder.withRunnable(monitor -> this.processProviders(languageProviders)).setTitle("Language Search").setCanCancel(false).setHasProgress(false).launchModal();
    }

    @Override
    public Language getLanguage(LanguageID languageID) throws LanguageNotFoundException {
        LanguageInfo info = this.languageMap.get(languageID);
        if (info == null) {
            throw new LanguageNotFoundException(languageID);
        }
        return info.getLanguage();
    }

    @Override
    public LanguageDescription getLanguageDescription(LanguageID languageID) throws LanguageNotFoundException {
        LanguageInfo info = this.languageMap.get(languageID);
        if (info == null) {
            throw new LanguageNotFoundException(languageID);
        }
        return info.description;
    }

    @Override
    public List<LanguageDescription> getLanguageDescriptions(boolean includeDeprecatedLanguages) {
        ArrayList<LanguageDescription> languageDescriptions = new ArrayList<LanguageDescription>();
        for (LanguageInfo info : this.languageInfos) {
            if (!includeDeprecatedLanguages && info.description.isDeprecated()) continue;
            languageDescriptions.add(info.description);
        }
        return languageDescriptions;
    }

    @Override
    public List<LanguageDescription> getLanguageDescriptions(Processor processor, Endian endianess, Integer size, String variant) {
        ArrayList<LanguageDescription> languageDescriptions = new ArrayList<LanguageDescription>();
        for (LanguageInfo info : this.languageInfos) {
            LanguageDescription description = info.description;
            if (processor != null && processor != description.getProcessor() || endianess != null && endianess != description.getEndian() || size != null && size.intValue() != description.getSize() || variant != null && !variant.equals(description.getVariant())) continue;
            languageDescriptions.add(description);
        }
        return languageDescriptions;
    }

    private static boolean languageMatchesExternalProcessor(LanguageDescription description, String externalProcessorName, String externalTool) {
        List<String> extNames;
        boolean result = false;
        if (externalProcessorName == null) {
            result = true;
        } else if (externalTool != null && (extNames = description.getExternalNames(externalTool)) != null) {
            for (String extName : extNames) {
                if (!externalProcessorName.equalsIgnoreCase(extName)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public List<LanguageDescription> getExternalLanguageDescriptions(String externalProcessorName, String externalTool, Endian endianess, Integer size) {
        ArrayList<LanguageDescription> languageDescriptions = new ArrayList<LanguageDescription>();
        for (LanguageInfo info : this.languageInfos) {
            LanguageDescription description = info.description;
            if (!DefaultLanguageService.languageMatchesExternalProcessor(description, externalProcessorName, externalTool) || endianess != null && endianess != description.getEndian() || size != null && size.intValue() != description.getSize()) continue;
            languageDescriptions.add(description);
        }
        return languageDescriptions;
    }

    @Override
    public List<LanguageCompilerSpecPair> getLanguageCompilerSpecPairs(LanguageCompilerSpecQuery query) {
        ArrayList<LanguageCompilerSpecPair> result = new ArrayList<LanguageCompilerSpecPair>();
        List<LanguageDescription> languageDescriptions = this.getLanguageDescriptions(query.processor, query.endian, query.size, query.variant);
        for (LanguageDescription languageDescription : languageDescriptions) {
            if (languageDescription.isDeprecated()) continue;
            Collection<CompilerSpecDescription> compilerSpecDescriptions = languageDescription.getCompatibleCompilerSpecDescriptions();
            for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
                if (query.compilerSpecID != null && !query.compilerSpecID.equals(compilerSpecDescription.getCompilerSpecID())) continue;
                result.add(new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID()));
            }
        }
        return result;
    }

    @Override
    public List<LanguageCompilerSpecPair> getLanguageCompilerSpecPairs(ExternalLanguageCompilerSpecQuery query) {
        ArrayList<LanguageCompilerSpecPair> result = new ArrayList<LanguageCompilerSpecPair>();
        List<LanguageDescription> languageDescriptions = this.getExternalLanguageDescriptions(query.externalProcessorName, query.externalTool, query.endian, query.size);
        for (LanguageDescription languageDescription : languageDescriptions) {
            if (languageDescription.isDeprecated()) continue;
            this.addLanguageCompilerSpecPairs(languageDescription, query.compilerSpecID, result);
        }
        return result;
    }

    private void addLanguageCompilerSpecPairs(LanguageDescription languageDescription, CompilerSpecID preferredCompilerSpecId, List<LanguageCompilerSpecPair> result) {
        Collection<CompilerSpecDescription> compilerSpecDescriptions = languageDescription.getCompatibleCompilerSpecDescriptions();
        if (preferredCompilerSpecId != null) {
            for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
                if (!preferredCompilerSpecId.equals(compilerSpecDescription.getCompilerSpecID())) continue;
                result.add(new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID()));
                return;
            }
        }
        for (CompilerSpecDescription compilerSpecDescription : compilerSpecDescriptions) {
            result.add(new LanguageCompilerSpecPair(languageDescription.getLanguageID(), compilerSpecDescription.getCompilerSpecID()));
        }
    }

    @Override
    public List<LanguageDescription> getLanguageDescriptions(Processor processor) {
        ArrayList<LanguageDescription> list = new ArrayList<LanguageDescription>();
        for (LanguageInfo info : this.languageInfos) {
            if (!info.description.getProcessor().equals(processor)) continue;
            list.add(info.description);
        }
        return list;
    }

    public static List<String> getDefinedExternalToolNames(String languageId, String tool, boolean includeDeprecated) {
        List<LanguageDescription> languageDescriptions;
        List<String> returnValue = null;
        if (languageId != null && languageId.length() > 0 && tool != null && tool.length() > 0 && (languageDescriptions = DefaultLanguageService.getLanguageService().getLanguageDescriptions(includeDeprecated)) != null) {
            for (LanguageDescription ld : languageDescriptions) {
                List<String> externalNames;
                if (ld == null || !languageId.equals(ld.getLanguageID().toString()) || (externalNames = ld.getExternalNames(tool)) == null) continue;
                returnValue = externalNames;
                break;
            }
        }
        return returnValue;
    }

    @Override
    public Language getDefaultLanguage(Processor processor) throws LanguageNotFoundException {
        if (processor == null) {
            throw new IllegalArgumentException("processor == null not allowed");
        }
        for (LanguageInfo info : this.languageInfos) {
            if (!info.description.getProcessor().equals(processor)) continue;
            long start = System.currentTimeMillis();
            Language language = info.getLanguage();
            log.debug("getDefaultLanguage(" + language.getLanguageID() + ") took " + (System.currentTimeMillis() - start) + " ms");
            return language;
        }
        throw new LanguageNotFoundException(processor);
    }

    private void processProviders(List<LanguageProvider> providers) {
        for (LanguageProvider provider : providers) {
            this.addLanguages(provider);
        }
    }

    private void addLanguages(LanguageProvider provider) {
        LanguageDescription[] lds;
        for (LanguageDescription description : lds = provider.getLanguageDescriptions()) {
            LanguageInfo info = new LanguageInfo(description, provider);
            if (this.languageInfos.contains(info)) continue;
            this.languageInfos.add(info);
            LanguageID id = info.description.getLanguageID();
            if (this.languageMap.containsKey(id)) {
                throw new IllegalStateException("Duplicate language ID encountered: " + id);
            }
            this.languageMap.put(id, info);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.searchForProviders();
    }

    private class LanguageInfo {
        private LanguageProvider provider;
        LanguageDescription description;

        LanguageInfo(LanguageDescription ld, LanguageProvider lp) {
            this.description = ld;
            this.provider = lp;
        }

        synchronized Language getLanguage() {
            LanguageID id = this.description.getLanguageID();
            if (this.provider.isLanguageLoaded(id)) {
                return this.provider.getLanguage(id);
            }
            TaskBuilder.withRunnable(monitor -> this.provider.getLanguage(id)).setTitle("Loading language '" + id + "'").setCanCancel(false).setHasProgress(false).launchModal();
            return this.provider.getLanguage(id);
        }

        public String toString() {
            return this.description.getLanguageID().getIdAsString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LanguageInfo)) {
                return false;
            }
            LanguageInfo otherInfo = (LanguageInfo)obj;
            return this.description.getLanguageID().equals(otherInfo.description.getLanguageID());
        }

        public int hashCode() {
            return this.description.getLanguageID().hashCode();
        }
    }
}

