/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import java.math.BigInteger;
import java.util.List;

public interface ProcessorContextView {
    public Register getBaseContextRegister();

    public List<Register> getRegisters();

    public Register getRegister(String var1);

    public BigInteger getValue(Register var1, boolean var2);

    public RegisterValue getRegisterValue(Register var1);

    public boolean hasValue(Register var1);

    public static String dumpContextValue(RegisterValue value, String indent) {
        StringBuilder buf = new StringBuilder();
        ProcessorContextView.dumpContextValue(value, indent, buf);
        return buf.toString();
    }

    public static void dumpContextValue(RegisterValue value, String indent, StringBuilder buf) {
        if (indent == null) {
            indent = "";
        }
        Register baseReg = value.getRegister();
        int baseRegSize = baseReg.getMinimumByteSize() * 8;
        for (Register reg : baseReg.getChildRegisters()) {
            RegisterValue childValue = value.getRegisterValue(reg);
            if (!childValue.hasAnyValue()) continue;
            BigInteger v = childValue.getUnsignedValueIgnoreMask();
            int msb = baseRegSize - reg.getLeastSignificatBitInBaseRegister() - 1;
            int lsb = msb - reg.getBitLength() + 1;
            if (buf.length() != 0) {
                buf.append("\n");
            }
            buf.append(indent + reg.getName() + "(" + lsb + "," + msb + ") = 0x" + Long.toHexString(v.longValue()));
            if (!reg.hasChildren()) continue;
            ProcessorContextView.dumpContextValue(childValue, indent + "   ", buf);
        }
    }
}

