/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.jar.ResourceFile;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataOrganizationImpl;
import ghidra.util.InvalidNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;

public class StandAloneDataTypeManager
extends DataTypeManagerDB {
    protected String name;
    private int transactionCount;
    private Long transaction;

    public StandAloneDataTypeManager(String rootName) {
        super(DataOrganizationImpl.getDefaultOrganization());
        this.name = rootName;
    }

    public StandAloneDataTypeManager(String rootName, DataOrganization dataOrganzation) {
        super(dataOrganzation);
        this.name = rootName;
    }

    protected StandAloneDataTypeManager(ResourceFile packedDbfile, int openMode) throws IOException {
        super(packedDbfile, openMode);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) throws InvalidNameException {
        if (name == null || name.length() == 0) {
            throw new InvalidNameException("Name is invalid: " + name);
        }
        this.name = name;
        this.defaultListener.categoryRenamed(this, CategoryPath.ROOT, CategoryPath.ROOT);
    }

    @Override
    public final DataOrganization getDataOrganization() {
        return super.getDataOrganization();
    }

    @Override
    public synchronized int startTransaction(String description) {
        if (this.transaction == null) {
            this.transaction = this.dbHandle.startTransaction();
        }
        ++this.transactionCount;
        return this.transaction.intValue();
    }

    @Override
    public void flushEvents() {
    }

    @Override
    public synchronized void endTransaction(int transactionID, boolean commit) {
        if (this.transaction == null) {
            throw new IllegalStateException("No Transaction Open");
        }
        if (this.transaction.intValue() != transactionID) {
            throw new IllegalArgumentException("Transaction id does not match current transaction");
        }
        if (--this.transactionCount == 0) {
            try {
                this.dbHandle.endTransaction(this.transaction.longValue(), commit);
                this.transaction = null;
            }
            catch (IOException e) {
                this.dbError(e);
            }
        }
    }

    @Override
    protected void replaceDataTypeIDs(long oldID, long newID) {
    }

    @Override
    protected void deleteDataTypeIDs(LinkedList<Long> deletedIds, TaskMonitor monitor) {
    }

    @Override
    public void close() {
        if (!this.dbHandle.isClosed()) {
            this.dbHandle.close();
        }
        super.close();
    }

    public void finalize() {
        this.close();
    }

    @Override
    protected String getDomainFileID() {
        return null;
    }

    @Override
    protected String getPath() {
        return null;
    }

    @Override
    public ArchiveType getType() {
        return ArchiveType.TEST;
    }
}

