/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.reloc;

import db.BinaryCodedField;
import db.BinaryField;
import db.DBHandle;
import db.DBRecord;
import db.RecordIterator;
import ghidra.framework.options.Options;
import ghidra.program.database.ManagerDB;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.reloc.RelocationDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Iterator;

public class RelocationManager
implements RelocationTable,
ManagerDB {
    private ProgramDB program;
    private AddressMap addrMap;
    private RelocationDBAdapter adapter;
    private Boolean isRelocatable = null;

    public RelocationManager(DBHandle handle, AddressMap addrMap, int openMode, Lock lock, TaskMonitor monitor) throws VersionException, IOException {
        this.addrMap = addrMap;
        this.initializeAdapters(handle, openMode, monitor);
    }

    private void initializeAdapters(DBHandle handle, int openMode, TaskMonitor monitor) throws VersionException, IOException {
        this.adapter = RelocationDBAdapter.getAdapter(handle, openMode, this.addrMap, monitor);
    }

    @Override
    public void invalidateCache(boolean all) {
    }

    @Override
    public void setProgram(ProgramDB p) {
        this.program = p;
    }

    @Override
    public void programReady(int openMode, int currentRevision, TaskMonitor monitor) throws IOException, CancelledException {
    }

    @Override
    public Relocation add(Address addr, int type, long[] values, byte[] bytes, String symbolName) {
        try {
            this.adapter.add(this.addrMap.getKey(addr, true), type, values, bytes, symbolName);
            return new Relocation(addr, type, values, bytes, symbolName);
        }
        catch (IOException e) {
            this.program.dbError(e);
            return null;
        }
    }

    @Override
    public void remove(Relocation reloc) {
        try {
            this.adapter.remove(this.addrMap.getKey(reloc.getAddress(), false));
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
    }

    @Override
    public Relocation getRelocation(Address addr) {
        try {
            DBRecord rec = this.adapter.get(this.addrMap.getKey(addr, false));
            if (rec != null) {
                return this.getRelocation(rec);
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return null;
    }

    private Relocation getRelocation(DBRecord rec) {
        BinaryCodedField valuesField = new BinaryCodedField((BinaryField)rec.getFieldValue(1));
        return new Relocation(this.addrMap.decodeAddress(rec.getKey()), rec.getIntValue(0), valuesField.getLongArray(), rec.getBinaryData(2), rec.getString(3));
    }

    @Override
    public Iterator<Relocation> getRelocations() {
        RecordIterator ri = null;
        try {
            ri = this.adapter.iterator();
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return new RelocationIterator(ri);
    }

    @Override
    public Relocation getRelocationAfter(Address addr) {
        RecordIterator ri = null;
        try {
            ri = this.adapter.iterator(addr);
            if (ri.hasNext()) {
                DBRecord r = ri.next();
                Relocation relocation = this.getRelocation(r);
                if (!relocation.getAddress().equals(addr)) {
                    return relocation;
                }
                if (ri.hasNext()) {
                    r = ri.next();
                    return this.getRelocation(r);
                }
            }
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return null;
    }

    @Override
    public Iterator<Relocation> getRelocations(AddressSetView set) {
        RecordIterator ri = null;
        try {
            ri = this.adapter.iterator(set);
        }
        catch (IOException e) {
            this.program.dbError(e);
        }
        return new RelocationIterator(ri);
    }

    @Override
    public int getSize() {
        return this.adapter.getRecordCount();
    }

    @Override
    public boolean isRelocatable() {
        if (this.isRelocatable == null) {
            Options propList = this.program.getOptions("Program Information");
            this.isRelocatable = propList.contains("Relocatable") ? Boolean.valueOf(propList.getBoolean("Relocatable", false)) : Boolean.valueOf(this.getSize() > 0);
        }
        return this.isRelocatable;
    }

    @Override
    public void deleteAddressRange(Address startAddr, Address endAddr, TaskMonitor monitor) {
    }

    @Override
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) {
    }

    private class RelocationIterator
    implements Iterator<Relocation> {
        private RecordIterator ri;

        RelocationIterator(RecordIterator ri) {
            this.ri = ri;
        }

        @Override
        public boolean hasNext() {
            if (this.ri == null) {
                return false;
            }
            try {
                return this.ri.hasNext();
            }
            catch (IOException e) {
                RelocationManager.this.program.dbError(e);
                return false;
            }
        }

        @Override
        public Relocation next() {
            if (this.ri == null) {
                return null;
            }
            try {
                DBRecord r = this.ri.next();
                return RelocationManager.this.getRelocation(r);
            }
            catch (IOException e) {
                RelocationManager.this.program.dbError(e);
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from relocation table inside iterator!");
        }
    }
}

