/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.EnumValueDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class EnumValueDBAdapterV0
extends EnumValueDBAdapter {
    static final int VERSION = 0;
    private Table table;

    public EnumValueDBAdapterV0(DBHandle handle) throws VersionException {
        this.table = handle.getTable("Enumeration Values");
        if (this.table == null) {
            throw new VersionException("Missing Table: Enumeration Values");
        }
        int version = this.table.getSchema().getVersion();
        if (version != 0) {
            String msg = "Expected version 0 for table Enumeration Values but got " + this.table.getSchema().getVersion();
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    public void createRecord(long enumID, String name, long value, String comment) throws IOException {
        throw new UnsupportedOperationException("Cannot update Version 0");
    }

    @Override
    public DBRecord getRecord(long valueID) throws IOException {
        return this.translateRecord(this.table.getRecord(valueID));
    }

    @Override
    public void removeRecord(long valueID) throws IOException {
        throw new UnsupportedOperationException("Cannot remove Version 0");
    }

    @Override
    public void updateRecord(DBRecord record) throws IOException {
        throw new UnsupportedOperationException("Cannot update Version 0");
    }

    @Override
    public Field[] getValueIdsInEnum(long enumID) throws IOException {
        return this.table.findRecords((Field)new LongField(enumID), 2);
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord record = EnumValueDBAdapter.ENUM_VALUE_SCHEMA.createRecord(oldRec.getKey());
        record.setLongValue(2, oldRec.getLongValue(2));
        record.setString(0, oldRec.getString(0));
        record.setLongValue(1, oldRec.getLongValue(1));
        record.setString(3, null);
        return record;
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.table.iterator(), (RecordTranslator)this);
    }
}

