/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.provider.markuptable;

import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import ghidra.docking.settings.Settings;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.gui.provider.markuptable.MarkupStatusIcons;
import ghidra.feature.vt.gui.provider.markuptable.VTMarkupItemsTableModel;
import ghidra.util.exception.AssertException;
import ghidra.util.table.column.AbstractGhidraColumnRenderer;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import resources.ResourceManager;

public class MarkupItemStatusRenderer
extends AbstractGhidraColumnRenderer<VTMarkupItemStatus> {
    private GTableCellRenderer dummy = new GTableCellRenderer();

    public Component getTableCellRendererComponent(GTableCellRenderingData data) {
        JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
        Object value = data.getValue();
        JTable table = data.getTable();
        int row = data.getRowViewIndex();
        if (!(value instanceof VTMarkupItemStatus)) {
            throw new AssertException("Incorrect column value for the markup item status column");
        }
        VTMarkupItemStatus status = (VTMarkupItemStatus)((Object)value);
        this.configureRendererForMarkupStatus(table, row, renderer, status);
        return renderer;
    }

    private JLabel configureRendererForMarkupStatus(JTable table, int row, JLabel renderer, VTMarkupItemStatus value) {
        renderer.setText("");
        renderer.setHorizontalAlignment(0);
        VTMarkupItemStatus status = value;
        switch (status) {
            case UNAPPLIED: {
                renderer.setIcon(null);
                renderer.setToolTipText("Not Applied");
                break;
            }
            case SAME: {
                renderer.setIcon(MarkupStatusIcons.SAME_ICON);
                renderer.setToolTipText("Destination already has same value as source");
                break;
            }
            case ADDED: {
                renderer.setIcon(MarkupStatusIcons.APPLIED_ADDED_ICON);
                renderer.setToolTipText("Applied - Added");
                break;
            }
            case REPLACED: {
                renderer.setIcon(MarkupStatusIcons.APPLIED_REPLACED_ICON);
                renderer.setToolTipText("Applied - Replaced");
                break;
            }
            case REJECTED: {
                renderer.setIcon(MarkupStatusIcons.REJECTED_ICON);
                renderer.setToolTipText("Rejected");
                break;
            }
            case FAILED_APPLY: {
                renderer.setIcon(MarkupStatusIcons.FAILED_ICON);
                renderer.setToolTipText(this.getFailedTooltipText(table, row));
                break;
            }
            case DONT_KNOW: {
                renderer.setIcon(MarkupStatusIcons.DONT_KNOW_ICON);
                renderer.setToolTipText("Don't Know");
                break;
            }
            case DONT_CARE: {
                renderer.setIcon(MarkupStatusIcons.DONT_CARE_ICON);
                renderer.setToolTipText("Don't Care");
                break;
            }
            case CONFLICT: {
                renderer.setIcon(MarkupStatusIcons.CONFLICT_ICON);
                renderer.setToolTipText("This markup item conflicts with another item that is already applied");
                break;
            }
            default: {
                renderer.setIcon(ResourceManager.loadImage((String)"images/core.png"));
                renderer.setToolTipText("Unexpected match status state!: " + status);
            }
        }
        return renderer;
    }

    private String getFailedTooltipText(JTable table, int row) {
        if (table == null) {
            return "Apply Failed";
        }
        VTMarkupItemsTableModel model = (VTMarkupItemsTableModel)((Object)table.getModel());
        VTMarkupItem item = (VTMarkupItem)model.getRowObject(row);
        String description = item.getStatusDescription();
        if (description != null) {
            return description;
        }
        return "Apply Failed";
    }

    public String getFilterString(VTMarkupItemStatus t, Settings settings) {
        this.configureRendererForMarkupStatus(null, -1, (JLabel)this.dummy, t);
        return this.dummy.getText();
    }
}

