/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgeng.manager.impl;

import agent.dbgeng.dbgeng.DebugRegisters;

public class DbgRegister
implements Comparable<DbgRegister> {
    private final String name;
    private final int number;
    private final int size;
    private DebugRegisters.DebugRegisterDescription desc;

    public DbgRegister(String name, int number, int size) {
        this.name = name;
        this.number = number;
        this.size = size;
    }

    public DbgRegister(DebugRegisters.DebugRegisterDescription desc) {
        this.name = desc.name;
        this.number = desc.index;
        this.size = desc.type.byteLength;
        this.desc = desc;
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public int compareTo(DbgRegister that) {
        return this.number - that.number;
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + " " + this.name + " (" + this.number + ")>";
    }

    public boolean isBaseRegister() {
        if (this.desc == null) {
            return true;
        }
        return this.desc.subregMaster == 0;
    }
}

