/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ModuleReference;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.error.DebuggerUserException;
import ghidra.dbg.jdi.model.JdiModelTargetModule;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetVM;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetModuleContainer;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.lifecycle.Internal;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="TargetModuleContainer", elements={@TargetElementType(type=JdiModelTargetModule.class)}, elementResync=TargetObjectSchema.ResyncMode.ONCE, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetModuleContainer
extends JdiModelTargetObjectImpl
implements TargetModuleContainer {
    protected final JdiModelTargetVM vm;
    protected final Map<String, JdiModelTargetModule> modulesByName = new HashMap<String, JdiModelTargetModule>();

    public JdiModelTargetModuleContainer(JdiModelTargetVM vm) {
        super(vm, "Modules");
        this.vm = vm;
    }

    @Internal
    public JdiModelTargetModule libraryLoaded(String name) {
        List<ModuleReference> allModules = this.vm.vm.allModules();
        for (ModuleReference ref : allModules) {
            if (!JdiModelTargetModule.getUniqueId(ref).equals(name)) continue;
            JdiModelTargetModule module = this.getTargetModule(ref);
            this.changeElements(List.of(), List.of(module), Map.of(), "Loaded");
            return module;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void libraryUnloaded(String name) {
        JdiModelTargetModuleContainer jdiModelTargetModuleContainer = this;
        synchronized (jdiModelTargetModuleContainer) {
            this.modulesByName.remove(name);
        }
        this.changeElements(List.of(name), List.of(), Map.of(), "Unloaded");
    }

    public boolean supportsSyntheticModules() {
        return false;
    }

    public CompletableFuture<? extends TargetModule> addSyntheticModule(String name) {
        throw new DebuggerUserException("GDB Does not support synthetic modules");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingModules(Map<String, ModuleReference> byName) {
        List modules;
        JdiModelTargetModuleContainer jdiModelTargetModuleContainer = this;
        synchronized (jdiModelTargetModuleContainer) {
            modules = byName.values().stream().map(this::getTargetModule).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetModule mod : modules) {
            fence.include(mod.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), modules, Map.of(), "Refreshed"));
    }

    protected CompletableFuture<Void> requestElements(boolean refresh) {
        return this.doRefresh();
    }

    protected CompletableFuture<Void> doRefresh() {
        HashMap<String, ModuleReference> map = new HashMap<String, ModuleReference>();
        List<ModuleReference> allModules = this.vm.vm.allModules();
        for (ModuleReference ref : allModules) {
            map.put(JdiModelTargetModule.getUniqueId(ref), ref);
        }
        this.modulesByName.keySet().retainAll(map.keySet());
        return this.updateUsingModules(map);
    }

    protected synchronized JdiModelTargetModule getTargetModule(ModuleReference module) {
        return this.modulesByName.computeIfAbsent(JdiModelTargetModule.getUniqueId(module), n -> new JdiModelTargetModule(this, module, true));
    }

    public synchronized JdiModelTargetModule getTargetModuleIfPresent(String name) {
        return this.modulesByName.get(name);
    }

    public CompletableFuture<?> refreshInternal() {
        if (!this.isObserved()) {
            return AsyncUtils.NIL;
        }
        return this.doRefresh().exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Problem refreshing inferior's modules", (Throwable)ex);
            return null;
        });
    }
}

