/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.jdi.model.JdiModelTargetConnector;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetRoot;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@TargetObjectSchemaInfo(name="ConnectorContainer", elements={@TargetElementType(type=JdiModelTargetConnector.class)}, attributes={@TargetAttributeType(type=Void.class)}, canonicalContainer=true)
public class JdiModelTargetConnectorContainer
extends JdiModelTargetObjectImpl {
    protected final JdiModelTargetRoot root;
    protected final Map<String, JdiModelTargetConnector> connectorsByName = new HashMap<String, JdiModelTargetConnector>();
    private JdiModelTargetConnector defaultConnector;

    public JdiModelTargetConnectorContainer(JdiModelTargetRoot root) {
        super(root, "Connectors");
        this.root = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CompletableFuture<Void> updateUsingConnectors(Map<String, Connector> byName) {
        List connectors;
        JdiModelTargetConnectorContainer jdiModelTargetConnectorContainer = this;
        synchronized (jdiModelTargetConnectorContainer) {
            connectors = byName.values().stream().map(this::getTargetConnector).collect(Collectors.toList());
        }
        AsyncFence fence = new AsyncFence();
        for (JdiModelTargetConnector c : connectors) {
            fence.include(c.init());
        }
        return fence.ready().thenAccept(__ -> this.changeElements(List.of(), connectors, Map.of(), "Refreshed"));
    }

    protected CompletableFuture<Void> requestElements(boolean refresh) {
        return this.doRefresh();
    }

    protected CompletableFuture<Void> doRefresh() {
        HashMap<String, Connector> map = new HashMap<String, Connector>();
        VirtualMachineManager vmm = this.impl.getManager().getVirtualMachineManager();
        List<Connector> allConnectors = vmm.allConnectors();
        for (Connector cx : allConnectors) {
            map.put(cx.name(), cx);
        }
        this.connectorsByName.keySet().retainAll(map.keySet());
        return this.updateUsingConnectors(map);
    }

    protected synchronized JdiModelTargetConnector getTargetConnector(Connector cx) {
        return this.connectorsByName.computeIfAbsent(cx.name(), n -> new JdiModelTargetConnector(this, cx, true));
    }

    public synchronized JdiModelTargetConnector getTargetConnectorIfPresent(String name) {
        for (String key : this.connectorsByName.keySet()) {
            if (!key.contains(name)) continue;
            return this.connectorsByName.get(key);
        }
        return null;
    }

    public CompletableFuture<?> refreshInternal() {
        if (!this.isObserved()) {
            return AsyncUtils.NIL;
        }
        return this.doRefresh().exceptionally(ex -> {
            Msg.error((Object)this, (Object)"Problem refreshing inferior's modules", (Throwable)ex);
            return null;
        });
    }

    public JdiModelTargetConnector getDefaultConnector() {
        return this.defaultConnector;
    }

    public void setDefaultConnector(JdiModelTargetConnector defaultConnector) {
        this.defaultConnector = defaultConnector;
    }
}

