/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.component.ClangHighlightListener;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.NullClangHighlightController;
import ghidra.app.decompiler.component.TokenHighlightColors;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.plugin.core.decompile.actions.TokenHighlightColorProvider;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import util.CollectionUtils;

public abstract class ClangHighlightController {
    public static Color DEFAULT_HIGHLIGHT_COLOR = new Color(255, 255, 0, 128);
    protected Color defaultHighlightColor = DEFAULT_HIGHLIGHT_COLOR;
    protected Color defaultParenColor = DEFAULT_HIGHLIGHT_COLOR;
    private TokenHighlights primaryHighlightTokens = new TokenHighlights();
    private TokenHighlights secondaryHighlightTokens = new TokenHighlights();
    private TokenHighlightColors secondaryHighlightColors = new TokenHighlightColors();
    private long updateId;
    private List<ClangHighlightListener> listeners = new ArrayList<ClangHighlightListener>();

    public static ClangHighlightController dummyIfNull(ClangHighlightController c) {
        if (c == null) {
            return new NullClangHighlightController();
        }
        return c;
    }

    public abstract void fieldLocationChanged(FieldLocation var1, Field var2, EventTrigger var3);

    void setHighlightColor(Color c) {
        this.defaultHighlightColor = c;
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public TokenHighlightColors getSecondaryHighlightColors() {
        return this.secondaryHighlightColors;
    }

    public TokenHighlights getPrimaryHighlightedTokens() {
        return this.primaryHighlightTokens;
    }

    public TokenHighlights getSecondaryHighlightedTokens() {
        return this.secondaryHighlightTokens;
    }

    public ClangToken getHighlightedToken() {
        if (this.primaryHighlightTokens.size() == 1) {
            HighlightToken hlToken = (HighlightToken)CollectionUtils.any((Iterable)this.primaryHighlightTokens);
            return hlToken.getToken();
        }
        return null;
    }

    private void gatherAllTokens(ClangNode parentNode, Set<ClangToken> results) {
        int n = parentNode.numChildren();
        for (int i = 0; i < n; ++i) {
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                this.gatherAllTokens(node, results);
                continue;
            }
            if (!(node instanceof ClangToken)) continue;
            results.add((ClangToken)node);
        }
    }

    public void clearPrimaryHighlights() {
        this.doClearHighlights(this.primaryHighlightTokens);
        this.notifyListeners();
    }

    public void clearAllHighlights() {
        this.doClearHighlights(this.primaryHighlightTokens);
        this.doClearHighlights(this.secondaryHighlightTokens);
        this.notifyListeners();
    }

    private void doClearHighlights(TokenHighlights tokenHighlights) {
        Iterator<HighlightToken> it = tokenHighlights.iterator();
        while (it.hasNext()) {
            HighlightToken highlight = it.next();
            it.remove();
            ClangToken token = highlight.getToken();
            token.setMatchingToken(false);
            this.updateHighlightColor(token);
        }
        tokenHighlights.clear();
    }

    public void togglePrimaryHighlights(Color hlColor, Supplier<List<ClangToken>> tokens) {
        boolean isAllHighlighted = true;
        for (ClangToken otherToken : tokens.get()) {
            if (this.hasPrimaryHighlight(otherToken)) continue;
            isAllHighlighted = false;
            break;
        }
        this.clearPrimaryHighlights();
        if (isAllHighlighted) {
            return;
        }
        this.addPrimaryHighlights(tokens, hlColor);
    }

    public boolean hasPrimaryHighlight(ClangToken token) {
        return this.primaryHighlightTokens.contains(token);
    }

    public boolean hasSecondaryHighlight(ClangToken token) {
        return this.secondaryHighlightTokens.contains(token);
    }

    public Set<HighlightToken> getSecondaryHighlightsByFunction(Function f) {
        Set<HighlightToken> highlights = this.secondaryHighlightTokens.getHighlightsByFunction(f);
        return highlights;
    }

    public void removeSecondaryHighlights(Function f) {
        Set<HighlightToken> oldHighlights = this.secondaryHighlightTokens.removeHighlightsByFunction(f);
        for (HighlightToken hl : oldHighlights) {
            ClangToken token = hl.getToken();
            this.updateHighlightColor(token);
        }
        this.notifyListeners();
    }

    public void removeSecondaryHighlights(ClangToken token) {
        this.secondaryHighlightTokens.remove(token);
    }

    public void removeSecondaryHighlights(Supplier<? extends Collection<ClangToken>> tokens) {
        for (ClangToken clangToken : tokens.get()) {
            this.secondaryHighlightTokens.remove(clangToken);
            this.updateHighlightColor(clangToken);
        }
        this.notifyListeners();
    }

    public void addSecondaryHighlights(String tokenText, Supplier<? extends Collection<ClangToken>> tokens) {
        Color highlightColor = this.secondaryHighlightColors.getColor(tokenText);
        this.addSecondaryHighlights(tokens, highlightColor);
    }

    public void addSecondaryHighlights(Supplier<? extends Collection<ClangToken>> tokens, Color hlColor) {
        java.util.function.Function<ClangToken, Color> colorProvider = token -> hlColor;
        this.addTokensToHighlights(tokens.get(), colorProvider, this.secondaryHighlightTokens);
    }

    public void addPrimaryHighlights(Supplier<? extends Collection<ClangToken>> tokens, Color hlColor) {
        java.util.function.Function<ClangToken, Color> colorProvider = token -> hlColor;
        this.addTokensToHighlights(tokens.get(), colorProvider, this.primaryHighlightTokens);
    }

    public void addPrimaryHighlights(ClangNode parentNode, TokenHighlightColorProvider colorProvider) {
        HashSet<ClangToken> tokens = new HashSet<ClangToken>();
        this.gatherAllTokens(parentNode, tokens);
        this.addTokensToHighlights(tokens, colorProvider::getColor, this.primaryHighlightTokens);
    }

    public void addPrimaryHighlights(ClangNode parentNode, Set<PcodeOp> ops, Color hlColor) {
        this.addPrimaryHighlights(parentNode, (ClangToken token) -> {
            PcodeOp op = token.getPcodeOp();
            return ops.contains(op) ? hlColor : null;
        });
    }

    private void addPrimaryHighlights(Collection<ClangToken> tokens, Color hlColor) {
        java.util.function.Function<ClangToken, Color> colorProvider = token -> hlColor;
        this.addTokensToHighlights(tokens, colorProvider, this.primaryHighlightTokens);
    }

    private void addTokensToHighlights(Collection<ClangToken> tokens, java.util.function.Function<ClangToken, Color> colorProvider, TokenHighlights currentHighlights) {
        ++this.updateId;
        for (ClangToken clangToken : tokens) {
            Color color = colorProvider.apply(clangToken);
            this.doAddHighlight(clangToken, color, currentHighlights);
        }
        this.notifyListeners();
    }

    protected void addPrimaryHighlight(ClangToken token, Color highlightColor) {
        this.addPrimaryHighlights(Set.of(token), highlightColor);
    }

    private void doAddHighlight(ClangToken clangToken, Color highlightColor, TokenHighlights currentHighlights) {
        if (highlightColor == null) {
            return;
        }
        currentHighlights.add(new HighlightToken(clangToken, highlightColor));
        this.updateHighlightColor(clangToken);
    }

    private void updateHighlightColor(ClangToken t) {
        Color combinedColor = this.getCombinedColor(t);
        t.setHighlight(combinedColor);
    }

    public Color getCombinedColor(ClangToken t) {
        Color secondary;
        HighlightToken primaryHl = this.primaryHighlightTokens.get(t);
        HighlightToken secondaryHl = this.secondaryHighlightTokens.get(t);
        Color primary = primaryHl == null ? null : primaryHl.getColor();
        Color color = secondary = secondaryHl == null ? null : secondaryHl.getColor();
        if (primary == null) {
            if (secondary == null) {
                return null;
            }
            return secondary;
        }
        if (secondary == null) {
            return primary;
        }
        return ColorUtils.blend((Color)primary, (Color)secondary, (float)0.8f);
    }

    protected List<ClangToken> addPrimaryHighlightToTokensForParenthesis(ClangSyntaxToken tok, Color highlightColor) {
        int paren = tok.getOpen();
        if (paren == -1) {
            paren = tok.getClose();
        }
        if (paren == -1) {
            return new ArrayList<ClangToken>();
        }
        List<ClangToken> results = this.gatherContentsOfParenthesis(tok, paren);
        this.addPrimaryHighlights(results, highlightColor);
        return results;
    }

    private List<ClangToken> gatherContentsOfParenthesis(ClangSyntaxToken tok, int parenId) {
        ArrayList<ClangToken> results = new ArrayList<ClangToken>();
        int parenCount = 0;
        ClangNode par = tok.Parent();
        while (par != null) {
            boolean outside = true;
            if (!(par instanceof ClangTokenGroup)) {
                par = par.Parent();
                continue;
            }
            ArrayList<ClangNode> list = new ArrayList<ClangNode>();
            ((ClangTokenGroup)par).flatten(list);
            for (ClangNode node : list) {
                ClangToken tk = (ClangToken)node;
                if (tk instanceof ClangSyntaxToken) {
                    ClangSyntaxToken syn = (ClangSyntaxToken)tk;
                    if (syn.getOpen() == parenId) {
                        ++parenCount;
                        outside = false;
                    } else if (syn.getClose() == parenId) {
                        ++parenCount;
                        outside = true;
                        results.add(syn);
                    }
                }
                if (!outside) {
                    results.add(tk);
                }
                if (parenCount != 2) continue;
                return results;
            }
            par = par.Parent();
        }
        return results;
    }

    public void addHighlightBrace(ClangSyntaxToken token, Color highlightColor) {
        if (DecompilerUtils.isBrace(token)) {
            this.highlightBrace(token, highlightColor);
            this.notifyListeners();
        }
    }

    private void highlightBrace(ClangSyntaxToken startToken, Color highlightColor) {
        ClangSyntaxToken matchingBrace = DecompilerUtils.getMatchingBrace(startToken);
        if (matchingBrace != null) {
            matchingBrace.setMatchingToken(true);
            this.addPrimaryHighlights(Set.of(matchingBrace), highlightColor);
        }
    }

    public void addListener(ClangHighlightListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ClangHighlightListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ClangHighlightListener listener : this.listeners) {
            listener.tokenHighlightsChanged();
        }
    }
}

