/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.fs;

import java.util.LinkedList;
import org.catacombae.hfsexplorer.types.applesingle.AppleSingleHeader;
import org.catacombae.hfsexplorer.types.applesingle.EntryDescriptor;
import org.catacombae.util.Util;

public class AppleSingleBuilder {
    private final FileType fileType;
    private final AppleSingleVersion version;
    private final FileSystem homeFileSystem;
    private final LinkedList<Util.Pair<EntryType, byte[]>> entryList = new LinkedList();

    public AppleSingleBuilder(FileType fileType, AppleSingleVersion version, FileSystem homeFileSystem) {
        if (fileType == null) {
            throw new IllegalArgumentException("fileType == null");
        }
        if (version == null) {
            throw new IllegalArgumentException("version == null");
        }
        if (homeFileSystem == null) {
            throw new IllegalArgumentException("homeFileSystem == null");
        }
        this.fileType = fileType;
        this.version = version;
        this.homeFileSystem = homeFileSystem;
    }

    public void addDataFork(byte[] resourceForkData) {
        this.entryList.add(new Util.Pair<EntryType, byte[]>(EntryType.DATA_FORK, resourceForkData));
    }

    public void addResourceFork(byte[] resourceForkData) {
        this.entryList.add(new Util.Pair<EntryType, byte[]>(EntryType.RESOURCE_FORK, resourceForkData));
    }

    /*
     * WARNING - void declaration
     */
    public byte[] getResult() {
        void var4_8;
        void var4_7;
        byte[] entryData;
        int dataSize = AppleSingleHeader.length();
        int dataStartOffset = dataSize += EntryDescriptor.length() * this.entryList.size();
        for (Util.Pair pair : this.entryList) {
            dataSize += ((byte[])pair.getB()).length;
        }
        byte[] result = new byte[dataSize];
        int n = 0;
        AppleSingleHeader header = new AppleSingleHeader(this.fileType.getMagic(), this.version.getVersionNumber(), this.homeFileSystem, this.entryList.size());
        byte[] headerData = header.getBytes();
        System.arraycopy(headerData, 0, result, n, headerData.length);
        int n2 = n + headerData.length;
        int dataOffset = dataStartOffset;
        for (Util.Pair pair : this.entryList) {
            entryData = (byte[])pair.getB();
            EntryDescriptor ed = new EntryDescriptor(((EntryType)((Object)pair.getA())).getTypeNumber(), dataOffset, entryData.length);
            dataOffset += entryData.length;
            byte[] entryDescriptorData = ed.getBytes();
            System.arraycopy(entryDescriptorData, 0, result, (int)var4_7, entryDescriptorData.length);
            var4_7 += entryDescriptorData.length;
        }
        if (var4_7 != dataStartOffset) {
            throw new RuntimeException("Internal error: Miscalculation of dataStartOffset (should be: " + (int)var4_7 + ", was: " + dataStartOffset + ")");
        }
        for (Util.Pair pair : this.entryList) {
            entryData = (byte[])pair.getB();
            System.arraycopy(entryData, 0, result, (int)var4_8, entryData.length);
            var4_8 += entryData.length;
        }
        if (var4_8 != result.length) {
            throw new RuntimeException("Internal error: Miscalculation of result.length (should be: " + (int)var4_8 + ", was: " + result.length + ")");
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum EntryType {
        DATA_FORK(1),
        RESOURCE_FORK(2),
        REAL_NAME(3),
        COMMENT(4),
        ICON_BW(5),
        ICON_COLOR(6),
        FILE_INFO(7),
        FINDER_INFO(9);

        private final int typeNumber;

        private EntryType(int typeNumber) {
            this.typeNumber = typeNumber;
        }

        public int getTypeNumber() {
            return this.typeNumber;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileSystem {
        MACOS("Macintosh"),
        MACOS_X("Mac OS X"),
        PRODOS("ProDOS"),
        MS_DOS("MS-DOS"),
        UNIS("Unix"),
        VMS("VAX VMS");

        private final String identifier;

        private FileSystem(String identifier) {
            this.identifier = identifier;
        }

        public byte[] getIdentifier() {
            char[] chars = this.identifier.toCharArray();
            byte[] result = new byte[16];
            for (int i = 0; i < result.length; ++i) {
                result[i] = i < chars.length ? (int)(chars[i] & 0x7F) : 32;
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AppleSingleVersion {
        VERSION_1_0(65536),
        VERSION_2_0(131072);

        private final int versionNumber;

        private AppleSingleVersion(int versionNumber) {
            this.versionNumber = versionNumber;
        }

        public int getVersionNumber() {
            return this.versionNumber;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FileType {
        APPLESINGLE(333312),
        APPLEDOUBLE(333319);

        private final int magic;

        private FileType(int magic) {
            this.magic = magic;
        }

        public int getMagic() {
            return this.magic;
        }
    }
}

