/*
 * Decompiled with CFR 0.152.
 */
package ghidra.closedpatternmining;

import ghidra.closedpatternmining.SequenceItem;
import java.util.List;

public class Sequence {
    private String sequence;
    private int count;

    public Sequence(String sequence, int count) {
        this.sequence = sequence;
        this.count = count;
    }

    public String getSequenceAsString() {
        return this.sequence;
    }

    public int getCount() {
        return this.count;
    }

    public int getIndexAfterFirstInstance(List<SequenceItem> prefixSequence) {
        if (prefixSequence == null) {
            return 0;
        }
        if (prefixSequence.isEmpty()) {
            return 0;
        }
        int index = 0;
        for (SequenceItem item : prefixSequence) {
            if (item.getIndex() + 1 > this.sequence.length()) {
                index = -1;
                break;
            }
            String symbol = this.sequence.substring(item.getIndex(), item.getIndex() + 1);
            if (!symbol.equals(item.getSymbol())) {
                index = -1;
                break;
            }
            index = item.getIndex() + 1;
        }
        return index;
    }
}

