/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager.impl.cmd;

import agent.gdb.manager.evt.GdbCommandDoneEvent;
import agent.gdb.manager.evt.GdbThreadSelectedEvent;
import agent.gdb.manager.impl.GdbEvent;
import agent.gdb.manager.impl.GdbManagerImpl;
import agent.gdb.manager.impl.GdbPendingCommand;
import agent.gdb.manager.impl.cmd.AbstractGdbCommand;

public class GdbInferiorSelectCommand
extends AbstractGdbCommand<Void> {
    private final int id;
    private final boolean internal;

    public GdbInferiorSelectCommand(GdbManagerImpl manager, int id, boolean internal) {
        super(manager);
        this.id = id;
        this.internal = internal;
    }

    @Override
    public void preCheck(GdbPendingCommand<? super Void> pending) {
        if (this.manager.currentInferior().getId() == this.id) {
            pending.complete(null);
        }
    }

    @Override
    public String encode() {
        return "-interpreter-exec console \"inferior " + this.id + "\"";
    }

    @Override
    public boolean handle(GdbEvent<?> evt, GdbPendingCommand<?> pending) {
        if (super.handle(evt, pending)) {
            return true;
        }
        if (evt instanceof GdbThreadSelectedEvent) {
            pending.claim(evt);
        }
        return false;
    }

    @Override
    public Void complete(GdbPendingCommand<?> pending) {
        pending.checkCompletion(GdbCommandDoneEvent.class);
        return null;
    }

    @Override
    public boolean isFocusInternallyDriven() {
        return this.internal;
    }
}

