/*
 * Decompiled with CFR 0.152.
 */
package agent.gdb.manager;

import agent.gdb.manager.parsing.GdbMiParser;
import ghidra.util.Msg;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GdbTable {
    private final int rowCount;
    private final int colCount;
    private final String[] cells;
    private final Column[] columns;
    private final Map<String, Column> colsByHead;
    private int rowIndex = -1;
    private int colIndex = -1;
    private final TableRowView rowView = new TableRowView();
    private final TableRowCellMap rowCellMap = new TableRowCellMap();
    private final TableRowCellSet rowCellSet = new TableRowCellSet();
    private final TableRowCellIterator rowCellIterator = new TableRowCellIterator();
    private final TableRowCellEntry rowCellEntry = new TableRowCellEntry();
    private final TableColumnView columnView = new TableColumnView();
    private final TableColumnSet columnSet = new TableColumnSet();
    private final TableColumnIterator columnIterator = new TableColumnIterator();
    private final TableColumnEntry columnEntry = new TableColumnEntry();
    private final TableColumnCellList columnCellList = new TableColumnCellList();

    public GdbTable(GdbMiParser.GdbMiFieldList dataMap, String rowKey) {
        this.rowCount = Integer.parseInt(dataMap.getString("nr_rows"));
        this.colCount = Integer.parseInt(dataMap.getString("nr_cols"));
        this.cells = new String[this.rowCount * this.colCount];
        this.columns = new Column[this.colCount];
        List<GdbMiParser.GdbMiFieldList> hdr = dataMap.getListOf(GdbMiParser.GdbMiFieldList.class, "hdr");
        if (hdr.size() != this.colCount) {
            Msg.warn((Object)this, (Object)"hdr contains fewer than nr_cols");
        }
        LinkedHashMap<String, Column> byHead = new LinkedHashMap<String, Column>();
        for (int colno = 0; colno < this.colCount; ++colno) {
            Column column;
            this.columns[colno] = column = new Column(colno, hdr.get(colno));
            byHead.put(column.head, column);
        }
        this.colsByHead = Collections.unmodifiableMap(byHead);
        Collection<Object> body = dataMap.getFieldList("body").get(rowKey);
        if (body.size() != this.rowCount) {
            Msg.warn((Object)this, (Object)"body contains fewer than nr_rows");
        }
        int rowno = 0;
        for (GdbMiParser.GdbMiFieldList gdbMiFieldList : body) {
            for (Column column : this.columns) {
                this.cells[this.colCount * rowno + column.num] = gdbMiFieldList.getString(column.name);
            }
            ++rowno;
        }
    }

    public TableRowView rows() {
        return this.rowView;
    }

    public TableColumnView columns() {
        return this.columnView;
    }

    public class TableColumnView
    extends AbstractMap<String, List<String>> {
        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return GdbTable.this.columnSet;
        }
    }

    private class TableColumnSet
    extends AbstractSet<Map.Entry<String, List<String>>> {
        private TableColumnSet() {
        }

        @Override
        public Iterator<Map.Entry<String, List<String>>> iterator() {
            GdbTable.this.colIndex = -1;
            return GdbTable.this.columnIterator;
        }

        @Override
        public int size() {
            return GdbTable.this.colCount;
        }
    }

    private class TableColumnIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private TableColumnIterator() {
        }

        @Override
        public boolean hasNext() {
            return GdbTable.this.colIndex < GdbTable.this.colCount - 1;
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            ++GdbTable.this.colIndex;
            return GdbTable.this.columnEntry;
        }
    }

    private class TableColumnEntry
    implements Map.Entry<String, List<String>> {
        private TableColumnEntry() {
        }

        @Override
        public String getKey() {
            return GdbTable.this.columns[GdbTable.this.colIndex].head;
        }

        @Override
        public List<String> getValue() {
            return GdbTable.this.columnCellList;
        }

        @Override
        public List<String> setValue(List<String> value) {
            throw new UnsupportedOperationException();
        }
    }

    private class TableColumnCellList
    extends AbstractList<String> {
        private TableColumnCellList() {
        }

        @Override
        public String get(int index) {
            return GdbTable.this.cells[index * GdbTable.this.colCount + GdbTable.this.colIndex];
        }

        @Override
        public int size() {
            return GdbTable.this.rowCount;
        }
    }

    public class TableRowView
    extends AbstractList<Map<String, String>> {
        @Override
        public Map<String, String> get(int index) {
            if (0 <= index && index < GdbTable.this.rowCount) {
                GdbTable.this.rowIndex = index;
                return GdbTable.this.rowCellMap;
            }
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }

        @Override
        public int size() {
            return GdbTable.this.rowCount;
        }
    }

    private class TableRowCellMap
    extends AbstractMap<String, String> {
        private TableRowCellMap() {
        }

        @Override
        public int size() {
            return GdbTable.this.colCount;
        }

        @Override
        public boolean containsKey(Object key) {
            return GdbTable.this.colsByHead.containsKey(key);
        }

        @Override
        public String get(Object key) {
            Column col = GdbTable.this.colsByHead.get(key);
            if (col == null) {
                return null;
            }
            return GdbTable.this.cells[GdbTable.this.rowIndex * GdbTable.this.colCount + col.num];
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return GdbTable.this.rowCellSet;
        }
    }

    private class TableRowCellSet
    extends AbstractSet<Map.Entry<String, String>> {
        private TableRowCellSet() {
        }

        @Override
        public Iterator<Map.Entry<String, String>> iterator() {
            GdbTable.this.colIndex = -1;
            return GdbTable.this.rowCellIterator;
        }

        @Override
        public int size() {
            return GdbTable.this.colCount;
        }
    }

    private class TableRowCellIterator
    implements Iterator<Map.Entry<String, String>> {
        private TableRowCellIterator() {
        }

        @Override
        public boolean hasNext() {
            return GdbTable.this.colIndex < GdbTable.this.colCount - 1;
        }

        @Override
        public Map.Entry<String, String> next() {
            ++GdbTable.this.colIndex;
            return GdbTable.this.rowCellEntry;
        }
    }

    private class TableRowCellEntry
    implements Map.Entry<String, String> {
        private TableRowCellEntry() {
        }

        @Override
        public String getKey() {
            return GdbTable.this.columns[GdbTable.this.colIndex].head;
        }

        @Override
        public String getValue() {
            return GdbTable.this.cells[GdbTable.this.rowIndex * GdbTable.this.colCount + GdbTable.this.colIndex];
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class Column {
        final int num;
        final String name;
        final String head;

        Column(int num, String name, String head) {
            this.num = num;
            this.name = name;
            this.head = head;
        }

        Column(int num, GdbMiParser.GdbMiFieldList map) {
            this(num, map.getString("col_name"), map.getString("colhdr"));
        }
    }
}

