/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.impl.dbgmodel.datamodel.script;

import agent.dbgmodel.dbgmodel.DbgModel;
import agent.dbgmodel.dbgmodel.datamodel.script.DataModelScriptClient;
import agent.dbgmodel.impl.dbgmodel.datamodel.script.DataModelScriptInternal;
import agent.dbgmodel.jna.dbgmodel.datamodel.script.IDataModelScript;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;

public class DataModelScriptImpl
implements DataModelScriptInternal {
    private final DbgModel.OpaqueCleanable cleanable;
    private final IDataModelScript jnaData;

    public DataModelScriptImpl(IDataModelScript jnaData) {
        this.cleanable = DbgModel.releaseWhenPhantom((Object)this, jnaData);
        this.jnaData = jnaData;
    }

    @Override
    public Pointer getPointer() {
        return this.jnaData.getPointer();
    }

    @Override
    public String getName() {
        WTypes.BSTRByReference bref = new WTypes.BSTRByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.GetName(bref));
        WTypes.BSTR bstr = bref.getValue();
        String scriptName = bstr.getValue();
        OleAuto.INSTANCE.SysFreeString(bstr);
        return scriptName;
    }

    @Override
    public void rename(WString scriptName) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Rename(scriptName));
    }

    @Override
    public void populate(Pointer contentStream) {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Populate(contentStream));
    }

    @Override
    public void execute(DataModelScriptClient client) {
        Pointer pClient = client.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Execute(pClient));
    }

    @Override
    public void unlink() {
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.Unlink());
    }

    @Override
    public boolean isInvocable() {
        WinDef.BOOLByReference bIsInvocable = new WinDef.BOOLByReference();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.IsInvocable(bIsInvocable));
        return bIsInvocable.getValue().booleanValue();
    }

    @Override
    public void invokeMain(DataModelScriptClient client) {
        Pointer pClient = client.getPointer();
        COMUtils.checkRC((WinNT.HRESULT)this.jnaData.InvokeMain(pClient));
    }
}

