/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.IdMsParsable;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AliasMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AliasStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArgumentsList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArgumentsListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Array16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ArrayStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BadMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BaseClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BaseInterfaceMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BasicArray16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BasicArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Bitfield16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BitfieldMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.BuildInfoMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Class16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Class19MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ClassStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Cobol016MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Cobol0MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Cobol1MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DefaultArguments16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DefaultArgumentsMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DefaultArgumentsStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DerivedClassList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DerivedClassListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArray16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsLowerUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsLowerUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayConstBoundsUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsLowerUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsLowerUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsUpper16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.DimensionedArrayVarBoundsUpperMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EndPrecompiledTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Enum16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.EnumerateStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FieldList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FieldListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendFunction16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FriendFunctionStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.FunctionIdMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.HighLevelShaderLanguageMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Index16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.IndexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.IndirectVirtualBaseClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.IndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.InterfaceMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.LabelMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ManagedMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ManagedStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MatrixMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Member16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunction16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunctionIdMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberFunctionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberModifyMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberModifyStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MemberStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MethodList16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MethodListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Modifier16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ModifierExMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ModifierMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.MsTypeField;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedType16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeExtMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeExtStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NestedTypeStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NotTranMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.NullMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OemDefinableString16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OemDefinableString2MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OemDefinableStringMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OneMethod16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OneMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OneMethodStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OverloadedMethod16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OverloadedMethodMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.OverloadedMethodStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Pointer16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrecompiledType16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrecompiledTypeMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.PrecompiledTypeStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Procedure16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ProcedureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.ReferencedSymbolMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Skip16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.SkipMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StaticMember16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StaticMemberMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StaticMemberStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StridedArrayMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StringIdMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Structure16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Structure19MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StructureMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.StructureStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.SubstringListMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.TypeServer2MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.TypeServerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.TypeServerStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.Union16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnionMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnionStMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UnknownMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeModuleSourceAndLineMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.UserDefinedTypeSourceAndLineMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VectorMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualBaseClass16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTableMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePath16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePathMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointer16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointerMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointerWithOffset16MsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VirtualFunctionTablePointerWithOffsetMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.VtShapeMsType;
import ghidra.util.exception.CancelledException;
import java.util.Objects;

public class TypeParser {
    protected AbstractPdb pdb;

    public TypeParser(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public AbstractMsType parseRecord(PdbByteReader reader, RecordNumber recordNumber) throws PdbException, CancelledException {
        AbstractMsType result = this.parse(reader, AbstractMsType.class);
        result.setRecordNumber(recordNumber);
        return result;
    }

    public MsTypeField parseField(PdbByteReader reader) throws PdbException, CancelledException {
        MsTypeField result = this.parse(reader, MsTypeField.class);
        return result;
    }

    public AbstractMsType parse(PdbByteReader reader) throws PdbException, CancelledException {
        AbstractMsType result = this.parse(reader, AbstractMsType.class);
        return result;
    }

    private <T> T parse(PdbByteReader reader, Class<T> requiredClass) throws PdbException, CancelledException {
        int dataTypeId = reader.parseUnsignedShortVal();
        try {
            IdMsParsable parsable = this.parse(reader, dataTypeId);
            if (requiredClass.isInstance(parsable)) {
                return requiredClass.cast(parsable);
            }
            PdbLog.logSerializationItemClassMismatch(parsable, requiredClass, dataTypeId);
        }
        catch (PdbException e) {
            PdbLog.logDeserializationFailure(reader, dataTypeId, e);
        }
        return requiredClass.cast(new BadMsType(this.pdb, dataTypeId));
    }

    private IdMsParsable parse(PdbByteReader reader, int dataTypeId) throws PdbException, CancelledException {
        this.pdb.getPdbReaderMetrics().witnessDataTypeId(dataTypeId);
        AbstractMsType type = null;
        switch (dataTypeId) {
            case 1: {
                type = new Modifier16MsType(this.pdb, reader);
                break;
            }
            case 2: {
                type = new Pointer16MsType(this.pdb, reader);
                break;
            }
            case 3: {
                type = new Array16MsType(this.pdb, reader);
                break;
            }
            case 4: {
                type = new Class16MsType(this.pdb, reader);
                break;
            }
            case 5: {
                type = new Structure16MsType(this.pdb, reader);
                break;
            }
            case 6: {
                type = new Union16MsType(this.pdb, reader);
                break;
            }
            case 7: {
                type = new Enum16MsType(this.pdb, reader);
                break;
            }
            case 8: {
                type = new Procedure16MsType(this.pdb, reader);
                break;
            }
            case 9: {
                type = new MemberFunction16MsType(this.pdb, reader);
                break;
            }
            case 10: {
                type = new VtShapeMsType(this.pdb, reader);
                break;
            }
            case 11: {
                type = new Cobol016MsType(this.pdb, reader);
                break;
            }
            case 12: {
                type = new Cobol1MsType(this.pdb, reader);
                break;
            }
            case 13: {
                type = new BasicArray16MsType(this.pdb, reader);
                break;
            }
            case 14: {
                type = new LabelMsType(this.pdb, reader);
                break;
            }
            case 15: {
                type = new NullMsType(this.pdb, reader);
                break;
            }
            case 16: {
                type = new NotTranMsType(this.pdb, reader);
                break;
            }
            case 17: {
                type = new DimensionedArray16MsType(this.pdb, reader);
                break;
            }
            case 18: {
                type = new VirtualFunctionTablePath16MsType(this.pdb, reader);
                break;
            }
            case 19: {
                type = new PrecompiledType16MsType(this.pdb, reader);
                break;
            }
            case 20: {
                type = new EndPrecompiledTypeMsType(this.pdb, reader);
                break;
            }
            case 21: {
                type = new OemDefinableString16MsType(this.pdb, reader);
                break;
            }
            case 22: {
                type = new TypeServerStMsType(this.pdb, reader);
                break;
            }
            case 512: {
                type = new Skip16MsType(this.pdb, reader);
                break;
            }
            case 513: {
                type = new ArgumentsList16MsType(this.pdb, reader);
                break;
            }
            case 514: {
                type = new DefaultArguments16MsType(this.pdb, reader);
                break;
            }
            case 515: {
                type = new ListMsType(this.pdb, reader);
                break;
            }
            case 516: {
                type = new FieldList16MsType(this.pdb, reader);
                break;
            }
            case 517: {
                type = new DerivedClassList16MsType(this.pdb, reader);
                break;
            }
            case 518: {
                type = new Bitfield16MsType(this.pdb, reader);
                break;
            }
            case 519: {
                type = new MethodList16MsType(this.pdb, reader);
                break;
            }
            case 520: {
                type = new DimensionedArrayConstBoundsUpper16MsType(this.pdb, reader);
                break;
            }
            case 521: {
                type = new DimensionedArrayConstBoundsLowerUpper16MsType(this.pdb, reader);
                break;
            }
            case 522: {
                type = new DimensionedArrayVarBoundsUpper16MsType(this.pdb, reader);
                break;
            }
            case 523: {
                type = new DimensionedArrayVarBoundsLowerUpper16MsType(this.pdb, reader);
                break;
            }
            case 524: {
                type = new ReferencedSymbolMsType(this.pdb, reader);
                break;
            }
            case 1024: {
                type = new BaseClass16MsType(this.pdb, reader);
                break;
            }
            case 1025: {
                type = new VirtualBaseClass16MsType(this.pdb, reader);
                break;
            }
            case 1026: {
                type = new IndirectVirtualBaseClass16MsType(this.pdb, reader);
                break;
            }
            case 1027: {
                type = new EnumerateStMsType(this.pdb, reader);
                break;
            }
            case 1028: {
                type = new FriendFunction16MsType(this.pdb, reader);
                break;
            }
            case 1029: {
                type = new Index16MsType(this.pdb, reader);
                break;
            }
            case 1030: {
                type = new Member16MsType(this.pdb, reader);
                break;
            }
            case 1031: {
                type = new StaticMember16MsType(this.pdb, reader);
                break;
            }
            case 1032: {
                type = new OverloadedMethod16MsType(this.pdb, reader);
                break;
            }
            case 1033: {
                type = new NestedType16MsType(this.pdb, reader);
                break;
            }
            case 1034: {
                type = new VirtualFunctionTablePointer16MsType(this.pdb, reader);
                break;
            }
            case 1035: {
                type = new FriendClass16MsType(this.pdb, reader);
                break;
            }
            case 1036: {
                type = new OneMethod16MsType(this.pdb, reader);
                break;
            }
            case 1037: {
                type = new VirtualFunctionTablePointerWithOffset16MsType(this.pdb, reader);
                break;
            }
            case 4097: {
                type = new ModifierMsType(this.pdb, reader);
                break;
            }
            case 4098: {
                type = new PointerMsType(this.pdb, reader);
                break;
            }
            case 4099: {
                type = new ArrayStMsType(this.pdb, reader);
                break;
            }
            case 4100: {
                type = new ClassStMsType(this.pdb, reader);
                break;
            }
            case 4101: {
                type = new StructureStMsType(this.pdb, reader);
                break;
            }
            case 4102: {
                type = new UnionStMsType(this.pdb, reader);
                break;
            }
            case 4103: {
                type = new EnumStMsType(this.pdb, reader);
                break;
            }
            case 4104: {
                type = new ProcedureMsType(this.pdb, reader);
                break;
            }
            case 4105: {
                type = new MemberFunctionMsType(this.pdb, reader);
                break;
            }
            case 4106: {
                type = new Cobol0MsType(this.pdb, reader);
                break;
            }
            case 4107: {
                type = new BasicArrayMsType(this.pdb, reader);
                break;
            }
            case 4108: {
                type = new DimensionedArrayStMsType(this.pdb, reader);
                break;
            }
            case 4109: {
                type = new VirtualFunctionTablePathMsType(this.pdb, reader);
                break;
            }
            case 4110: {
                type = new PrecompiledTypeStMsType(this.pdb, reader);
                break;
            }
            case 4111: {
                type = new OemDefinableStringMsType(this.pdb, reader);
                break;
            }
            case 4112: {
                type = new AliasStMsType(this.pdb, reader);
                break;
            }
            case 4113: {
                type = new OemDefinableString2MsType(this.pdb, reader);
                break;
            }
            case 4608: {
                type = new SkipMsType(this.pdb, reader);
                break;
            }
            case 4609: {
                type = new ArgumentsListMsType(this.pdb, reader);
                break;
            }
            case 4610: {
                type = new DefaultArgumentsStMsType(this.pdb, reader);
                break;
            }
            case 4611: {
                type = new FieldListMsType(this.pdb, reader);
                break;
            }
            case 4612: {
                type = new DerivedClassListMsType(this.pdb, reader);
                break;
            }
            case 4613: {
                type = new BitfieldMsType(this.pdb, reader);
                break;
            }
            case 4614: {
                type = new MethodListMsType(this.pdb, reader);
                break;
            }
            case 4615: {
                type = new DimensionedArrayConstBoundsUpperMsType(this.pdb, reader);
                break;
            }
            case 4616: {
                type = new DimensionedArrayConstBoundsLowerUpperMsType(this.pdb, reader);
                break;
            }
            case 4617: {
                type = new DimensionedArrayVarBoundsUpperMsType(this.pdb, reader);
                break;
            }
            case 4618: {
                type = new DimensionedArrayVarBoundsLowerUpperMsType(this.pdb, reader);
                break;
            }
            case 5120: {
                type = new BaseClassMsType(this.pdb, reader);
                break;
            }
            case 5121: {
                type = new VirtualBaseClassMsType(this.pdb, reader);
                break;
            }
            case 5122: {
                type = new IndirectVirtualBaseClassMsType(this.pdb, reader);
                break;
            }
            case 5123: {
                type = new FriendFunctionStMsType(this.pdb, reader);
                break;
            }
            case 5124: {
                type = new IndexMsType(this.pdb, reader);
                break;
            }
            case 5125: {
                type = new MemberStMsType(this.pdb, reader);
                break;
            }
            case 5126: {
                type = new StaticMemberStMsType(this.pdb, reader);
                break;
            }
            case 5127: {
                type = new OverloadedMethodStMsType(this.pdb, reader);
                break;
            }
            case 5128: {
                type = new NestedTypeStMsType(this.pdb, reader);
                break;
            }
            case 5129: {
                type = new VirtualFunctionTablePointerMsType(this.pdb, reader);
                break;
            }
            case 5130: {
                type = new FriendClassMsType(this.pdb, reader);
                break;
            }
            case 5131: {
                type = new OneMethodStMsType(this.pdb, reader);
                break;
            }
            case 5132: {
                type = new VirtualFunctionTablePointerWithOffsetMsType(this.pdb, reader);
                break;
            }
            case 5133: {
                type = new NestedTypeExtStMsType(this.pdb, reader);
                break;
            }
            case 5134: {
                type = new MemberModifyStMsType(this.pdb, reader);
                break;
            }
            case 5135: {
                type = new ManagedStMsType(this.pdb, reader);
                break;
            }
            case 5377: {
                type = new TypeServerMsType(this.pdb, reader);
                break;
            }
            case 5378: {
                type = new EnumerateMsType(this.pdb, reader);
                break;
            }
            case 5379: {
                type = new ArrayMsType(this.pdb, reader);
                break;
            }
            case 5380: {
                type = new ClassMsType(this.pdb, reader);
                break;
            }
            case 5381: {
                type = new StructureMsType(this.pdb, reader);
                break;
            }
            case 5382: {
                type = new UnionMsType(this.pdb, reader);
                break;
            }
            case 5383: {
                type = new EnumMsType(this.pdb, reader);
                break;
            }
            case 5384: {
                type = new DimensionedArrayMsType(this.pdb, reader);
                break;
            }
            case 5385: {
                type = new PrecompiledTypeMsType(this.pdb, reader);
                break;
            }
            case 5386: {
                type = new AliasMsType(this.pdb, reader);
                break;
            }
            case 5387: {
                type = new DefaultArgumentsMsType(this.pdb, reader);
                break;
            }
            case 5388: {
                type = new FriendFunctionMsType(this.pdb, reader);
                break;
            }
            case 5389: {
                type = new MemberMsType(this.pdb, reader);
                break;
            }
            case 5390: {
                type = new StaticMemberMsType(this.pdb, reader);
                break;
            }
            case 5391: {
                type = new OverloadedMethodMsType(this.pdb, reader);
                break;
            }
            case 5392: {
                type = new NestedTypeMsType(this.pdb, reader);
                break;
            }
            case 5393: {
                type = new OneMethodMsType(this.pdb, reader);
                break;
            }
            case 5394: {
                type = new NestedTypeExtMsType(this.pdb, reader);
                break;
            }
            case 5395: {
                type = new MemberModifyMsType(this.pdb, reader);
                break;
            }
            case 5396: {
                type = new ManagedMsType(this.pdb, reader);
                break;
            }
            case 5397: {
                type = new TypeServer2MsType(this.pdb, reader);
                break;
            }
            case 5398: {
                type = new StridedArrayMsType(this.pdb, reader);
                break;
            }
            case 5399: {
                type = new HighLevelShaderLanguageMsType(this.pdb, reader);
                break;
            }
            case 5400: {
                type = new ModifierExMsType(this.pdb, reader);
                break;
            }
            case 5401: {
                type = new InterfaceMsType(this.pdb, reader);
                break;
            }
            case 5402: {
                type = new BaseInterfaceMsType(this.pdb, reader);
                break;
            }
            case 5403: {
                type = new VectorMsType(this.pdb, reader);
                break;
            }
            case 5404: {
                type = new MatrixMsType(this.pdb, reader);
                break;
            }
            case 5405: {
                type = new VirtualFunctionTableMsType(this.pdb, reader);
                break;
            }
            case 5633: {
                type = new FunctionIdMsType(this.pdb, reader);
                break;
            }
            case 5634: {
                type = new MemberFunctionIdMsType(this.pdb, reader);
                break;
            }
            case 5635: {
                type = new BuildInfoMsType(this.pdb, reader);
                break;
            }
            case 5636: {
                type = new SubstringListMsType(this.pdb, reader);
                break;
            }
            case 5637: {
                type = new StringIdMsType(this.pdb, reader);
                break;
            }
            case 5638: {
                type = new UserDefinedTypeSourceAndLineMsType(this.pdb, reader);
                break;
            }
            case 5639: {
                type = new UserDefinedTypeModuleSourceAndLineMsType(this.pdb, reader);
                break;
            }
            case 5640: {
                type = new Class19MsType(this.pdb, reader);
                break;
            }
            case 5641: {
                type = new Structure19MsType(this.pdb, reader);
                break;
            }
            default: {
                type = new UnknownMsType(this.pdb, reader, dataTypeId);
            }
        }
        return type;
    }
}

