/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jgrapht.Graph;
import org.jungrapht.visualization.DefaultRenderContext;
import org.jungrapht.visualization.MultiLayerTransformer;
import org.jungrapht.visualization.PropertyLoader;
import org.jungrapht.visualization.RenderContext;
import org.jungrapht.visualization.RenderContextStateChange;
import org.jungrapht.visualization.VisualizationComponent;
import org.jungrapht.visualization.VisualizationModel;
import org.jungrapht.visualization.VisualizationServer;
import org.jungrapht.visualization.control.CrossoverScalingControl;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.ScalingControl;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.decorators.EdgeShape;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.EdgeArticulationFunctionSupplier;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.algorithms.util.VertexBoundsFunctionConsumer;
import org.jungrapht.visualization.layout.event.LayoutSizeChange;
import org.jungrapht.visualization.layout.event.LayoutStateChange;
import org.jungrapht.visualization.layout.event.LayoutVertexPositionChange;
import org.jungrapht.visualization.layout.event.ModelChange;
import org.jungrapht.visualization.layout.event.ViewChange;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.renderers.DefaultModalRenderer;
import org.jungrapht.visualization.renderers.ModalRenderer;
import org.jungrapht.visualization.selection.MultiMutableSelectedState;
import org.jungrapht.visualization.selection.MutableSelectedState;
import org.jungrapht.visualization.selection.ShapePickSupport;
import org.jungrapht.visualization.spatial.AbstractSpatial;
import org.jungrapht.visualization.spatial.Spatial;
import org.jungrapht.visualization.spatial.SpatialGrid;
import org.jungrapht.visualization.spatial.SpatialQuadTree;
import org.jungrapht.visualization.spatial.SpatialRTree;
import org.jungrapht.visualization.spatial.SwingThreadSpatial;
import org.jungrapht.visualization.spatial.rtree.QuadraticLeafSplitter;
import org.jungrapht.visualization.spatial.rtree.QuadraticSplitter;
import org.jungrapht.visualization.spatial.rtree.RStarLeafSplitter;
import org.jungrapht.visualization.spatial.rtree.RStarSplitter;
import org.jungrapht.visualization.spatial.rtree.SplitterContext;
import org.jungrapht.visualization.transform.shape.GraphicsDecorator;
import org.jungrapht.visualization.util.BoundingRectangleCollector;
import org.jungrapht.visualization.util.ChangeEventSupport;
import org.jungrapht.visualization.util.DefaultChangeEventSupport;
import org.jungrapht.visualization.util.LayoutPaintable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultVisualizationServer<V, E>
extends JPanel
implements VisualizationServer<V, E>,
VisualizationComponent {
    static Logger log = LoggerFactory.getLogger(DefaultVisualizationServer.class);
    private static final String VERTEX_SPATIAL_SUPPORT = "jungrapht.vertexSpatialSupport";
    private static final String EDGE_SPATIAL_SUPPORT = "jungrapht.edgeSpatialSupport";
    private static final String SPATIAL_SUPPORT_ON_SWING_THREAD = "jungrapht.spatialSupportOnSwingThread";
    private static final String PROPERTIES_FILE_NAME;
    private static final String LIGHTWEIGHT_VERTEX_COUNT_THRESHOLD = "jungrapht.lightweightVertexCountThreshold";
    private static final String LIGHTWEIGHT_SCALE_THRESHOLD = "jungrapht.lightweightScaleThreshold";
    private static final String DOUBLE_BUFFERED = "jungrapht.doubleBuffered";
    private static final String SCALE_TO_LAYOUT_PADDING_FACTOR = "jungrapht.scaleToLayoutPaddingFactor";
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);
    protected VisualizationModel<V, E> visualizationModel;
    protected DefaultModalRenderer<V, E> renderer;
    protected Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    protected MutableSelectedState<V> selectedVertexState;
    protected MutableSelectedState<E> selectedEdgeState;
    protected ItemListener pickEventListener;
    protected BufferedImage offscreen;
    protected Graphics2D offscreenG2d;
    protected boolean doubleBuffered;
    protected List<VisualizationServer.Paintable> preRenderers = new ArrayList<VisualizationServer.Paintable>();
    protected List<VisualizationServer.Paintable> postRenderers = new ArrayList<VisualizationServer.Paintable>();
    protected RenderContext<V, E> renderContext;
    protected TransformSupport<V, E> transformSupport = new TransformSupport();
    protected Spatial<V, V> vertexSpatial;
    protected Spatial<E, V> edgeSpatial;
    protected boolean spatialSupportOnSwingThread = Boolean.parseBoolean(System.getProperty("jungrapht.spatialSupportOnSwingThread", "true"));
    protected BiFunction<Graph<V, E>, E, Shape> savedEdgeShapeFunction;
    protected int lightweightRenderingVertexCountThreshold = Integer.parseInt(System.getProperty("jungrapht.lightweightVertexCountThreshold", "20"));
    protected double lightweightRenderingScaleThreshold = Double.parseDouble(System.getProperty("jungrapht.lightweightScaleThreshold", "0.5"));
    protected double scaleToLayoutPaddingFactor = Double.parseDouble(System.getProperty("jungrapht.scaleToLayoutPaddingFactor", "0.9"));
    protected Predicate<Double> smallScaleOverridePredicate = e -> e < this.lightweightRenderingScaleThreshold;
    private LayoutPaintable.LayoutBounds layoutBounds;

    protected DefaultVisualizationServer(VisualizationServer.Builder<V, E, ?, ?> builder) {
        this(builder.graph, builder.visualizationModel, builder.initialDimensionFunction, builder.layoutAlgorithm, builder.layoutSize, builder.viewSize);
    }

    protected DefaultVisualizationServer(Graph<V, E> graph, VisualizationModel<V, E> visualizationModel, Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction, LayoutAlgorithm<V> layoutAlgorithm, Dimension layoutSize, Dimension viewSize) {
        Spatial<E, V> edgeSpatial;
        if (visualizationModel == null) {
            Objects.requireNonNull(graph);
            Objects.requireNonNull(viewSize);
            if (layoutSize == null) {
                layoutSize = viewSize;
            }
            if (layoutSize.width <= 0 || layoutSize.height <= 0) {
                throw new IllegalArgumentException("width and height must be > 0");
            }
            visualizationModel = ((VisualizationModel.Builder)((VisualizationModel.Builder)((VisualizationModel.Builder)VisualizationModel.builder(graph).layoutAlgorithm(layoutAlgorithm)).initialDimensionFunction(initialDimensionFunction)).layoutSize(layoutSize)).build();
        }
        this.doubleBuffered = Boolean.parseBoolean(System.getProperty(DOUBLE_BUFFERED, "true"));
        this.setBackground(Color.white);
        this.setLayout(null);
        this.setVisualizationModel(visualizationModel);
        this.renderContext = new DefaultRenderContext();
        this.renderContext.getRenderContextStateChangeSupport().addRenderContextStateChangeListener(this);
        this.renderContext.setScreenDevice(this);
        this.renderer = ((DefaultModalRenderer.Builder)DefaultModalRenderer.builder().component(this)).build();
        this.renderer.setCountSupplier(this.getVisualizationModel().getGraph().vertexSet()::size);
        this.renderer.setScaleSupplier(this.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW)::scale);
        this.createSpatialStuctures(this.visualizationModel, this.renderContext);
        this.addComponentListener(new VisualizationListener(this));
        this.setPickSupport(new ShapePickSupport(this));
        this.setSelectedVertexState(new MultiMutableSelectedState());
        this.setSelectedEdgeState(new MultiMutableSelectedState());
        this.setPreferredSize(viewSize);
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.renderContext.getMultiLayerTransformer().addChangeListener(this);
        Spatial<V, V> vertexSpatial = this.createVertexSpatial(visualizationModel.getLayoutModel(), this.renderContext);
        if (vertexSpatial != null) {
            this.setVertexSpatial(vertexSpatial);
        }
        if ((edgeSpatial = this.createEdgeSpatial(visualizationModel.getLayoutModel(), this.renderContext)) != null) {
            this.setEdgeSpatial(edgeSpatial);
        }
        this.addChangeListener(this.renderer);
    }

    @Override
    public void reset() {
        this.getRenderContext().getMultiLayerTransformer().setToIdentity();
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public void layoutSizeChanged(LayoutSizeChange.Event evt) {
        log.trace("layoutSizeChanged to {} x {}", (Object)evt.width, (Object)evt.height);
        this.scaleToLayout();
    }

    @Override
    public void setInitialDimensionFunction(Function<Graph<V, ?>, Pair<Integer>> initialDimensionFunction) {
        this.visualizationModel.setInitialDimensionFunction(initialDimensionFunction);
    }

    private void createSpatialStuctures(VisualizationModel<V, E> visualizationModel, RenderContext<V, E> renderContext) {
        this.setVertexSpatial(this.createVertexSpatial(visualizationModel.getLayoutModel(), renderContext));
        this.setEdgeSpatial(this.createEdgeSpatial(visualizationModel.getLayoutModel(), renderContext));
    }

    @Override
    public Spatial<V, V> getVertexSpatial() {
        return this.vertexSpatial;
    }

    @Override
    public void setVertexSpatial(Spatial<V, V> spatial) {
        if (this.vertexSpatial != null) {
            this.disconnectListeners(this.vertexSpatial);
        }
        this.vertexSpatial = spatial;
        boolean layoutModelRelaxing = this.visualizationModel.getLayoutModel().isRelaxing();
        this.vertexSpatial.setActive(!layoutModelRelaxing);
        if (!layoutModelRelaxing) {
            this.vertexSpatial.recalculate();
        }
        this.connectListeners(spatial);
    }

    @Override
    public Spatial<E, V> getEdgeSpatial() {
        return this.edgeSpatial;
    }

    @Override
    public void setEdgeSpatial(Spatial<E, V> spatial) {
        if (this.edgeSpatial != null) {
            this.disconnectListeners(this.edgeSpatial);
        }
        this.edgeSpatial = spatial;
        boolean layoutModelRelaxing = this.visualizationModel.getLayoutModel().isRelaxing();
        this.edgeSpatial.setActive(!layoutModelRelaxing);
        if (!layoutModelRelaxing) {
            this.edgeSpatial.recalculate();
        }
        this.connectListeners(this.edgeSpatial);
    }

    private void connectListeners(Spatial spatial) {
        LayoutModel<V> layoutModel = this.visualizationModel.getLayoutModel();
        layoutModel.getLayoutStateChangeSupport().addLayoutStateChangeListener((LayoutStateChange.Listener)spatial);
        if (spatial instanceof LayoutVertexPositionChange.Listener) {
            layoutModel.getLayoutVertexPositionSupport().addLayoutVertexPositionChangeListener((LayoutVertexPositionChange.Listener)spatial);
        }
    }

    private void disconnectListeners(Spatial spatial) {
        LayoutModel<V> layoutModel = this.visualizationModel.getLayoutModel();
        layoutModel.getLayoutStateChangeSupport().removeLayoutStateChangeListener((LayoutStateChange.Listener)spatial);
        if (spatial instanceof LayoutVertexPositionChange.Listener) {
            layoutModel.getLayoutVertexPositionSupport().removeLayoutVertexPositionChangeListener((LayoutVertexPositionChange.Listener)spatial);
        }
    }

    @Override
    public void setDoubleBuffered(boolean doubleBuffered) {
        this.doubleBuffered = doubleBuffered;
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    @Override
    public Dimension getSize() {
        Dimension d = super.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = this.getPreferredSize();
        }
        return d;
    }

    protected void checkOffscreenImage(Dimension d) {
        if (this.doubleBuffered && (this.offscreen == null || this.offscreen.getWidth() != d.width || this.offscreen.getHeight() != d.height)) {
            this.offscreen = new BufferedImage(d.width, d.height, 2);
            this.offscreenG2d = this.offscreen.createGraphics();
        }
    }

    @Override
    public VisualizationModel<V, E> getVisualizationModel() {
        return this.visualizationModel;
    }

    @Override
    public void setVisualizationModel(VisualizationModel<V, E> visualizationModel) {
        if (this.visualizationModel != null) {
            this.visualizationModel.getModelChangeSupport().removeModelChangeListener((ModelChange.Listener)this);
            this.visualizationModel.getViewChangeSupport().removeViewChangeListener((ViewChange.Listener)this);
            this.visualizationModel.getLayoutModel().getLayoutStateChangeSupport().removeLayoutStateChangeListener((LayoutStateChange.Listener)this);
            this.visualizationModel.getLayoutSizeChangeSupport().removeLayoutSizeChangeListener((LayoutSizeChange.Listener)this);
        }
        this.visualizationModel = visualizationModel;
        this.visualizationModel.getModelChangeSupport().addModelChangeListener((ModelChange.Listener)this);
        this.visualizationModel.getViewChangeSupport().addViewChangeListener((ViewChange.Listener)this);
        this.visualizationModel.getLayoutModel().getLayoutStateChangeSupport().addLayoutStateChangeListener((LayoutStateChange.Listener)this);
        this.visualizationModel.getLayoutSizeChangeSupport().addLayoutSizeChangeListener((LayoutSizeChange.Listener)this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
        this.fireStateChanged();
    }

    @Override
    public ModalRenderer<V, E> getRenderer() {
        return this.renderer;
    }

    @Override
    public void resizeToLayout() {
        this.scaleToLayout(true);
    }

    @Override
    public void scaleToLayout() {
        this.scaleToLayout(false);
    }

    @Override
    public void scaleToLayout(boolean resizeToPoints) {
        this.scaleToLayout(new CrossoverScalingControl(), resizeToPoints);
    }

    @Override
    public void scaleToLayout(ScalingControl scaler) {
        this.scaleToLayout(scaler, false);
    }

    @Override
    public void scaleToLayout(ScalingControl scaler, boolean resizeToPoints) {
        log.trace("Thread: {} will scaleToLayout({})", (Object)Thread.currentThread(), (Object)resizeToPoints);
        MultiLayerTransformer mlt = this.renderContext.getMultiLayerTransformer();
        log.trace("view transform: {}", (Object)mlt.getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform());
        log.trace("layout transform: {}", (Object)mlt.getTransformer(MultiLayerTransformer.Layer.LAYOUT).getTransform());
        this.reset();
        log.trace("reset view transform: {}", (Object)mlt.getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform());
        log.trace("reset layout transform: {}", (Object)mlt.getTransformer(MultiLayerTransformer.Layer.LAYOUT).getTransform());
        Dimension vd = this.getPreferredSize();
        log.trace("preferred view size: {}", (Object)vd);
        if (this.isShowing()) {
            vd = this.getSize();
            log.trace("actual view size: {}", (Object)vd);
        }
        if (resizeToPoints) {
            log.warn("resize to points is deprecated");
            LayoutModel<V> layoutModel = this.visualizationModel.getLayoutModel();
            this.vertexSpatial.setActive(false);
            this.edgeSpatial.setActive(false);
            layoutModel.resizeToSurroundingRectangle();
        }
        Dimension ld = this.visualizationModel.getLayoutSize();
        log.trace("layoutSize {}", (Object)ld);
        if (!vd.equals(ld)) {
            double widthRatio = vd.getWidth() / ld.getWidth();
            double heightRatio = vd.getHeight() / ld.getHeight();
            double ratio = Math.min(widthRatio, heightRatio);
            ratio *= this.scaleToLayoutPaddingFactor;
            if (log.isTraceEnabled()) {
                log.trace("scaling with {} {}", (Object)(widthRatio < heightRatio ? "widthRatio" : "heightRatio"), (Object)ratio);
                log.trace("vd.getWidth() {} ld.getWidth() {} ", (Object)vd.getWidth(), (Object)ld.getWidth());
                log.trace("vd.getHeight() {} ld.getHeight() {} ", (Object)vd.getHeight(), (Object)ld.getHeight());
                log.trace("ratio: {}", (Object)ratio);
            }
            scaler.scale(this, (float)ratio, (float)ratio, new Point2D.Double());
            if (log.isTraceEnabled()) {
                log.trace("center of view is " + this.getCenter());
                log.trace("center of layout is " + this.visualizationModel.getLayoutModel().getWidth() / 2 + ", " + this.visualizationModel.getLayoutModel().getHeight() / 2);
            }
            Point2D centerOfView = this.getCenter();
            Point2D viewCenterOnLayout = this.getRenderContext().getMultiLayerTransformer().inverseTransform(centerOfView);
            Point layoutCenter = this.visualizationModel.getLayoutModel().getCenter();
            double deltaX = viewCenterOnLayout.getX() - layoutCenter.x;
            double deltaY = viewCenterOnLayout.getY() - layoutCenter.y;
            this.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).translate(deltaX, deltaY);
        }
        log.trace("Thread: {} is done with scaleToLayout({})", (Object)Thread.currentThread(), (Object)resizeToPoints);
    }

    @Override
    public Map<RenderingHints.Key, Object> getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public void setRenderingHints(Map<RenderingHints.Key, Object> renderingHints) {
        this.renderingHints = renderingHints;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        if (this.doubleBuffered) {
            this.checkOffscreenImage(this.getSize());
            this.renderGraph(this.offscreenG2d);
            g2d.drawImage(this.offscreen, null, 0, 0);
        } else {
            this.renderGraph(g2d);
        }
    }

    @Override
    public Shape viewOnLayout() {
        Dimension d = this.getSize();
        MultiLayerTransformer vt = this.renderContext.getMultiLayerTransformer();
        Rectangle2D.Double s = new Rectangle2D.Double(0.0, 0.0, d.width, d.height);
        return vt.inverseTransform(s);
    }

    protected void renderGraph(Graphics2D g2d) {
        this.renderContext.setupArrows(this.visualizationModel.getGraph().getType().isDirected());
        if (this.renderContext.getGraphicsContext() == null) {
            this.renderContext.setGraphicsContext(new GraphicsDecorator(g2d));
        } else {
            this.renderContext.getGraphicsContext().setDelegate(g2d);
        }
        this.renderContext.setScreenDevice(this);
        g2d.setRenderingHints(this.renderingHints);
        Dimension d = this.getSize();
        g2d.setColor(this.getBackground());
        g2d.fillRect(0, 0, d.width, d.height);
        AffineTransform oldXform = g2d.getTransform();
        AffineTransform newXform = new AffineTransform(oldXform);
        newXform.concatenate(this.renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW).getTransform());
        g2d.setTransform(newXform);
        if (log.isTraceEnabled()) {
            this.addSpatialAnnotations(this.vertexSpatial, Color.blue);
            this.addSpatialAnnotations(this.edgeSpatial, Color.green);
        } else {
            this.removeSpatialAnnotations();
        }
        for (VisualizationServer.Paintable paintable : this.preRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        this.renderer.render(this.renderContext, this.visualizationModel.getLayoutModel(), this.vertexSpatial, this.edgeSpatial);
        for (VisualizationServer.Paintable paintable : this.postRenderers) {
            if (paintable.useTransform()) {
                paintable.paint(g2d);
                continue;
            }
            g2d.setTransform(oldXform);
            paintable.paint(g2d);
            g2d.setTransform(newXform);
        }
        g2d.setTransform(oldXform);
    }

    public void modelChanged() {
        this.renderContext.setupArrows(this.visualizationModel.getGraph().getType().isDirected());
        this.applyLayoutAlgorithmConnections();
        this.renderer.setCountSupplier(this.visualizationModel.getGraph().vertexSet()::size);
        if (log.isDebugEnabled()) {
            SwingUtilities.invokeLater(() -> this.displayLayoutBounds());
        }
        this.updateSelectionStates();
        this.repaint();
    }

    protected void updateSelectionStates() {
        Graph graph = this.visualizationModel.getGraph();
        this.selectedVertexState.getSelected().stream().filter(v -> !graph.containsVertex(v)).collect(Collectors.toSet()).forEach(this.selectedVertexState::deselect);
        this.selectedEdgeState.getSelected().stream().filter(e -> !graph.containsEdge(e)).collect(Collectors.toSet()).forEach(this.selectedEdgeState::deselect);
    }

    private void displayLayoutBounds() {
        if (this.layoutBounds != null) {
            this.removePreRenderPaintable(this.layoutBounds);
        }
        this.layoutBounds = new LayoutPaintable.LayoutBounds(this);
        this.addPreRenderPaintable(this.layoutBounds);
    }

    protected void applyLayoutAlgorithmConnections() {
        log.trace("applyLayoutAlgorithmConnections on model change");
        LayoutAlgorithm<V> layoutAlgorithm = this.visualizationModel.getLayoutAlgorithm();
        BiFunction<Graph<V, E>, E, Shape> edgeShapeFunction = this.renderContext.getEdgeShapeFunction();
        if (layoutAlgorithm instanceof EdgeArticulationFunctionSupplier) {
            if (this.savedEdgeShapeFunction == null) {
                this.savedEdgeShapeFunction = edgeShapeFunction;
                log.trace("savedEdgeShapeFunction gets {}", edgeShapeFunction);
            }
            edgeShapeFunction = EdgeShape.articulatedLine();
            log.trace("edgeShapeFunction gets {}", edgeShapeFunction);
            ((EdgeShape.ArticulatedLine)edgeShapeFunction).setEdgeArticulationFunction(((EdgeArticulationFunctionSupplier)this.visualizationModel.getLayoutAlgorithm()).getEdgeArticulationFunction());
            this.renderContext.setEdgeShapeFunction(edgeShapeFunction);
        } else if (this.savedEdgeShapeFunction != null) {
            edgeShapeFunction = this.savedEdgeShapeFunction;
            log.trace("edgeShapeFunction got savedEdgeShapeFunction: {}", edgeShapeFunction);
            if (edgeShapeFunction instanceof EdgeShape.ArticulatedLine) {
                ((EdgeShape.ArticulatedLine)edgeShapeFunction).setEdgeArticulationFunction(e -> Collections.emptyList());
                log.trace("unset the edge articulations in edgeShapeFunction : {}", edgeShapeFunction);
            }
            this.renderContext.setEdgeShapeFunction(edgeShapeFunction);
        }
        if (layoutAlgorithm instanceof VertexBoundsFunctionConsumer) {
            ((VertexBoundsFunctionConsumer)layoutAlgorithm).accept(this.renderContext.getVertexBoundsFunction());
        }
    }

    public void viewChanged() {
        this.repaint();
    }

    public void layoutStateChanged(LayoutStateChange.Event evt) {
        log.trace("layoutStateChanged. active:{}", (Object)evt.active);
    }

    public void renderContextStateChanged(RenderContextStateChange.Event evt) {
        this.createSpatialStuctures(this.visualizationModel, this.renderContext);
    }

    @Override
    public void addPreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers == null) {
            this.preRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.preRenderers.add(paintable);
    }

    @Override
    public void prependPreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers == null) {
            this.preRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.preRenderers.add(0, paintable);
    }

    @Override
    public void removePreRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.preRenderers != null) {
            this.preRenderers.remove(paintable);
        }
    }

    @Override
    public void addPostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers == null) {
            this.postRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.postRenderers.add(paintable);
    }

    public void prependPostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers == null) {
            this.postRenderers = new ArrayList<VisualizationServer.Paintable>();
        }
        this.postRenderers.add(0, paintable);
    }

    @Override
    public void removePostRenderPaintable(VisualizationServer.Paintable paintable) {
        if (this.postRenderers != null) {
            this.postRenderers.remove(paintable);
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
        this.vertexSpatial.recalculate();
    }

    @Override
    public MutableSelectedState<V> getSelectedVertexState() {
        return this.selectedVertexState;
    }

    @Override
    public Set<V> getSelectedVertices() {
        return this.getSelectedVertexState().getSelected();
    }

    @Override
    public MutableSelectedState<E> getSelectedEdgeState() {
        return this.selectedEdgeState;
    }

    @Override
    public Set<E> getSelectedEdges() {
        return this.getSelectedEdgeState().getSelected();
    }

    @Override
    public void setSelectedVertexState(MutableSelectedState<V> selectedVertexState) {
        Objects.requireNonNull(selectedVertexState);
        if (this.pickEventListener != null && this.selectedVertexState != null) {
            this.selectedVertexState.removeItemListener(this.pickEventListener);
        }
        this.selectedVertexState = selectedVertexState;
        this.renderContext.setSelectedVertexState(selectedVertexState);
        if (this.pickEventListener == null) {
            this.pickEventListener = e -> this.repaint();
        }
        selectedVertexState.addItemListener(this.pickEventListener);
    }

    @Override
    public void setSelectedEdgeState(MutableSelectedState<E> selectedEdgeState) {
        Objects.requireNonNull(selectedEdgeState);
        if (this.pickEventListener != null && this.selectedEdgeState != null) {
            this.selectedEdgeState.removeItemListener(this.pickEventListener);
        }
        this.selectedEdgeState = selectedEdgeState;
        this.renderContext.setSelectedEdgeState(selectedEdgeState);
        if (this.pickEventListener == null) {
            this.pickEventListener = e -> this.repaint();
        }
        selectedEdgeState.addItemListener(this.pickEventListener);
    }

    @Override
    public GraphElementAccessor<V, E> getPickSupport() {
        return this.renderContext.getPickSupport();
    }

    @Override
    public void setPickSupport(GraphElementAccessor<V, E> pickSupport) {
        this.renderContext.setPickSupport(pickSupport);
    }

    @Override
    public Point2D getCenter() {
        Dimension d = this.getSize();
        return new Point2D.Double(d.width / 2, d.height / 2);
    }

    @Override
    public RenderContext<V, E> getRenderContext() {
        return this.renderContext;
    }

    @Override
    public void setRenderContext(RenderContext<V, E> renderContext) {
        this.renderContext = renderContext;
    }

    private void addSpatialAnnotations(Spatial spatial, Color color) {
        if (spatial != null) {
            this.addPreRenderPaintable(new SpatialPaintable(spatial, color));
        }
    }

    private void removeSpatialAnnotations() {
        this.preRenderers.removeIf(paintable -> paintable instanceof SpatialPaintable);
    }

    @Override
    public TransformSupport<V, E> getTransformSupport() {
        return this.transformSupport;
    }

    @Override
    public void setTransformSupport(TransformSupport<V, E> transformSupport) {
        this.transformSupport = transformSupport;
    }

    private VisualizationModel.SpatialSupport getVertexSpatialSupportPreference() {
        String spatialSupportProperty = System.getProperty(VERTEX_SPATIAL_SUPPORT, "RTREE");
        try {
            return VisualizationModel.SpatialSupport.valueOf(spatialSupportProperty);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Unknown ModelStructure type {} ignored.", (Object)spatialSupportProperty);
            return VisualizationModel.SpatialSupport.QUADTREE;
        }
    }

    private VisualizationModel.SpatialSupport getEdgeSpatialSupportPreference() {
        String spatialSupportProperty = System.getProperty(EDGE_SPATIAL_SUPPORT, "RTREE");
        try {
            return VisualizationModel.SpatialSupport.valueOf(spatialSupportProperty);
        }
        catch (IllegalArgumentException ex) {
            log.warn("Unknown ModelStructure type {} ignored.", (Object)spatialSupportProperty);
            return VisualizationModel.SpatialSupport.NONE;
        }
    }

    private Spatial<V, V> createVertexSpatial(LayoutModel<V> layoutModel, RenderContext<V, E> renderContext) {
        AbstractSpatial vertexSpatial;
        switch (this.getVertexSpatialSupportPreference()) {
            case RTREE: {
                vertexSpatial = SpatialRTree.Vertices.builder().layoutModel(layoutModel).boundingRectangleCollector(new BoundingRectangleCollector.Vertices<V>(renderContext.getVertexShapeFunction().andThen(shape -> {
                    AffineTransform layoutTransform = renderContext.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT).getTransform();
                    return AffineTransform.getScaleInstance(1.0 / layoutTransform.getScaleX(), 1.0 / layoutTransform.getScaleY()).createTransformedShape((Shape)shape);
                }), this.visualizationModel.getLayoutModel())).splitterContext(SplitterContext.of(new RStarLeafSplitter(), new RStarSplitter())).reinsert(true).build();
                break;
            }
            case GRID: {
                vertexSpatial = new SpatialGrid<V>(this.visualizationModel.getLayoutModel());
                break;
            }
            case QUADTREE: {
                vertexSpatial = new SpatialQuadTree<V>(this.visualizationModel.getLayoutModel());
                break;
            }
            default: {
                vertexSpatial = new Spatial.NoOp.Vertex<V>(this.visualizationModel.getLayoutModel());
            }
        }
        return this.spatialSupportOnSwingThread ? SwingThreadSpatial.of(vertexSpatial).after(this::repaint) : vertexSpatial;
    }

    private Spatial<E, V> createEdgeSpatial(LayoutModel<V> layoutModel, RenderContext<V, E> renderContext) {
        AbstractSpatial edgeSpatial;
        switch (this.getEdgeSpatialSupportPreference()) {
            case RTREE: {
                edgeSpatial = SpatialRTree.Edges.builder().layoutModel((LayoutModel)layoutModel).boundingRectangleCollector(new BoundingRectangleCollector.Edges<V, E>(renderContext.getVertexShapeFunction(), renderContext.getEdgeShapeFunction(), this.visualizationModel.getLayoutModel())).splitterContext(SplitterContext.of(new QuadraticLeafSplitter(), new QuadraticSplitter())).reinsert(false).build();
                break;
            }
            default: {
                edgeSpatial = new Spatial.NoOp.Edge<E, V>(this.visualizationModel);
            }
        }
        return this.spatialSupportOnSwingThread ? SwingThreadSpatial.of(edgeSpatial).after(this::repaint) : edgeSpatial;
    }

    static {
        PropertyLoader.load();
        PROPERTIES_FILE_NAME = System.getProperty("jungrapht.properties.file.name", "jungrapht.properties");
    }

    class SpatialPaintable<T, NT>
    implements VisualizationServer.Paintable {
        Spatial<T, NT> quadTree;
        Color color;

        public SpatialPaintable(Spatial<T, NT> quadTree, Color color) {
            this.quadTree = quadTree;
            this.color = color;
        }

        @Override
        public boolean useTransform() {
            return false;
        }

        @Override
        public void paint(Graphics g) {
            Shape shape;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            List<Shape> grid = this.quadTree.getGrid();
            g2d.setColor(this.color);
            for (Shape r : grid) {
                shape = DefaultVisualizationServer.this.transformSupport.transform(DefaultVisualizationServer.this, r);
                g2d.draw(shape);
            }
            g2d.setColor(Color.red);
            for (Shape pickShape : this.quadTree.getPickShapes()) {
                if (pickShape == null) continue;
                shape = DefaultVisualizationServer.this.transformSupport.transform(DefaultVisualizationServer.this, pickShape);
                g2d.draw(shape);
            }
            g2d.setColor(oldColor);
        }
    }

    protected class VisualizationListener
    extends ComponentAdapter {
        protected DefaultVisualizationServer<V, E> vv;

        public VisualizationListener(DefaultVisualizationServer<V, E> vv) {
            this.vv = vv;
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Dimension d = this.vv.getSize();
            if (d.width <= 0 || d.height <= 0) {
                return;
            }
            DefaultVisualizationServer.this.checkOffscreenImage(d);
            DefaultVisualizationServer.this.repaint();
        }
    }
}

