/*
 * Decompiled with CFR 0.152.
 */
package ghidra.async;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class AsyncClaimQueue<T> {
    private final Deque<Entry<T>> queue = new LinkedList<Entry<T>>();

    public CompletableFuture<T> claim() {
        return this.claim(t -> true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<T> claim(Predicate<T> predicate) {
        Deque<Entry<T>> deque = this.queue;
        synchronized (deque) {
            CompletableFuture future = new CompletableFuture();
            this.queue.add(new Entry(future, predicate));
            return future;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean satisfy(T t) {
        Entry<T> entry = null;
        Deque<Entry<T>> deque = this.queue;
        synchronized (deque) {
            Iterator<Entry<T>> eit = this.queue.iterator();
            while (eit.hasNext()) {
                Entry<T> e = eit.next();
                if (!e.predicate.test(t)) continue;
                entry = e;
                eit.remove();
                break;
            }
        }
        if (entry == null) {
            return false;
        }
        entry.future.complete(t);
        return true;
    }

    private static class Entry<T> {
        final CompletableFuture<T> future;
        final Predicate<T> predicate;

        Entry(CompletableFuture<T> future, Predicate<T> predicate) {
            this.future = future;
            this.predicate = predicate;
        }
    }
}

