/*
 * Decompiled with CFR 0.152.
 */
package org.snpsift.testCases;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Assert;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;
import org.snpsift.SnpSift;
import org.snpsift.SnpSiftCmdAnnotate;

public class TestCasesZzz
extends TestCase {
    public static boolean debug = false;
    public static boolean verbose = true;
    protected String[] defaultExtraArgs;
    protected boolean deleteIndexFile;

    public TestCasesZzz() {
        String[] memExtraArgs = new String[]{"-sorted"};
        this.defaultExtraArgs = memExtraArgs;
    }

    public List<VcfEntry> annotate(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        if (this.deleteIndexFile) {
            this.deleteIndexFile(dbFileName);
        }
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdAnnotate snpSiftAnnotate = (SnpSiftCmdAnnotate)snpSift.cmd();
        snpSiftAnnotate.setDebug(debug);
        snpSiftAnnotate.setVerbose(verbose);
        snpSiftAnnotate.setSuppressOutput(!verbose);
        List<VcfEntry> results = snpSiftAnnotate.run(true);
        Assert.assertTrue(results != null);
        Assert.assertTrue(results.size() > 0);
        return results;
    }

    public String annotateOut(String dbFileName, String fileName, String[] extraArgs) {
        if (verbose) {
            System.out.println("Annotate: " + dbFileName + "\t" + fileName);
        }
        if (this.deleteIndexFile) {
            this.deleteIndexFile(dbFileName);
        }
        String[] args = this.argsList(dbFileName, fileName, extraArgs);
        SnpSift snpSift = new SnpSift(args);
        SnpSiftCmdAnnotate snpSiftAnnotate = (SnpSiftCmdAnnotate)snpSift.cmd();
        snpSiftAnnotate.setDebug(debug);
        snpSiftAnnotate.setVerbose(verbose);
        snpSiftAnnotate.setSaveOutput(true);
        snpSiftAnnotate.run();
        return snpSiftAnnotate.getOutput();
    }

    public void annotateTest(String dbFileName, String fileName) {
        this.annotateTest(dbFileName, fileName, null);
    }

    public void annotateTest(String dbFileName, String fileName, String[] extraArgs) {
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        for (VcfEntry vcf : results) {
            String idstr = vcf.getId();
            String expectedIds = vcf.getInfo("EXP_IDS");
            if (expectedIds != null) {
                expectedIds = expectedIds.replace('|', ';');
                if ((expectedIds = expectedIds.replace(',', ';')).equals(".")) {
                    expectedIds = "";
                }
                Assert.assertEquals(expectedIds, idstr);
                continue;
            }
            TestCasesZzz.fail("EXP_IDS (expected ids) INFO field missing in " + fileName + ", entry:\n" + vcf);
        }
    }

    protected String[] argsList(String dbFileName, String fileName, String[] extraArgs) {
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("annotate");
        if (this.defaultExtraArgs != null) {
            for (String arg : this.defaultExtraArgs) {
                argsList.add(arg);
            }
        }
        if (extraArgs != null) {
            for (String arg : extraArgs) {
                argsList.add(arg);
            }
        }
        argsList.add(dbFileName);
        argsList.add(fileName);
        return argsList.toArray(new String[0]);
    }

    void deleteIndexFile(String dbFileName) {
        String indexFile = dbFileName + ".sidx";
        File f2 = new File(indexFile);
        if (f2.delete() && verbose) {
            Gpr.debug("Index file '" + indexFile + "' deleted before annotation test");
        }
    }

    public void test_45() {
        Gpr.debug("Test");
        String dbFileName = "./test/ann/gnomad_db_multiple_entries.vcf";
        String fileName = "./test/ann/annotate_45.vcf";
        String fieldName = "AC_AMR";
        String[] extraArgs = new String[]{"-info", fieldName};
        List<VcfEntry> results = this.annotate(dbFileName, fileName, extraArgs);
        VcfEntry ve = results.get(0);
        if (verbose) {
            System.out.println(ve);
        }
        String infoStr = ve.getInfoStr();
        Assert.assertTrue("Missing " + fieldName + " annotation", infoStr.indexOf(fieldName + "=") >= 0);
        String expectedValue = "2";
        String value2 = ve.getInfo(fieldName);
        Assert.assertEquals("Expecting different value", expectedValue, value2);
    }
}

