/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.fileIterator;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import org.snpeff.binseq.BinarySequence;

public class BinSeqFileIterator<T extends BinarySequence>
implements Iterable<T>,
Iterator<T> {
    DataInputStream in;
    BinarySequence binRead;
    BinarySequence readerObject;

    public BinSeqFileIterator(String fileName) {
        try {
            this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            this.binRead = null;
        }
        catch (FileNotFoundException e) {
            this.in = null;
        }
    }

    public void close() {
        if (this.in != null) {
            try {
                this.in.close();
                this.binRead = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.in == null) {
            return false;
        }
        if (this.binRead != null) {
            return true;
        }
        try {
            this.binRead = this.readerObject.read(this.in);
            if (this.binRead == null) {
                this.close();
            }
        }
        catch (IOException e) {
            this.binRead = null;
        }
        return this.binRead != null;
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    @Override
    public T next() {
        BinarySequence bs = this.binRead;
        this.binRead = null;
        this.hasNext();
        return (T)bs;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unimplemented!");
    }
}

