/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.FastMath;

public class BisectionSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BisectionSolver() {
        this(1.0E-6);
    }

    public BisectionSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public BisectionSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    protected double doSolve() throws TooManyEvaluationsException {
        double m;
        double min2 = this.getMin();
        double max2 = this.getMax();
        this.verifyInterval(min2, max2);
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        do {
            m = UnivariateSolverUtils.midpoint(min2, max2);
            double fmin = this.computeObjectiveValue(min2);
            double fm = this.computeObjectiveValue(m);
            if (fm * fmin > 0.0) {
                min2 = m;
                continue;
            }
            max2 = m;
        } while (!(FastMath.abs(max2 - min2) <= absoluteAccuracy));
        m = UnivariateSolverUtils.midpoint(min2, max2);
        return m;
    }
}

