/*
 * Decompiled with CFR 0.152.
 */
package com.clineff.clinvar;

import com.clineff.clinvar.ClinSig;
import org.snpeff.util.Gpr;
import org.snpeff.vcf.VcfEntry;

public class ClinVarEntry {
    public static final int ORIGIN_UNKNOWN = 0;
    public static final int ORIGIN_GERMLINE = 1;
    public static final int ORIGIN_SOMATIC = 2;
    public static final int ORIGIN_INHERITED = 4;
    public static final int ORIGIN_PATERNAL = 8;
    public static final int ORIGIN_MATERNAL = 16;
    public static final int ORIGIN_DE_NOVO = 32;
    public static final int ORIGIN_BIPARENTAL = 64;
    public static final int ORIGIN_UNIPARENTAL = 128;
    public static final int ORIGIN_NOT_TESTED = 256;
    public static final int ORIGIN_TESTED_INCONCLUSIVE = 512;
    public static final int ORIGIN_OTHER = 0x40000000;
    VcfEntry vcfEntry;
    String hgvs;
    int allele;
    String src;
    int origin;
    String srcId;
    ClinSig clinSig;
    String dsdb;
    String dsdbId;
    String dbn;
    String revStat;
    String acc;
    String geneName;
    String geneId;

    public ClinVarEntry(VcfEntry ve) {
        this.vcfEntry = ve;
        this.hgvs = this.getInfo("CLNHGVS");
        this.allele = Gpr.parseIntSafe(ve.getInfo("CLNHGVS"));
        this.src = this.getInfo("CLNSRC");
        this.origin = Gpr.parseIntSafe(ve.getInfo("CLNORIGIN"));
        this.srcId = this.getInfo("CLNSRCID");
        this.dsdb = this.getInfo("CLNDSDB");
        this.dsdbId = this.getInfo("CLNDSDBID");
        this.dbn = this.getInfo("CLNDBN");
        this.revStat = this.getInfo("CLNREVSTAT");
        this.acc = this.getInfo("CLNACC");
        String clinSigStr = ve.getInfo("CLNSIG");
        this.clinSig = clinSigStr != null ? ClinSig.parse(clinSigStr) : ClinSig.NONE;
        String geneStr = ve.getInfo("GENEINFO");
        if (geneStr != null) {
            geneStr = geneStr.split("\\|")[0];
            this.geneName = geneStr.split(":")[0];
            this.geneId = geneStr.split(":")[1];
        } else {
            this.geneId = "";
            this.geneName = "";
        }
    }

    public String getAcc() {
        return this.acc;
    }

    public int getAllele() {
        return this.allele;
    }

    public ClinSig getClinSig() {
        return this.clinSig;
    }

    public String getDbn() {
        return this.dbn;
    }

    public String getDsdb() {
        return this.dsdb;
    }

    public String getDsdbId() {
        return this.dsdbId;
    }

    public String getGeneId() {
        return this.geneId;
    }

    public String getGeneName() {
        return this.geneName;
    }

    public String getHgvs() {
        return this.hgvs;
    }

    String getInfo(String info) {
        String str = this.vcfEntry.getInfo(info);
        return str != null ? str : "";
    }

    public int getOrigin() {
        return this.origin;
    }

    public String getRevStat() {
        return this.revStat;
    }

    public String getSrc() {
        return this.src;
    }

    public String getSrcId() {
        return this.srcId;
    }
}

