/*
 * Decompiled with CFR 0.152.
 */
package DistLib;

import DistLib.beta;
import DistLib.chisquare;
import DistLib.misc;
import DistLib.normal;
import DistLib.uniform;

public class t {
    private static double eps = 1.0E-12;

    public static double density(double x2, double n) {
        if (Double.isNaN(x2) || Double.isNaN(n)) {
            return x2 + n;
        }
        if (n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(x2)) {
            return 0.0;
        }
        if (Double.isInfinite(n)) {
            return normal.density(x2, 0.0, 1.0);
        }
        return Math.pow(1.0 + x2 * x2 / n, -0.5 * (n + 1.0)) / (Math.sqrt(n) * misc.beta(0.5, 0.5 * n));
    }

    public static double cumulative(double x2, double n) {
        if (Double.isNaN(x2) || Double.isNaN(n)) {
            return x2 + n;
        }
        if (n <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(x2)) {
            return !(x2 < 0.0) ? 1 : 0;
        }
        if (Double.isInfinite(n)) {
            return normal.cumulative(x2, 0.0, 1.0);
        }
        double val = 0.5 * beta.cumulative(n / (n + x2 * x2), n / 2.0, 0.5);
        return x2 > 0.0 ? 1.0 - val : val;
    }

    public static double quantile(double p, double ndf) {
        double q;
        double P;
        boolean neg;
        if (Double.isNaN(p) || Double.isNaN(ndf)) {
            return p + ndf;
        }
        if (ndf < 1.0 || p > 1.0 || p < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (ndf < 1.0 || p > 1.0 || p < 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (ndf > 1.0E20) {
            return normal.quantile(p, 0.0, 1.0);
        }
        if (p > 0.5) {
            neg = false;
            P = 2.0 * (1.0 - p);
        } else {
            neg = true;
            P = 2.0 * p;
        }
        if (Math.abs(ndf - 2.0) < eps) {
            q = Math.sqrt(2.0 / (P * (2.0 - P)) - 2.0);
        } else if (ndf < 1.0 + eps) {
            double prob = P * 1.5707963267948966;
            q = Math.cos(prob) / Math.sin(prob);
        } else {
            double a = 1.0 / (ndf - 0.5);
            double b = 48.0 / (a * a);
            double c = ((20700.0 * a / b - 98.0) * a - 16.0) * a + 96.36;
            double d = ((94.5 / (b + c) - 3.0) / b + 1.0) * Math.sqrt(a * 1.5707963267948966) * ndf;
            double y = Math.pow(d * P, 2.0 / ndf);
            if (y > 0.05 + a) {
                double x2 = normal.quantile(0.5 * P, 0.0, 1.0);
                y = x2 * x2;
                if (ndf < 5.0) {
                    c += 0.3 * (ndf - 4.5) * (x2 + 0.6);
                }
                c = (((0.05 * d * x2 - 5.0) * x2 - 7.0) * x2 - 2.0) * x2 + b + c;
                y = (((((0.4 * y + 6.3) * y + 36.0) * y + 94.5) / c - y - 3.0) / b + 1.0) * x2;
                y = (y = a * y * y) > 0.002 ? Math.exp(y) - 1.0 : 0.5 * y * y + y;
            } else {
                y = ((1.0 / (((ndf + 6.0) / (ndf * y) - 0.089 * d - 0.822) * (ndf + 2.0) * 3.0) + 0.5 / (ndf + 4.0)) * y - 1.0) * (ndf + 1.0) / (ndf + 2.0) + 1.0 / y;
            }
            q = Math.sqrt(ndf * y);
        }
        if (neg) {
            q = -q;
        }
        return q;
    }

    public static double random(double df, uniform PRNG) {
        if (Double.isNaN(df) || df <= 0.0) {
            throw new ArithmeticException("Math Error: DOMAIN");
        }
        if (Double.isInfinite(df)) {
            return normal.random(PRNG);
        }
        return normal.random(PRNG) / Math.sqrt(chisquare.random(df, PRNG) / df);
    }
}

