/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect.commandLine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.snpeff.SnpEff;
import org.snpeff.align.SmithWaterman;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.genBank.EmblFile;
import org.snpeff.genBank.Feature;
import org.snpeff.genBank.Features;
import org.snpeff.genBank.FeaturesFile;
import org.snpeff.genBank.GenBankFile;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.commandLine.SnpEffCmdCds;
import org.snpeff.util.Gpr;
import org.snpeff.util.Timer;

public class SnpEffCmdProtein
extends SnpEff {
    public static boolean onlyOneError = false;
    public static double MAX_ERROR_RATE = 0.05;
    boolean checkNumOk = true;
    boolean codonTables;
    boolean storeAlignments;
    int totalErrors = 0;
    int totalOk = 0;
    int totalWarnings = 0;
    int totalNotFound = 0;
    String configFile = "snpEff.config";
    String proteinFile = "";
    Map<String, String> proteinByTrId;
    AutoHashMap<String, List<Transcript>> trByChromo;
    HashMap<String, SmithWaterman> alignmentByTrId = new HashMap();

    public static int diffCount(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        int count2 = 0;
        for (int j = 0; j < minLen; ++j) {
            if (s1.charAt(j) == s2.charAt(j)) continue;
            ++count2;
        }
        return count2;
    }

    public static String diffStr(String s1, String s2) {
        int minLen = Math.min(s1.length(), s2.length());
        char[] diff2 = new char[minLen];
        for (int j = 0; j < minLen; ++j) {
            diff2[j] = s1.charAt(j) != s2.charAt(j) ? 124 : 32;
        }
        return new String(diff2);
    }

    public SnpEffCmdProtein() {
    }

    public SnpEffCmdProtein(Config config) {
        this.config = config;
        this.proteinFile = config.getFileNameProteins();
    }

    public SnpEffCmdProtein(Config config, String proteinFile) {
        this.config = config;
        this.proteinFile = proteinFile;
    }

    public SnpEffCmdProtein(String genomeVer, String configFile, String proteinFile) {
        this.configFile = configFile;
        this.genomeVer = genomeVer;
        this.proteinFile = proteinFile;
    }

    void add(String trId, String seq2, int lineNum, boolean check2) {
        if (check2 && this.proteinByTrId.get(trId) != null && !this.proteinByTrId.get(trId).equals(seq2)) {
            System.err.println("ERROR: Different protein for the same transcript ID. This should never happen!!!\n\tLine number   : " + lineNum + "\n\tTranscript ID : '" + trId + "'\n\tProtein       : " + this.proteinByTrId.get(trId) + "\n\tProtein (new) : " + seq2);
        }
        this.proteinByTrId.put(trId, seq2);
        if (this.debug) {
            Gpr.debug("Adding proteinByTrId{'" + trId + "'} :\t" + seq2);
        }
    }

    void checkCodonTables() {
        if (this.verbose) {
            Timer.showStdErr("Comparing Proteins...");
        }
        this.createTrByChromo();
        for (Chromosome chromo : this.genome) {
            String chr = chromo.getId();
            for (CodonTable codonTable : CodonTables.getInstance()) {
                this.setCodonTable(chromo, codonTable);
                this.proteinCompare(chr, false, false);
            }
        }
        if (this.verbose) {
            Timer.showStdErr("done");
        }
    }

    void checkProteins() {
        if (this.verbose) {
            Timer.showStdErr("Comparing Proteins...");
        }
        if (this.codonTables) {
            this.checkCodonTables();
        } else {
            this.proteinCompare(null, true, true);
        }
    }

    void createTrByChromo() {
        this.trByChromo = new AutoHashMap(new ArrayList());
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                String chr = tr.getChromosomeName();
                this.trByChromo.getOrCreate(chr).add(tr);
            }
        }
    }

    boolean equals(String protein, String proteinRef) {
        if (protein.isEmpty() && proteinRef.isEmpty()) {
            return true;
        }
        if ((protein = this.proteinFormat(protein)).equals(proteinRef = this.proteinFormat(proteinRef))) {
            return true;
        }
        String refUnk = "";
        if (proteinRef.length() > 0 && protein.equals(refUnk = proteinRef.substring(0, proteinRef.length() - 1))) {
            return true;
        }
        String proteinNoStart = "";
        String refNoStart = "";
        if (protein.length() > 0 && proteinRef.length() > 0 && (proteinNoStart = protein.substring(1)).equals(refNoStart = proteinRef.substring(1))) {
            return true;
        }
        String proteinU = protein.replace('*', 'U');
        if (proteinU.equals(proteinRef) || proteinU.equals(refUnk)) {
            return true;
        }
        String proteinNoStartU = proteinNoStart.replace('*', 'U');
        return proteinNoStartU.equals(refNoStart);
    }

    void fatalErrorNoTranscriptsChecked() {
        StringBuilder sb = new StringBuilder();
        int maxTrIds = 20;
        sb.append("Transcript IDs from database (sample):\n" + this.sampleTrIds(maxTrIds));
        sb.append("Transcript IDs from database (fasta file):\n" + this.sampleTrIdsFasta(maxTrIds));
        this.fatalError("No proteins checked. This is might be caused by differences in FASTA file transcript IDs respect to database's transcript's IDs.\n" + sb);
    }

    public HashMap<String, SmithWaterman> getAlignmentByTrId() {
        return this.alignmentByTrId;
    }

    public int getTotalErrors() {
        return this.totalErrors;
    }

    public int getTotalOk() {
        return this.totalOk;
    }

    @Override
    public void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (this.isOpt(arg)) {
                if (arg.equalsIgnoreCase("-codonTables")) {
                    this.codonTables = true;
                    continue;
                }
                this.usage("Unknown option '" + arg + "'");
                continue;
            }
            if (this.genomeVer.isEmpty()) {
                this.genomeVer = arg;
                continue;
            }
            if (this.proteinFile.isEmpty()) {
                this.proteinFile = arg;
                continue;
            }
            this.usage("Unknown parameter '" + arg + "'");
        }
        if (this.genomeVer.isEmpty()) {
            this.usage("Missing genomer_version parameter");
        }
        if (this.proteinFile.isEmpty()) {
            this.usage("Missing protein_file parameter");
        }
    }

    double proteinCompare(String chr, boolean addTotals, boolean updateTranscriptAaCheck) {
        List<Transcript> trList = null;
        if (chr == null) {
            trList = new ArrayList();
            for (Gene g : this.genome.getGenes()) {
                for (Transcript tr : g) {
                    trList.add(tr);
                }
            }
        } else {
            trList = (List)this.trByChromo.get(chr);
        }
        if (trList.isEmpty()) {
            return 0.0;
        }
        int i = 1;
        if (this.verbose) {
            System.err.println("\tLabels:");
            System.err.println("\t\t'+' : OK");
            System.err.println("\t\t'.' : Missing");
            System.err.println("\t\t'*' : Error");
            System.out.print((chr != null ? chr : "") + "\t");
        }
        int countNotFound = 0;
        int countOk = 0;
        int countErrors = 0;
        for (Transcript tr : trList) {
            char status = ' ';
            String protein = tr.protein();
            String proteinReference = this.proteinByTrId.get(tr.getId());
            if (proteinReference == null) {
                if (tr.isProteinCoding()) {
                    status = '.';
                    if (this.debug) {
                        System.err.println("\nWARNING:Cannot find Protein for transcript " + tr.getId());
                    }
                }
            } else if (this.equals(protein, proteinReference)) {
                status = '+';
            } else {
                status = '*';
                if (this.debug || this.storeAlignments || onlyOneError) {
                    protein = this.proteinFormat(protein);
                    proteinReference = this.proteinFormat(proteinReference);
                    SmithWaterman sw = new SmithWaterman(protein, proteinReference);
                    if (Math.max(protein.length(), proteinReference.length()) < SnpEffCmdCds.MAX_ALIGN_LENGTH) {
                        sw.align();
                    }
                    if (this.storeAlignments) {
                        this.alignmentByTrId.put(tr.getId(), sw);
                    }
                    int maxScore = Math.min(protein.length(), proteinReference.length());
                    int score = sw.getAlignmentScore();
                    if (this.debug || onlyOneError) {
                        System.err.println("\nERROR: Proteins do not match for transcript " + tr.getId() + "\tStrand:" + (tr.isStrandPlus() ? "+" : "-") + "\tExons: " + tr.numChilds() + "\n" + String.format("\tSnpEff protein     (%6d) : '%s'\n", protein.length(), protein) + String.format("\tReference protein  (%6d) : '%s'\n", proteinReference.length(), proteinReference) + "\tAlignment (Snpeff protein vs Reference protein).\tScore: " + score + "\tMax. possible score: " + maxScore + "\tDiff: " + (maxScore - score) + "\n" + sw);
                        System.err.println("Transcript details:\n" + tr);
                    }
                }
                if (onlyOneError) {
                    System.err.println("Transcript details:\n" + tr);
                    throw new RuntimeException("DIE");
                }
            }
            boolean ok = false;
            switch (status) {
                case '.': {
                    ++countNotFound;
                    break;
                }
                case '+': {
                    ++countOk;
                    ok = true;
                    break;
                }
                case '*': {
                    ++countErrors;
                    break;
                }
                case ' ': {
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown status '" + status + "'");
                }
            }
            if (ok && updateTranscriptAaCheck) {
                tr.setAaCheck(true);
            }
            if (!this.verbose || status == 32) continue;
            System.out.print(status);
            if (++i % 100 != 0) continue;
            System.out.print("\n\t");
        }
        double errorRate = (double)countErrors / (double)(countErrors + countOk);
        if (this.verbose) {
            System.out.println("\n");
        }
        System.out.println("\tProtein check:\t" + this.genome.getVersion() + (chr != null ? "\tChromosome: " + chr : "") + (chr != null ? "\tCodon table: " + CodonTables.getInstance().getTable(this.genome, chr).getName() : "") + "\tOK: " + countOk + "\tNot found: " + countNotFound + "\tErrors: " + countErrors + "\tError percentage: " + 100.0 * errorRate + "%");
        if (addTotals) {
            this.totalNotFound += countNotFound;
            this.totalOk += countOk;
            this.totalErrors += countErrors;
        } else if (this.checkNumOk && this.totalOk <= 0) {
            this.fatalErrorNoTranscriptsChecked();
        }
        return errorRate;
    }

    String proteinFormat(String protein) {
        int idxLast;
        if (protein.isEmpty()) {
            return "";
        }
        char lastChar = (protein = protein.toUpperCase()).charAt(idxLast = protein.length() - 1);
        if (lastChar == '*' || lastChar == '?') {
            protein = protein.substring(0, idxLast);
        }
        if ((protein = protein.replace('X', '?')).startsWith("?")) {
            protein = protein.substring(1);
        }
        return protein;
    }

    void readProteinFile() {
        if (this.verbose) {
            Timer.showStdErr("Reading proteins from file '" + this.proteinFile + "'...");
        }
        this.proteinByTrId = new HashMap<String, String>();
        if (this.proteinFile.endsWith("txt") || this.proteinFile.endsWith("txt.gz")) {
            this.readProteinFileTxt();
        } else if (this.proteinFile.endsWith(".gbk")) {
            this.readProteinFileGenBank();
        } else if (this.proteinFile.endsWith(".embl")) {
            this.readProteinFileEmbl();
        } else {
            this.readProteinFileFasta();
        }
        if (this.verbose) {
            Timer.showStdErr("done (" + this.proteinByTrId.size() + " Proteins).");
        }
    }

    void readProteinFileEmbl() {
        EmblFile featuresFile = new EmblFile(this.proteinFile);
        this.readProteinFileFeatures(featuresFile);
    }

    void readProteinFileFasta() {
        FastaFileIterator ffi = new FastaFileIterator(this.proteinFile);
        for (String seq2 : ffi) {
            String trId = ffi.getTranscriptId();
            this.add(trId, seq2, ffi.getLineNum(), true);
            List<String> ids = ffi.fastaHeader2Ids();
            for (String id : ids) {
                this.add(id, seq2, ffi.getLineNum(), false);
            }
        }
    }

    void readProteinFileFeatures(FeaturesFile featuresFile) {
        for (Features features : featuresFile) {
            String trIdPrev = null;
            for (Feature f2 : features.getFeatures()) {
                if (f2.getType() == Feature.Type.GENE) {
                    trIdPrev = null;
                    continue;
                }
                if (f2.getType() == Feature.Type.MRNA) {
                    trIdPrev = f2.getTranscriptId();
                    continue;
                }
                if (f2.getType() != Feature.Type.CDS) continue;
                String trId = trIdPrev;
                if (trId == null) {
                    trId = f2.getTranscriptId();
                }
                String seq2 = f2.getAasequence();
                if (this.debug) {
                    Gpr.debug(trId + "\t" + seq2);
                }
                if (trId == null || seq2 == null) continue;
                this.add(trId, seq2, -1, true);
            }
        }
    }

    void readProteinFileGenBank() {
        GenBankFile featuresFile = new GenBankFile(this.proteinFile);
        this.readProteinFileFeatures(featuresFile);
    }

    void readProteinFileTxt() {
        String proteinData = Gpr.readFile(this.proteinFile);
        String[] proteinLines = proteinData.split("\n");
        int lineNum = 1;
        for (String proteinLine : proteinLines) {
            String[] field2 = proteinLine.split("\\s+");
            if (field2.length >= 2) {
                String seq2 = field2[1].trim();
                String trId = field2[0].trim();
                this.add(trId, seq2, lineNum, true);
            }
            ++lineNum;
        }
    }

    @Override
    public boolean run() {
        if (this.verbose) {
            Timer.showStdErr("Checking database using protein sequences");
        }
        this.loadConfig();
        if (this.proteinByTrId == null) {
            this.readProteinFile();
        }
        this.loadDb();
        this.checkProteins();
        return true;
    }

    String sampleTrIds(int maxTrIds) {
        StringBuilder sb = new StringBuilder();
        int count2 = 0;
        for (Gene g : this.config.getGenome().getGenes()) {
            for (Transcript tr : g) {
                sb.append("\t'" + tr.getId() + "'\n");
                if (count2++ <= maxTrIds) continue;
                return sb.toString();
            }
        }
        return sb.toString();
    }

    String sampleTrIdsFasta(int maxTrIds) {
        StringBuilder sb = new StringBuilder();
        int count2 = 0;
        for (String trid : this.proteinByTrId.keySet()) {
            sb.append("\t'" + trid + "'\n");
            if (count2++ <= maxTrIds) continue;
            return sb.toString();
        }
        return sb.toString();
    }

    public void setCheckNumOk(boolean checkNumOk) {
        this.checkNumOk = checkNumOk;
    }

    void setCodonTable(Chromosome chromo, CodonTable codonTable) {
        CodonTables.getInstance().set(this.genome, chromo, codonTable);
        for (Transcript tr : (List)this.trByChromo.get(chromo.getId())) {
            tr.resetCache();
        }
    }

    public void setProteinByTrId(Map<String, String> proteinByTrId) {
        this.proteinByTrId = proteinByTrId;
    }

    public void setStoreAlignments(boolean storeAlignments) {
        this.storeAlignments = storeAlignments;
    }

    @Override
    public void usage(String message) {
        if (message != null) {
            System.err.println("Error: " + message + "\n");
        }
        System.err.println("snpEff version " + SnpEff.VERSION);
        System.err.println("Usage: snpEff protein [options] genome_version proteing_file");
        System.err.println("\nOptions:");
        System.err.println("\t-codonTables    : Try all codon tables on each chromosome and calculate error rates.");
        System.exit(-1);
    }
}

