<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">


  <xsl:output method="xml" media-type="text/xml" standalone="yes" indent="yes" encoding="utf-8" version="1.0"/>



  <!-- Documents template, all or one  -->

  <xsl:template match="GBSet">
  
    <xsl:element name="giv">
      <xsl:attribute name="name">
      <xsl:text>Genbank Features, </xsl:text>
      <xsl:value-of select='./GBSeq/GBSeq_locus[1]'/> 
      </xsl:attribute>


      <xsl:element name="view">
        <xsl:attribute name="name">Single Panel</xsl:attribute>
        <xsl:attribute name="from">1</xsl:attribute>
        <xsl:attribute name="to"><xsl:value-of select='./GBSeq/GBSeq_length'/></xsl:attribute> 
        <xsl:attribute name="edge">0.01</xsl:attribute>
		
 
        <xsl:element name="map-panel">
          <xsl:attribute name="label">Genbank Features - Protein</xsl:attribute>
          <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
          <xsl:attribute name="buoyancy">Floating</xsl:attribute>
          <xsl:attribute name="h-gap">3</xsl:attribute>
          <xsl:attribute name="v-gap">3</xsl:attribute>
 
          <xsl:element name="style-for">
            <xsl:attribute name="color">Magenta</xsl:attribute>
            <xsl:attribute name="bar-height">7</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:text>gene</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Orange</xsl:attribute>
            <xsl:attribute name="bar-height">7</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:text>CDS</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Blue Gray</xsl:attribute>
            <xsl:attribute name="bar-height">3</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>Org</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Plum</xsl:attribute>
            <xsl:attribute name="bar-height">5</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:text>Protein</xsl:text>
          </xsl:element>


          <xsl:element name="style-for">
            <xsl:attribute name="color">Blue</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:text>Region</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Red</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:text>Site</xsl:text>
          </xsl:element>

          <xsl:element name="style-for">
            <xsl:attribute name="color">Green</xsl:attribute>
            <xsl:attribute name="lbl-display">Always</xsl:attribute>
            <xsl:attribute name="bar-height">4</xsl:attribute>
            <xsl:text>variation</xsl:text>
          </xsl:element>


          <xsl:element name="group">
            <xsl:attribute name="name">Coding</xsl:attribute>
            <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:attribute name="v-gap">5</xsl:attribute>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='CDS']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='gene']/GBFeature_intervals/GBInterval"/>
          </xsl:element>


          <xsl:element name="group">
            <xsl:attribute name="name">Product</xsl:attribute>
            <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:attribute name="v-gap">5</xsl:attribute>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='Protein']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='Region']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='Site']/GBFeature_intervals/GBInterval"/>
          </xsl:element>

          <xsl:element name="group">
            <xsl:attribute name="name">Variation</xsl:attribute>
            <xsl:attribute name="bkg-color">Apricot</xsl:attribute>
            <xsl:attribute name="h-gap">0</xsl:attribute>
            <xsl:attribute name="v-gap">5</xsl:attribute>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='variation']/GBFeature_intervals/GBInterval"/>
            <xsl:apply-templates select="./GBSeq/GBSeq_feature-table/GBFeature[./GBFeature_key/text()='misc_feature']/GBFeature_intervals/GBInterval"/>
          </xsl:element>



        </xsl:element>
        
      </xsl:element>
    </xsl:element>

  </xsl:template>


  <!-- ====================================================================================  -->
 
 
  <xsl:template match="GBInterval">
    <xsl:element name="element">
      <xsl:attribute name="name">
        <xsl:value-of select="../../GBFeature_key"/>
      </xsl:attribute>
      <xsl:attribute name="type">
        <xsl:value-of select="../../GBFeature_key"/>
      </xsl:attribute>
      <xsl:apply-templates select="./GBInterval_from"/>
      <xsl:apply-templates select="./GBInterval_to"/>
      <xsl:apply-templates select="./GBInterval_point"/>
    </xsl:element>
  </xsl:template>

  <xsl:template match="GBInterval_from">
      <xsl:attribute name="from"><xsl:value-of select="."/></xsl:attribute>
  </xsl:template>

  <xsl:template match="GBInterval_to">
      <xsl:attribute name="to"><xsl:value-of select="."/></xsl:attribute>
  </xsl:template>

  <xsl:template match="GBInterval_point">
      <xsl:attribute name="from"><xsl:value-of select="."/></xsl:attribute>
      <xsl:attribute name="to"><xsl:value-of select="."/></xsl:attribute>
  </xsl:template>


  
</xsl:stylesheet>


