/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.QuaquaButtonListener;
import ch.randelshofer.quaqua.QuaquaManager;
import ch.randelshofer.quaqua.QuaquaUtilities;
import ch.randelshofer.quaqua.VisuallyLayoutable;
import ch.randelshofer.quaqua.util.Debug;
import ch.randelshofer.quaqua.util.Fonts;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicRadioButtonUI;
import javax.swing.text.View;

public class QuaquaRadioButtonUI
extends BasicRadioButtonUI
implements VisuallyLayoutable {
    private static final QuaquaRadioButtonUI checkboxUI = new QuaquaRadioButtonUI();
    private static final PropertyChangeHandler propertyChangeListener = new PropertyChangeHandler();
    protected Icon smallIcon;
    private boolean defaults_initialized = false;
    private static Dimension size = new Dimension();
    private static Rectangle viewR = new Rectangle();
    private static Rectangle iconR = new Rectangle();
    private static Rectangle textR = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);
    private static final Insets regularSpacing = new Insets(6, 6, 6, 6);
    private static final Insets smallSpacing = new Insets(6, 6, 6, 6);
    private static final Insets miniSpacing = new Insets(5, 5, 5, 5);

    public static ComponentUI createUI(JComponent b) {
        return checkboxUI;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.smallIcon = UIManager.getIcon(this.getPropertyPrefix() + "smallIcon");
            this.defaults_initialized = true;
        }
        QuaquaUtilities.installProperty(b, "opaque", UIManager.get("RadioButton.opaque"));
        b.setRequestFocusEnabled(QuaquaManager.getBoolean("RadioButton.requestFocusEnabled"));
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener(propertyChangeListener);
    }

    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(propertyChangeListener);
    }

    public Icon getDefaultIcon(JComponent c) {
        return c.getFont().getSize() <= 11 ? this.smallIcon : this.icon;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new QuaquaButtonListener(b);
    }

    public void paint(Graphics g, JComponent c) {
        Object oldHints = QuaquaUtilities.beginGraphics((Graphics2D)g);
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = g.getFontMetrics();
        Insets i = this.getInsets(b, viewInsets);
        size = b.getSize(size);
        QuaquaRadioButtonUI.viewR.x = i.left;
        QuaquaRadioButtonUI.viewR.y = i.top;
        QuaquaRadioButtonUI.viewR.width = QuaquaRadioButtonUI.size.width - (i.right + QuaquaRadioButtonUI.viewR.x);
        QuaquaRadioButtonUI.viewR.height = QuaquaRadioButtonUI.size.height - (i.bottom + QuaquaRadioButtonUI.viewR.y);
        QuaquaRadioButtonUI.iconR.height = 0;
        QuaquaRadioButtonUI.iconR.width = 0;
        QuaquaRadioButtonUI.iconR.y = 0;
        QuaquaRadioButtonUI.iconR.x = 0;
        QuaquaRadioButtonUI.textR.height = 0;
        QuaquaRadioButtonUI.textR.width = 0;
        QuaquaRadioButtonUI.textR.y = 0;
        QuaquaRadioButtonUI.textR.x = 0;
        Icon altIcon = b.getIcon();
        Object selectedIcon = null;
        Object disabledIcon = null;
        String text = this.layoutCL(b, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(c), viewR, iconR, textR);
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, QuaquaRadioButtonUI.size.width, QuaquaRadioButtonUI.size.height);
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, QuaquaRadioButtonUI.iconR.x, QuaquaRadioButtonUI.iconR.y);
        } else {
            Icon defaultIcon = this.getDefaultIcon(c);
            if (defaultIcon != null) {
                if (f.getSize() <= 11) {
                    --QuaquaRadioButtonUI.iconR.y;
                }
                defaultIcon.paintIcon(c, g, QuaquaRadioButtonUI.iconR.x, QuaquaRadioButtonUI.iconR.y);
            }
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textR);
            } else {
                this.paintText(g, b, textR, text);
                if (b.hasFocus() && b.isFocusPainted() && QuaquaRadioButtonUI.textR.width > 0 && QuaquaRadioButtonUI.textR.height > 0) {
                    this.paintFocus(g, textR, size);
                }
            }
        }
        QuaquaUtilities.endGraphics((Graphics2D)g, oldHints);
        Debug.paint(g, c, this);
    }

    protected void paintFocus(Graphics g, Rectangle textR, Dimension size) {
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.getDefaultIcon(c);
        }
        Font font = b.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        QuaquaRadioButtonUI.viewR.y = 0;
        QuaquaRadioButtonUI.viewR.x = 0;
        QuaquaRadioButtonUI.viewR.width = Short.MAX_VALUE;
        QuaquaRadioButtonUI.viewR.height = Short.MAX_VALUE;
        QuaquaRadioButtonUI.iconR.height = 0;
        QuaquaRadioButtonUI.iconR.width = 0;
        QuaquaRadioButtonUI.iconR.y = 0;
        QuaquaRadioButtonUI.iconR.x = 0;
        QuaquaRadioButtonUI.textR.height = 0;
        QuaquaRadioButtonUI.textR.width = 0;
        QuaquaRadioButtonUI.textR.y = 0;
        QuaquaRadioButtonUI.textR.x = 0;
        this.layoutCL(b, fm, text, buttonIcon, viewR, iconR, textR);
        int x1 = Math.min(QuaquaRadioButtonUI.iconR.x, QuaquaRadioButtonUI.textR.x);
        int x2 = Math.max(QuaquaRadioButtonUI.iconR.x + QuaquaRadioButtonUI.iconR.width, QuaquaRadioButtonUI.textR.x + QuaquaRadioButtonUI.textR.width);
        int y1 = Math.min(QuaquaRadioButtonUI.iconR.y, QuaquaRadioButtonUI.textR.y);
        int y2 = Math.max(QuaquaRadioButtonUI.iconR.y + QuaquaRadioButtonUI.iconR.height, QuaquaRadioButtonUI.textR.y + QuaquaRadioButtonUI.textR.height);
        int width = x2 - x1;
        int height = y2 - y1;
        viewInsets = this.getInsets(b, viewInsets);
        return new Dimension(width += QuaquaRadioButtonUI.viewInsets.left + QuaquaRadioButtonUI.viewInsets.right, height += QuaquaRadioButtonUI.viewInsets.top + QuaquaRadioButtonUI.viewInsets.bottom);
    }

    private Insets getInsets(AbstractButton b, Insets i) {
        i = b.getInsets(i);
        if (QuaquaManager.getBoolean("RadioButton.enforceVisualMargin")) {
            Insets vmargin = UIManager.getInsets("Component.visualMargin");
            i.left = Math.max(i.left, vmargin.left);
            i.top = Math.max(i.top, vmargin.top);
            i.bottom = Math.max(i.bottom, vmargin.bottom);
            i.right = Math.max(i.right, vmargin.right);
        }
        return i;
    }

    protected void paintText(Graphics g, AbstractButton b, Rectangle textR, String text) {
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        int mnemonicIndex = Methods.invokeGetter((Object)b, "getDisplayedMnemonicIndex", -1);
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
        } else {
            Color c = UIManager.getColor("RadioButton.disabledForeground");
            g.setColor(c != null ? c : b.getForeground());
        }
        QuaquaUtilities.drawStringUnderlineCharAt(g, text, mnemonicIndex, textR.x + this.getTextShiftOffset(), textR.y + fm.getAscent() + this.getTextShiftOffset());
    }

    protected String layoutCL(AbstractButton c, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        String clippedText = SwingUtilities.layoutCompoundLabel(c, fontMetrics, text, icon, c.getVerticalAlignment(), c.getHorizontalAlignment(), c.getVerticalTextPosition(), c.getHorizontalTextPosition(), viewR, iconR, textR, Methods.invokeGetter((Object)c, "getIconTextGap", 4));
        if (fontMetrics.getHeight() >= 13) {
            --iconR.y;
        }
        return clippedText;
    }

    public int getBaseline(JComponent c, int width, int height) {
        Rectangle vb = this.getVisualBounds(c, 2, width, height);
        return vb == null ? -1 : vb.y + vb.height;
    }

    public Rectangle getVisualBounds(JComponent c, int type, int width, int height) {
        Icon icon;
        Rectangle rect = new Rectangle(0, 0, width, height);
        if (type == 0) {
            return rect;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon icon2 = icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        if (icon == null) {
            icon = this.getDefaultIcon(b);
        }
        if (icon == null && text == null) {
            return rect;
        }
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets insets = this.getInsets(b, viewInsets);
        QuaquaRadioButtonUI.viewR.x = insets.left;
        QuaquaRadioButtonUI.viewR.y = insets.top;
        QuaquaRadioButtonUI.viewR.width = width - (insets.left + insets.right);
        QuaquaRadioButtonUI.viewR.height = height - (insets.top + insets.bottom);
        QuaquaRadioButtonUI.iconR.height = 0;
        QuaquaRadioButtonUI.iconR.width = 0;
        QuaquaRadioButtonUI.iconR.y = 0;
        QuaquaRadioButtonUI.iconR.x = 0;
        QuaquaRadioButtonUI.textR.height = 0;
        QuaquaRadioButtonUI.textR.width = 0;
        QuaquaRadioButtonUI.textR.y = 0;
        QuaquaRadioButtonUI.textR.x = 0;
        String clippedText = this.layoutCL(b, fm, text, icon, viewR, iconR, textR);
        Rectangle textBounds = Fonts.getPerceivedBounds(text, c.getFont(), c);
        int ascent = fm.getAscent();
        QuaquaRadioButtonUI.textR.x += textBounds.x;
        QuaquaRadioButtonUI.textR.width = textBounds.width;
        QuaquaRadioButtonUI.textR.y += ascent + textBounds.y;
        QuaquaRadioButtonUI.textR.height = textBounds.height;
        switch (type) {
            case 1: {
                rect = textR.union(iconR);
                break;
            }
            case 2: {
                rect.setBounds(textR);
            }
        }
        return rect;
    }

    public static class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            AbstractButton src = (AbstractButton)evt.getSource();
            if (name.equals("Frame.active") && src.isSelected()) {
                src.repaint();
            }
        }
    }
}

