/*
 * Decompiled with CFR 0.152.
 */
package installer;

import installer.Install;
import installer.OperatingSystem;
import installer.Progress;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;

public class InstallThread
extends Thread {
    private Install installer;
    private Progress progress;
    private OperatingSystem.ScriptParameters scriptParams;
    private int size;
    private Vector components;
    private byte[] buf;
    private boolean killed = false;

    public InstallThread(Install installer, Progress progress, OperatingSystem.ScriptParameters scriptParams, int size, Vector components) {
        super("Install thread");
        this.installer = installer;
        this.progress = progress;
        this.size = size;
        this.components = components;
        this.scriptParams = scriptParams;
        this.buf = new byte[32768];
    }

    public void setProgress(Progress progress) {
        this.progress = progress;
    }

    public void run() {
        this.progress.setMaximum(this.size * 1024);
        try {
            for (int i = 0; i < this.components.size(); ++i) {
                if (this.killed) {
                    return;
                }
                this.installComponent((String)this.components.elementAt(i));
            }
            if (this.scriptParams.binDir != null) {
                if (this.killed) {
                    return;
                }
                OperatingSystem.getOperatingSystem().mkdirs(this.scriptParams.binDir);
            }
            if (this.killed) {
                return;
            }
            OperatingSystem.getOperatingSystem().createScript(this.installer, this.scriptParams);
        }
        catch (IOException io) {
            this.progress.error(io.toString());
            return;
        }
        this.progress.done();
    }

    public void kill() {
        this.killed = true;
    }

    private void installComponent(String name) throws IOException {
        String fileName;
        BufferedReader fileList = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(name)));
        OperatingSystem os = OperatingSystem.getOperatingSystem();
        String execExtension = os.getExecScriptExtension();
        while ((fileName = fileList.readLine()) != null) {
            if (this.killed) {
                return;
            }
            String outfile = this.scriptParams.installDir + File.separatorChar + fileName.replace('/', File.separatorChar);
            BufferedInputStream in = new BufferedInputStream(this.getClass().getResourceAsStream("/" + fileName));
            if (in == null) {
                throw new FileNotFoundException(fileName);
            }
            this.copy(in, outfile);
            if (execExtension != null && fileName.endsWith(execExtension)) {
                os.chmodScript(outfile);
            }
            ((InputStream)in).close();
        }
        fileList.close();
    }

    private void copy(InputStream in, String outfile) throws IOException {
        int count;
        File outFile = new File(outfile);
        OperatingSystem.getOperatingSystem().mkdirs(outFile.getParent());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        while ((count = in.read(this.buf, 0, this.buf.length)) != -1) {
            out.write(this.buf, 0, count);
            this.progress.advance(count);
        }
        in.close();
        out.close();
    }
}

