/*
 * Decompiled with CFR 0.152.
 */
package org.forester.util;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Distribution;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.protein.BasicProtein;
import org.forester.protein.Domain;
import org.forester.protein.Protein;
import org.forester.sequence.MolecularSequence;
import org.forester.surfacing.SurfacingUtil;
import org.forester.util.EasyWriter;
import org.forester.util.TaxonomyColors;
import org.forester.util.TrustManager;

public final class ForesterUtil {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");
    public static final NumberFormat FORMATTER_06;
    public static final NumberFormat FORMATTER_3;
    public static final NumberFormat FORMATTER_6;
    public static final NumberFormat FORMATTER_9;
    public static final String JAVA_VENDOR;
    public static final String JAVA_VERSION;
    public static final String LINE_SEPARATOR;
    public static final String NCBI_GI = "https://www.ncbi.nlm.nih.gov/protein/gi:";
    public static final String NCBI_NUCCORE = "https://www.ncbi.nlm.nih.gov/nuccore/";
    public static final String NCBI_PROTEIN = "https://www.ncbi.nlm.nih.gov/protein/";
    public static final BigDecimal NULL_BD;
    public static final String OS_ARCH;
    public static final String OS_NAME;
    public static final String OS_VERSION;
    public static final String PDB = "http://www.pdb.org/pdb/explore/explore.do?pdbId=";
    public static final String UNIPROT_KB = "https://www.uniprot.org/uniprot/";
    public static final double ZERO_DIFF = 1.0E-12;
    private static final Pattern PARANTHESESABLE_NH_CHARS_PATTERN;

    public static final void appendSeparatorIfNotEmpty(StringBuffer stringBuffer, char c) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(c);
        }
    }

    public static final String removeFileExtension(String string) {
        if (string.indexOf(".") > 0) {
            return string.substring(0, string.lastIndexOf("."));
        }
        return string;
    }

    public static final Color calcColor(double d, double d2, double d3, Color color, Color color2) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        double d4 = ForesterUtil.calculateColorFactor(d, d3, d2);
        int n = ForesterUtil.calculateColorComponent(color.getRed(), color2.getRed(), d4);
        int n2 = ForesterUtil.calculateColorComponent(color.getGreen(), color2.getGreen(), d4);
        int n3 = ForesterUtil.calculateColorComponent(color.getBlue(), color2.getBlue(), d4);
        return new Color(n, n2, n3);
    }

    public static final Color calcColor(double d, double d2, double d3, double d4, Color color, Color color2, Color color3) {
        if (d < d2) {
            d = d2;
        }
        if (d > d3) {
            d = d3;
        }
        if (d < d4) {
            double d5 = ForesterUtil.calculateColorFactor(d, d4, d2);
            int n = ForesterUtil.calculateColorComponent(color.getRed(), color3.getRed(), d5);
            int n2 = ForesterUtil.calculateColorComponent(color.getGreen(), color3.getGreen(), d5);
            int n3 = ForesterUtil.calculateColorComponent(color.getBlue(), color3.getBlue(), d5);
            return new Color(n, n2, n3);
        }
        if (d > d4) {
            double d6 = ForesterUtil.calculateColorFactor(d, d3, d4);
            int n = ForesterUtil.calculateColorComponent(color3.getRed(), color2.getRed(), d6);
            int n4 = ForesterUtil.calculateColorComponent(color3.getGreen(), color2.getGreen(), d6);
            int n5 = ForesterUtil.calculateColorComponent(color3.getBlue(), color2.getBlue(), d6);
            return new Color(n, n4, n5);
        }
        return color3;
    }

    private static final int calculateColorComponent(double d, double d2, double d3) {
        return (int)(d + d3 * (d2 - d) / 255.0);
    }

    private static final double calculateColorFactor(double d, double d2, double d3) {
        return 255.0 * (d - d3) / (d2 - d3);
    }

    public static int calculateOverlap(Domain domain, List<Boolean> list) {
        int n = 0;
        for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
            if (i >= list.size() || !list.get(i).booleanValue()) continue;
            ++n;
        }
        return n;
    }

    public static final String collapseWhiteSpace(String string) {
        return string.replaceAll("[\\s]+", " ");
    }

    public static final void collection2file(File file, Collection<?> collection, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        ForesterUtil.collection2writer(bufferedWriter, collection, string);
        ((Writer)bufferedWriter).close();
    }

    public static final void collection2writer(Writer writer, Collection<?> collection, String string) throws IOException {
        boolean bl = true;
        for (Object obj : collection) {
            if (!bl) {
                writer.write(string);
            } else {
                bl = false;
            }
            writer.write(obj.toString());
        }
    }

    public static final String colorToHex(Color color) {
        String string = Integer.toHexString(color.getRGB());
        return string.substring(2, string.length());
    }

    public static synchronized void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = fileInputStream.read(byArray)) != -1) {
                fileOutputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    public static final int countChars(String string, char c) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            ++n;
        }
        return n;
    }

    public static final BufferedWriter createBufferedWriter(File file) throws IOException {
        if (file.exists()) {
            throw new IOException("[" + file + "] already exists");
        }
        return new BufferedWriter(new FileWriter(file));
    }

    public static final BufferedWriter createBufferedWriter(String string) throws IOException {
        return new BufferedWriter(new FileWriter(ForesterUtil.createFileForWriting(string)));
    }

    public static final EasyWriter createEasyWriter(File file) throws IOException {
        return new EasyWriter(ForesterUtil.createBufferedWriter(file));
    }

    public static final BufferedWriter createEasyWriter(String string) throws IOException {
        return ForesterUtil.createEasyWriter(ForesterUtil.createFileForWriting(string));
    }

    public static final File createFileForWriting(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            throw new IOException("[" + string + "] already exists");
        }
        return file;
    }

    public static final void ensurePresenceOfDate(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasDate()) {
            phylogenyNode.getNodeData().setDate(new org.forester.phylogeny.data.Date());
        }
    }

    public static final void ensurePresenceOfDistribution(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasDistribution()) {
            phylogenyNode.getNodeData().setDistribution(new Distribution(""));
        }
    }

    public static void ensurePresenceOfSequence(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasSequence()) {
            phylogenyNode.getNodeData().setSequence(new Sequence());
        }
    }

    public static void ensurePresenceOfTaxonomy(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
        }
    }

    public static void fatalError(String string) {
        System.err.println();
        System.err.println("error: " + string);
        System.err.println();
        System.exit(-1);
    }

    public static void fatalError(String string, String string2) {
        System.err.println();
        System.err.println("[" + string + "] > " + string2);
        System.err.println();
        System.exit(-1);
    }

    public static void fatalErrorIfFileNotReadable(File file) {
        String string = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(string)) {
            System.err.println();
            System.err.println("error: " + string);
            System.err.println();
            System.exit(-1);
        }
    }

    public static void fatalErrorIfFileNotReadable(String string, File file) {
        String string2 = ForesterUtil.isReadableFile(file);
        if (!ForesterUtil.isEmpty(string2)) {
            System.err.println();
            System.err.println("[" + string + "] > " + string2);
            System.err.println();
            System.exit(-1);
        }
    }

    public static String[][] file22dArray(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            arrayList.add(string);
        }
        bufferedReader.close();
        String[][] stringArray = new String[arrayList.size()][2];
        Pattern pattern = Pattern.compile("(\\S+)\\s+(\\S+)");
        int n = 0;
        for (String string2 : arrayList) {
            Matcher matcher = pattern.matcher(string2);
            if (matcher.matches()) {
                stringArray[n][0] = matcher.group(1);
                stringArray[n][1] = matcher.group(2);
                ++n;
                continue;
            }
            throw new IOException("unexpcted format: " + string2);
        }
        return stringArray;
    }

    public static String[] file2array(File file) throws IOException {
        List<String> list = ForesterUtil.file2list(file);
        String[] stringArray = new String[list.size()];
        int n = 0;
        for (String string : list) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static final List<String> file2list(File file) throws IOException {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            for (String string2 : ForesterUtil.splitString(string)) {
                arrayList.add(string2);
            }
        }
        bufferedReader.close();
        return arrayList;
    }

    public static final SortedSet<String> file2set(File file) throws IOException {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            for (String string2 : ForesterUtil.splitString(string)) {
                treeSet.add(string2);
            }
        }
        bufferedReader.close();
        return treeSet;
    }

    public static final String getCurrentDateTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return simpleDateFormat.format(new Date());
    }

    public static final String getFileSeparator() {
        return FILE_SEPARATOR;
    }

    public static final String getFirstLine(Object object) throws FileNotFoundException, IOException {
        Object object2;
        BufferedReader bufferedReader = null;
        if (object instanceof File) {
            object2 = (File)object;
            if (!((File)object2).exists()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] does not exist");
            }
            if (!((File)object2).isFile()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] is not a file");
            }
            if (!((File)object2).canRead()) {
                throw new IOException("[" + ((File)object2).getAbsolutePath() + "] is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader((File)object2));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof String) {
            bufferedReader = new BufferedReader(new StringReader((String)object));
        } else if (object instanceof StringBuffer) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else if (object instanceof URL) {
            object2 = ((URL)object).openConnection();
            ((URLConnection)object2).setDefaultUseCaches(false);
            bufferedReader = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        } else {
            throw new IllegalArgumentException("dont know how to read [" + object.getClass() + "]");
        }
        while ((object2 = bufferedReader.readLine()) != null) {
            if (ForesterUtil.isEmpty((String)(object2 = ((String)object2).trim()))) continue;
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            return object2;
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        return object2;
    }

    public static final String getForesterLibraryInformation() {
        return "forester 1.050 (180705)";
    }

    public static final String getLineSeparator() {
        return LINE_SEPARATOR;
    }

    public static final MolecularSequence.TYPE guessMolecularSequenceType(String string) {
        String string2 = string.toUpperCase();
        if (string2.contains("L") || string2.contains("I") || string2.contains("E") || string2.contains("H") || string2.contains("D") || string2.contains("Q")) {
            return MolecularSequence.TYPE.AA;
        }
        if (string2.contains("T")) {
            return MolecularSequence.TYPE.DNA;
        }
        if (string2.contains("U")) {
            return MolecularSequence.TYPE.RNA;
        }
        return null;
    }

    public static final void increaseCountingMap(Map<String, Integer> map, String string) {
        if (!map.containsKey(string)) {
            map.put(string, 1);
        } else {
            map.put(string, map.get(string) + 1);
        }
    }

    public static final boolean isEmpty(List<?> list) {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (Object obj : list) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(Set<?> set) {
        if (set == null || set.isEmpty()) {
            return true;
        }
        for (Object obj : set) {
            if (obj == null) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEmpty(String string) {
        return string == null || string.length() < 1;
    }

    public static final boolean isEmptyTrimmed(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() < 1;
    }

    public static boolean isEngulfed(Domain domain, List<Boolean> list) {
        for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
            if (i < list.size() && list.get(i).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static final boolean isEqual(double d, double d2) {
        return Math.abs(d - d2) < 1.0E-12;
    }

    public static final boolean isEqual(double d, double d2, double d3) {
        return Math.abs(d - d2) < d3;
    }

    public static final boolean isEven(int n) {
        return n % 2 == 0;
    }

    public static final boolean isIntersecting(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return false;
        }
        if (stringArray.length < 1 || stringArray2.length < 1) {
            return false;
        }
        for (String string : stringArray) {
            for (String string2 : stringArray2) {
                if (string == null || string2 == null || !string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    public static final double isLargerOrEqualToZero(double d) {
        if (d > 0.0) {
            return d;
        }
        return 0.0;
    }

    public static final boolean isMac() {
        try {
            return OS_NAME.toLowerCase().startsWith("mac");
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + exception);
            return false;
        }
    }

    public static final boolean isNull(BigDecimal bigDecimal) {
        return bigDecimal == null || bigDecimal.compareTo(NULL_BD) == 0;
    }

    public static final String isReadableFile(File file) {
        if (!file.exists()) {
            return "file [" + file + "] does not exist";
        }
        if (file.isDirectory()) {
            return "[" + file + "] is a directory";
        }
        if (!file.isFile()) {
            return "[" + file + "] is not a file";
        }
        if (!file.canRead()) {
            return "file [" + file + "] is not readable";
        }
        if (file.length() < 1L) {
            return "file [" + file + "] is empty";
        }
        return null;
    }

    public static final String isReadableFile(String string) {
        return ForesterUtil.isReadableFile(new File(string));
    }

    public static final boolean isWindows() {
        try {
            return OS_NAME.toLowerCase().indexOf("win") > -1;
        }
        catch (Exception exception) {
            ForesterUtil.printWarningMessage("Archaeopteryx", "minor error: " + exception);
            return false;
        }
    }

    public static final String isWritableFile(File file) {
        if (file.isDirectory()) {
            return "[" + file + "] is a directory";
        }
        if (file.exists()) {
            return "[" + file + "] already exists";
        }
        return null;
    }

    public static final String isWritableFile(String string) {
        return ForesterUtil.isWritableFile(new File(string));
    }

    public static final int limitRangeForColor(int n) {
        if (n > 255) {
            n = 255;
        } else if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static final SortedMap<Object, Integer> listToSortedCountsMap(List<?> list) {
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        for (Object obj : list) {
            if (!treeMap.containsKey(obj)) {
                treeMap.put(obj, 1);
                continue;
            }
            treeMap.put(obj, (Integer)treeMap.get(obj) + 1);
        }
        return treeMap;
    }

    public static final void map2file(File file, Map<?, ?> map, String string, String string2) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        ForesterUtil.map2writer(bufferedWriter, map, string, string2);
        ((Writer)bufferedWriter).close();
    }

    public static final void map2writer(Writer writer, Map<?, ?> map, String string, String string2) throws IOException {
        boolean bl = true;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (!bl) {
                writer.write(string2);
            } else {
                bl = false;
            }
            writer.write(entry.getKey().toString());
            writer.write(string);
            writer.write(entry.getValue().toString());
        }
    }

    public static final StringBuffer mapToStringBuffer(Map<Object, Object> map, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (Object object : map.keySet()) {
            stringBuffer.append(object.toString());
            stringBuffer.append(string);
            stringBuffer.append(map.get(object).toString());
            stringBuffer.append(ForesterUtil.getLineSeparator());
        }
        return stringBuffer;
    }

    public static final String normalizeString(String string, int n, boolean bl, char c) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        StringBuffer stringBuffer = new StringBuffer(n - string.length());
        for (int i = 0; i < n - string.length(); ++i) {
            stringBuffer.append(c);
        }
        if (bl) {
            return stringBuffer + string;
        }
        return string + stringBuffer;
    }

    public static final Color obtainColorDependingOnTaxonomyGroup(String string) {
        if (!ForesterUtil.isEmpty(string)) {
            if (string.equals("deuterostomia")) {
                return TaxonomyColors.DEUTEROSTOMIA_COLOR;
            }
            if (string.equals("protostomia")) {
                return TaxonomyColors.PROTOSTOMIA_COLOR;
            }
            if (string.equals("cnidaria")) {
                return TaxonomyColors.CNIDARIA_COLOR;
            }
            if (string.equals("placozoa")) {
                return TaxonomyColors.PLACOZOA_COLOR;
            }
            if (string.equals("ctenophora")) {
                return TaxonomyColors.CTENOPHORA_COLOR;
            }
            if (string.equals("porifera")) {
                return TaxonomyColors.PORIFERA_COLOR;
            }
            if (string.equals("choanoflagellida")) {
                return TaxonomyColors.CHOANOFLAGELLIDA;
            }
            if (string.equals("ichthyophonida & filasterea")) {
                return TaxonomyColors.ICHTHYOSPOREA_AND_FILASTEREA;
            }
            if (string.equals("dikarya")) {
                return TaxonomyColors.DIKARYA_COLOR;
            }
            if (string.equalsIgnoreCase("fungi") || string.equalsIgnoreCase("other fungi")) {
                return TaxonomyColors.OTHER_FUNGI_COLOR;
            }
            if (string.equals("nucleariidae and fonticula group")) {
                return TaxonomyColors.NUCLEARIIDAE_AND_FONTICULA_GROUP_COLOR;
            }
            if (string.equals("amoebozoa")) {
                return TaxonomyColors.AMOEBOZOA_COLOR;
            }
            if (string.equals("embryophyta")) {
                return TaxonomyColors.EMBRYOPHYTA_COLOR;
            }
            if (string.equals("chlorophyta")) {
                return TaxonomyColors.CHLOROPHYTA_COLOR;
            }
            if (string.equals("rhodophyta")) {
                return TaxonomyColors.RHODOPHYTA_COLOR;
            }
            if (string.equals("hacrobia")) {
                return TaxonomyColors.HACROBIA_COLOR;
            }
            if (string.equals("glaucocystophyceae")) {
                return TaxonomyColors.GLAUCOPHYTA_COLOR;
            }
            if (string.equals("stramenopiles")) {
                return TaxonomyColors.STRAMENOPILES_COLOR;
            }
            if (string.equals("alveolata")) {
                return TaxonomyColors.ALVEOLATA_COLOR;
            }
            if (string.equals("rhizaria")) {
                return TaxonomyColors.RHIZARIA_COLOR;
            }
            if (string.equals("excavata")) {
                return TaxonomyColors.EXCAVATA_COLOR;
            }
            if (string.equals("apusozoa")) {
                return TaxonomyColors.APUSOZOA_COLOR;
            }
            if (string.equals("archaea")) {
                return TaxonomyColors.ARCHAEA_COLOR;
            }
            if (string.equals("bacteria")) {
                return TaxonomyColors.BACTERIA_COLOR;
            }
            if (string.equals("viruses")) {
                return TaxonomyColors.VIRUSES_COLOR;
            }
            if (string.equals("alphaherpesvirinae")) {
                return TaxonomyColors.ALPHAHERPESVIRINAE_COLOR;
            }
            if (string.equals("betaherpesvirinae")) {
                return TaxonomyColors.BETAHERPESVIRINAE_COLOR;
            }
            if (string.equals("gammaherpesvirinae")) {
                return TaxonomyColors.GAMMAHERPESVIRINAE_COLOR;
            }
            if (string.equals("entomopoxvirinae")) {
                return TaxonomyColors.ENTOMOPOXVIRINAE_COLOR;
            }
            if (string.equals("chordopoxvirinae")) {
                return TaxonomyColors.CHORDOPOXVIRINAE_COLOR;
            }
            if (string.equals("alphacoronavirus")) {
                return TaxonomyColors.ALPHACORONAVIRUS_COLOR;
            }
            if (string.equals("betacoronavirus")) {
                return TaxonomyColors.BETACORONAVIRUS_COLOR;
            }
            if (string.equals("gammacoronavirus")) {
                return TaxonomyColors.GAMMACORONAVIRUS_COLOR;
            }
            if (string.equals("deltacoronavirus")) {
                return TaxonomyColors.DELTACORONAVIRUS_COLOR;
            }
            if (string.equals("torovirus")) {
                return TaxonomyColors.TOROVIRUS_COLOR;
            }
            if (string.equals("bafinivirus")) {
                return TaxonomyColors.BAFINIVIRUS_COLOR;
            }
            if (string.equals("other")) {
                return TaxonomyColors.OTHER_COLOR;
            }
        }
        return null;
    }

    public static final String obtainNormalizedTaxonomyGroup(String string) {
        if (string.equalsIgnoreCase("deuterostomia")) {
            return "deuterostomia";
        }
        if (string.equalsIgnoreCase("protostomia")) {
            return "protostomia";
        }
        if (string.equalsIgnoreCase("cnidaria")) {
            return "cnidaria";
        }
        if (string.toLowerCase().startsWith("trichoplax") || string.equalsIgnoreCase("placozoa")) {
            return "placozoa";
        }
        if (string.toLowerCase().startsWith("mnemiopsis") || string.equalsIgnoreCase("ctenophora")) {
            return "ctenophora";
        }
        if (string.toLowerCase().startsWith("amphimedon") || string.equalsIgnoreCase("porifera")) {
            return "porifera";
        }
        if (string.equalsIgnoreCase("codonosigidae") || string.equalsIgnoreCase("choanoflagellida")) {
            return "choanoflagellida";
        }
        if (string.toLowerCase().startsWith("ichthyophonida & filasterea") || string.toLowerCase().startsWith("ichthyophonida and filasterea") || string.toLowerCase().startsWith("ichthyosporea & filasterea") || string.toLowerCase().startsWith("ichthyosporea and filasterea")) {
            return "ichthyophonida & filasterea";
        }
        if (string.equalsIgnoreCase("dikarya")) {
            return "dikarya";
        }
        if (string.equalsIgnoreCase("fungi") || string.equalsIgnoreCase("other fungi")) {
            return "other fungi";
        }
        if (string.toLowerCase().startsWith("nucleariidae and fonticula")) {
            return "nucleariidae and fonticula group";
        }
        if (string.equalsIgnoreCase("amoebozoa")) {
            return "amoebozoa";
        }
        if (string.equalsIgnoreCase("embryophyta")) {
            return "embryophyta";
        }
        if (string.equalsIgnoreCase("chlorophyta")) {
            return "chlorophyta";
        }
        if (string.equalsIgnoreCase("rhodophyta")) {
            return "rhodophyta";
        }
        if (string.toLowerCase().startsWith("hacrobia")) {
            return "hacrobia";
        }
        if (string.equalsIgnoreCase("glaucocystophyceae") || string.equalsIgnoreCase("glaucophyta")) {
            return "glaucocystophyceae";
        }
        if (string.equalsIgnoreCase("stramenopiles")) {
            return "stramenopiles";
        }
        if (string.equalsIgnoreCase("alveolata")) {
            return "alveolata";
        }
        if (string.equalsIgnoreCase("rhizaria")) {
            return "rhizaria";
        }
        if (string.equalsIgnoreCase("excavata")) {
            return "excavata";
        }
        if (string.equalsIgnoreCase("apusozoa")) {
            return "apusozoa";
        }
        if (string.equalsIgnoreCase("archaea")) {
            return "archaea";
        }
        if (string.equalsIgnoreCase("bacteria")) {
            return "bacteria";
        }
        if (string.equalsIgnoreCase("bacteria")) {
            return "bacteria";
        }
        if (string.equalsIgnoreCase("viruses")) {
            return "viruses";
        }
        if (string.equalsIgnoreCase("alphaherpesvirinae")) {
            return "alphaherpesvirinae";
        }
        if (string.equalsIgnoreCase("betaherpesvirinae")) {
            return "betaherpesvirinae";
        }
        if (string.equalsIgnoreCase("gammaherpesvirinae")) {
            return "gammaherpesvirinae";
        }
        if (string.equalsIgnoreCase("chordopoxvirinae")) {
            return "chordopoxvirinae";
        }
        if (string.equalsIgnoreCase("entomopoxvirinae")) {
            return "entomopoxvirinae";
        }
        if (string.equalsIgnoreCase("alphacoronavirus")) {
            return "alphacoronavirus";
        }
        if (string.equalsIgnoreCase("betacoronavirus")) {
            return "betacoronavirus";
        }
        if (string.equalsIgnoreCase("deltacoronavirus")) {
            return "deltacoronavirus";
        }
        if (string.equalsIgnoreCase("gammacoronavirus")) {
            return "gammacoronavirus";
        }
        if (string.equalsIgnoreCase("torovirus")) {
            return "torovirus";
        }
        if (string.equalsIgnoreCase("bafinivirus")) {
            return "bafinivirus";
        }
        return null;
    }

    public static final BufferedReader obtainReader(Object object) throws IOException, FileNotFoundException {
        BufferedReader bufferedReader = null;
        if (object instanceof File) {
            File file = (File)object;
            if (!file.exists()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" does not exist");
            }
            if (!file.isFile()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" is not a file");
            }
            if (!file.canRead()) {
                throw new IOException("\"" + file.getAbsolutePath() + "\" is not a readable");
            }
            bufferedReader = new BufferedReader(new FileReader(file));
        } else if (object instanceof InputStream) {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        } else if (object instanceof String) {
            bufferedReader = new BufferedReader(new StringReader((String)object));
        } else if (object instanceof StringBuffer) {
            bufferedReader = new BufferedReader(new StringReader(object.toString()));
        } else {
            throw new IllegalArgumentException("attempt to parse object of type [" + object.getClass() + "] (can only parse objects of type File, InputStream, String, or StringBuffer)");
        }
        return bufferedReader;
    }

    public static final void outOfMemoryError(OutOfMemoryError outOfMemoryError) {
        System.err.println();
        System.err.println("Java memory allocation might be too small, try \"-Xmx2048m\" java command line option");
        System.err.println();
        outOfMemoryError.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final StringBuffer pad(double d, int n, char c, boolean bl) {
        return ForesterUtil.pad(new StringBuffer(d + ""), n, c, bl);
    }

    public static final StringBuffer pad(String string, int n, char c, boolean bl) {
        return ForesterUtil.pad(new StringBuffer(string), n, c, bl);
    }

    public static final StringBuffer pad(StringBuffer stringBuffer, int n, char c, boolean bl) {
        StringBuffer stringBuffer2 = new StringBuffer();
        int n2 = n - stringBuffer.length();
        if (n2 < 1) {
            return new StringBuffer(stringBuffer.substring(0, n));
        }
        for (int i = 0; i < n2; ++i) {
            stringBuffer2.append(c);
        }
        if (bl) {
            return stringBuffer2.append(stringBuffer);
        }
        return stringBuffer.append(stringBuffer2);
    }

    public static final double parseDouble(String string) throws ParseException {
        if (ForesterUtil.isEmpty(string)) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    public static final int parseInt(String string) throws ParseException {
        if (ForesterUtil.isEmpty(string)) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static final void printArray(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            System.out.println("[" + i + "]=" + objectArray[i]);
        }
    }

    public static final void printCountingMap(Map<String, Integer> map) {
        for (String string : map.keySet()) {
            System.out.println(string + ": " + map.get(string));
        }
    }

    public static final void printErrorMessage(String string, String string2) {
        System.err.println("[" + string + "] > error: " + string2);
    }

    public static final void printProgramInformation(String string, String string2, String string3) {
        int n = string.length() + string2.length() + string3.length() + 4;
        System.out.println();
        System.out.println(string + " " + string2 + " (" + string3 + ")");
        for (int i = 0; i < n; ++i) {
            System.out.print("_");
        }
        System.out.println();
    }

    public static final void printProgramInformation(String string, String string2, String string3, String string4, String string5) {
        ForesterUtil.printProgramInformation(string, null, string2, string3, string4, string5, null);
    }

    public static final void printProgramInformation(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        String string8 = new String(string);
        if (!ForesterUtil.isEmpty(string2)) {
            string8 = string8 + " - " + string2;
        }
        int n = string8.length() + string3.length() + string4.length() + 4;
        System.out.println();
        System.out.println(string8 + " " + string3 + " (" + string4 + ")");
        for (int i = 0; i < n; ++i) {
            System.out.print("_");
        }
        System.out.println();
        System.out.println();
        System.out.println("WWW     : " + string6);
        System.out.println("Contact : " + string5);
        if (!ForesterUtil.isEmpty(string7)) {
            System.out.println("Based on: " + string7);
        }
        if (!ForesterUtil.isEmpty(JAVA_VERSION) && !ForesterUtil.isEmpty(JAVA_VENDOR)) {
            System.out.println();
            System.out.println("[running on Java " + JAVA_VERSION + " " + JAVA_VENDOR + "]");
        }
        System.out.println();
    }

    public static final void printWarningMessage(String string, String string2) {
        System.out.println("[" + string + "] > warning: " + string2);
    }

    public static final void programMessage(String string, String string2) {
        System.out.println("[" + string + "] > " + string2);
    }

    public static List<String> readUrl(String string) throws IOException {
        String string2;
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string2 = bufferedReader.readLine()) != null) {
            arrayList.add(string2);
        }
        bufferedReader.close();
        return arrayList;
    }

    public static Protein removeOverlappingDomains(int n, boolean bl, Protein protein) {
        BasicProtein basicProtein = new BasicProtein(protein.getProteinId().getId(), protein.getSpecies().getSpeciesId(), protein.getLength());
        List<Domain> list = SurfacingUtil.sortDomainsWithAscendingConfidenceValues(protein);
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
        for (Domain domain : list) {
            int n2;
            int n3;
            if (n >= 0 && ForesterUtil.calculateOverlap(domain, arrayList) > n || bl && ForesterUtil.isEngulfed(domain, arrayList)) continue;
            for (n3 = n2 = arrayList.size(); n3 < domain.getFrom(); ++n3) {
                arrayList.add(false);
            }
            n3 = arrayList.size();
            for (int i = domain.getFrom(); i <= domain.getTo(); ++i) {
                if (i < n3) {
                    arrayList.set(i, true);
                    continue;
                }
                arrayList.add(true);
            }
            basicProtein.addProteinDomain(domain);
        }
        return basicProtein;
    }

    public static final String removeSuffix(String string) {
        int n = string.lastIndexOf(46);
        if (n > 1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static final String removeWhiteSpace(String string) {
        for (int i = 0; i <= string.length() - 1; ++i) {
            if (string.charAt(i) != ' ' && string.charAt(i) != '\t' && string.charAt(i) != '\n' && string.charAt(i) != '\r') continue;
            string = string.substring(0, i) + string.substring(i + 1);
            --i;
        }
        return string;
    }

    public static final String replaceIllegalNhxCharacters(String string) {
        if (string == null) {
            return "";
        }
        return string.trim().replaceAll("[\\[\\]']+", "_");
    }

    public static final double round(double d, int n) {
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(n, RoundingMode.HALF_UP);
        return bigDecimal.doubleValue();
    }

    public static final int roundToInt(double d) {
        return (int)(d + 0.5);
    }

    public static final int roundToInt(float f) {
        return (int)(f + 0.5f);
    }

    public static final short roundToShort(double d) {
        return (short)(d + 0.5);
    }

    public static final String sanitizeString(String string) {
        if (string == null) {
            return "";
        }
        return string.trim();
    }

    public static final StringBuilder santitizeStringForNH(String string) {
        string = string.replaceAll("\\s+", " ").trim();
        StringBuilder stringBuilder = new StringBuilder();
        if (string.length() > 0) {
            boolean bl;
            boolean bl2 = string.indexOf(39) > -1;
            boolean bl3 = bl = string.indexOf(34) > -1;
            if (bl2 && bl) {
                string = string.replace('\'', '`');
                stringBuilder.append('\'');
                stringBuilder.append(string);
                stringBuilder.append('\'');
            } else if (bl2) {
                stringBuilder.append('\"');
                stringBuilder.append(string);
                stringBuilder.append('\"');
            } else if (PARANTHESESABLE_NH_CHARS_PATTERN.matcher(string).find()) {
                stringBuilder.append('\'');
                stringBuilder.append(string);
                stringBuilder.append('\'');
            } else {
                stringBuilder.append(string);
            }
        }
        return stringBuilder;
    }

    public static boolean seqIsLikelyToBeAa(String string) {
        String string2 = string.toLowerCase();
        return string2.indexOf(114) > -1 || string2.indexOf(100) > -1 || string2.indexOf(101) > -1 || string2.indexOf(113) > -1 || string2.indexOf(104) > -1 || string2.indexOf(107) > -1 || string2.indexOf(119) > -1 || string2.indexOf(115) > -1 || string2.indexOf(109) > -1 || string2.indexOf(112) > -1 || string2.indexOf(118) > -1;
    }

    private static final String[] splitString(String string) {
        return string.split("[\\s;,]+");
    }

    public static final String stringArrayToString(String[] stringArray) {
        return ForesterUtil.stringArrayToString(stringArray, ", ");
    }

    public static final String stringArrayToString(String[] stringArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stringArray != null && stringArray.length > 0) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                stringBuilder.append(stringArray[i] + string);
            }
            stringBuilder.append(stringArray[stringArray.length - 1]);
        }
        return stringBuilder.toString();
    }

    public static final String[] stringListToArray(List<String> list) {
        if (list != null) {
            String[] stringArray = new String[list.size()];
            int n = 0;
            for (String string : list) {
                stringArray[n++] = string;
            }
            return stringArray;
        }
        return null;
    }

    public static final String stringListToString(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size() - 1; ++i) {
                stringBuilder.append(list.get(i) + string);
            }
            stringBuilder.append(list.get(list.size() - 1));
        }
        return stringBuilder.toString();
    }

    public static final String[] stringSetToArray(Set<String> set) {
        String[] stringArray = new String[set.size()];
        int n = 0;
        for (String string : set) {
            stringArray[n++] = string;
        }
        return stringArray;
    }

    public static final void unexpectedFatalError(Error error) {
        System.err.println();
        System.err.println("unexpected error: should not have occured! Please contact program author(s).");
        error.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(Exception exception) {
        System.err.println();
        System.err.println("unexpected exception: should not have occured! Please contact program author(s).");
        exception.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string) {
        System.err.println();
        System.err.println("unexpected error: should not have occured! Please contact program author(s).");
        System.err.println(string);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string, Exception exception) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error; should not have occured! Please contact program author(s).");
        exception.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string, String string2) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error: should not have occured! Please contact program author(s).");
        System.err.println(string2);
        System.err.println();
        System.exit(-1);
    }

    public static final void unexpectedFatalError(String string, String string2, Exception exception) {
        System.err.println();
        System.err.println("[" + string + "] > unexpected error: should not have occured! Please contact program author(s).");
        System.err.println(string2);
        exception.printStackTrace(System.err);
        System.err.println();
        System.exit(-1);
    }

    public static final void updateProgress(double d) {
        int n;
        System.out.print("\r[");
        for (n = 0; n <= ForesterUtil.roundToInt(d * 50.0); ++n) {
            System.out.print(".");
        }
        while (n < 50) {
            System.out.print(" ");
            ++n;
        }
        System.out.print("]");
    }

    public static final void updateProgress(int n, DecimalFormat decimalFormat) {
        System.out.print("\r[" + decimalFormat.format(n) + "]");
    }

    public static final String wordWrap(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) == ' ') {
                n3 = i;
            }
            if (stringBuilder.charAt(i) == '\n') {
                n3 = -1;
                n2 = i + 1;
            }
            if (i <= n2 + n - 1) continue;
            if (n3 != -1) {
                stringBuilder.setCharAt(n3, '\n');
                n2 = n3 + 1;
                n3 = -1;
                continue;
            }
            stringBuilder.insert(i, '\n');
            n2 = i + 1;
        }
        return stringBuilder.toString();
    }

    public static final Phylogeny[] readPhylogeniesFromUrl(URL uRL, PhylogenyParser phylogenyParser) throws NoSuchAlgorithmException, IOException, KeyManagementException {
        URLConnection uRLConnection;
        if (uRL == null) {
            throw new IllegalArgumentException("URL to read from must not be null");
        }
        if (phylogenyParser == null) {
            throw new IllegalArgumentException("parser to use to read from URL must not be null");
        }
        if (uRL.toString().startsWith("https:")) {
            uRLConnection = TrustManager.makeHttpsURLConnection(uRL);
        } else if (uRL.toString().startsWith("http:")) {
            uRLConnection = uRL.openConnection();
        } else {
            throw new IllegalArgumentException("Cannot deal with URL: " + uRL);
        }
        if (uRLConnection == null) {
            throw new IOException("could not create connection from " + uRL);
        }
        uRLConnection.setDefaultUseCaches(false);
        InputStream inputStream = uRLConnection.getInputStream();
        if (inputStream == null) {
            throw new IOException("could not create input stream from " + uRL);
        }
        Phylogeny[] phylogenyArray = ParserBasedPhylogenyFactory.getInstance().create(inputStream, phylogenyParser);
        try {
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return phylogenyArray;
    }

    public static final File getMatchingFile(File file, String string, final String string2) throws IOException {
        if (!file.exists()) {
            throw new IOException("[" + file + "] does not exist");
        }
        if (!file.isDirectory()) {
            throw new IOException("[" + file + "] is not a directory");
        }
        if (file.listFiles().length == 0) {
            throw new IOException("[" + file + "] is empty");
        }
        File[] fileArray = file.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(string2);
            }
        });
        if (fileArray.length == 0) {
            throw new IOException("no files ending with \"" + string2 + "\" found in [" + file + "]");
        }
        String string3 = string;
        boolean bl = false;
        boolean bl2 = false;
        File file2 = null;
        do {
            int n = 0;
            for (File file3 : fileArray) {
                if (!file3.getName().startsWith(string3)) continue;
                if (++n > 1) {
                    file2 = null;
                    break;
                }
                file2 = file3;
            }
            if (n > 1) {
                bl2 = true;
                bl = true;
            }
            if (n == 1) {
                bl = true;
                continue;
            }
            if (string3.length() <= 1) {
                throw new IOException("no file matching \"" + ForesterUtil.removeFileExtension(string) + "\" and ending with \"" + string2 + "\" found in [" + file + "]");
            }
            string3 = string3.substring(0, string3.length() - 1);
        } while (!bl);
        if (bl2) {
            throw new IOException("multiple files matching \"" + ForesterUtil.removeFileExtension(string) + "\" and ending with \"" + string2 + "\" found in [" + file + "]");
        }
        if (file2 == null) {
            throw new IOException("no file matching \"" + ForesterUtil.removeFileExtension(string) + "\" and ending with \"" + string2 + "\" found in [" + file + "]");
        }
        return file2;
    }

    public static final String greatestCommonPrefix(String string, String string2) {
        int n = Math.min(string.length(), string2.length());
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) == string2.charAt(i)) continue;
            return string.substring(0, i);
        }
        return string.substring(0, n);
    }

    public static final boolean isContainsPrefix(String string, String string2, String string3) {
        String[] stringArray;
        if (ForesterUtil.isEmpty(string3)) {
            throw new IllegalArgumentException("separator must not be null or empty");
        }
        String[] stringArray2 = string.split(Pattern.quote(string3));
        if (stringArray2.length < (stringArray = string2.split(Pattern.quote(string3))).length) {
            return false;
        }
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (stringArray2[i].equals(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public static final String greatestCommonPrefix(String string, String string2, String string3) {
        if (ForesterUtil.isEmpty(string3)) {
            throw new IllegalArgumentException("separator must not be null or empty");
        }
        String[] stringArray = string.split(Pattern.quote(string3));
        String[] stringArray2 = string2.split(Pattern.quote(string3));
        int n = Math.min(stringArray.length, stringArray2.length);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].equals(stringArray2[i])) continue;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (int j = 0; j < i; ++j) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(string3);
                }
                stringBuilder.append(stringArray[j]);
            }
            return stringBuilder.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string3);
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static final String greatestCommonPrefix(List<String> list) {
        if (list == null) {
            throw new IllegalArgumentException("list of strings is null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("list of strings is empty");
        }
        String string = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            string = ForesterUtil.greatestCommonPrefix(string, list.get(i));
        }
        return string;
    }

    public static final String greatestCommonPrefix(List<String> list, String string) {
        if (ForesterUtil.isEmpty(string)) {
            return ForesterUtil.greatestCommonPrefix(list);
        }
        if (list == null) {
            throw new IllegalArgumentException("list of strings is null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("list of strings is empty");
        }
        String string2 = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            string2 = ForesterUtil.greatestCommonPrefix(string2, list.get(i), string);
        }
        return string2;
    }

    public static List<String> spliIntoPrefixes(String string, String string2) {
        String[] stringArray = string.split(Pattern.quote(string2));
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j <= i; ++j) {
                stringBuilder.append(stringArray[j]);
                if (j >= i) continue;
                stringBuilder.append(string2);
            }
            arrayList.add(stringBuilder.toString());
        }
        return arrayList;
    }

    public static boolean isLooksLikeFasta(File file) throws IOException {
        String string = ForesterUtil.getFirstLine(file).trim().toLowerCase();
        return !ForesterUtil.isEmptyTrimmed(string) && string.trim().startsWith(">");
    }

    private ForesterUtil() {
    }

    static {
        JAVA_VENDOR = System.getProperty("java.vendor");
        JAVA_VERSION = System.getProperty("java.version");
        LINE_SEPARATOR = System.getProperty("line.separator");
        NULL_BD = new BigDecimal(0);
        OS_ARCH = System.getProperty("os.arch");
        OS_NAME = System.getProperty("os.name");
        OS_VERSION = System.getProperty("os.version");
        PARANTHESESABLE_NH_CHARS_PATTERN = Pattern.compile("[(),;\\s:\\[\\]]");
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        FORMATTER_9 = new DecimalFormat("#.#########", decimalFormatSymbols);
        FORMATTER_6 = new DecimalFormat("#.######", decimalFormatSymbols);
        FORMATTER_06 = new DecimalFormat("0.######", decimalFormatSymbols);
        FORMATTER_3 = new DecimalFormat("#.###", decimalFormatSymbols);
    }
}

