/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.nhx;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nhx.NHXFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.io.parsers.util.PhylogenyParserException;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.Identifier;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.util.ForesterUtil;

public final class NHXParser
implements PhylogenyParser,
IteratingPhylogenyParser {
    private static final Pattern MB_BL_PATTERN = Pattern.compile("length.median=([-+eE0-9\\.]+)");
    private static final Pattern MB_PROB_PATTERN = Pattern.compile("prob=([-+eE0-9\\.]+)");
    private static final Pattern MB_PROB_SD_PATTERN = Pattern.compile("prob.stddev=([-+eE0-9\\.]+)");
    private static final Pattern NUMBERS_ONLY_PATTERN = Pattern.compile("^[-+]?[0-9\\.]+$");
    private static final Pattern BEAST_STYLE_EXTENDED_BOOTSTRAP_PATTERN = Pattern.compile("boot?strap=([\\d\\.]+)");
    private static final Pattern BEAST_STYLE_EXTENDED_COLOR_PATTERN = Pattern.compile("colou?r=(#[\\da-fA-F]{6})");
    private static final Pattern ENDS_WITH_NUMBER_PATTERN = Pattern.compile("(:[-+eE0-9\\.]+$)");
    public static final boolean REPLACE_UNDERSCORES_DEFAULT = false;
    private static final boolean ALLOW_ERRORS_IN_DISTANCE_TO_PARENT_DEFAULT = false;
    private static final byte BUFFERED_READER = 3;
    private static final byte CHAR_ARRAY = 2;
    private static final boolean GUESS_IF_SUPPORT_VALUES = true;
    private static final boolean GUESS_ROOTEDNESS_DEFAULT = true;
    private static final boolean IGNORE_QUOTES_DEFAULT = false;
    private static final char BELL = '\u0007';
    private static final String ENCODING_DEFAULT = "UTF-8";
    private boolean _allow_errors_in_distance_to_parent;
    private int _clade_level;
    private StringBuilder _current_anotation;
    private PhylogenyNode _current_node;
    private Phylogeny _current_phylogeny;
    private boolean _guess_rootedness;
    private int _i;
    private boolean _ignore_quotes;
    private boolean _in_comment = false;
    private boolean _in_double_quote = false;
    private boolean _in_open_bracket = false;
    private boolean _in_single_quote = false;
    private byte _input_type;
    private BufferedReader _my_source_br = null;
    private char[] _my_source_charary = null;
    private Phylogeny _next;
    private Object _nhx_source;
    private boolean _replace_underscores;
    private boolean _saw_closing_paren;
    private boolean _saw_colon = false;
    private boolean _saw_open_bracket = false;
    private boolean _after_close_paren = false;
    private Object _source;
    private int _source_length;
    private TAXONOMY_EXTRACTION _taxonomy_extraction;
    private boolean _parse_beast_style_extended_tags = false;
    private final String _encoding;

    public NHXParser() {
        this._encoding = ENCODING_DEFAULT;
        this.init();
    }

    public NHXParser(String string) {
        this._encoding = string;
        this.init();
    }

    @Override
    public String getName() {
        return "NH/NHX Parser";
    }

    public final TAXONOMY_EXTRACTION getTaxonomyExtraction() {
        return this._taxonomy_extraction;
    }

    @Override
    public final boolean hasNext() {
        return this._next != null;
    }

    @Override
    public final Phylogeny next() throws NHXFormatException, IOException {
        Phylogeny phylogeny = this._next;
        this.parseNext();
        return phylogeny;
    }

    @Override
    public final Phylogeny[] parse() throws IOException {
        ArrayList<Phylogeny> arrayList = new ArrayList<Phylogeny>();
        while (this.hasNext()) {
            arrayList.add(this.next());
        }
        Phylogeny[] phylogenyArray = new Phylogeny[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            phylogenyArray[i] = (Phylogeny)arrayList.get(i);
        }
        this.reset();
        return phylogenyArray;
    }

    @Override
    public final void reset() throws NHXFormatException, IOException {
        this._i = 0;
        this._next = null;
        this._in_comment = false;
        this._saw_colon = false;
        this._saw_open_bracket = false;
        this._in_open_bracket = false;
        this._in_double_quote = false;
        this._in_single_quote = false;
        this._after_close_paren = false;
        this._clade_level = 0;
        this._current_anotation = new StringBuilder();
        this._current_phylogeny = null;
        this._current_node = null;
        this._my_source_charary = null;
        this.determineAndProcessSourceType(this._source);
        switch (this._input_type) {
            case 2: {
                this._my_source_br = null;
                this._my_source_charary = (char[])this._nhx_source;
                break;
            }
            case 3: {
                this._my_source_br = (BufferedReader)this._nhx_source;
                break;
            }
            default: {
                throw new RuntimeException("unknown input type");
            }
        }
        this.parseNext();
    }

    public final void setGuessRootedness(boolean bl) {
        this._guess_rootedness = bl;
    }

    public final void setIgnoreQuotes(boolean bl) {
        this._ignore_quotes = bl;
    }

    public final void setReplaceUnderscores(boolean bl) {
        this._replace_underscores = bl;
    }

    @Override
    public final void setSource(Object object) throws NHXFormatException, IOException {
        this._source = object;
        this.reset();
    }

    public final void setTaxonomyExtraction(TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION) {
        this._taxonomy_extraction = tAXONOMY_EXTRACTION;
    }

    public final void setAllowErrorsInDistanceToParent(boolean bl) {
        this._allow_errors_in_distance_to_parent = bl;
    }

    private final void determineAndProcessSourceType(Object object) throws IOException {
        if (object == null) {
            throw new PhylogenyParserException(this.getClass() + ": attempt to parse null object.");
        }
        if (object instanceof String) {
            this._nhx_source = object;
            this._input_type = (byte)3;
            this._source_length = 0;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(((String)object).getBytes(this.getEncoding()));
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, this.getEncoding());
            this._nhx_source = new BufferedReader(inputStreamReader);
        } else if (object instanceof char[]) {
            this._input_type = (byte)2;
            this._source_length = ((char[])object).length;
            this._nhx_source = object;
        } else if (object instanceof File) {
            File file;
            String string;
            this._input_type = (byte)3;
            this._source_length = 0;
            if (this._my_source_br != null) {
                // empty if block
            }
            if (!ForesterUtil.isEmpty(string = ForesterUtil.isReadableFile(file = (File)object))) {
                throw new PhylogenyParserException(string);
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, this.getEncoding());
            this._nhx_source = new BufferedReader(inputStreamReader);
        } else if (object instanceof URL) {
            this._input_type = (byte)3;
            this._source_length = 0;
            if (this._my_source_br != null) {
                // empty if block
            }
            InputStream inputStream = ((URL)object).openStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.getEncoding());
            this._nhx_source = new BufferedReader(inputStreamReader);
        } else if (object instanceof InputStream) {
            this._input_type = (byte)3;
            this._source_length = 0;
            if (this._my_source_br != null) {
                // empty if block
            }
            InputStream inputStream = (InputStream)object;
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, this.getEncoding());
            this._nhx_source = new BufferedReader(inputStreamReader);
        } else {
            throw new IllegalArgumentException(this.getClass() + " can only parse objects of type String, char[], File, InputStream, or URL  [attempt to parse object of " + object.getClass() + "].");
        }
    }

    private final Phylogeny finishPhylogeny() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        if (this._current_phylogeny != null) {
            PhylogenyNode phylogenyNode;
            NHXParser.parseNHX(this._current_anotation != null ? this._current_anotation.toString() : "", this._current_phylogeny.getRoot(), this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true, this.isParseBeastStyleExtendedTags());
            if (NHXParser.isBranchLengthsLikeBootstrapValues(this._current_phylogeny)) {
                NHXParser.moveBranchLengthsToConfidenceValues(this._current_phylogeny);
            }
            if (this.isGuessRootedness() && ((phylogenyNode = this._current_phylogeny.getRoot()).getDistanceToParent() >= 0.0 || !ForesterUtil.isEmpty(phylogenyNode.getName()) || !ForesterUtil.isEmpty(PhylogenyMethods.getSpecies(phylogenyNode)) || phylogenyNode.isHasAssignedEvent())) {
                this._current_phylogeny.setRooted(true);
            }
            return this._current_phylogeny;
        }
        return null;
    }

    private final Phylogeny finishSingleNodePhylogeny() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        NHXParser.parseNHX(this._current_anotation.toString(), phylogenyNode, this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true, this.isParseBeastStyleExtendedTags());
        this._current_phylogeny = new Phylogeny();
        this._current_phylogeny.setRoot(phylogenyNode);
        return this._current_phylogeny;
    }

    private final void init() {
        this.setTaxonomyExtraction(TAXONOMY_EXTRACTION.NO);
        this.setReplaceUnderscores(false);
        this.setGuessRootedness(true);
        this.setIgnoreQuotes(false);
        this.setAllowErrorsInDistanceToParent(false);
        this.setParseBeastStyleExtendedTags(false);
    }

    private final boolean isAllowErrorsInDistanceToParent() {
        return this._allow_errors_in_distance_to_parent;
    }

    private final boolean isGuessRootedness() {
        return this._guess_rootedness;
    }

    private final boolean isIgnoreQuotes() {
        return this._ignore_quotes;
    }

    private final boolean isReplaceUnderscores() {
        return this._replace_underscores;
    }

    private final void parseNext() throws IOException, NHXFormatException {
        if (this._source == null) {
            throw new IOException("source is not set");
        }
        while (true) {
            char c = '\b';
            if (this._input_type == 3) {
                int n = this._my_source_br.read();
                if (n < 0) break;
                c = (char)n;
            } else {
                if (this._i >= this._source_length) break;
                c = this._my_source_charary[this._i];
            }
            if (!this._in_single_quote && !this._in_double_quote) {
                if (c == ':') {
                    this._saw_colon = true;
                } else if (c >= '!' && c != '\u007f' && this._saw_colon && c != '[' && c != '.' && (c < '0' || c > '9')) {
                    this._saw_colon = false;
                }
                if (this._in_open_bracket && c == ']') {
                    this._in_open_bracket = false;
                }
            }
            if (c >= ' ' && c != '\u007f' && (!this.isIgnoreQuotes() || c != ' ' && c != '\"' && c != '\'') && (c != ' ' || this._in_single_quote || this._in_double_quote) && (this._clade_level != 0 || c != ';' || this._in_single_quote || this._in_double_quote)) {
                if (this._in_comment) {
                    if (c == ']') {
                        this._in_comment = false;
                    }
                } else if (this._in_double_quote) {
                    if (c == '\"') {
                        this._in_double_quote = false;
                    } else {
                        this._current_anotation.append(NHXParser.changeCharInParens(c));
                    }
                } else if (c == '\"' && !this._in_single_quote) {
                    this._in_double_quote = true;
                } else if (this._in_single_quote) {
                    if (c == '\'') {
                        this._in_single_quote = false;
                    } else {
                        this._current_anotation.append(NHXParser.changeCharInParens(c));
                    }
                } else if (c == '\'') {
                    this._in_single_quote = true;
                } else if (c == '[') {
                    this._saw_open_bracket = true;
                    this._in_open_bracket = true;
                } else if (this._saw_open_bracket) {
                    if (c != ']') {
                        if (c == '&') {
                            this._current_anotation.append("[&");
                        } else if ((this._saw_colon || this._after_close_paren) && (c > '/' && c < ':' || c == '.' || c == '-' || c == '+')) {
                            this._current_anotation.append("[" + c);
                        } else {
                            this._in_comment = true;
                        }
                    }
                    this._saw_open_bracket = false;
                } else if (c == '(' && !this._in_open_bracket) {
                    this._after_close_paren = false;
                    Phylogeny phylogeny = this.processOpenParen();
                    if (phylogeny != null) {
                        ++this._i;
                        this._next = phylogeny;
                        return;
                    }
                } else if (c == ')' && !this._in_open_bracket) {
                    this._after_close_paren = true;
                    this.processCloseParen();
                } else if (c == ',' && !this._in_open_bracket) {
                    this._after_close_paren = false;
                    this.processComma();
                } else {
                    this._current_anotation.append(c);
                }
            }
            ++this._i;
        }
        if (this._clade_level != 0) {
            throw new PhylogenyParserException("error in NH (Newick) formatted data: most likely cause: number of open parens does not equal number of close parens");
        }
        if (this._current_phylogeny != null) {
            this._next = this.finishPhylogeny();
            this._current_phylogeny = null;
            this._current_anotation = null;
        } else if (this._current_anotation != null && this._current_anotation.length() > 0) {
            this._next = this.finishSingleNodePhylogeny();
            this._current_anotation = null;
        } else {
            this._next = null;
        }
    }

    private static final char changeCharInParens(char c) {
        if (c == ':') {
            c = (char)7;
        } else if (c == '[') {
            c = (char)123;
        } else if (c == ']') {
            c = (char)125;
        }
        return c;
    }

    private final void processCloseParen() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        if (this._clade_level < 0) {
            throw new PhylogenyParserException("error in NH (Newick)/NHX formatted data: most likely cause: number of close parens is larger than number of open parens");
        }
        --this._clade_level;
        if (!this._saw_closing_paren) {
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            NHXParser.parseNHX(this._current_anotation.toString(), phylogenyNode, this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true, this.isParseBeastStyleExtendedTags());
            this._current_anotation = new StringBuilder();
            this._current_node.addAsChild(phylogenyNode);
        } else {
            NHXParser.parseNHX(this._current_anotation.toString(), this._current_node.getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true, this.isParseBeastStyleExtendedTags());
            this._current_anotation = new StringBuilder();
        }
        if (!this._current_node.isRoot()) {
            this._current_node = this._current_node.getParent();
        }
        this._saw_closing_paren = true;
    }

    private final void processComma() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        if (!this._saw_closing_paren) {
            PhylogenyNode phylogenyNode = new PhylogenyNode();
            NHXParser.parseNHX(this._current_anotation.toString(), phylogenyNode, this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true, this.isParseBeastStyleExtendedTags());
            if (this._current_node == null) {
                throw new NHXFormatException("format might not be NH or NHX");
            }
            this._current_node.addAsChild(phylogenyNode);
        } else {
            NHXParser.parseNHX(this._current_anotation.toString(), this._current_node.getLastChildNode(), this.getTaxonomyExtraction(), this.isReplaceUnderscores(), this.isAllowErrorsInDistanceToParent(), true, this.isParseBeastStyleExtendedTags());
        }
        this._current_anotation = new StringBuilder();
        this._saw_closing_paren = false;
    }

    private final Phylogeny processOpenParen() throws PhylogenyParserException, NHXFormatException, PhyloXmlDataFormatException {
        Phylogeny phylogeny = null;
        PhylogenyNode phylogenyNode = new PhylogenyNode();
        if (this._clade_level == 0) {
            if (this._current_phylogeny != null) {
                phylogeny = this.finishPhylogeny();
            }
            this._clade_level = 1;
            this._current_anotation = new StringBuilder();
            this._current_phylogeny = new Phylogeny();
            this._current_phylogeny.setRoot(phylogenyNode);
        } else {
            ++this._clade_level;
            this._current_node.addAsChild(phylogenyNode);
        }
        this._current_node = phylogenyNode;
        this._saw_closing_paren = false;
        return phylogeny;
    }

    private static final NHXParser createInstance(Object object) throws NHXFormatException, IOException {
        NHXParser nHXParser = new NHXParser();
        nHXParser.setSource(object);
        return nHXParser;
    }

    public static final Phylogeny[] parse(Object object) throws NHXFormatException, IOException {
        return NHXParser.createInstance(object).parse();
    }

    public static final void parseNHX(String string, PhylogenyNode phylogenyNode, TAXONOMY_EXTRACTION tAXONOMY_EXTRACTION, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws NHXFormatException, PhyloXmlDataFormatException {
        if (tAXONOMY_EXTRACTION != TAXONOMY_EXTRACTION.NO && bl) {
            throw new IllegalArgumentException("cannot extract taxonomies and replace under scores at the same time");
        }
        if (string != null && string.length() > 0) {
            Object object;
            if (bl) {
                string = string.replaceAll("_+", " ");
            }
            string = string.replaceAll("\\s+", " ").trim();
            boolean bl5 = false;
            int n = string.indexOf("[");
            if (n > -1) {
                object = "";
                bl5 = true;
                int n2 = string.indexOf("]");
                if (n2 < 0) {
                    throw new NHXFormatException("error in NHX formatted data: no closing \"]\" in \"" + string + "\"");
                }
                if (string.indexOf("&&NHX") == n + 1) {
                    object = string.substring(n + 6, n2);
                } else {
                    Matcher matcher;
                    String string2 = string.substring(n + 1, n2);
                    Matcher matcher2 = NUMBERS_ONLY_PATTERN.matcher(string2);
                    if (matcher2.matches()) {
                        object = ":B=" + string2;
                    } else if (string.indexOf("prob=") > -1) {
                        NHXParser.processMrBayes3Data(string, phylogenyNode);
                    }
                    if (bl4) {
                        NHXParser.processBeastStyleExtendedData(string, phylogenyNode);
                    }
                    if ((matcher = ENDS_WITH_NUMBER_PATTERN.matcher(string)).find()) {
                        object = (String)object + matcher.group(1);
                    }
                }
                string = string.substring(0, n) + (String)object;
                if (string.indexOf("[") > -1 || string.indexOf("]") > -1) {
                    throw new NHXFormatException("error in NHX formatted data: more than one \"]\" or \"[\"");
                }
            }
            if (((StringTokenizer)(object = new StringTokenizer(string, ":"))).countTokens() > 0) {
                if (!string.startsWith(":")) {
                    if (string.indexOf(7) <= -1 || !bl3) {
                        phylogenyNode.setName(((StringTokenizer)object).nextToken());
                    } else {
                        phylogenyNode.setName(((StringTokenizer)object).nextToken().replace('\u0007', ':'));
                    }
                    if (!bl && !bl5 && tAXONOMY_EXTRACTION != TAXONOMY_EXTRACTION.NO) {
                        ParserUtils.extractTaxonomyDataFromNodeName(phylogenyNode, tAXONOMY_EXTRACTION);
                    }
                }
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string = ((StringTokenizer)object).nextToken();
                    if (string.indexOf(7) > -1 && bl3) {
                        string = string.replace('\u0007', ':');
                    }
                    if (string.indexOf(61) < 0) {
                        if (phylogenyNode.getDistanceToParent() != -1024.0 && !bl2) {
                            throw new NHXFormatException("error in NHX formatted data: more than one distance to parent:\"" + string + "\"");
                        }
                        phylogenyNode.setDistanceToParent(NHXParser.doubleValue(string, bl2));
                        continue;
                    }
                    if (string.startsWith("S=")) {
                        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        phylogenyNode.getNodeData().getTaxonomy().setScientificName(string.substring(2));
                        continue;
                    }
                    if (string.startsWith("D=")) {
                        if (string.charAt(2) == 'Y' || string.charAt(2) == 'T') {
                            phylogenyNode.getNodeData().setEvent(Event.createSingleDuplicationEvent());
                            continue;
                        }
                        if (string.charAt(2) == 'N' || string.charAt(2) == 'F') {
                            phylogenyNode.getNodeData().setEvent(Event.createSingleSpeciationEvent());
                            continue;
                        }
                        if (string.charAt(2) == '?') {
                            phylogenyNode.getNodeData().setEvent(Event.createSingleSpeciationOrDuplicationEvent());
                            continue;
                        }
                        throw new NHXFormatException("error in NHX formatted data: :D=Y or :D=N or :D=?");
                    }
                    if (string.startsWith("B=")) {
                        PhylogenyMethods.setConfidence(phylogenyNode, NHXParser.doubleValue(string.substring(2), false));
                        continue;
                    }
                    if (string.startsWith("T=")) {
                        if (!phylogenyNode.getNodeData().isHasTaxonomy()) {
                            phylogenyNode.getNodeData().setTaxonomy(new Taxonomy());
                        }
                        phylogenyNode.getNodeData().getTaxonomy().setIdentifier(new Identifier(string.substring(2)));
                        continue;
                    }
                    if (string.startsWith("AC=")) {
                        if (!phylogenyNode.getNodeData().isHasSequence()) {
                            phylogenyNode.getNodeData().setSequence(new Sequence());
                        }
                        phylogenyNode.getNodeData().getSequence().setAccession(new Accession(string.substring(3), "?"));
                        continue;
                    }
                    if (!string.startsWith("GN=")) continue;
                    if (!phylogenyNode.getNodeData().isHasSequence()) {
                        phylogenyNode.getNodeData().setSequence(new Sequence());
                    }
                    phylogenyNode.getNodeData().getSequence().setName(string.substring(3));
                }
            }
        }
    }

    private static final double doubleValue(String string, boolean bl) throws NHXFormatException {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (!bl) {
                throw new NHXFormatException("error in NH/NHX formatted data: failed to parse number from \"" + string + "\"");
            }
            return 0.0;
        }
    }

    private static final boolean isBranchLengthsLikeBootstrapValues(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        double d = phylogenyNodeIterator.next().getDistanceToParent();
        if (d < 10.0 || !phylogenyNodeIterator.hasNext()) {
            return false;
        }
        while (phylogenyNodeIterator.hasNext()) {
            double d2 = phylogenyNodeIterator.next().getDistanceToParent();
            if (d2 == d && !(d2 < 10.0)) continue;
            return false;
        }
        return true;
    }

    private static final void moveBranchLengthsToConfidenceValues(Phylogeny phylogeny) {
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            PhylogenyMethods.setBootstrapConfidence(phylogenyNode, phylogenyNode.getDistanceToParent());
            phylogenyNode.setDistanceToParent(-1024.0);
        }
    }

    private static final void processBeastStyleExtendedData(String string, PhylogenyNode phylogenyNode) throws NHXFormatException {
        Matcher matcher = BEAST_STYLE_EXTENDED_BOOTSTRAP_PATTERN.matcher(string);
        double d = -1.0;
        if (matcher.find()) {
            try {
                d = Double.parseDouble(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse bootstrap support from \"" + string + "\"");
            }
            if (d >= 0.0) {
                phylogenyNode.getBranchData().addConfidence(new Confidence(d, "bootstrap"));
            }
        }
        Matcher matcher2 = BEAST_STYLE_EXTENDED_COLOR_PATTERN.matcher(string);
        Color color = null;
        if (matcher2.find()) {
            try {
                color = Color.decode(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse color from \"" + string + "\"");
            }
        }
        if (color != null) {
            phylogenyNode.getBranchData().setBranchColor(new BranchColor(color));
        }
    }

    private static final void processMrBayes3Data(String string, PhylogenyNode phylogenyNode) throws NHXFormatException {
        Matcher matcher;
        Matcher matcher2;
        double d = -1.0;
        Matcher matcher3 = MB_PROB_SD_PATTERN.matcher(string);
        if (matcher3.find()) {
            try {
                d = Double.parseDouble(matcher3.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse probability standard deviation (Mr Bayes output) from \"" + string + "\"");
            }
        }
        if ((matcher2 = MB_PROB_PATTERN.matcher(string)).find()) {
            double d2 = -1.0;
            try {
                d2 = Double.parseDouble(matcher2.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse probability (Mr Bayes output) from \"" + string + "\"");
            }
            if (d2 >= 0.0) {
                if (d >= 0.0) {
                    phylogenyNode.getBranchData().addConfidence(new Confidence(d2, "posterior probability", d));
                } else {
                    phylogenyNode.getBranchData().addConfidence(new Confidence(d2, "posterior probability"));
                }
            }
        }
        if ((matcher = MB_BL_PATTERN.matcher(string)).find()) {
            double d3 = -1.0;
            try {
                d3 = Double.parseDouble(matcher.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                throw new NHXFormatException("failed to parse median branch length (Mr Bayes output) from \"" + string + "\"");
            }
            if (d3 >= 0.0) {
                phylogenyNode.setDistanceToParent(d3);
            }
        }
    }

    public String getEncoding() {
        return this._encoding;
    }

    private final boolean isParseBeastStyleExtendedTags() {
        return this._parse_beast_style_extended_tags;
    }

    public final void setParseBeastStyleExtendedTags(boolean bl) {
        this._parse_beast_style_extended_tags = bl;
    }

    public static enum TAXONOMY_EXTRACTION {
        AGGRESSIVE,
        NO,
        PFAM_STYLE_RELAXED,
        PFAM_STYLE_STRICT;

    }
}

