/*
 * Decompiled with CFR 0.152.
 */
package org.forester.archaeopteryx;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.AttributedString;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.forester.archaeopteryx.AptxUtil;
import org.forester.archaeopteryx.Configuration;
import org.forester.archaeopteryx.ControlPanel;
import org.forester.archaeopteryx.FontChooser;
import org.forester.archaeopteryx.MainFrame;
import org.forester.archaeopteryx.MainPanel;
import org.forester.archaeopteryx.MouseListener;
import org.forester.archaeopteryx.NodeFrame;
import org.forester.archaeopteryx.Options;
import org.forester.archaeopteryx.TreeColorSet;
import org.forester.archaeopteryx.TreeFontSet;
import org.forester.archaeopteryx.TreePanelUtil;
import org.forester.archaeopteryx.phylogeny.data.RenderableDomainArchitecture;
import org.forester.archaeopteryx.phylogeny.data.RenderableMsaSequence;
import org.forester.archaeopteryx.phylogeny.data.RenderablePhylogenyData;
import org.forester.archaeopteryx.phylogeny.data.RenderableVector;
import org.forester.archaeopteryx.tools.Blast;
import org.forester.archaeopteryx.tools.ImageLoader;
import org.forester.io.writers.SequenceWriter;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Accession;
import org.forester.phylogeny.data.Annotation;
import org.forester.phylogeny.data.BranchColor;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.DomainArchitecture;
import org.forester.phylogeny.data.Event;
import org.forester.phylogeny.data.NodeDataField;
import org.forester.phylogeny.data.NodeVisualData;
import org.forester.phylogeny.data.ProteinDomain;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.data.Uri;
import org.forester.phylogeny.iterators.PhylogenyNodeIterator;
import org.forester.phylogeny.iterators.PreorderTreeIterator;
import org.forester.util.DescriptiveStatistics;
import org.forester.util.ForesterUtil;
import org.forester.util.SequenceAccessionTools;
import org.forester.util.TaxonomyUtil;

public final class TreePanel
extends JPanel
implements ActionListener,
MouseWheelListener,
Printable {
    public static final boolean SPECIAL_DOMAIN_COLORING = true;
    static final Cursor ARROW_CURSOR = Cursor.getPredefinedCursor(0);
    static final Cursor CUT_CURSOR = Cursor.getPredefinedCursor(1);
    static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    private static final double _180_OVER_PI = 57.29577951308232;
    private static final float ANGLE_ROTATION_UNIT = 0.09817477f;
    private static final int CONFIDENCE_LEFT_MARGIN = 4;
    private static final int EURO_D = 10;
    private static final NumberFormat FORMATTER_BRANCH_LENGTH;
    private static final NumberFormat FORMATTER_CONFIDENCE;
    private static final float HALF_PI = 1.5707964f;
    private static final int LIMIT_FOR_HQ_RENDERING = 2000;
    private static final int MAX_NODE_FRAMES = 10;
    private static final int MAX_SUBTREES = 100;
    private static final int MIN_ROOT_LENGTH = 3;
    private static final int MOVE = 20;
    private static final String NODE_POPMENU_NODE_CLIENT_PROPERTY = "node";
    private static final float ONEHALF_PI = 4.712389f;
    private static final short OV_BORDER = 10;
    private static final double OVERVIEW_FOUND_NODE_BOX_SIZE = 2.0;
    private static final double OVERVIEW_FOUND_NODE_BOX_SIZE_HALF = 1.0;
    private static final float PI = (float)Math.PI;
    private static final Font POPUP_FONT;
    private static final float ROUNDED_D = 8.0f;
    private static final long serialVersionUID = -978349745916505029L;
    private static final BasicStroke STROKE_0025;
    private static final BasicStroke STROKE_005;
    private static final BasicStroke STROKE_01;
    private static final BasicStroke STROKE_025;
    private static final BasicStroke STROKE_05;
    private static final BasicStroke STROKE_075;
    private static final BasicStroke STROKE_1;
    private static final BasicStroke STROKE_2;
    private static final BasicStroke STROKE_01_DASHED;
    private static final BasicStroke STROKE_005_DASHED;
    private static final BasicStroke STROKE_001_DASHED;
    private static final double TWO_PI = Math.PI * 2;
    private static final int WIGGLE = 2;
    private static final String SHOW_ONLY_THIS_CONF_TYPE;
    HashMap<Long, Short> _nodeid_dist_to_leaf = new HashMap();
    private final Arc2D _arc = new Arc2D.Double();
    private AffineTransform _at;
    private int _circ_max_depth;
    private final Set<Long> _collapsed_external_nodeid_set = new HashSet<Long>();
    private JColorChooser _color_chooser = null;
    private Configuration _configuration = null;
    private ControlPanel _control_panel = null;
    private final CubicCurve2D _cubic_curve = new CubicCurve2D.Float();
    private Set<Long> _current_external_nodes = null;
    private StringBuilder _current_external_nodes_data_buffer = new StringBuilder();
    private int _current_external_nodes_data_buffer_change_counter = 0;
    private int _domain_structure_e_value_thr_exp = -3;
    private double _domain_structure_width = 100.0;
    private int _dynamic_hiding_factor = 0;
    private boolean _edited = false;
    private final Ellipse2D _ellipse = new Ellipse2D.Float();
    private int _external_node_index = 0;
    private Set<Long> _found_nodes_0 = null;
    private Set<Long> _found_nodes_1 = null;
    private final FontRenderContext _frc = new FontRenderContext(null, false, false);
    private Options.PHYLOGENY_GRAPHICS_TYPE _graphics_type = Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR;
    private PhylogenyNode _highlight_node = null;
    private boolean _in_ov = false;
    private boolean _in_ov_rect = false;
    private float _last_drag_point_x = 0.0f;
    private float _last_drag_point_y = 0.0f;
    private final Line2D _line = new Line2D.Float();
    private int _longest_ext_node_info = 0;
    private PhylogenyNode _ext_node_with_longest_txt_info = null;
    private MainPanel _main_panel = null;
    private double _max_distance_to_root = -1.0;
    private Popup _node_desc_popup;
    private int _node_frame_index = 0;
    private final NodeFrame[] _node_frames = new NodeFrame[10];
    private JPopupMenu _node_popup_menu = null;
    private JMenuItem[] _node_popup_menu_items = null;
    private PhylogenyNode[] _nodes_in_preorder = null;
    private Options _options = null;
    private float _ov_max_height = 0.0f;
    private float _ov_max_width = 0.0f;
    private boolean _ov_on = false;
    private final Rectangle2D _ov_rectangle = new Rectangle2D.Float();
    private final Rectangle _ov_virtual_rectangle = new Rectangle();
    private float _ov_x_correction_factor = 0.0f;
    private float _ov_x_distance = 0.0f;
    private int _ov_x_position = 0;
    private float _ov_y_distance = 0.0f;
    private int _ov_y_position = 0;
    private int _ov_y_start = 0;
    private final boolean _phy_has_branch_lengths;
    private Phylogeny _phylogeny = null;
    private final Path2D.Float _polygon = new Path2D.Float();
    private final StringBuffer _popup_buffer = new StringBuffer();
    private final QuadCurve2D _quad_curve = new QuadCurve2D.Float();
    private Sequence _query_sequence = null;
    private final Rectangle2D _rectangle = new Rectangle2D.Float();
    private final RenderingHints _rendering_hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
    private JTextArea _rollover_popup;
    private PhylogenyNode _root;
    private final StringBuilder _sb = new StringBuilder();
    private double _scale_distance = 0.0;
    private String _scale_label = null;
    private DescriptiveStatistics _statistics_for_vector_data;
    private final Phylogeny[] _sub_phylogenies = new Phylogeny[100];
    private final PhylogenyNode[] _sub_phylogenies_temp_roots = new PhylogenyNode[100];
    private int _subtree_index = 0;
    private File _treefile = null;
    private float _urt_factor = 1.0f;
    private float _urt_factor_ov = 1.0f;
    private final HashMap<Long, Double> _urt_nodeid_angle_map = new HashMap();
    private final HashMap<Long, Integer> _urt_nodeid_index_map = new HashMap();
    private double _urt_starting_angle = 1.5707963705062866;
    private float _x_correction_factor = 0.0f;
    private float _x_distance = 0.0f;
    private float _y_distance = 0.0f;
    private int _length_of_longest_text;
    private int _longest_domain;
    private Map<String, AttributedString> _attributed_string_map = null;
    private int _depth_collapse_level = -1;
    private int _rank_collapse_level = -1;

    TreePanel(Phylogeny phylogeny, Configuration configuration, MainPanel mainPanel) {
        this.requestFocusInWindow();
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                TreePanel.this.keyPressedCalls(keyEvent);
                TreePanel.this.requestFocusInWindow();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TreePanel.this.requestFocusInWindow();
            }
        });
        if (phylogeny == null || phylogeny.isEmpty()) {
            throw new IllegalArgumentException("attempt to draw phylogeny which is null or empty");
        }
        this._graphics_type = mainPanel.getOptions().getPhylogenyGraphicsType();
        this._main_panel = mainPanel;
        this._configuration = configuration;
        this._phylogeny = phylogeny;
        this._phy_has_branch_lengths = AptxUtil.isHasAtLeastOneBranchLengthLargerThanZero(this._phylogeny);
        this.init();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.setBackground(this.getTreeColorSet().getBackgroundColor());
        MouseListener mouseListener = new MouseListener(this);
        this.addMouseListener(mouseListener);
        this.addMouseMotionListener(mouseListener);
        this.addMouseWheelListener(this);
        this.calculateScaleDistance();
        FORMATTER_CONFIDENCE.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForConfidenceValues());
        FORMATTER_BRANCH_LENGTH.setMaximumFractionDigits(configuration.getNumberOfDigitsAfterCommaForBranchLengthValues());
    }

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        for (int i = 0; i < this._node_popup_menu_items.length && !bl; ++i) {
            if (jMenuItem != this._node_popup_menu_items[i]) continue;
            this._main_panel.getControlPanel().setClickToAction(i);
            PhylogenyNode phylogenyNode = (PhylogenyNode)this._node_popup_menu.getClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY);
            this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), phylogenyNode);
            bl = true;
        }
        this.repaint();
        this.requestFocusInWindow();
    }

    public synchronized Hashtable<String, BufferedImage> getImageMap() {
        return this.getMainPanel().getImageMap();
    }

    public final MainPanel getMainPanel() {
        return this._main_panel;
    }

    public final Phylogeny getPhylogeny() {
        return this._phylogeny;
    }

    public final TreeColorSet getTreeColorSet() {
        return this.getMainPanel().getTreeColorSet();
    }

    @Override
    public final void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getWheelRotation();
        if (this.inOvVirtualRectangle(mouseWheelEvent)) {
            if (!this.isInOvRect()) {
                this.setInOvRect(true);
                this.repaint();
            }
        } else if (this.isInOvRect()) {
            this.setInOvRect(false);
            this.repaint();
        }
        if (mouseWheelEvent.isControlDown() && mouseWheelEvent.isShiftDown()) {
            if (n < 0) {
                this.getTreeFontSet().increaseFontSize();
            } else {
                this.getTreeFontSet().decreaseFontSize(1, false);
            }
            this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
            this.resetPreferredSize();
            this.updateOvSizes();
            this.repaint();
        } else if (mouseWheelEvent.isShiftDown() && mouseWheelEvent.isAltDown()) {
            if (n < 0) {
                for (int i = 0; i < -n; ++i) {
                    this.getControlPanel().zoomInX(1.08f, 1.08f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            }
        } else if (mouseWheelEvent.isShiftDown()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                if (n < 0) {
                    for (int i = 0; i < -n; ++i) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                        if (this.getStartingAngle() < 0.0) {
                            this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                        }
                        this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                    }
                }
            } else if (n < 0) {
                for (int i = 0; i < -n; ++i) {
                    this.getControlPanel().zoomInY(1.08f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.getControlPanel().zoomOutY(0.9259259f);
                    this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
                }
            }
        } else if (n < 0) {
            for (int i = 0; i < -n; ++i) {
                this.getControlPanel().zoomInX(1.08f, 1.085f);
                this.getControlPanel().zoomInY(1.08f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.getControlPanel().zoomOutY(0.9259259f);
                this.getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        }
        this.requestFocus();
        this.requestFocusInWindow();
        this.requestFocus();
    }

    @Override
    public final void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHints(this._rendering_hints);
        this.paintPhylogeny(graphics2D, false, false, 0, 0, 0, 0);
    }

    @Override
    public final int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        this.paintPhylogeny(graphics2D, true, false, 0, 0, 0, 0);
        return 0;
    }

    public final void setEdited(boolean bl) {
        this._edited = bl;
    }

    public synchronized void setImageMap(Hashtable<String, BufferedImage> hashtable) {
        this.getMainPanel().setImageMap(hashtable);
    }

    public final void setTree(Phylogeny phylogeny) {
        this.setNodeInPreorderToNull();
        this._phylogeny = phylogeny;
    }

    public final void setWaitCursor() {
        this.setCursor(WAIT_CURSOR);
        this.repaint();
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    private void abbreviateScientificName(String string, StringBuilder stringBuilder) {
        String[] stringArray = string.split("\\s+");
        stringBuilder.append(stringArray[0].substring(0, 1));
        stringBuilder.append(stringArray[1].substring(0, 2));
        if (stringArray.length > 2) {
            for (int i = 2; i < stringArray.length; ++i) {
                stringBuilder.append(" ");
                stringBuilder.append(stringArray[i]);
            }
        }
    }

    private final void addEmptyNode(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        String string = this.createASimpleTextRepresentationOfANode(phylogenyNode);
        String string2 = "";
        string2 = ForesterUtil.isEmpty(string) ? "How to add the new, empty node?" : "How to add the new, empty node to node" + string + "?";
        Object[] objectArray = new Object[]{"As sibling", "As descendant", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, string2, "Addition of Empty New Node", -1, 3, null, objectArray, objectArray[2]);
        boolean bl = true;
        if (n == 1) {
            bl = false;
        } else if (n != 0) {
            return;
        }
        Phylogeny phylogeny = new Phylogeny();
        phylogeny.setRoot(new PhylogenyNode());
        phylogeny.setRooted(true);
        if (bl) {
            if (phylogenyNode.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot add sibling to root", "Attempt to add sibling to root", 0);
                return;
            }
            phylogeny.addAsSibling(phylogenyNode);
        } else {
            phylogeny.addAsChild(phylogenyNode);
        }
        this.setNodeInPreorderToNull();
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void addToCurrentExternalNodes(long l) {
        if (this._current_external_nodes == null) {
            this._current_external_nodes = new HashSet<Long>();
        }
        this._current_external_nodes.add(l);
    }

    private final void assignGraphicsForBranchWithColorForParentBranch(PhylogenyNode phylogenyNode, boolean bl, Graphics graphics, boolean bl2, boolean bl3) {
        ControlPanel.NodeClickAction nodeClickAction = this._control_panel.getActionWhenNodeClicked();
        if ((bl2 || bl3) && this.getOptions().isPrintBlackAndWhite()) {
            graphics.setColor(Color.BLACK);
        } else if (!(nodeClickAction != ControlPanel.NodeClickAction.COPY_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.CUT_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.PASTE_SUBTREE && nodeClickAction != ControlPanel.NodeClickAction.ADD_NEW_NODE || this.getCutOrCopiedTree() == null || this.getCopiedAndPastedNodes() == null || bl2 || bl3 || !this.getCopiedAndPastedNodes().contains(phylogenyNode.getId()))) {
            graphics.setColor(this.getTreeColorSet().getFoundColor0());
        } else if (this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
            graphics.setColor(PhylogenyMethods.getBranchColorValue(phylogenyNode));
        } else if (bl2) {
            graphics.setColor(this.getTreeColorSet().getBranchColorForPdf());
        } else {
            graphics.setColor(this.getTreeColorSet().getBranchColor());
        }
    }

    private final void blast(PhylogenyNode phylogenyNode) {
        if (!this.isCanBlast(phylogenyNode)) {
            JOptionPane.showMessageDialog(this, "Insufficient information present", "Cannot Blast", 1);
            return;
        }
        String string = Blast.obtainQueryForBlast(phylogenyNode);
        System.out.println("query for BLAST is: " + string);
        int n = 63;
        if (!ForesterUtil.isEmpty(string)) {
            if (phylogenyNode.getNodeData().isHasSequence()) {
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getType())) {
                    n = phylogenyNode.getNodeData().getSequence().getType().toLowerCase().equals("protein") ? 112 : 110;
                } else if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getMolecularSequence())) {
                    n = ForesterUtil.seqIsLikelyToBeAa(phylogenyNode.getNodeData().getSequence().getMolecularSequence()) ? 112 : 110;
                }
            }
            if (n == 63) {
                n = SequenceAccessionTools.isProteinDbQuery(string) ? 112 : 110;
            }
            try {
                Blast.openNcbiBlastWeb(string, n == 110, this);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private final int calcDynamicHidingFactor() {
        return (int)(0.5 + (double)this.getFontMetricsForLargeDefaultFont().getHeight() / (1.5 * (double)this.getYdistance()));
    }

    private final int calcLengthOfLongestText() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this._ext_node_with_longest_txt_info != null) {
            this.nodeDataAsSB(this._ext_node_with_longest_txt_info, stringBuilder);
            if (this._ext_node_with_longest_txt_info.getNodeData().isHasTaxonomy()) {
                this.nodeTaxonomyDataAsSB(this._ext_node_with_longest_txt_info.getNodeData().getTaxonomy(), stringBuilder);
            }
        }
        return this.getFontMetricsForLargeDefaultFont().stringWidth(stringBuilder.toString());
    }

    private final float calculateBranchLengthToParent(PhylogenyNode phylogenyNode, float f) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (phylogenyNode.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getXcorrectionFactor() * phylogenyNode.getDistanceToParent());
        }
        if (f == 0.0f || this.isNonLinedUpCladogram()) {
            return this.getXdistance();
        }
        return this.getXdistance() * f;
    }

    private final Color calculateColorForAnnotation(SortedSet<Annotation> sortedSet) {
        Color color = this.getTreeColorSet().getAnnotationColor();
        if (this.getControlPanel().isColorAccordingToAnnotation() && this.getControlPanel().getAnnotationColors() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Annotation annotation : sortedSet) {
                stringBuilder.append(!ForesterUtil.isEmpty(annotation.getRefValue()) ? annotation.getRefValue() : annotation.getDesc());
            }
            String string = stringBuilder.toString();
            if (!ForesterUtil.isEmpty(string)) {
                color = this.getControlPanel().getAnnotationColors().get(string);
                if (color == null) {
                    color = AptxUtil.calculateColorFromString(string, false);
                    this.getControlPanel().getAnnotationColors().put(string, color);
                }
                if (color == null) {
                    color = this.getTreeColorSet().getAnnotationColor();
                }
            }
        }
        return color;
    }

    private final float calculateOvBranchLengthToParent(PhylogenyNode phylogenyNode, int n) {
        if (this.getControlPanel().isDrawPhylogram()) {
            if (phylogenyNode.getDistanceToParent() < 0.0) {
                return 0.0f;
            }
            return (float)((double)this.getOvXcorrectionFactor() * phylogenyNode.getDistanceToParent());
        }
        if (n == 0 || this.isNonLinedUpCladogram()) {
            return this.getOvXDistance();
        }
        return this.getOvXDistance() * (float)n;
    }

    private final void cannotOpenBrowserWarningMessage(String string) {
        JOptionPane.showMessageDialog(this, "Cannot launch web browser for " + string + " data of this node", "Cannot launch web browser", 2);
    }

    private void changeNodeFont(PhylogenyNode phylogenyNode) {
        FontChooser fontChooser = new FontChooser();
        Font font = null;
        if (phylogenyNode.getNodeData().getNodeVisualData() != null && !phylogenyNode.getNodeData().getNodeVisualData().isEmpty()) {
            font = phylogenyNode.getNodeData().getNodeVisualData().getFont();
        }
        if (font != null) {
            fontChooser.setFont(font);
        } else {
            fontChooser.setFont(this.getMainPanel().getTreeFontSet().getLargeFont());
        }
        List<Object> list = new ArrayList();
        if (this.getFoundNodes0() != null || this.getFoundNodes1() != null) {
            list = this.getFoundNodesAsListOfPhylogenyNodes();
        }
        if (!list.contains(phylogenyNode)) {
            list.add(phylogenyNode);
        }
        int n = list.size();
        String string = "Change the font for ";
        string = n == 1 ? string + "one node" : string + n + " nodes";
        fontChooser.showDialog(this, string);
        if (fontChooser.getFont() != null && !ForesterUtil.isEmpty(fontChooser.getFont().getFamily().trim())) {
            for (PhylogenyNode phylogenyNode2 : list) {
                if (phylogenyNode2.getNodeData().getNodeVisualData() == null) {
                    phylogenyNode2.getNodeData().setNodeVisualData(new NodeVisualData());
                }
                NodeVisualData nodeVisualData = phylogenyNode2.getNodeData().getNodeVisualData();
                Font font2 = fontChooser.getFont();
                nodeVisualData.setFontName(font2.getFamily().trim());
                int n2 = font2.getSize();
                if (n2 < 0) {
                    n2 = 0;
                }
                if (n2 > 127) {
                    n2 = 127;
                }
                nodeVisualData.setFontSize(n2);
                nodeVisualData.setFontStyle(font2.getStyle());
            }
            if (this._control_panel.getUseVisualStylesCb() != null) {
                this.getControlPanel().getUseVisualStylesCb().setSelected(true);
            }
        }
        this.setEdited(true);
        this.repaint();
    }

    private final void colorizeNodes(Color color, PhylogenyNode phylogenyNode, List<PhylogenyNode> list) {
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        if (phylogenyNode != null) {
            TreePanel.colorizeNodesHelper(color, phylogenyNode);
        }
        if (list != null) {
            for (PhylogenyNode phylogenyNode2 : list) {
                TreePanel.colorizeNodesHelper(color, phylogenyNode2);
            }
        }
        this.repaint();
    }

    private final void colorizeSubtree(Color color, PhylogenyNode phylogenyNode, List<PhylogenyNode> list) {
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        if (phylogenyNode != null) {
            Iterator<PhylogenyNode> iterator = new PreorderTreeIterator(phylogenyNode);
            while (((PreorderTreeIterator)iterator).hasNext()) {
                ((PreorderTreeIterator)iterator).next().getBranchData().setBranchColor(new BranchColor(color));
            }
        }
        if (list != null) {
            for (PhylogenyNode phylogenyNode2 : list) {
                PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode2);
                while (preorderTreeIterator.hasNext()) {
                    preorderTreeIterator.next().getBranchData().setBranchColor(new BranchColor(color));
                }
            }
        }
        this.repaint();
    }

    private void colorNodeFont(PhylogenyNode phylogenyNode) {
        NodeColorizationActionListener nodeColorizationActionListener;
        Object object;
        this._color_chooser.setPreviewPanel(new JPanel());
        int n = 1;
        if (this.getFoundNodes0() != null || this.getFoundNodes1() != null) {
            object = this.getFoundNodesAsListOfPhylogenyNodes();
            nodeColorizationActionListener = new NodeColorizationActionListener(this._color_chooser, phylogenyNode, (List<PhylogenyNode>)object);
            n = object.size();
            if (!object.contains(phylogenyNode)) {
                ++n;
            }
        } else {
            nodeColorizationActionListener = new NodeColorizationActionListener(this._color_chooser, phylogenyNode);
        }
        object = "Change the (node and font) color for ";
        object = n == 1 ? (String)object + "one node" : (String)object + n + " nodes";
        JDialog jDialog = JColorChooser.createDialog(this, (String)object, true, this._color_chooser, nodeColorizationActionListener, null);
        this.setEdited(true);
        jDialog.setVisible(true);
    }

    private final void colorSubtree(PhylogenyNode phylogenyNode) {
        SubtreeColorizationActionListener subtreeColorizationActionListener;
        Object object;
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot colorize subtree in unrooted display type", "Attempt to colorize subtree in unrooted display", 2);
            return;
        }
        this._color_chooser.setPreviewPanel(new JPanel());
        boolean bl = this.getOptions().isColorAllFoundNodesWhenColoringSubtree();
        if (bl && (this.getFoundNodes0() != null || this.getFoundNodes1() != null)) {
            object = this.getFoundNodesAsListOfPhylogenyNodes();
            subtreeColorizationActionListener = new SubtreeColorizationActionListener(this._color_chooser, phylogenyNode, (List<PhylogenyNode>)object);
        } else {
            subtreeColorizationActionListener = new SubtreeColorizationActionListener(this._color_chooser, phylogenyNode);
        }
        object = JColorChooser.createDialog(this, "Subtree colorization", true, this._color_chooser, subtreeColorizationActionListener, null);
        this.setEdited(true);
        ((Dialog)object).setVisible(true);
    }

    private final void copySubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        this.setNodeInPreorderToNull();
        this.setCutOrCopiedTree(this._phylogeny.copy(phylogenyNode));
        List<PhylogenyNode> list = PhylogenyMethods.getAllDescendants(phylogenyNode);
        HashSet<Long> hashSet = new HashSet<Long>(list.size());
        for (PhylogenyNode phylogenyNode2 : list) {
            hashSet.add(phylogenyNode2.getId());
        }
        hashSet.add(phylogenyNode.getId());
        this.setCopiedAndPastedNodes(hashSet);
        this.repaint();
    }

    private final String createASimpleTextRepresentationOfANode(PhylogenyNode phylogenyNode) {
        String string = PhylogenyMethods.getSpecies(phylogenyNode);
        String string2 = phylogenyNode.getName();
        string2 = !ForesterUtil.isEmpty(string2) && !ForesterUtil.isEmpty(string) ? string2 + " " + string : (!ForesterUtil.isEmpty(string) ? string : "");
        if (!ForesterUtil.isEmpty(string2)) {
            string2 = " [" + string2 + "]";
        }
        return string2;
    }

    private final void cutSubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (phylogenyNode.isRoot()) {
            JOptionPane.showMessageDialog(this, "Cannot cut entire tree as subtree", "Attempt to cut entire tree", 0);
            return;
        }
        String string = this.createASimpleTextRepresentationOfANode(phylogenyNode);
        int n = JOptionPane.showConfirmDialog(null, "Cut subtree" + string + "?", "Confirm Cutting of Subtree", 0);
        if (n != 0) {
            return;
        }
        this.setNodeInPreorderToNull();
        this.setCopiedAndPastedNodes(null);
        this.setCutOrCopiedTree(this._phylogeny.copy(phylogenyNode));
        this._phylogeny.deleteSubtree(phylogenyNode, true);
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void cycleColors() {
        this.getMainPanel().getTreeColorSet().cycleColorScheme();
        for (TreePanel treePanel : this.getMainPanel().getTreePanels()) {
            treePanel.setBackground(this.getMainPanel().getTreeColorSet().getBackgroundColor());
        }
    }

    private final void decreaseOvSize() {
        if (this.getOvMaxWidth() > 20.0f && this.getOvMaxHeight() > 20.0f) {
            this.setOvMaxWidth(this.getOvMaxWidth() - 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() - 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    private final void deleteNodeOrSubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (phylogenyNode.isRoot() && phylogenyNode.getNumberOfDescendants() != 1) {
            JOptionPane.showMessageDialog(this, "Cannot delete entire tree", "Attempt to delete entire tree", 0);
            return;
        }
        String string = this.createASimpleTextRepresentationOfANode(phylogenyNode);
        Object[] objectArray = new Object[]{"Node only", "Entire subtree", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "Delete" + string + "?", "Delete Node/Subtree", -1, 3, null, objectArray, objectArray[2]);
        this.setNodeInPreorderToNull();
        boolean bl = true;
        if (n == 1) {
            bl = false;
        } else if (n != 0) {
            return;
        }
        if (bl) {
            PhylogenyMethods.removeNode(phylogenyNode, this._phylogeny);
        } else {
            this._phylogeny.deleteSubtree(phylogenyNode, true);
        }
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.repaint();
    }

    private final void displayNodePopupMenu(PhylogenyNode phylogenyNode, int n, int n2) {
        this.makePopupMenus(phylogenyNode);
        this._node_popup_menu.putClientProperty(NODE_POPMENU_NODE_CLIENT_PROPERTY, phylogenyNode);
        this._node_popup_menu.show(this, n, n2);
    }

    private final void drawArc(double d, double d2, double d3, double d4, double d5, double d6, Graphics2D graphics2D) {
        this._arc.setArc(d, d2, d3, d4, 57.29577951308232 * d5, 57.29577951308232 * d6, 0);
        graphics2D.draw(this._arc);
    }

    private final void drawLine(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        if (d == d3 && d2 == d4) {
            return;
        }
        this._line.setLine(d, d2, d3, d4);
        graphics2D.draw(this._line);
    }

    private final void drawOval(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        this._ellipse.setFrame(d, d2, d3, d4);
        graphics2D.draw(this._ellipse);
    }

    private final void drawOvalFilled(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        this._ellipse.setFrame(d, d2, d3, d4);
        graphics2D.fill(this._ellipse);
    }

    private final void drawOvalGradient(float f, float f2, float f3, float f4, Graphics2D graphics2D, Color color, Color color2, Color color3) {
        this._ellipse.setFrame(f, f2, f3, f4);
        graphics2D.setPaint(new GradientPaint(f, f2, color, f + f3, f2 + f4, color2, false));
        graphics2D.fill(this._ellipse);
        if (color3 != null) {
            graphics2D.setPaint(color3);
            graphics2D.draw(this._ellipse);
        }
    }

    private final void drawRect(float f, float f2, float f3, float f4, Graphics2D graphics2D) {
        this._rectangle.setFrame(f, f2, f3, f4);
        graphics2D.draw(this._rectangle);
    }

    private final void drawRectFilled(double d, double d2, double d3, double d4, Graphics2D graphics2D) {
        this._rectangle.setFrame(d, d2, d3, d4);
        graphics2D.fill(this._rectangle);
    }

    private final void drawRectGradient(float f, float f2, float f3, float f4, Graphics2D graphics2D, Color color, Color color2, Color color3) {
        this._rectangle.setFrame(f, f2, f3, f4);
        graphics2D.setPaint(new GradientPaint(f, f2, color, f + f3, f2 + f4, color2, false));
        graphics2D.fill(this._rectangle);
        if (color3 != null) {
            graphics2D.setPaint(color3);
            graphics2D.draw(this._rectangle);
        }
    }

    private double drawTaxonomyImage(double d, double d2, PhylogenyNode phylogenyNode, Graphics2D graphics2D) {
        ArrayList<Uri> arrayList = new ArrayList<Uri>();
        for (Taxonomy taxonomy : phylogenyNode.getNodeData().getTaxonomies()) {
            for (Uri uri : taxonomy.getUris()) {
                arrayList.add(uri);
            }
        }
        double d3 = 0.0;
        for (Uri uri : arrayList) {
            BufferedImage bufferedImage;
            if (uri == null) continue;
            String string = uri.getValue().toString().toLowerCase();
            if (!this.getImageMap().containsKey(string) || (bufferedImage = this.getImageMap().get(string)) == null || bufferedImage.getHeight() <= 5 || bufferedImage.getWidth() <= 5) continue;
            double d4 = 1.0;
            if (this.getOptions().isAllowMagnificationOfTaxonomyImages() || (double)bufferedImage.getHeight() > 1.8 * (double)this.getYdistance()) {
                d4 = 1.8 * (double)this.getYdistance() / (double)bufferedImage.getHeight();
            }
            double d5 = (double)bufferedImage.getHeight() * d4;
            double d6 = (double)bufferedImage.getWidth() * d4 + d3;
            double d7 = d2 - 0.5 * d5;
            int n = (int)(d + d6 + 0.5);
            int n2 = (int)(d7 + d5 + 0.5);
            if ((double)n - d > 7.0 && (double)n2 - d7 > 7.0) {
                graphics2D.drawImage(bufferedImage, (int)(d + 0.5 + d3), (int)(d7 + 0.5), n, n2, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
                d6 += 8.0;
            } else {
                d6 = 0.0;
            }
            d3 = d6;
        }
        return d3;
    }

    private final void errorMessageNoCutCopyPasteInUnrootedDisplay() {
        JOptionPane.showMessageDialog(this, "Cannot cut, copy, paste, add, or delete subtrees/nodes in unrooted display", "Attempt to cut/copy/paste/add/delete in unrooted display", 0);
    }

    private final Color getColorForFoundNode(PhylogenyNode phylogenyNode) {
        if (this.isInCurrentExternalNodes(phylogenyNode)) {
            return this.getTreeColorSet().getFoundColor0();
        }
        if (this.isInFoundNodes0(phylogenyNode) && !this.isInFoundNodes1(phylogenyNode)) {
            return this.getTreeColorSet().getFoundColor0();
        }
        if (!this.isInFoundNodes0(phylogenyNode) && this.isInFoundNodes1(phylogenyNode)) {
            return this.getTreeColorSet().getFoundColor1();
        }
        return this.getTreeColorSet().getFoundColor0and1();
    }

    private final Set<Long> getCopiedAndPastedNodes() {
        return this.getMainPanel().getCopiedAndPastedNodes();
    }

    private final Set<Long> getCurrentExternalNodes() {
        return this._current_external_nodes;
    }

    private final Phylogeny getCutOrCopiedTree() {
        return this.getMainPanel().getCutOrCopiedTree();
    }

    private FontMetrics getFontMetricsForLargeDefaultFont() {
        return this.getTreeFontSet().getFontMetricsLarge();
    }

    private final float getLastDragPointX() {
        return this._last_drag_point_x;
    }

    private final float getLastDragPointY() {
        return this._last_drag_point_y;
    }

    private final double getMaxDistanceToRoot() {
        if (this._max_distance_to_root < 0.0) {
            this.recalculateMaxDistanceToRoot();
        }
        return this._max_distance_to_root;
    }

    private final float getOvMaxHeight() {
        return this._ov_max_height;
    }

    private final float getOvMaxWidth() {
        return this._ov_max_width;
    }

    private final float getOvXcorrectionFactor() {
        return this._ov_x_correction_factor;
    }

    private final float getOvXDistance() {
        return this._ov_x_distance;
    }

    private final int getOvXPosition() {
        return this._ov_x_position;
    }

    private final float getOvYDistance() {
        return this._ov_y_distance;
    }

    private final int getOvYPosition() {
        return this._ov_y_position;
    }

    private final int getOvYStart() {
        return this._ov_y_start;
    }

    private final List<Accession> getPdbAccs(PhylogenyNode phylogenyNode) {
        Sequence sequence;
        ArrayList<Accession> arrayList = new ArrayList<Accession>();
        if (phylogenyNode.getNodeData().isHasSequence() && !ForesterUtil.isEmpty((sequence = phylogenyNode.getNodeData().getSequence()).getCrossReferences())) {
            SortedSet<Accession> sortedSet = sequence.getCrossReferences();
            for (Accession accession : sortedSet) {
                if (!accession.getSource().equalsIgnoreCase("pdb")) continue;
                arrayList.add(accession);
            }
        }
        return arrayList;
    }

    private final double getScaleDistance() {
        return this._scale_distance;
    }

    private final String getScaleLabel() {
        return this._scale_label;
    }

    private final TreeFontSet getTreeFontSet() {
        return this.getMainPanel().getTreeFontSet();
    }

    private final float getUrtFactor() {
        return this._urt_factor;
    }

    private final float getUrtFactorOv() {
        return this._urt_factor_ov;
    }

    private final void handleClickToAction(ControlPanel.NodeClickAction nodeClickAction, PhylogenyNode phylogenyNode) {
        switch (nodeClickAction) {
            case SHOW_DATA: {
                this.showNodeFrame(phylogenyNode);
                break;
            }
            case COLLAPSE: {
                this.collapse(phylogenyNode);
                break;
            }
            case REROOT: {
                this.reRoot(phylogenyNode);
                break;
            }
            case SUBTREE: {
                this.subTree(phylogenyNode);
                break;
            }
            case SWAP: {
                this.swap(phylogenyNode);
                break;
            }
            case COLOR_SUBTREE: {
                this.colorSubtree(phylogenyNode);
                break;
            }
            case COLOR_NODE_FONT: {
                this.colorNodeFont(phylogenyNode);
                break;
            }
            case CHANGE_NODE_FONT: {
                this.changeNodeFont(phylogenyNode);
                break;
            }
            case OPEN_SEQ_WEB: {
                this.openSeqWeb(phylogenyNode);
                break;
            }
            case BLAST: {
                this.blast(phylogenyNode);
                break;
            }
            case OPEN_TAX_WEB: {
                this.openTaxWeb(phylogenyNode);
                break;
            }
            case OPEN_PDB_WEB: {
                this.openPdbWeb(phylogenyNode);
                break;
            }
            case CUT_SUBTREE: {
                this.cutSubtree(phylogenyNode);
                break;
            }
            case COPY_SUBTREE: {
                this.copySubtree(phylogenyNode);
                break;
            }
            case PASTE_SUBTREE: {
                this.pasteSubtree(phylogenyNode);
                break;
            }
            case DELETE_NODE_OR_SUBTREE: {
                this.deleteNodeOrSubtree(phylogenyNode);
                break;
            }
            case ADD_NEW_NODE: {
                this.addEmptyNode(phylogenyNode);
                break;
            }
            case EDIT_NODE_DATA: {
                this.showNodeEditFrame(phylogenyNode);
                break;
            }
            case SELECT_NODES: {
                this.selectNode(phylogenyNode);
                break;
            }
            case SORT_DESCENDENTS: {
                this.sortDescendants(phylogenyNode);
                break;
            }
            case GET_EXT_DESC_DATA: {
                this.showExtDescNodeData(phylogenyNode, '_');
                break;
            }
            case UNCOLLAPSE_ALL: {
                this.uncollapseAll(phylogenyNode);
                break;
            }
            case ORDER_SUBTREE: {
                this.orderSubtree(phylogenyNode);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown action: " + (Object)((Object)nodeClickAction));
            }
        }
    }

    private final void increaseCurrentExternalNodesDataBufferChangeCounter() {
        ++this._current_external_nodes_data_buffer_change_counter;
    }

    private final void increaseOvSize() {
        if ((double)this.getOvMaxWidth() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getWidth() / 2.0 && (double)this.getOvMaxHeight() < this.getMainPanel().getCurrentScrollPane().getViewport().getVisibleRect().getHeight() / 2.0) {
            this.setOvMaxWidth(this.getOvMaxWidth() + 5.0f);
            this.setOvMaxHeight(this.getOvMaxHeight() + 5.0f);
            this.updateOvSettings();
            this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
        }
    }

    private final void init() {
        this._color_chooser = new JColorChooser();
        this._rollover_popup = new JTextArea();
        this._rollover_popup.setFont(POPUP_FONT);
        this.resetNodeIdToDistToLeafMap();
        this.setTextAntialias();
        this.setTreeFile(null);
        this.setEdited(false);
        this.initializeOvSettings();
        this.resetDepthCollapseDepthValue();
        this.resetRankCollapseRankValue();
        this.setStartingAngle(4.71238898038469);
        ImageLoader imageLoader = new ImageLoader(this);
        new Thread(imageLoader).start();
    }

    private final void initializeOvSettings() {
        this.setOvMaxHeight(this.getConfiguration().getOvMaxHeight());
        this.setOvMaxWidth(this.getConfiguration().getOvMaxWidth());
    }

    private final boolean inOvVirtualRectangle(int n, int n2) {
        return n >= this.getOvVirtualRectangle().x - 1 && n <= this.getOvVirtualRectangle().x + this.getOvVirtualRectangle().width + 1 && n2 >= this.getOvVirtualRectangle().y - 1 && n2 <= this.getOvVirtualRectangle().y + this.getOvVirtualRectangle().height + 1;
    }

    private final boolean inOvVirtualRectangle(MouseEvent mouseEvent) {
        return this.inOvVirtualRectangle(mouseEvent.getX(), mouseEvent.getY());
    }

    private final boolean isCanBlast(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.getNodeData().isHasSequence() && ForesterUtil.isEmpty(phylogenyNode.getName())) {
            return false;
        }
        return Blast.isContainsQueryForBlast(phylogenyNode);
    }

    private final String isCanOpenSeqWeb(PhylogenyNode phylogenyNode) {
        Accession accession = SequenceAccessionTools.obtainAccessorFromDataFields(phylogenyNode);
        if (accession != null) {
            return accession.getValue();
        }
        return null;
    }

    private final boolean isCanOpenTaxWeb(PhylogenyNode phylogenyNode) {
        return phylogenyNode.getNodeData().isHasTaxonomy() && (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getScientificName()) || !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getTaxonomyCode()) || !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getCommonName()) || phylogenyNode.getNodeData().getTaxonomy().getIdentifier() != null && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getTaxonomy().getIdentifier().getValue()));
    }

    private final boolean isInCurrentExternalNodes(PhylogenyNode phylogenyNode) {
        return this.getCurrentExternalNodes() != null && this.getCurrentExternalNodes().contains(phylogenyNode.getId());
    }

    private boolean isInFoundNodes(PhylogenyNode phylogenyNode) {
        return this.isInFoundNodes0(phylogenyNode) || this.isInFoundNodes1(phylogenyNode);
    }

    private final boolean isInFoundNodes0(PhylogenyNode phylogenyNode) {
        return this.getFoundNodes0() != null && this.getFoundNodes0().contains(phylogenyNode.getId());
    }

    private final boolean isInFoundNodes1(PhylogenyNode phylogenyNode) {
        return this.getFoundNodes1() != null && this.getFoundNodes1().contains(phylogenyNode.getId());
    }

    private final boolean isInOv() {
        return this._in_ov;
    }

    private final boolean isNodeDataInvisible(PhylogenyNode phylogenyNode) {
        int n = 40;
        if (this.getControlPanel().isShowTaxonomyImages()) {
            n = 40 + (int)this.getYdistance();
        }
        return (double)phylogenyNode.getYcoord() < this.getVisibleRect().getMinY() - (double)n || (double)phylogenyNode.getYcoord() > this.getVisibleRect().getMaxY() + (double)n || phylogenyNode.getParent() != null && (double)phylogenyNode.getParent().getXcoord() > this.getVisibleRect().getMaxX();
    }

    private final boolean isNodeDataInvisibleUnrootedCirc(PhylogenyNode phylogenyNode) {
        return (double)phylogenyNode.getYcoord() < this.getVisibleRect().getMinY() - 20.0 || (double)phylogenyNode.getYcoord() > this.getVisibleRect().getMaxY() + 20.0 || (double)phylogenyNode.getXcoord() < this.getVisibleRect().getMinX() - 20.0 || (double)phylogenyNode.getXcoord() > this.getVisibleRect().getMaxX() + 20.0;
    }

    private final boolean isNonLinedUpCladogram() {
        return this.getOptions().getCladogramType() == Options.CLADOGRAM_TYPE.NON_LINED_UP;
    }

    private final void keyPressedCalls(KeyEvent keyEvent) {
        if (this.isOvOn() && this.getMousePosition() != null && this.getMousePosition().getLocation() != null) {
            if (this.inOvVirtualRectangle(this.getMousePosition().x, this.getMousePosition().y)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
            }
        }
        if (keyEvent.isAltDown()) {
            if (keyEvent.getKeyCode() == 127 || keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 8) {
                this.getControlPanel().showWhole();
            } else if (keyEvent.isShiftDown() && (keyEvent.getKeyCode() == 109 || keyEvent.getKeyCode() == 45)) {
                this.getMainPanel().getTreeFontSet().decreaseFontSize(1, false);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (keyEvent.isShiftDown() && TreePanel.plusPressed(keyEvent.getKeyCode())) {
                this.getMainPanel().getTreeFontSet().increaseFontSize();
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
            } else if (keyEvent.getKeyCode() == 79) {
                this.getControlPanel().orderPressed(this);
            } else if (keyEvent.getKeyCode() == 82) {
                this.getControlPanel().returnedToSuperTreePressed();
            } else if (keyEvent.getKeyCode() == 85) {
                this.getControlPanel().uncollapseAll(this);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (keyEvent.getKeyCode() == 38) {
                this.getMainPanel().getControlPanel().zoomInY(1.08f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (keyEvent.getKeyCode() == 40) {
                this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (keyEvent.getKeyCode() == 37) {
                this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (keyEvent.getKeyCode() == 39) {
                this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (keyEvent.getKeyCode() == 109 || keyEvent.getKeyCode() == 45) {
                this.getMainPanel().getControlPanel().zoomOutY(0.9259259f);
                this.getMainPanel().getControlPanel().zoomOutX(0.9259259f, 0.92165893f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            } else if (TreePanel.plusPressed(keyEvent.getKeyCode())) {
                this.getMainPanel().getControlPanel().zoomInX(1.08f, 1.08f);
                this.getMainPanel().getControlPanel().zoomInY(1.08f);
                this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        } else if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40 || keyEvent.getKeyCode() == 37 || keyEvent.getKeyCode() == 39) {
            int n;
            int n2 = 0;
            int n3 = -80;
            if (keyEvent.getKeyCode() == 40) {
                n3 = 80;
            } else if (keyEvent.getKeyCode() == 37) {
                n2 = -80;
                n3 = 0;
            } else if (keyEvent.getKeyCode() == 39) {
                n2 = 80;
                n3 = 0;
            }
            Point point = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
            point.x += n2;
            point.y += n3;
            if (point.x <= 0) {
                point.x = 0;
            } else {
                n = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
                if (point.x >= n) {
                    point.x = n;
                }
            }
            if (point.y <= 0) {
                point.y = 0;
            } else {
                n = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
                if (point.y >= n) {
                    point.y = n;
                }
            }
            this.repaint();
            this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(point);
        } else if (keyEvent.getKeyCode() == 83) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) + 0.09817477315664291);
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        } else if (keyEvent.getKeyCode() == 65) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                this.setStartingAngle(this.getStartingAngle() % (Math.PI * 2) - 0.09817477315664291);
                if (this.getStartingAngle() < 0.0) {
                    this.setStartingAngle(Math.PI * 2 + this.getStartingAngle());
                }
                this.getControlPanel().displayedPhylogenyMightHaveChanged(false);
            }
        } else if (keyEvent.getKeyCode() == 68) {
            boolean bl = false;
            if (this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.HORIZONTAL) {
                this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.RADIAL);
                bl = true;
            } else {
                this.getOptions().setNodeLabelDirection(Options.NODE_LABEL_DIRECTION.HORIZONTAL);
            }
            this.getMainPanel().getMainFrame().getlabelDirectionCbmi().setSelected(bl);
            this.repaint();
        } else if (keyEvent.getKeyCode() == 88) {
            this.switchDisplaygetPhylogenyGraphicsType();
            this.repaint();
        } else if (keyEvent.getKeyCode() == 67) {
            this.cycleColors();
            this.repaint();
        } else if (this.getOptions().isShowOverview() && this.isOvOn() && keyEvent.getKeyCode() == 79) {
            MainFrame.cycleOverview(this.getOptions(), this);
            this.repaint();
        } else if (this.getOptions().isShowOverview() && this.isOvOn() && keyEvent.getKeyCode() == 73) {
            this.increaseOvSize();
        } else if (this.getOptions().isShowOverview() && this.isOvOn() && keyEvent.getKeyCode() == 85) {
            this.decreaseOvSize();
        }
        if (keyEvent.getKeyCode() == 36 || keyEvent.getKeyCode() == 27) {
            this.getControlPanel().showWhole();
        } else if (keyEvent.getKeyCode() == 33) {
            this.getMainPanel().getTreeFontSet().increaseFontSize();
            this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
        } else if (keyEvent.getKeyCode() == 34) {
            this.getMainPanel().getTreeFontSet().decreaseFontSize(1, false);
            this.getMainPanel().getControlPanel().displayedPhylogenyMightHaveChanged(true);
        }
        keyEvent.consume();
    }

    private final void makePopupMenus(PhylogenyNode phylogenyNode) {
        this._node_popup_menu = new JPopupMenu();
        List<String> list = this._main_panel.getControlPanel().getSingleClickToNames();
        this._node_popup_menu_items = new JMenuItem[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            String string = list.get(i);
            this._node_popup_menu_items[i] = new JMenuItem(string);
            if (string.equals(Configuration.clickto_options[8][0])) {
                object = this.isCanOpenSeqWeb(phylogenyNode);
                if (!ForesterUtil.isEmpty((String)object)) {
                    this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + (String)object + "]");
                    this._node_popup_menu_items[i].setEnabled(true);
                } else {
                    this._node_popup_menu_items[i].setEnabled(false);
                }
            } else if (string.equals(Configuration.clickto_options[9][0])) {
                object = this.getPdbAccs(phylogenyNode);
                this._node_popup_menu_items[i] = new JMenuItem(string);
                if (!ForesterUtil.isEmpty(object)) {
                    if (object.size() == 1) {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString((List<Accession>)object, 0) + "]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    } else if (object.size() == 2) {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString((List<Accession>)object, 0) + ", " + TreePanelUtil.pdbAccToString((List<Accession>)object, 1) + "]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    } else if (object.size() == 3) {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString((List<Accession>)object, 0) + ", " + TreePanelUtil.pdbAccToString((List<Accession>)object, 1) + ", " + TreePanelUtil.pdbAccToString((List<Accession>)object, 2) + "]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    } else {
                        this._node_popup_menu_items[i].setText(this._node_popup_menu_items[i].getText() + " [" + TreePanelUtil.pdbAccToString((List<Accession>)object, 0) + ", " + TreePanelUtil.pdbAccToString((List<Accession>)object, 1) + ", " + TreePanelUtil.pdbAccToString((List<Accession>)object, 2) + ", + " + (object.size() - 3) + " more]");
                        this._node_popup_menu_items[i].setEnabled(true);
                    }
                } else {
                    this._node_popup_menu_items[i].setEnabled(false);
                }
            } else if (string.startsWith(Configuration.clickto_options[19][0])) {
                this._node_popup_menu_items[i].setText(Configuration.clickto_options[19][0] + ": " + this.getOptions().getExtDescNodeDataToReturn().toString());
            } else if (string.equals(Configuration.clickto_options[10][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanOpenTaxWeb(phylogenyNode));
            } else if (string.equals(Configuration.clickto_options[11][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanBlast(phylogenyNode));
            } else if (string.equals(Configuration.clickto_options[15][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanDelete());
            } else if (string.equals(Configuration.clickto_options[12][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanCut(phylogenyNode));
            } else if (string.equals(Configuration.clickto_options[13][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanCopy());
            } else if (string.equals(Configuration.clickto_options[14][0])) {
                if (!this.getOptions().isEditable()) continue;
                this._node_popup_menu_items[i].setEnabled(this.isCanPaste());
            } else if (string.equals(Configuration.clickto_options[17][0])) {
                if (!this.getOptions().isEditable()) {
                    continue;
                }
            } else if (string.equals(Configuration.clickto_options[16][0])) {
                if (!this.getOptions().isEditable()) {
                    continue;
                }
            } else if (string.equals(Configuration.clickto_options[2][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanReroot());
            } else if (string.equals(Configuration.clickto_options[1][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanCollapse() && !phylogenyNode.isExternal());
            } else if (string.equals(Configuration.clickto_options[7][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanColorSubtree());
            } else if (string.equals(Configuration.clickto_options[3][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanSubtree(phylogenyNode));
            } else if (string.equals(Configuration.clickto_options[4][0])) {
                this._node_popup_menu_items[i].setEnabled(phylogenyNode.getNumberOfDescendants() == 2);
            } else if (string.equals(Configuration.clickto_options[18][0])) {
                this._node_popup_menu_items[i].setEnabled(phylogenyNode.getNumberOfDescendants() > 1);
            } else if (string.equals(Configuration.clickto_options[21][0])) {
                this._node_popup_menu_items[i].setEnabled(this.isCanUncollapseAll(phylogenyNode));
            }
            this._node_popup_menu_items[i].addActionListener(this);
            this._node_popup_menu.add(this._node_popup_menu_items[i]);
        }
    }

    private final void nodeDataAsSB(PhylogenyNode phylogenyNode, StringBuilder stringBuilder) {
        if (phylogenyNode != null) {
            if (this.getControlPanel().isShowNodeNames() && !ForesterUtil.isEmpty(phylogenyNode.getName())) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(phylogenyNode.getName());
            }
            if (phylogenyNode.getNodeData().isHasSequence()) {
                if (this.getControlPanel().isShowSeqSymbols() && phylogenyNode.getNodeData().getSequence().getSymbol().length() > 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(phylogenyNode.getNodeData().getSequence().getSymbol());
                }
                if (this.getControlPanel().isShowGeneNames() && phylogenyNode.getNodeData().getSequence().getGeneName().length() > 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(phylogenyNode.getNodeData().getSequence().getGeneName());
                }
                if (this.getControlPanel().isShowSeqNames() && phylogenyNode.getNodeData().getSequence().getName().length() > 0) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    stringBuilder.append(phylogenyNode.getNodeData().getSequence().getName());
                }
                if (this.getControlPanel().isShowSequenceAcc() && phylogenyNode.getNodeData().getSequence().getAccession() != null) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(" ");
                    }
                    if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource())) {
                        stringBuilder.append(phylogenyNode.getNodeData().getSequence().getAccession().getSource());
                        stringBuilder.append(":");
                    }
                    stringBuilder.append(phylogenyNode.getNodeData().getSequence().getAccession().getValue());
                }
            }
            if (this.getControlPanel().isShowProperties() && phylogenyNode.getNodeData().isHasProperties()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                stringBuilder.append(this.propertiesToString(phylogenyNode));
            }
        }
    }

    private final void nodeTaxonomyDataAsSB(Taxonomy taxonomy, StringBuilder stringBuilder) {
        if (this._control_panel.isShowTaxonomyRank() && !ForesterUtil.isEmpty(taxonomy.getRank())) {
            stringBuilder.append("[");
            stringBuilder.append(taxonomy.getRank());
            stringBuilder.append("] ");
        }
        if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            stringBuilder.append(taxonomy.getTaxonomyCode());
            stringBuilder.append(" ");
        }
        if (this._control_panel.isShowTaxonomyScientificNames() && this._control_panel.isShowTaxonomyCommonNames()) {
            if (!ForesterUtil.isEmpty(taxonomy.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName(), stringBuilder);
                } else {
                    stringBuilder.append(taxonomy.getScientificName());
                }
                stringBuilder.append(" (");
                stringBuilder.append(taxonomy.getCommonName());
                stringBuilder.append(") ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName(), stringBuilder);
                } else {
                    stringBuilder.append(taxonomy.getScientificName());
                }
                stringBuilder.append(" ");
            } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                stringBuilder.append(taxonomy.getCommonName());
                stringBuilder.append(" ");
            }
        } else if (this._control_panel.isShowTaxonomyScientificNames()) {
            if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                if (this.getOptions().isAbbreviateScientificTaxonNames() && taxonomy.getScientificName().indexOf(32) > 0) {
                    this.abbreviateScientificName(taxonomy.getScientificName(), stringBuilder);
                } else {
                    stringBuilder.append(taxonomy.getScientificName());
                }
                stringBuilder.append(" ");
            }
        } else if (this._control_panel.isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            stringBuilder.append(taxonomy.getCommonName());
            stringBuilder.append(" ");
        }
    }

    private final String obtainTitleForExtDescNodeData() {
        return this.getOptions().getExtDescNodeDataToReturn().toString();
    }

    private final void openPdbWeb(PhylogenyNode phylogenyNode) {
        List<Accession> list = this.getPdbAccs(phylogenyNode);
        if (ForesterUtil.isEmpty(list)) {
            this.cannotOpenBrowserWarningMessage("PDB");
            return;
        }
        List<String> list2 = TreePanelUtil.createUrisForPdbWeb(phylogenyNode, list, this.getConfiguration(), this);
        if (!ForesterUtil.isEmpty(list2)) {
            for (String string : list2) {
                try {
                    AptxUtil.launchWebBrowser(new URI(string), "_aptx_seq");
                }
                catch (IOException iOException) {
                    AptxUtil.showErrorMessage(this, iOException.toString());
                    iOException.printStackTrace();
                }
                catch (URISyntaxException uRISyntaxException) {
                    AptxUtil.showErrorMessage(this, uRISyntaxException.toString());
                    uRISyntaxException.printStackTrace();
                }
            }
        } else {
            this.cannotOpenBrowserWarningMessage("PDB");
        }
    }

    private final void openSeqWeb(PhylogenyNode phylogenyNode) {
        if (ForesterUtil.isEmpty(this.isCanOpenSeqWeb(phylogenyNode))) {
            this.cannotOpenBrowserWarningMessage("sequence");
            return;
        }
        String string = TreePanelUtil.createUriForSeqWeb(phylogenyNode, this.getConfiguration(), this);
        if (!ForesterUtil.isEmpty(string)) {
            try {
                AptxUtil.launchWebBrowser(new URI(string), "_aptx_seq");
            }
            catch (IOException iOException) {
                AptxUtil.showErrorMessage(this, iOException.toString());
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                AptxUtil.showErrorMessage(this, uRISyntaxException.toString());
                uRISyntaxException.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("sequence");
        }
    }

    private final void openTaxWeb(PhylogenyNode phylogenyNode) {
        if (!this.isCanOpenTaxWeb(phylogenyNode)) {
            this.cannotOpenBrowserWarningMessage("taxonomic");
            return;
        }
        String string = null;
        Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
        if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && taxonomy.getIdentifier().getValue().startsWith("http://")) {
            try {
                string = new URI(taxonomy.getIdentifier().getValue()).toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                AptxUtil.showErrorMessage(this, uRISyntaxException.toString());
                string = null;
                uRISyntaxException.printStackTrace();
            }
        } else if (taxonomy.getIdentifier() != null && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getValue()) && !ForesterUtil.isEmpty(taxonomy.getIdentifier().getProvider()) && (taxonomy.getIdentifier().getProvider().equalsIgnoreCase("ncbi") || taxonomy.getIdentifier().getProvider().equalsIgnoreCase("uniprot"))) {
            try {
                string = "http://www.uniprot.org/taxonomy/" + URLEncoder.encode(taxonomy.getIdentifier().getValue(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            try {
                string = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(taxonomy.getScientificName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            try {
                string = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(taxonomy.getTaxonomyCode(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
            try {
                string = "http://www.uniprot.org/taxonomy/?query=" + URLEncoder.encode(taxonomy.getCommonName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                AptxUtil.showErrorMessage(this, unsupportedEncodingException.toString());
                unsupportedEncodingException.printStackTrace();
            }
        }
        if (!ForesterUtil.isEmpty(string)) {
            try {
                AptxUtil.launchWebBrowser(new URI(string), "_aptx_tax");
            }
            catch (IOException iOException) {
                AptxUtil.showErrorMessage(this, iOException.toString());
                iOException.printStackTrace();
            }
            catch (URISyntaxException uRISyntaxException) {
                AptxUtil.showErrorMessage(this, uRISyntaxException.toString());
                uRISyntaxException.printStackTrace();
            }
        } else {
            this.cannotOpenBrowserWarningMessage("taxonomic");
        }
    }

    private final void paintBranchLength(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        graphics2D.setFont(this.getTreeFontSet().getSmallFont());
        if (bl || bl2 && this.getOptions().isPrintBlackAndWhite()) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        if (!phylogenyNode.isRoot()) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), phylogenyNode.getParent().getXcoord() + 10.0f, phylogenyNode.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), graphics2D);
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), phylogenyNode.getParent().getXcoord() + 8.0f, phylogenyNode.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), graphics2D);
            } else {
                TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), phylogenyNode.getParent().getXcoord() + 3.0f, phylogenyNode.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), graphics2D);
            }
        } else {
            TreePanel.drawString(FORMATTER_BRANCH_LENGTH.format(phylogenyNode.getDistanceToParent()), 3.0f, phylogenyNode.getYcoord() - (float)this.getTreeFontSet().getSmallMaxDescent(), graphics2D);
        }
    }

    private final void paintBranchLite(Graphics2D graphics2D, float f, float f2, float f3, float f4, PhylogenyNode phylogenyNode) {
        graphics2D.setColor(this.getTreeColorSet().getOvColor());
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(f, f3, f2, f4, graphics2D);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(f, f3, f, f4, f2, f4);
            graphics2D.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float f5 = f2 - f;
            float f6 = f4 - f3;
            this._cubic_curve.setCurve(f, f3, f + f5 * 0.4f, f3 + f6 * 0.2f, f + f5 * 0.6f, f3 + f6 * 0.8f, f2, f4);
            graphics2D.draw(this._cubic_curve);
        } else {
            float f7 = f2;
            float f8 = f;
            if (phylogenyNode.isFirstChildNode() || phylogenyNode.isLastChildNode()) {
                this.drawLine(f, f3, f, f4, graphics2D);
            }
            this.drawLine(f8, f4, f7, f4, graphics2D);
        }
    }

    private final void paintBranchRectangular(Graphics2D graphics2D, float f, float f2, float f3, float f4, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode, false, graphics2D, bl, bl2);
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR) {
            this.drawLine(f, f3, f2, f4, graphics2D);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX) {
            this._quad_curve.setCurve(f, f3, f, f4, f2, f4);
            graphics2D.draw(this._quad_curve);
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CURVED) {
            float f5 = f2 - f;
            float f6 = f4 - f3;
            this._cubic_curve.setCurve(f, f3, f + f5 * 0.4f, f3 + f6 * 0.2f, f + f5 * 0.6f, f3 + f6 * 0.8f, f2, f4);
            graphics2D.draw(this._cubic_curve);
        } else {
            float f7;
            float f8 = f2;
            float f9 = f;
            float f10 = 0.0f;
            if (!(!phylogenyNode.isFirstChildNode() && !phylogenyNode.isLastChildNode() && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || !bl2 && !bl && ((double)f4 < this.getVisibleRect().getMinY() - 20.0 && (double)f3 < this.getVisibleRect().getMinY() - 20.0 || (double)f4 > this.getVisibleRect().getMaxY() + 20.0 && (double)f3 > this.getVisibleRect().getMaxY() + 20.0))) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    f7 = f + 10.0f;
                    if (f7 > f8) {
                        f7 = f8;
                    }
                    this.drawLine(f, f3, f7, f4, graphics2D);
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    if (f4 > f3) {
                        f10 = f4 - 8.0f;
                        if (f10 < f3) {
                            f10 = f3;
                        }
                        this.drawLine(f, f3, f, f10, graphics2D);
                    } else {
                        f10 = f4 + 8.0f;
                        if (f10 > f3) {
                            f10 = f3;
                        }
                        this.drawLine(f, f3, f, f10, graphics2D);
                    }
                } else {
                    this.drawLine(f, f3, f, f4, graphics2D);
                }
            }
            if (!bl2 && !bl && ((double)f4 < this.getVisibleRect().getMinY() - 20.0 || (double)f4 > this.getVisibleRect().getMaxY() + 20.0)) {
                return;
            }
            f7 = 0.0f;
            if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(phylogenyNode) == 1.0) {
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    f7 = f9 + 8.0f;
                    if (f7 < f8) {
                        this.drawLine(f7, f4, f8, f4, graphics2D);
                    }
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    float f11 = f9 + 10.0f;
                    if (f11 < f8) {
                        this.drawLine(f11, f4, f8, f4, graphics2D);
                    }
                } else {
                    this.drawLine(f9, f4, f8, f4, graphics2D);
                }
            } else {
                double d = PhylogenyMethods.getBranchWidthValue(phylogenyNode);
                if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                    f7 = f9 + 8.0f;
                    if (f7 < f8) {
                        this.drawRectFilled(f7, (double)f4 - d / 2.0, f8 - f7, d, graphics2D);
                    }
                } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                    float f12 = f9 + 10.0f;
                    if (f12 < f8) {
                        this.drawRectFilled(f12, (double)f4 - d / 2.0, f8 - f12, d, graphics2D);
                    }
                } else {
                    this.drawRectFilled(f9, (double)f4 - d / 2.0, f8 - f9, d, graphics2D);
                }
            }
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                if (f7 > f8) {
                    f7 = f8;
                }
                if (f4 > f10) {
                    double d = f4 - f10;
                    this._arc.setArc(f, (double)f10 - d, 2.0f * (f7 - f), 2.0 * d, 180.0, 90.0, 0);
                } else {
                    this._arc.setArc(f, f4, 2.0f * (f7 - f), 2.0f * (f10 - f4), 90.0, 90.0, 0);
                }
                graphics2D.draw(this._arc);
            }
        }
        if (phylogenyNode.isExternal()) {
            this.paintNodeBox(f2, f4, phylogenyNode, graphics2D, bl, bl2);
        }
    }

    private final double paintCirculars(PhylogenyNode phylogenyNode, Phylogeny phylogeny, float f, float f2, double d, boolean bl, Graphics2D graphics2D, boolean bl2, boolean bl3) {
        if (phylogenyNode.isExternal() || phylogenyNode.isCollapse()) {
            if (!this._urt_nodeid_angle_map.containsKey(phylogenyNode.getId())) {
                System.out.println("no " + phylogenyNode + " =====>>>>>>> ERROR!");
            }
            return this._urt_nodeid_angle_map.get(phylogenyNode.getId());
        }
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        double d2 = 0.0;
        for (PhylogenyNode phylogenyNode2 : list) {
            d2 += this.paintCirculars(phylogenyNode2, phylogeny, f, f2, d, bl, graphics2D, bl2, bl3);
        }
        double d3 = 0.0;
        if (!phylogenyNode.isRoot()) {
            d3 = 1.0 - ((double)this._circ_max_depth - (double)phylogenyNode.calculateDepth()) / (double)this._circ_max_depth;
        }
        double d4 = d2 / (double)list.size();
        phylogenyNode.setXcoord((float)((double)f + d3 * d * Math.cos(d4)));
        phylogenyNode.setYcoord((float)((double)f2 + d3 * d * Math.sin(d4)));
        this._urt_nodeid_angle_map.put(phylogenyNode.getId(), d4);
        for (PhylogenyNode phylogenyNode3 : list) {
            this.paintBranchCircular(phylogenyNode, phylogenyNode3, graphics2D, bl, bl2, bl3);
        }
        return d4;
    }

    private final void paintCircularsLite(PhylogenyNode phylogenyNode, Phylogeny phylogeny, int n, int n2, int n3, Graphics2D graphics2D) {
        if (phylogenyNode.isExternal()) {
            return;
        }
        List<PhylogenyNode> list = phylogenyNode.getDescendants();
        for (PhylogenyNode phylogenyNode2 : list) {
            this.paintCircularsLite(phylogenyNode2, phylogeny, n, n2, n3, graphics2D);
        }
        float f = 0.0f;
        if (!phylogenyNode.isRoot()) {
            f = 1.0f - ((float)this._circ_max_depth - (float)phylogenyNode.calculateDepth()) / (float)this._circ_max_depth;
        }
        double d = this._urt_nodeid_angle_map.get(phylogenyNode.getId());
        phylogenyNode.setXSecondary((float)((double)n + (double)((float)n3 * f) * Math.cos(d)));
        phylogenyNode.setYSecondary((float)((double)n2 + (double)((float)n3 * f) * Math.sin(d)));
        for (PhylogenyNode phylogenyNode3 : list) {
            this.paintBranchCircularLite(phylogenyNode, phylogenyNode3, graphics2D);
        }
    }

    private final void paintCollapsedNode(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3) {
        float f;
        Color color = null;
        int[] nArray = null;
        if (this._found_nodes_0 != null || this._found_nodes_1 != null) {
            nArray = this.calcFoundNodesInSubtree(phylogenyNode);
        }
        if ((bl2 || bl) && this.getOptions().isPrintBlackAndWhite()) {
            color = Color.BLACK;
        } else if (this.getOptions().isColorLabelsSameAsParentBranch() && this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
            color = PhylogenyMethods.getBranchColorValue(phylogenyNode);
        } else if (bl2) {
            graphics2D.setColor(this.getTreeColorSet().getBranchColorForPdf());
        } else {
            color = this.getTreeColorSet().getCollapseFillColor();
        }
        double d = phylogenyNode.getAllExternalDescendants().size();
        double d2 = 0.0;
        if (this.getControlPanel().isDrawPhylogram()) {
            float f2;
            if ((d = d > 1000.0 ? 0.75 * (double)this._y_distance : 0.25 * Math.log10(d) * (double)this._y_distance) < (double)(f2 = 0.5f * (float)this.getOptions().getDefaultNodeShapeSize())) {
                d = f2;
            }
            this._polygon.reset();
            float f3 = phylogenyNode.getXcoord() - (float)this.getOptions().getDefaultNodeShapeSize();
            f = f3 > phylogenyNode.getParent().getXcoord() + 1.0f ? f3 : phylogenyNode.getParent().getXcoord() + 1.0f;
            this._polygon.moveTo((double)f, (double)phylogenyNode.getYcoord() + 0.5);
            this._polygon.lineTo((double)f, (double)phylogenyNode.getYcoord() - 0.5);
            d2 = this._options.isCollapsedWithAverageHeigh() ? PhylogenyMethods.calculateAverageTreeHeight(phylogenyNode) * (double)this._x_correction_factor : 1.0;
            this._polygon.lineTo((double)phylogenyNode.getXcoord() + d2, (double)phylogenyNode.getYcoord() - d);
            this._polygon.lineTo((double)phylogenyNode.getXcoord() + d2, (double)phylogenyNode.getYcoord() + d);
            this._polygon.closePath();
        } else {
            float f4;
            int n;
            if ((d = d > 1000.0 ? (double)this._y_distance : Math.log10(d) * (double)this._y_distance / 2.5) < (double)(n = this.getOptions().getDefaultNodeShapeSize() + 1)) {
                d = n;
            }
            f = (f4 = phylogenyNode.getXcoord() - (float)(2 * n)) > phylogenyNode.getParent().getXcoord() + 1.0f ? f4 : phylogenyNode.getParent().getXcoord() + 1.0f;
            this._polygon.reset();
            this._polygon.moveTo(f, phylogenyNode.getYcoord());
            this._polygon.lineTo((double)(phylogenyNode.getXcoord() + 1.0f), (double)phylogenyNode.getYcoord() - d);
            this._polygon.lineTo((double)(phylogenyNode.getXcoord() + 1.0f), (double)phylogenyNode.getYcoord() + d);
            this._polygon.closePath();
        }
        if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.SOLID) {
            graphics2D.setColor(color);
            graphics2D.fill(this._polygon);
        } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.NONE) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fill(this._polygon);
            graphics2D.setColor(color);
            graphics2D.draw(this._polygon);
        } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.GRADIENT) {
            graphics2D.setPaint(new GradientPaint(f, phylogenyNode.getYcoord(), this.getBackground(), phylogenyNode.getXcoord(), (float)((double)phylogenyNode.getYcoord() - d), color, false));
            graphics2D.fill(this._polygon);
            graphics2D.setPaint(color);
            graphics2D.draw(this._polygon);
        }
        this.paintNodeData(graphics2D, phylogenyNode, bl, bl2, bl3, d2);
    }

    private final void paintConfidenceValues(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
        boolean bl3 = false;
        Collections.sort(list);
        StringBuilder stringBuilder = new StringBuilder();
        for (Confidence confidence : list) {
            double d;
            if (!ForesterUtil.isEmpty(SHOW_ONLY_THIS_CONF_TYPE) && (ForesterUtil.isEmpty(confidence.getType()) || !confidence.getType().equalsIgnoreCase(SHOW_ONLY_THIS_CONF_TYPE)) || (d = confidence.getValue()) == -2.147483647E9) continue;
            if (d < this.getOptions().getMinConfidenceValue()) {
                return;
            }
            if (bl3) {
                stringBuilder.append("/");
            } else {
                bl3 = true;
            }
            stringBuilder.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(d, this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
            if (!this.getOptions().isShowConfidenceStddev() || confidence.getStandardDeviation() == -2.147483647E9) continue;
            stringBuilder.append("(");
            stringBuilder.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getStandardDeviation(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
            stringBuilder.append(")");
        }
        if (stringBuilder.length() > 0) {
            float f = phylogenyNode.getParent().getXcoord();
            float f2 = phylogenyNode.getXcoord();
            graphics2D.setFont(this.getTreeFontSet().getSmallFont());
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) {
                f2 += 10.0f;
            } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) {
                f2 += 8.0f;
            }
            if (bl || bl2 && this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setColor(this.getTreeColorSet().getConfidenceColor());
            }
            String string = stringBuilder.toString();
            TreePanel.drawString(string, f + (f2 - f - (float)this.getTreeFontSet().getFontMetricsSmall().stringWidth(string)) / 2.0f, phylogenyNode.getYcoord() + (float)this.getTreeFontSet().getSmallMaxAscent() - 1.0f, graphics2D);
        }
    }

    private final void paintGainedAndLostCharacters(Graphics2D graphics2D, PhylogenyNode phylogenyNode, String string, String string2) {
        if (phylogenyNode.getParent() != null) {
            float f = phylogenyNode.getParent().getXcoord();
            float f2 = phylogenyNode.getXcoord();
            graphics2D.setFont(this.getTreeFontSet().getLargeFont());
            graphics2D.setColor(this.getTreeColorSet().getGainedCharactersColor());
            TreePanel.drawString(string, f + (f2 - f - (float)this.getFontMetricsForLargeDefaultFont().stringWidth(string)) / 2.0f, phylogenyNode.getYcoord() - (float)this.getFontMetricsForLargeDefaultFont().getMaxDescent(), graphics2D);
            graphics2D.setColor(this.getTreeColorSet().getLostCharactersColor());
            TreePanel.drawString(string2, f + (f2 - f - (float)this.getFontMetricsForLargeDefaultFont().stringWidth(string2)) / 2.0f, phylogenyNode.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getMaxAscent(), graphics2D);
        }
    }

    private void paintMolecularSequences(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl) {
        RenderableMsaSequence renderableMsaSequence = RenderableMsaSequence.createInstance(phylogenyNode.getNodeData().getSequence().getMolecularSequence(), phylogenyNode.getNodeData().getSequence().getType(), this.getConfiguration());
        if (renderableMsaSequence != null) {
            float f = this.getYdistance();
            int n = f / 2.0f < 8.0f ? ForesterUtil.roundToInt(f * 2.0f) : 8;
            renderableMsaSequence.setRenderingHeight(n > 1 ? (float)n : 1.0f);
            if (this.getControlPanel().isDrawPhylogram()) {
                renderableMsaSequence.render((float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)this._length_of_longest_text), phylogenyNode.getYcoord() - (float)n / 2.0f, graphics2D, this, bl);
            } else {
                renderableMsaSequence.render(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text, phylogenyNode.getYcoord() - (float)n / 2.0f, graphics2D, this, bl);
            }
        }
    }

    private final void paintNodeBox(float f, float f2, PhylogenyNode phylogenyNode, Graphics2D graphics2D, boolean bl, boolean bl2) {
        if (phylogenyNode.isCollapse()) {
            return;
        }
        if (this._highlight_node == phylogenyNode && !bl && !bl2) {
            graphics2D.setColor(this.getTreeColorSet().getFoundColor0());
            this.drawOval(f - 8.0f, f2 - 8.0f, 16.0, 16.0, graphics2D);
            this.drawOval(f - 9.0f, f2 - 8.0f, 17.0, 17.0, graphics2D);
            this.drawOval(f - 9.0f, f2 - 9.0f, 18.0, 18.0, graphics2D);
        }
        if (this.isInFoundNodes(phylogenyNode) || this.isInCurrentExternalNodes(phylogenyNode) || this.getOptions().isShowDefaultNodeShapesExternal() && phylogenyNode.isExternal() || this.getOptions().isShowDefaultNodeShapesInternal() && phylogenyNode.isInternal() || this.getOptions().isShowDefaultNodeShapesForMarkedNodes() && phylogenyNode.getNodeData().getNodeVisualData() != null && !phylogenyNode.getNodeData().getNodeVisualData().isEmpty() || this.getControlPanel().isUseVisualStyles() && phylogenyNode.getNodeData().getNodeVisualData() != null && (phylogenyNode.getNodeData().getNodeVisualData().getNodeColor() != null || phylogenyNode.getNodeData().getNodeVisualData().getSize() != -1.0f || phylogenyNode.getNodeData().getNodeVisualData().getFillType() != NodeVisualData.NodeFill.DEFAULT || phylogenyNode.getNodeData().getNodeVisualData().getShape() != NodeVisualData.NodeShape.DEFAULT) || this.getControlPanel().isEvents() && phylogenyNode.isHasAssignedEvent() && (phylogenyNode.getNodeData().getEvent().isDuplication() || phylogenyNode.getNodeData().getEvent().isSpeciation() || phylogenyNode.getNodeData().getEvent().isSpeciationOrDuplication())) {
            Object object;
            NodeVisualData nodeVisualData = null;
            if (this.getControlPanel().isUseVisualStyles() && phylogenyNode.getNodeData().getNodeVisualData() != null && !phylogenyNode.getNodeData().getNodeVisualData().isEmpty()) {
                nodeVisualData = phylogenyNode.getNodeData().getNodeVisualData();
            }
            float f3 = this.getOptions().getDefaultNodeShapeSize();
            if (nodeVisualData != null && nodeVisualData.getSize() != -1.0f) {
                f3 = nodeVisualData.getSize();
            }
            float f4 = f3 / 2.0f;
            Color color = null;
            if ((bl || bl2) && this.getOptions().isPrintBlackAndWhite()) {
                color = Color.BLACK;
            } else if (this.isInFoundNodes(phylogenyNode) || this.isInCurrentExternalNodes(phylogenyNode)) {
                color = this.getColorForFoundNode(phylogenyNode);
            } else if (nodeVisualData != null) {
                if (nodeVisualData.getNodeColor() != null) {
                    color = nodeVisualData.getNodeColor();
                } else if (nodeVisualData.getFontColor() != null) {
                    color = nodeVisualData.getFontColor();
                }
            } else if (this.getControlPanel().isEvents() && TreePanelUtil.isHasAssignedEvent(phylogenyNode)) {
                object = phylogenyNode.getNodeData().getEvent();
                if (((Event)object).isDuplication()) {
                    color = this.getTreeColorSet().getDuplicationBoxColor();
                } else if (((Event)object).isSpeciation()) {
                    color = this.getTreeColorSet().getSpecBoxColor();
                } else if (((Event)object).isSpeciationOrDuplication()) {
                    color = this.getTreeColorSet().getDuplicationOrSpeciationColor();
                }
            }
            if (color == null) {
                color = this.getGraphicsForNodeBoxWithColorForParentBranch(phylogenyNode);
                if (bl && color == this.getTreeColorSet().getBranchColor()) {
                    color = this.getTreeColorSet().getBranchColorForPdf();
                }
            }
            object = null;
            if (nodeVisualData != null) {
                if (nodeVisualData.getShape() == NodeVisualData.NodeShape.CIRCLE) {
                    object = NodeVisualData.NodeShape.CIRCLE;
                } else if (nodeVisualData.getShape() == NodeVisualData.NodeShape.RECTANGLE) {
                    object = NodeVisualData.NodeShape.RECTANGLE;
                }
            }
            if (object == null) {
                if (this.getOptions().getDefaultNodeShape() == NodeVisualData.NodeShape.CIRCLE) {
                    object = NodeVisualData.NodeShape.CIRCLE;
                } else if (this.getOptions().getDefaultNodeShape() == NodeVisualData.NodeShape.RECTANGLE) {
                    object = NodeVisualData.NodeShape.RECTANGLE;
                }
            }
            NodeVisualData.NodeFill nodeFill = null;
            if (nodeVisualData != null) {
                if (nodeVisualData.getFillType() == NodeVisualData.NodeFill.SOLID) {
                    nodeFill = NodeVisualData.NodeFill.SOLID;
                } else if (nodeVisualData.getFillType() == NodeVisualData.NodeFill.NONE) {
                    nodeFill = NodeVisualData.NodeFill.NONE;
                } else if (nodeVisualData.getFillType() == NodeVisualData.NodeFill.GRADIENT) {
                    nodeFill = NodeVisualData.NodeFill.GRADIENT;
                }
            }
            if (nodeFill == null) {
                if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.SOLID) {
                    nodeFill = NodeVisualData.NodeFill.SOLID;
                } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.NONE) {
                    nodeFill = NodeVisualData.NodeFill.NONE;
                } else if (this.getOptions().getDefaultNodeFill() == NodeVisualData.NodeFill.GRADIENT) {
                    nodeFill = NodeVisualData.NodeFill.GRADIENT;
                }
            }
            Color color2 = null;
            if (nodeVisualData != null && nodeVisualData.getNodeColor() != null) {
                color2 = nodeVisualData.getNodeColor();
            }
            if (object == NodeVisualData.NodeShape.CIRCLE) {
                if (nodeFill == NodeVisualData.NodeFill.GRADIENT) {
                    this.drawOvalGradient(f - f4, f2 - f4, f3, f3, graphics2D, bl ? Color.WHITE : color, bl ? color : this.getBackground(), color);
                } else if (nodeFill == NodeVisualData.NodeFill.NONE) {
                    Color color3 = this.getBackground();
                    if (bl) {
                        color3 = Color.WHITE;
                    }
                    this.drawOvalGradient(f - f4, f2 - f4, f3, f3, graphics2D, color3, color3, color);
                } else if (nodeFill == NodeVisualData.NodeFill.SOLID) {
                    if (color2 != null) {
                        graphics2D.setColor(color2);
                    } else {
                        graphics2D.setColor(color);
                    }
                    this.drawOvalFilled(f - f4, f2 - f4, f3, f3, graphics2D);
                }
            } else if (object == NodeVisualData.NodeShape.RECTANGLE) {
                if (nodeFill == NodeVisualData.NodeFill.GRADIENT) {
                    this.drawRectGradient(f - f4, f2 - f4, f3, f3, graphics2D, bl ? Color.WHITE : color, bl ? color : this.getBackground(), color);
                } else if (nodeFill == NodeVisualData.NodeFill.NONE) {
                    Color color4 = this.getBackground();
                    if (bl) {
                        color4 = Color.WHITE;
                    }
                    this.drawRectGradient(f - f4, f2 - f4, f3, f3, graphics2D, color4, color4, color);
                } else if (nodeFill == NodeVisualData.NodeFill.SOLID) {
                    if (color2 != null) {
                        graphics2D.setColor(color2);
                    } else {
                        graphics2D.setColor(color);
                    }
                    this.drawRectFilled(f - f4, f2 - f4, f3, f3, graphics2D);
                }
            }
        }
    }

    private final int paintNodeData(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3, double d) {
        if (this.isNodeDataInvisible(phylogenyNode) && !bl && !bl2) {
            return 0;
        }
        if (this.getControlPanel().isWriteBranchLengthValues() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && !phylogenyNode.isRoot() && phylogenyNode.getDistanceToParent() != -1024.0) {
            this.paintBranchLength(graphics2D, phylogenyNode, bl2, bl);
        }
        if (!(this.getControlPanel().isShowInternalData() || phylogenyNode.isExternal() || phylogenyNode.isCollapse())) {
            return 0;
        }
        if (!this.getControlPanel().isShowExternalData() && (phylogenyNode.isExternal() || phylogenyNode.isCollapse())) {
            return 0;
        }
        this._sb.setLength(0);
        int n = 0;
        if (d > 0.0) {
            n = (int)((double)n + d);
        }
        int n2 = this.getOptions().getDefaultNodeShapeSize() / 2;
        if (this.getControlPanel().isShowTaxonomyImages() && this.getImageMap() != null && !this.getImageMap().isEmpty() && phylogenyNode.getNodeData().isHasTaxonomy() && phylogenyNode.getNodeData().getTaxonomy().getUris() != null && !phylogenyNode.getNodeData().getTaxonomy().getUris().isEmpty()) {
            n = (int)((double)n + this.drawTaxonomyImage(phylogenyNode.getXcoord() + 2.0f + (float)n2, phylogenyNode.getYcoord(), phylogenyNode, graphics2D));
        }
        if ((this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCommonNames() || this.getControlPanel().isShowTaxonomyRank()) && phylogenyNode.getNodeData().isHasTaxonomy()) {
            n += this.paintTaxonomy(graphics2D, phylogenyNode, bl3, bl2, bl, n);
        }
        this.setColor(graphics2D, phylogenyNode, bl, bl2, bl3, this.getTreeColorSet().getSequenceColor());
        boolean bl4 = this._sb.length() > 0;
        this._sb.setLength(0);
        this.nodeDataAsSB(phylogenyNode, this._sb);
        if (phylogenyNode.isCollapse() && (!phylogenyNode.isRoot() && !phylogenyNode.getParent().isCollapse() || phylogenyNode.isRoot())) {
            Object object;
            if (this._sb.length() == 0 && !bl4) {
                if (this.getOptions().isShowAbbreviatedLabelsForCollapsedNodes() && (this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowSeqNames() || this.getControlPanel().isShowNodeNames())) {
                    object = PhylogenyMethods.getFirstExternalNode(phylogenyNode);
                    PhylogenyNode phylogenyNode2 = PhylogenyMethods.getLastExternalNode(phylogenyNode);
                    if (this.getControlPanel().isShowTaxonomyCode() && ((PhylogenyNode)object).getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)object).getNodeData().getTaxonomy().getTaxonomyCode()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                        this.addLabelForCollapsed(((PhylogenyNode)object).getNodeData().getTaxonomy().getTaxonomyCode(), phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode(), phylogenyNode.getAllExternalDescendants().size(), phylogenyNode);
                    } else if (this.getControlPanel().isShowTaxonomyScientificNames() && ((PhylogenyNode)object).getNodeData().isHasTaxonomy() && phylogenyNode2.getNodeData().isHasTaxonomy() && !ForesterUtil.isEmpty(((PhylogenyNode)object).getNodeData().getTaxonomy().getScientificName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                        this.addLabelForCollapsed(((PhylogenyNode)object).getNodeData().getTaxonomy().getScientificName(), phylogenyNode2.getNodeData().getTaxonomy().getScientificName(), phylogenyNode.getAllExternalDescendants().size(), phylogenyNode);
                    } else if (this.getControlPanel().isShowSeqNames() && ((PhylogenyNode)object).getNodeData().isHasSequence() && phylogenyNode2.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(((PhylogenyNode)object).getNodeData().getSequence().getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                        this.addLabelForCollapsed(((PhylogenyNode)object).getNodeData().getSequence().getName(), phylogenyNode2.getNodeData().getSequence().getName(), phylogenyNode.getAllExternalDescendants().size(), phylogenyNode);
                    } else if (this.getControlPanel().isShowNodeNames() && !ForesterUtil.isEmpty(((PhylogenyNode)object).getName()) && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                        this.addLabelForCollapsed(((PhylogenyNode)object).getName(), phylogenyNode2.getName(), phylogenyNode.getAllExternalDescendants().size(), phylogenyNode);
                    }
                }
            } else if (this._sb.length() > 0 || bl4) {
                this._sb.append(" [");
                this._sb.append(phylogenyNode.getAllExternalDescendants().size());
                this._sb.append("]");
                if ((this._found_nodes_0 != null || this._found_nodes_1 != null) && (object = (Object)this.calcFoundNodesInSubtree(phylogenyNode))[0] > 0) {
                    this._sb.append(" [");
                    this._sb.append((int)object[0]);
                    this._sb.append("/");
                    this._sb.append((int)object[1]);
                    this._sb.append("]");
                }
            }
        }
        boolean bl5 = this.setFont(graphics2D, phylogenyNode, bl3);
        float f = 3.0f;
        if (!phylogenyNode.isExternal() && phylogenyNode.getNumberOfDescendants() == 1) {
            f = 1.0f;
        }
        float f2 = this.getControlPanel().getTreeDisplayType() == Options.PHYLOGENY_DISPLAY_TYPE.ALIGNED_PHYLOGRAM && (phylogenyNode.isExternal() || phylogenyNode.isCollapse()) ? (float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)(this.getOptions().getDefaultNodeShapeSize() / 2) + (double)n + 20.0 + (double)this.getXdistance() + 2.0) : phylogenyNode.getXcoord() + (float)n + 2.0f + (float)n2;
        float f3 = !bl5 ? phylogenyNode.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / f : phylogenyNode.getYcoord() + (float)this.getFontMetrics(graphics2D.getFont()).getAscent() / f;
        if (this.getControlPanel().getTreeDisplayType() == Options.PHYLOGENY_DISPLAY_TYPE.ALIGNED_PHYLOGRAM && (phylogenyNode.isExternal() || phylogenyNode.isCollapse())) {
            this.drawConnection(phylogenyNode.getXcoord(), f2 - (float)n, phylogenyNode.getYcoord(), 5, 20, graphics2D, bl2);
            if (phylogenyNode.isCollapse()) {
                f2 = (float)((double)f2 - d);
            }
        }
        String string = this._sb.toString();
        if (this._control_panel.isShowSequenceRelations() && phylogenyNode.getNodeData().isHasSequence() && this._query_sequence != null) {
            n = this.paintSequenceRelation(graphics2D, phylogenyNode, n, n2, f2, f3, string);
        }
        if (string.length() > 0) {
            if (!this.isAllowAttributedStrings()) {
                TreePanel.drawString(string, f2, f3, graphics2D);
            } else {
                this.drawStringX(string, f2, f3, graphics2D);
            }
        }
        if (this._sb.length() > 0) {
            n = !bl5 && !bl3 ? (n += this.getFontMetricsForLargeDefaultFont().stringWidth(this._sb.toString()) + 5) : (n += this.getFontMetrics(graphics2D.getFont()).stringWidth(this._sb.toString()) + 5);
        }
        if (this.getControlPanel().isShowAnnotation() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAnnotations() != null && !phylogenyNode.getNodeData().getSequence().getAnnotations().isEmpty()) {
            SortedSet<Annotation> sortedSet = phylogenyNode.getNodeData().getSequence().getAnnotations();
            if ((bl2 || bl) && this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(Color.BLACK);
            } else if (this.getControlPanel().isColorAccordingToAnnotation()) {
                graphics2D.setColor(this.calculateColorForAnnotation(sortedSet));
            }
            String string2 = TreePanelUtil.createAnnotationString(sortedSet, this.getOptions().isShowAnnotationRefSource());
            TreePanel.drawString(string2, phylogenyNode.getXcoord() + (float)n + 3.0f + (float)n2, phylogenyNode.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / f, graphics2D);
            this._sb.setLength(0);
            this._sb.append(string2);
            if (this._sb.length() > 0) {
                n = !bl5 && !bl3 ? (n += this.getFontMetricsForLargeDefaultFont().stringWidth(this._sb.toString()) + 5) : (n += this.getFontMetrics(graphics2D.getFont()).stringWidth(this._sb.toString()) + 5);
            }
        }
        if ((this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED) && (this.getControlPanel().isShowBinaryCharacters() || this.getControlPanel().isShowBinaryCharacterCounts()) && phylogenyNode.getNodeData().isHasBinaryCharacters()) {
            if ((bl2 || bl) && this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(Color.BLACK);
            } else {
                graphics2D.setColor(this.getTreeColorSet().getBinaryDomainCombinationsColor());
            }
            if (this.getControlPanel().isShowBinaryCharacters()) {
                TreePanel.drawString(phylogenyNode.getNodeData().getBinaryCharacters().getPresentCharactersAsStringBuffer().toString(), phylogenyNode.getXcoord() + (float)n + 1.0f + (float)n2, phylogenyNode.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / f, graphics2D);
                this.paintGainedAndLostCharacters(graphics2D, phylogenyNode, phylogenyNode.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString(), phylogenyNode.getNodeData().getBinaryCharacters().getLostCharactersAsStringBuffer().toString());
            } else {
                TreePanel.drawString(" " + phylogenyNode.getNodeData().getBinaryCharacters().getPresentCount(), phylogenyNode.getXcoord() + (float)n + 4.0f + (float)n2, phylogenyNode.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / f, graphics2D);
                this.paintGainedAndLostCharacters(graphics2D, phylogenyNode, "+" + phylogenyNode.getNodeData().getBinaryCharacters().getGainedCount(), "-" + phylogenyNode.getNodeData().getBinaryCharacters().getLostCount());
            }
        }
        return n;
    }

    private final int paintSequenceRelation(Graphics2D graphics2D, PhylogenyNode phylogenyNode, int n, int n2, float f, float f2, String string) {
        block6: {
            Object object;
            int n3;
            block5: {
                n3 = 0;
                if (string.length() > 0) {
                    object = new TextLayout(string, graphics2D.getFont(), this._frc).getBounds();
                    n3 = (int)((RectangularShape)object).getWidth();
                }
                if (!phylogenyNode.getNodeData().getSequence().equals(this._query_sequence)) break block5;
                if (n3 <= 0) break block6;
                graphics2D.fillRect((int)f - 1, (int)f2 - 8, n3 + 5, 11);
                graphics2D.setColor(this.getTreeColorSet().getBackgroundColor());
                break block6;
            }
            object = phylogenyNode.getNodeData().getSequence().getSequenceRelations();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                String string2;
                SequenceRelation sequenceRelation = (SequenceRelation)iterator.next();
                boolean bl = (sequenceRelation.getRef0().isEqual(this._query_sequence) || sequenceRelation.getRef1().isEqual(this._query_sequence)) && sequenceRelation.getType().equals(this.getControlPanel().getSequenceRelationTypeBox().getSelectedItem());
                if (!bl) continue;
                double d = phylogenyNode.getXcoord() + 2.0f + (float)n2;
                String string3 = string2 = !this.getControlPanel().isShowSequenceRelationConfidence() || sequenceRelation.getConfidence() == null ? null : " (" + sequenceRelation.getConfidence().getValue() + ")";
                if (string2 != null) {
                    float f3 = f;
                    if (string.length() > 0) {
                        f3 = (float)((double)f3 + (new TextLayout(string, graphics2D.getFont(), this._frc).getBounds().getWidth() + 4.0));
                    }
                    if ((double)f3 > d) {
                        int n4 = (int)new TextLayout(string2, graphics2D.getFont(), this._frc).getBounds().getWidth();
                        TreePanel.drawString(string2, f3, f2, graphics2D);
                        n += 4 + n4;
                    }
                }
                if (n + n3 <= 0) continue;
                n3 = n3 == 0 ? (n3 -= 3) : (n3 += 2);
                graphics2D.drawLine((int)d + 1, 3 + (int)f2, (int)d + n + n3, 3 + (int)f2);
                break;
            }
        }
        return n;
    }

    private final void drawConnection(float f, float f2, float f3, int n, int n2, Graphics2D graphics2D, boolean bl) {
        if (f + (float)n < f2 - (float)n2) {
            Stroke stroke = graphics2D.getStroke();
            Color color = null;
            if (stroke == STROKE_005) {
                graphics2D.setStroke(STROKE_001_DASHED);
            } else if (stroke == STROKE_01) {
                graphics2D.setStroke(STROKE_005_DASHED);
            } else {
                graphics2D.setStroke(STROKE_01_DASHED);
            }
            if (bl) {
                color = graphics2D.getColor();
                graphics2D.setColor(TreePanel.lighter(color));
            }
            this.drawLine(f + (float)n, f3, f2 - (float)n2, f3, graphics2D);
            graphics2D.setStroke(stroke);
            if (bl) {
                graphics2D.setColor(color);
            }
        }
    }

    private static Color lighter(Color color) {
        if (color.getRed() == 0 && color.getGreen() == 0 && color.getBlue() == 0) {
            return new Color(200, 200, 200);
        }
        return color;
    }

    private final void addLabelForCollapsed(String string, String string2, int n, PhylogenyNode phylogenyNode) {
        int[] nArray;
        this._sb.append(string.length() < 8 ? string : string.substring(0, 7));
        this._sb.append(" ... ");
        this._sb.append(string2.length() < 8 ? string2 : string2.substring(0, 7));
        this._sb.append(" (" + n + ")");
        if ((this._found_nodes_0 != null || this._found_nodes_1 != null) && (nArray = this.calcFoundNodesInSubtree(phylogenyNode))[0] > 0) {
            this._sb.append(" [");
            this._sb.append(nArray[0]);
            this._sb.append("/");
            this._sb.append(nArray[1]);
            this._sb.append("]");
        }
    }

    private final int[] calcFoundNodesInSubtree(PhylogenyNode phylogenyNode) {
        List<PhylogenyNode> list = PhylogenyMethods.getAllDescendants(phylogenyNode);
        int[] nArray = new int[2];
        int n = 0;
        int n2 = 0;
        for (PhylogenyNode phylogenyNode2 : list) {
            if (!phylogenyNode2.isHasNodeData()) continue;
            if (this._found_nodes_0 != null && this._found_nodes_0.contains(phylogenyNode2.getId()) || this._found_nodes_1 != null && this._found_nodes_1.contains(phylogenyNode2.getId())) {
                ++n;
            }
            ++n2;
        }
        nArray[0] = n;
        nArray[1] = n2;
        return nArray;
    }

    private final boolean isAllowAttributedStrings() {
        return false;
    }

    private final void paintNodeDataUnrootedCirc(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3, double d, boolean bl4) {
        if (this.isNodeDataInvisibleUnrootedCirc(phylogenyNode) && !bl2 && !bl) {
            return;
        }
        this._sb.setLength(0);
        this._sb.append(" ");
        if (phylogenyNode.getNodeData().isHasTaxonomy() && (this.getControlPanel().isShowTaxonomyCode() || this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCommonNames())) {
            Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
            if (this._control_panel.isShowTaxonomyCode() && !ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                this._sb.append(taxonomy.getTaxonomyCode());
                this._sb.append(" ");
            }
            if (this._control_panel.isShowTaxonomyScientificNames() && this._control_panel.isShowTaxonomyCommonNames()) {
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName()) && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" (");
                    this._sb.append(taxonomy.getCommonName());
                    this._sb.append(") ");
                } else if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" ");
                } else if (!ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                    this._sb.append(taxonomy.getCommonName());
                    this._sb.append(" ");
                }
            } else if (this._control_panel.isShowTaxonomyScientificNames()) {
                if (!ForesterUtil.isEmpty(taxonomy.getScientificName())) {
                    this._sb.append(taxonomy.getScientificName());
                    this._sb.append(" ");
                }
            } else if (this._control_panel.isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(taxonomy.getCommonName())) {
                this._sb.append(taxonomy.getCommonName());
                this._sb.append(" ");
            }
        }
        if (phylogenyNode.isCollapse() && (!phylogenyNode.isRoot() && !phylogenyNode.getParent().isCollapse() || phylogenyNode.isRoot())) {
            this._sb.append(" [");
            this._sb.append(phylogenyNode.getAllExternalDescendants().size());
            this._sb.append("]");
        }
        if (this.getControlPanel().isShowNodeNames() && phylogenyNode.getName().length() > 0) {
            if (this._sb.length() > 0) {
                this._sb.append(" ");
            }
            this._sb.append(phylogenyNode.getName());
        }
        if (phylogenyNode.getNodeData().isHasSequence()) {
            if (this.getControlPanel().isShowSequenceAcc() && phylogenyNode.getNodeData().getSequence().getAccession() != null) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                if (!ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getAccession().getSource())) {
                    this._sb.append(phylogenyNode.getNodeData().getSequence().getAccession().getSource());
                    this._sb.append(":");
                }
                this._sb.append(phylogenyNode.getNodeData().getSequence().getAccession().getValue());
            }
            if (this.getControlPanel().isShowSeqNames() && phylogenyNode.getNodeData().getSequence().getName().length() > 0) {
                if (this._sb.length() > 0) {
                    this._sb.append(" ");
                }
                this._sb.append(phylogenyNode.getNodeData().getSequence().getName());
            }
        }
        if (this._sb.length() > 1) {
            this.setColor(graphics2D, phylogenyNode, bl2, bl, bl4, this.getTreeColorSet().getSequenceColor());
            boolean bl5 = this.setFont(graphics2D, phylogenyNode, bl4);
            String string = this._sb.toString();
            double d2 = 0.0;
            d2 = this._graphics_type == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR ? this._urt_nodeid_angle_map.get(phylogenyNode.getId()) % (Math.PI * 2) : (double)((float)(d % (Math.PI * 2)));
            this._at = graphics2D.getTransform();
            boolean bl6 = false;
            float f = phylogenyNode.getXcoord();
            float f2 = !bl5 ? phylogenyNode.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / 3.0f : phylogenyNode.getYcoord() + (float)this.getFontMetrics(graphics2D.getFont()).getAscent() / 3.0f;
            if (bl3) {
                bl6 = true;
                boolean bl7 = false;
                if (d2 > 1.5707963705062866 && d2 < 4.71238899230957) {
                    d2 -= 3.1415927410125732;
                    bl7 = true;
                }
                graphics2D.rotate(d2, f, phylogenyNode.getYcoord());
                if (bl7) {
                    if (!bl5) {
                        graphics2D.translate(-this.getFontMetricsForLargeDefaultFont().getStringBounds(string, graphics2D).getWidth(), 0.0);
                    } else {
                        graphics2D.translate(-this.getFontMetrics(graphics2D.getFont()).getStringBounds(string, graphics2D).getWidth(), 0.0);
                    }
                }
            } else if (d2 > 1.5707963705062866 && d2 < 4.71238899230957) {
                bl6 = true;
                if (!bl5) {
                    graphics2D.translate(-this.getFontMetricsForLargeDefaultFont().getStringBounds(string, graphics2D).getWidth(), 0.0);
                } else {
                    graphics2D.translate(-this.getFontMetrics(graphics2D.getFont()).getStringBounds(string, graphics2D).getWidth(), 0.0);
                }
            }
            TreePanel.drawString(string, f, f2, graphics2D);
            if (bl6) {
                graphics2D.setTransform(this._at);
            }
        }
    }

    private final void paintNodeLite(Graphics2D graphics2D, PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isCollapse()) {
            return;
        }
        if (this.isInFoundNodes(phylogenyNode) || this.isInCurrentExternalNodes(phylogenyNode)) {
            graphics2D.setColor(this.getColorForFoundNode(phylogenyNode));
            this.drawRectFilled((double)phylogenyNode.getXSecondary() - 1.0, (double)phylogenyNode.getYSecondary() - 1.0, 2.0, 2.0, graphics2D);
        }
        float f = 0.0f;
        if (!phylogenyNode.isExternal() && !phylogenyNode.isCollapse()) {
            boolean bl = true;
            float f2 = 0.0f;
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
                int n = phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes();
                if (bl) {
                    bl = false;
                    f2 = phylogenyNode.getYSecondary() - this.getOvYDistance() * (float)(phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes());
                } else {
                    f2 += this.getOvYDistance() * (float)phylogenyNode2.getNumberOfExternalNodes();
                }
                float f3 = this.calculateOvBranchLengthToParent(phylogenyNode2, n);
                f = f3 + phylogenyNode.getXSecondary();
                float f4 = phylogenyNode.getYSecondary() - f2;
                float f5 = phylogenyNode.getXSecondary() - f;
                if (f4 > 2.0f || f4 < -2.0f || f5 > 2.0f || f5 < -2.0f) {
                    this.paintBranchLite(graphics2D, phylogenyNode.getXSecondary(), f, phylogenyNode.getYSecondary(), f2, phylogenyNode2);
                }
                phylogenyNode2.setXSecondary(f);
                phylogenyNode2.setYSecondary(f2);
                f2 += this.getOvYDistance() * (float)phylogenyNode2.getNumberOfExternalNodes();
            }
        }
    }

    private final void paintNodeRectangular(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, int n, boolean bl3, boolean bl4) {
        int n2;
        boolean bl5;
        boolean bl6 = bl5 = this.isInFoundNodes(phylogenyNode) || this.isInCurrentExternalNodes(phylogenyNode);
        if (phylogenyNode.isCollapse()) {
            if (!phylogenyNode.isRoot() && !phylogenyNode.getParent().isCollapse()) {
                this.paintCollapsedNode(graphics2D, phylogenyNode, bl3, bl, bl5);
            }
            return;
        }
        if (phylogenyNode.isExternal()) {
            ++this._external_node_index;
        }
        if (this.getControlPanel().isShowConfidenceValues() && !phylogenyNode.isExternal() && !phylogenyNode.isRoot() && (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE) && phylogenyNode.getBranchData().isHasConfidences()) {
            this.paintConfidenceValues(graphics2D, phylogenyNode, bl, bl3);
        }
        if (phylogenyNode.isRoot() && this._phylogeny.isRooted()) {
            this.paintRootBranch(graphics2D, phylogenyNode.getXcoord(), phylogenyNode.getYcoord(), phylogenyNode, bl, bl3);
        }
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = 1.5f;
        if (!bl4) {
            if (n > 4000) {
                f3 = 4.0f;
            } else if (n > 1000) {
                f3 = 3.0f;
            } else if (n > 100) {
                f3 = 2.0f;
            }
        }
        if (!phylogenyNode.isExternal() && !phylogenyNode.isCollapse()) {
            n2 = 1;
            float f4 = 0.0f;
            for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
                PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
                int n3 = phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes();
                if (n2 != 0) {
                    n2 = 0;
                    f4 = phylogenyNode.getYcoord() - this._y_distance * (float)(phylogenyNode.getNumberOfExternalNodes() - phylogenyNode2.getNumberOfExternalNodes());
                } else {
                    f4 += this._y_distance * (float)phylogenyNode2.getNumberOfExternalNodes();
                }
                float f5 = this.calculateBranchLengthToParent(phylogenyNode2, n3);
                f = f5 + phylogenyNode.getXcoord();
                if (bl2 && f5 < f2) {
                    f2 = f5;
                }
                float f6 = phylogenyNode.getYcoord() - f4;
                float f7 = phylogenyNode.getXcoord() - f;
                if (bl4 || f6 > f3 || f6 < -f3 || f7 > f3 || f7 < -f3) {
                    this.paintBranchRectangular(graphics2D, phylogenyNode.getXcoord(), f, phylogenyNode.getYcoord(), f4, phylogenyNode2, bl, bl3);
                }
                phylogenyNode2.setXcoord(f);
                phylogenyNode2.setYcoord(f4);
                f4 += this._y_distance * (float)phylogenyNode2.getNumberOfExternalNodes();
            }
            this.paintNodeBox(phylogenyNode.getXcoord(), phylogenyNode.getYcoord(), phylogenyNode, graphics2D, bl, bl3);
        }
        if (this.getControlPanel().isShowMolSequences() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().isMolecularSequenceAligned() && !ForesterUtil.isEmpty(phylogenyNode.getNodeData().getSequence().getMolecularSequence())) {
            this.paintMolecularSequences(graphics2D, phylogenyNode, bl);
        }
        if (bl2 && (phylogenyNode.isExternal() && this._external_node_index % n != 1 || !phylogenyNode.isExternal() && (f2 < 20.0f || this._y_distance * (float)phylogenyNode.getNumberOfExternalNodes() < (float)this.getFontMetricsForLargeDefaultFont().getHeight()))) {
            return;
        }
        n2 = this.paintNodeData(graphics2D, phylogenyNode, bl3, bl, bl5, 0.0);
        this.paintNodeWithRenderableData(n2, graphics2D, phylogenyNode, bl3, bl);
    }

    private final void paintNodeWithRenderableData(int n, Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        RenderablePhylogenyData renderablePhylogenyData;
        if (this.isNodeDataInvisible(phylogenyNode) && !bl && !bl2) {
            return;
        }
        if (!this.getControlPanel().isShowInternalData() && !phylogenyNode.isExternal()) {
            return;
        }
        if (!this.getControlPanel().isShowExternalData() && phylogenyNode.isExternal()) {
            return;
        }
        if (this.getControlPanel().isShowDomainArchitectures() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() instanceof RenderableDomainArchitecture) {
            renderablePhylogenyData = null;
            try {
                renderablePhylogenyData = (RenderableDomainArchitecture)phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
            }
            catch (ClassCastException classCastException) {
                classCastException.printStackTrace();
            }
            if (renderablePhylogenyData != null) {
                float f = this.getYdistance();
                if (this.getControlPanel().isDynamicallyHideData()) {
                    f = this.getTreeFontSet().getFontMetricsLarge().getHeight();
                }
                int n2 = f < 7.0f ? ForesterUtil.roundToInt(f) : 7;
                ((RenderableDomainArchitecture)renderablePhylogenyData).setRenderingHeight(n2 > 1 ? (float)n2 : 2.0f);
                if (this.getControlPanel().isDrawPhylogram()) {
                    if (this.getOptions().isLineUpRendarableNodeData()) {
                        if (this.getOptions().isRightLineUpDomains()) {
                            ((RenderableDomainArchitecture)renderablePhylogenyData).render((float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)this._length_of_longest_text + (double)this._phylogeny.getRoot().getXcoord() + (double)((float)(this._longest_domain - ((RenderableDomainArchitecture)renderablePhylogenyData).getTotalLength()) * ((RenderableDomainArchitecture)renderablePhylogenyData).getRenderingFactorWidth())), phylogenyNode.getYcoord() - (float)n2 / 2.0f, graphics2D, this, bl2);
                        } else {
                            ((RenderableDomainArchitecture)renderablePhylogenyData).render((float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)this._length_of_longest_text + (double)this._phylogeny.getRoot().getXcoord()), phylogenyNode.getYcoord() - (float)n2 / 2.0f, graphics2D, this, bl2);
                        }
                    } else {
                        ((RenderableDomainArchitecture)renderablePhylogenyData).render(phylogenyNode.getXcoord() + (float)n, phylogenyNode.getYcoord() - (float)n2 / 2.0f, graphics2D, this, bl2);
                    }
                } else if (this.getOptions().isRightLineUpDomains()) {
                    ((RenderableDomainArchitecture)renderablePhylogenyData).render(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text - 20.0f + (float)(this._longest_domain - ((RenderableDomainArchitecture)renderablePhylogenyData).getTotalLength()) * ((RenderableDomainArchitecture)renderablePhylogenyData).getRenderingFactorWidth(), phylogenyNode.getYcoord() - (float)n2 / 2.0f, graphics2D, this, bl2);
                } else {
                    ((RenderableDomainArchitecture)renderablePhylogenyData).render(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text, phylogenyNode.getYcoord() - (float)n2 / 2.0f, graphics2D, this, bl2);
                }
            }
        }
        if (this.getControlPanel().isShowVectorData() && phylogenyNode.getNodeData().getVector() != null && phylogenyNode.getNodeData().getVector().size() > 0 && this.getStatisticsForExpressionValues() != null && (renderablePhylogenyData = RenderableVector.createInstance(phylogenyNode.getNodeData().getVector(), this.getStatisticsForExpressionValues(), this.getConfiguration())) != null) {
            double d = 0.0;
            if (this.getControlPanel().isShowDomainArchitectures() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getDomainArchitecture() != null) {
                d = this._domain_structure_width + 10.0;
            }
            if (this.getControlPanel().isDrawPhylogram()) {
                ((RenderableVector)renderablePhylogenyData).render((float)((double)(phylogenyNode.getXcoord() + (float)n) + d), phylogenyNode.getYcoord() - 3.0f, graphics2D, this, bl2);
            } else {
                ((RenderableVector)renderablePhylogenyData).render((float)((double)(this.getPhylogeny().getFirstExternalNode().getXcoord() + (float)this._length_of_longest_text) + d), phylogenyNode.getYcoord() - 3.0f, graphics2D, this, bl2);
            }
        }
    }

    private final void paintOvRectangle(Graphics2D graphics2D) {
        float f = (float)this.getWidth() / (float)this.getVisibleRect().width;
        float f2 = (float)this.getHeight() / (float)this.getVisibleRect().height;
        float f3 = (float)this.getWidth() / (float)this.getVisibleRect().x;
        float f4 = (float)this.getHeight() / (float)this.getVisibleRect().y;
        float f5 = this.getOvMaxWidth() / f;
        float f6 = this.getOvMaxHeight() / f2;
        float f7 = (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / f3;
        float f8 = (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / f4;
        graphics2D.setColor(this.getTreeColorSet().getFoundColor0());
        this.getOvRectangle().setRect(f7, f8, f5, f6);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE_1);
        if (f5 < 6.0f && f6 < 6.0f) {
            this.drawRectFilled(f7, f8, 6.0, 6.0, graphics2D);
            this.getOvVirtualRectangle().setRect(f7, f8, 6.0, 6.0);
        } else if (f5 < 6.0f) {
            this.drawRectFilled(f7, f8, 6.0, f6, graphics2D);
            this.getOvVirtualRectangle().setRect(f7, f8, 6.0, f6);
        } else if (f6 < 6.0f) {
            this.drawRectFilled(f7, f8, f5, 6.0, graphics2D);
            this.getOvVirtualRectangle().setRect(f7, f8, f5, 6.0);
        } else {
            this.drawRect(f7, f8, f5, f6, graphics2D);
            if (this.isInOvRect()) {
                this.drawRect(f7 + 1.0f, f8 + 1.0f, f5 - 2.0f, f6 - 2.0f, graphics2D);
            }
            this.getOvVirtualRectangle().setRect(f7, f8, f5, f6);
        }
        graphics2D.setStroke(stroke);
    }

    private final void paintPhylogenyLite(Graphics2D graphics2D) {
        this._phylogeny.getRoot().setXSecondary((float)((double)(this.getVisibleRect().x + this.getOvXPosition()) + 20.0 / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())));
        this._phylogeny.getRoot().setYSecondary(this.getVisibleRect().y + this.getOvYStart());
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE_05);
        for (PhylogenyNode phylogenyNode : this._nodes_in_preorder) {
            this.paintNodeLite(graphics2D, phylogenyNode);
        }
        graphics2D.setStroke(stroke);
        this.paintOvRectangle(graphics2D);
    }

    private final void paintRootBranch(Graphics2D graphics2D, float f, float f2, PhylogenyNode phylogenyNode, boolean bl, boolean bl2) {
        this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode, false, graphics2D, bl, bl2);
        float f3 = this.getXdistance();
        if (this.getControlPanel().isDrawPhylogram() && phylogenyNode.getDistanceToParent() > 0.0) {
            f3 = (float)((double)this.getXcorrectionFactor() * phylogenyNode.getDistanceToParent());
        }
        if (f3 < 3.0f) {
            f3 = 3.0f;
        }
        if (!this.getControlPanel().isWidthBranches() || PhylogenyMethods.getBranchWidthValue(phylogenyNode) == 1.0) {
            this.drawLine(f - f3, phylogenyNode.getYcoord(), f, phylogenyNode.getYcoord(), graphics2D);
        } else {
            double d = PhylogenyMethods.getBranchWidthValue(phylogenyNode);
            this.drawRectFilled(f - f3, (double)phylogenyNode.getYcoord() - d / 2.0, f3, d, graphics2D);
        }
        this.paintNodeBox(f, phylogenyNode.getYcoord(), phylogenyNode, graphics2D, bl, bl2);
    }

    private final void paintScale(Graphics2D graphics2D, int n, int n2, boolean bl, boolean bl2) {
        double d = (double)(n += 20) + this.getScaleDistance() * (double)this.getXcorrectionFactor();
        int n3 = (n2 -= 12) - 8;
        int n4 = n2 - 4;
        graphics2D.setFont(this.getTreeFontSet().getSmallFont());
        if ((bl || bl2) && this.getOptions().isPrintBlackAndWhite()) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(this.getTreeColorSet().getBranchLengthColor());
        }
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(STROKE_1);
        this.drawLine(n, n2, n, n3, graphics2D);
        this.drawLine(d, n2, d, n3, graphics2D);
        this.drawLine(n, n4, d, n4, graphics2D);
        if (this.getScaleLabel() != null) {
            graphics2D.drawString(this.getScaleLabel(), n + 2, n4 - 2);
        }
        graphics2D.setStroke(stroke);
    }

    private final int paintTaxonomy(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3, float f) {
        Taxonomy taxonomy = phylogenyNode.getNodeData().getTaxonomy();
        boolean bl4 = this.setFont(graphics2D, phylogenyNode, bl);
        this.setColor(graphics2D, phylogenyNode, bl3, bl2, bl, this.getTreeColorSet().getTaxonomyColor());
        float f2 = phylogenyNode.getXcoord() + 3.0f + (float)(this.getOptions().getDefaultNodeShapeSize() / 2) + f;
        if (this.getControlPanel().getTreeDisplayType() == Options.PHYLOGENY_DISPLAY_TYPE.ALIGNED_PHYLOGRAM && phylogenyNode.isExternal()) {
            f2 = (float)(this.getMaxDistanceToRoot() * (double)this.getXcorrectionFactor() + (double)(this.getOptions().getDefaultNodeShapeSize() / 2) + (double)f + 20.0 + (double)this.getXdistance() + 3.0);
        }
        float f3 = !bl4 ? phylogenyNode.getYcoord() + (float)this.getFontMetricsForLargeDefaultFont().getAscent() / (phylogenyNode.getNumberOfDescendants() == 1 ? 1.0f : 3.0f) : phylogenyNode.getYcoord() + (float)this.getFontMetrics(graphics2D.getFont()).getAscent() / (phylogenyNode.getNumberOfDescendants() == 1 ? 1.0f : 3.0f);
        this._sb.setLength(0);
        this.nodeTaxonomyDataAsSB(taxonomy, this._sb);
        String string = this._sb.toString();
        if (this._control_panel.isShowSequenceRelations() && string.length() > 0 && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().equals(this._query_sequence)) {
            Rectangle2D rectangle2D = new TextLayout(string, graphics2D.getFont(), new FontRenderContext(null, false, false)).getBounds();
            graphics2D.fillRect((int)f2 - 1, (int)f3 - 8, (int)rectangle2D.getWidth() + 4, 11);
            graphics2D.setColor(this.getTreeColorSet().getBackgroundColor());
        }
        TreePanel.drawString(string, f2, f3, graphics2D);
        if (!bl4 && !bl) {
            return this.getFontMetricsForLargeDefaultFont().stringWidth(string);
        }
        return this.getFontMetrics(graphics2D.getFont()).stringWidth(string);
    }

    private final void paintUnrooted(PhylogenyNode phylogenyNode, double d, double d2, boolean bl, Graphics2D graphics2D, boolean bl2, boolean bl3) {
        if (phylogenyNode.isRoot()) {
            phylogenyNode.setXcoord(this.getWidth() / 2);
            phylogenyNode.setYcoord(this.getHeight() / 2);
        }
        if (phylogenyNode.isExternal()) {
            this.paintNodeDataUnrootedCirc(graphics2D, phylogenyNode, bl2, bl3, bl, (d2 + d) / 2.0, this.isInFoundNodes(phylogenyNode) || this.isInCurrentExternalNodes(phylogenyNode));
            return;
        }
        float f = phylogenyNode.getNumberOfExternalNodes();
        float f2 = phylogenyNode.getXcoord();
        float f3 = phylogenyNode.getYcoord();
        double d3 = d;
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            int n = phylogenyNode2.getNumberOfExternalNodes();
            double d4 = (double)((float)n / f) * (d2 - d);
            float f4 = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (phylogenyNode2.getDistanceToParent() < 0.0 ? 0.0f : (float)(phylogenyNode2.getDistanceToParent() * (double)this.getUrtFactor())) : this.getUrtFactor();
            double d5 = d3 + d4 / 2.0;
            float f5 = (float)((double)f2 + Math.cos(d5) * (double)f4);
            float f6 = (float)((double)f3 + Math.sin(d5) * (double)f4);
            phylogenyNode2.setXcoord(f5);
            phylogenyNode2.setYcoord(f6);
            this.paintUnrooted(phylogenyNode2, d3, d3 + d4, bl, graphics2D, bl2, bl3);
            d3 += d4;
            this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode2, false, graphics2D, bl2, bl3);
            this.drawLine(f2, f3, f5, f6, graphics2D);
            this.paintNodeBox(f5, f6, phylogenyNode2, graphics2D, bl2, bl3);
        }
        if (phylogenyNode.isRoot()) {
            this.paintNodeBox(phylogenyNode.getXcoord(), phylogenyNode.getYcoord(), phylogenyNode, graphics2D, bl2, bl3);
        }
    }

    private final void paintUnrootedLite(PhylogenyNode phylogenyNode, double d, double d2, Graphics2D graphics2D, float f) {
        if (phylogenyNode.isRoot()) {
            int n = (int)((float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() / 2.0f);
            int n2 = (int)((float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() / 2.0f);
            phylogenyNode.setXSecondary(n);
            phylogenyNode.setYSecondary(n2);
        }
        if (phylogenyNode.isExternal()) {
            return;
        }
        float f2 = phylogenyNode.getNumberOfExternalNodes();
        float f3 = phylogenyNode.getXSecondary();
        float f4 = phylogenyNode.getYSecondary();
        double d3 = d;
        for (int i = 0; i < phylogenyNode.getNumberOfDescendants(); ++i) {
            PhylogenyNode phylogenyNode2 = phylogenyNode.getChildNode(i);
            int n = phylogenyNode2.getNumberOfExternalNodes();
            double d4 = (double)((float)n / f2) * (d2 - d);
            float f5 = this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram() ? (phylogenyNode2.getDistanceToParent() < 0.0 ? 0.0f : (float)(phylogenyNode2.getDistanceToParent() * (double)f)) : f;
            double d5 = d3 + d4 / 2.0;
            float f6 = (float)((double)f3 + Math.cos(d5) * (double)f5);
            float f7 = (float)((double)f4 + Math.sin(d5) * (double)f5);
            phylogenyNode2.setXSecondary(f6);
            phylogenyNode2.setYSecondary(f7);
            if (this.isInFoundNodes(phylogenyNode2) || this.isInCurrentExternalNodes(phylogenyNode2)) {
                graphics2D.setColor(this.getColorForFoundNode(phylogenyNode2));
                this.drawRectFilled((double)phylogenyNode2.getXSecondary() - 1.0, (double)phylogenyNode2.getYSecondary() - 1.0, 2.0, 2.0, graphics2D);
                graphics2D.setColor(this.getTreeColorSet().getOvColor());
            }
            this.paintUnrootedLite(phylogenyNode2, d3, d3 + d4, graphics2D, f);
            d3 += d4;
            this.drawLine(f3, f4, f6, f7, graphics2D);
        }
    }

    private final void pasteSubtree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            this.errorMessageNoCutCopyPasteInUnrootedDisplay();
            return;
        }
        if (this.getCutOrCopiedTree() == null || this.getCutOrCopiedTree().isEmpty()) {
            JOptionPane.showMessageDialog(this, "No tree in buffer (need to copy or cut a subtree first)", "Attempt to paste with empty buffer", 0);
            return;
        }
        String string = this.createASimpleTextRepresentationOfANode(this.getCutOrCopiedTree().getRoot());
        Object[] objectArray = new Object[]{"As sibling", "As descendant", "Cancel"};
        int n = JOptionPane.showOptionDialog(this, "How to paste subtree" + string + "?", "Paste Subtree", -1, 3, null, objectArray, objectArray[2]);
        boolean bl = true;
        if (n == 1) {
            bl = false;
        } else if (n != 0) {
            return;
        }
        Phylogeny phylogeny = this.getCutOrCopiedTree().copy();
        phylogeny.setAllNodesToNotCollapse();
        PhylogenyMethods.preOrderReId(phylogeny);
        phylogeny.setRooted(true);
        boolean bl2 = false;
        if (bl) {
            if (phylogenyNode.isRoot()) {
                JOptionPane.showMessageDialog(this, "Cannot paste sibling to root", "Attempt to paste sibling to root", 0);
                return;
            }
            phylogeny.addAsSibling(phylogenyNode);
        } else if (phylogenyNode.getNumberOfExternalNodes() == 1 && phylogenyNode.isRoot()) {
            bl2 = true;
            this._phylogeny = phylogeny;
        } else {
            phylogeny.addAsChild(phylogenyNode);
        }
        if (this.getCopiedAndPastedNodes() == null) {
            this.setCopiedAndPastedNodes(new HashSet<Long>());
        }
        List<PhylogenyNode> list = PhylogenyMethods.obtainAllNodesAsList(phylogeny);
        HashSet<Long> hashSet = new HashSet<Long>(list.size());
        for (PhylogenyNode phylogenyNode2 : list) {
            hashSet.add(phylogenyNode2.getId());
        }
        hashSet.add(phylogenyNode.getId());
        this.getCopiedAndPastedNodes().addAll(hashSet);
        this.setNodeInPreorderToNull();
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        if (bl2) {
            this.getControlPanel().showWhole();
        }
        this.repaint();
    }

    private final StringBuffer propertiesToString(PhylogenyNode phylogenyNode) {
        return phylogenyNode.getNodeData().getProperties().asText();
    }

    private void setColor(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl, boolean bl2, boolean bl3, Color color) {
        if ((bl2 || bl) && this.getOptions().isPrintBlackAndWhite()) {
            graphics2D.setColor(Color.BLACK);
        } else if (bl3) {
            graphics2D.setColor(this.getColorForFoundNode(phylogenyNode));
        } else if (this.getControlPanel().isUseVisualStyles() && phylogenyNode.getNodeData().getNodeVisualData() != null && phylogenyNode.getNodeData().getNodeVisualData().getFontColor() != null) {
            graphics2D.setColor(phylogenyNode.getNodeData().getNodeVisualData().getFontColor());
        } else if (this.getControlPanel().isColorAccordingToSequence()) {
            graphics2D.setColor(this.getSequenceBasedColor(phylogenyNode));
        } else if (this.getControlPanel().isColorAccordingToTaxonomy()) {
            graphics2D.setColor(this.getTaxonomyBasedColor(phylogenyNode));
        } else if (this.getControlPanel().isColorAccordingToAnnotation() && phylogenyNode.getNodeData().isHasSequence() && phylogenyNode.getNodeData().getSequence().getAnnotations() != null && !phylogenyNode.getNodeData().getSequence().getAnnotations().isEmpty()) {
            graphics2D.setColor(this.calculateColorForAnnotation(phylogenyNode.getNodeData().getSequence().getAnnotations()));
        } else if (this.getOptions().isColorLabelsSameAsParentBranch() && this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
            graphics2D.setColor(PhylogenyMethods.getBranchColorValue(phylogenyNode));
        } else if (bl2) {
            graphics2D.setColor(Color.BLACK);
        } else {
            graphics2D.setColor(color);
        }
    }

    private final void setCopiedAndPastedNodes(Set<Long> set) {
        this.getMainPanel().setCopiedAndPastedNodes(set);
    }

    private final void setCutOrCopiedTree(Phylogeny phylogeny) {
        this.getMainPanel().setCutOrCopiedTree(phylogeny);
    }

    private boolean setFont(Graphics2D graphics2D, PhylogenyNode phylogenyNode, boolean bl) {
        Font font = null;
        if (this.getControlPanel().isUseVisualStyles() && phylogenyNode.getNodeData().getNodeVisualData() != null) {
            font = phylogenyNode.getNodeData().getNodeVisualData().getFont();
            graphics2D.setFont(font != null ? font : this.getTreeFontSet().getLargeFont());
        } else {
            graphics2D.setFont(this.getTreeFontSet().getLargeFont());
        }
        if (bl) {
            graphics2D.setFont(graphics2D.getFont().deriveFont(1));
        }
        return font != null;
    }

    private final void setInOv(boolean bl) {
        this._in_ov = bl;
    }

    private final void setOvMaxHeight(float f) {
        this._ov_max_height = f;
    }

    private final void setOvMaxWidth(float f) {
        this._ov_max_width = f;
    }

    private final void setOvXcorrectionFactor(float f) {
        this._ov_x_correction_factor = f;
    }

    private final void setOvXDistance(float f) {
        this._ov_x_distance = f;
    }

    private final void setOvXPosition(int n) {
        this._ov_x_position = n;
    }

    private final void setOvYDistance(float f) {
        this._ov_y_distance = f;
    }

    private final void setOvYPosition(int n) {
        this._ov_y_position = n;
    }

    private final void setOvYStart(int n) {
        this._ov_y_start = n;
    }

    private final void setScaleDistance(double d) {
        this._scale_distance = d;
    }

    private final void setScaleLabel(String string) {
        this._scale_label = string;
    }

    private final void setupStroke(Graphics2D graphics2D) {
        if ((double)this.getYdistance() < 1.0E-4) {
            graphics2D.setStroke(STROKE_0025);
        }
        if ((double)this.getYdistance() < 0.001) {
            graphics2D.setStroke(STROKE_005);
        } else if ((double)this.getYdistance() < 0.01) {
            graphics2D.setStroke(STROKE_01);
        } else if ((double)this.getYdistance() < 0.5) {
            graphics2D.setStroke(STROKE_025);
        } else if (this.getYdistance() < 1.0f) {
            graphics2D.setStroke(STROKE_05);
        } else if (this.getYdistance() < 2.0f) {
            graphics2D.setStroke(STROKE_075);
        } else if (this.getYdistance() < 20.0f || !this.getConfiguration().isAllowThickStrokes()) {
            graphics2D.setStroke(STROKE_1);
        } else {
            graphics2D.setStroke(STROKE_2);
        }
    }

    private final void setUpUrtFactor() {
        int n;
        int n2 = n = this.getVisibleRect().width < this.getVisibleRect().height ? this.getVisibleRect().width : this.getVisibleRect().height;
        if (this.isPhyHasBranchLengths() && this.getControlPanel().isDrawPhylogram()) {
            this.setUrtFactor((float)((double)n / (2.0 * this.getMaxDistanceToRoot())));
        } else {
            int n3 = this._circ_max_depth;
            if (n3 > 0) {
                this.setUrtFactor(n / (2 * n3));
            } else {
                this.setUrtFactor(n / 2);
            }
        }
        this.setUrtFactorOv(this.getUrtFactor());
    }

    private final void setUrtFactor(float f) {
        this._urt_factor = f;
    }

    private final void setUrtFactorOv(float f) {
        this._urt_factor_ov = f;
    }

    private void showExtDescNodeData(PhylogenyNode phylogenyNode, char c) {
        Object object;
        CharSequence charSequence;
        ArrayList<String> arrayList = new ArrayList<String>();
        List<PhylogenyNode> list = phylogenyNode.getAllExternalDescendants();
        if (this.getFoundNodes0() != null || this.getFoundNodes1() != null) {
            for (PhylogenyNode phylogenyNode2 : this.getFoundNodesAsListOfPhylogenyNodes()) {
                if (list.contains(phylogenyNode2)) continue;
                list.add(phylogenyNode2);
            }
        }
        block15: for (PhylogenyNode phylogenyNode2 : list) {
            switch (this.getOptions().getExtDescNodeDataToReturn()) {
                case NODE_NAME: {
                    if (ForesterUtil.isEmpty(phylogenyNode2.getName())) continue block15;
                    arrayList.add(phylogenyNode2.getName());
                    break;
                }
                case SEQUENCE_NAME: {
                    if (!phylogenyNode2.getNodeData().isHasSequence() || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) continue block15;
                    arrayList.add(phylogenyNode2.getNodeData().getSequence().getName());
                    break;
                }
                case GENE_NAME: {
                    if (!phylogenyNode2.getNodeData().isHasSequence() || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getGeneName())) continue block15;
                    arrayList.add(phylogenyNode2.getNodeData().getSequence().getGeneName());
                    break;
                }
                case SEQUENCE_SYMBOL: {
                    if (!phylogenyNode2.getNodeData().isHasSequence() || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) continue block15;
                    arrayList.add(phylogenyNode2.getNodeData().getSequence().getSymbol());
                    break;
                }
                case SEQUENCE_MOL_SEQ_FASTA: {
                    charSequence = new StringBuilder();
                    if (!phylogenyNode2.getNodeData().isHasSequence() || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getMolecularSequence())) continue block15;
                    object = new StringBuilder();
                    if (this.getControlPanel().isShowNodeNames() && !ForesterUtil.isEmpty(phylogenyNode2.getName())) {
                        ((StringBuilder)object).append(phylogenyNode2.getName());
                        ((StringBuilder)object).append(c);
                    }
                    if (phylogenyNode2.getNodeData().isHasTaxonomy()) {
                        if (this.getControlPanel().isShowTaxonomyCode() && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) {
                            ((StringBuilder)object).append(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                            ((StringBuilder)object).append(c);
                        }
                        if (this.getControlPanel().isShowTaxonomyScientificNames() && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) {
                            ((StringBuilder)object).append(phylogenyNode2.getNodeData().getTaxonomy().getScientificName());
                            ((StringBuilder)object).append(c);
                        }
                        if (this.getControlPanel().isShowTaxonomyCommonNames() && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getCommonName())) {
                            ((StringBuilder)object).append(phylogenyNode2.getNodeData().getTaxonomy().getCommonName());
                            ((StringBuilder)object).append(c);
                        }
                    }
                    if (this.getControlPanel().isShowSeqSymbols() && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getSymbol())) {
                        ((StringBuilder)object).append(phylogenyNode2.getNodeData().getSequence().getSymbol());
                        ((StringBuilder)object).append(c);
                    }
                    if (this.getControlPanel().isShowSeqNames() && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getName())) {
                        ((StringBuilder)object).append(phylogenyNode2.getNodeData().getSequence().getName());
                        ((StringBuilder)object).append(c);
                    }
                    if (this.getControlPanel().isShowGeneNames() && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getGeneName())) {
                        ((StringBuilder)object).append(phylogenyNode2.getNodeData().getSequence().getGeneName());
                        ((StringBuilder)object).append(c);
                    }
                    if (this.getControlPanel().isShowSequenceAcc() && phylogenyNode2.getNodeData().getSequence().getAccession() != null) {
                        ((StringBuilder)object).append(phylogenyNode2.getNodeData().getSequence().getAccession().asText());
                        ((StringBuilder)object).append(c);
                    }
                    String string = ((StringBuilder)object).length() > 0 && ((StringBuilder)object).charAt(((StringBuilder)object).length() - 1) == c ? ((StringBuilder)object).substring(0, ((StringBuilder)object).length() - 1) : ((StringBuilder)object).toString();
                    ((StringBuilder)charSequence).append((CharSequence)SequenceWriter.toFasta(string, phylogenyNode2.getNodeData().getSequence().getMolecularSequence(), 60));
                    arrayList.add(((StringBuilder)charSequence).toString());
                    break;
                }
                case SEQUENCE_ACC: {
                    if (!phylogenyNode2.getNodeData().isHasSequence() || phylogenyNode2.getNodeData().getSequence().getAccession() == null || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getAccession().toString())) continue block15;
                    arrayList.add(phylogenyNode2.getNodeData().getSequence().getAccession().toString());
                    break;
                }
                case TAXONOMY_SCIENTIFIC_NAME: {
                    if (!phylogenyNode2.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getScientificName())) continue block15;
                    arrayList.add(phylogenyNode2.getNodeData().getTaxonomy().getScientificName());
                    break;
                }
                case TAXONOMY_CODE: {
                    if (!phylogenyNode2.getNodeData().isHasTaxonomy() || ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode())) continue block15;
                    arrayList.add(phylogenyNode2.getNodeData().getTaxonomy().getTaxonomyCode());
                    break;
                }
                case DOMAINS_ALL: 
                case DOMAINS_COLLAPSED_PER_PROTEIN: {
                    Object object2;
                    if (!phylogenyNode2.getNodeData().isHasSequence() || phylogenyNode2.getNodeData().getSequence().getDomainArchitecture() == null) continue block15;
                    object = phylogenyNode2.getNodeData().getSequence().getDomainArchitecture();
                    HashSet<String> hashSet = new HashSet<String>();
                    for (int i = 0; i < ((DomainArchitecture)object).getDomains().size(); ++i) {
                        String string;
                        object2 = ((DomainArchitecture)object).getDomain(i);
                        if (!(((ProteinDomain)object2).getConfidence() <= Math.pow(10.0, this.getDomainStructureEvalueThresholdExp())) || hashSet.contains(string = ((ProteinDomain)object2).getName())) continue;
                        arrayList.add(string);
                        if (this.getOptions().getExtDescNodeDataToReturn() != NodeDataField.DOMAINS_COLLAPSED_PER_PROTEIN) continue;
                        hashSet.add(string);
                    }
                    continue block15;
                }
                case SEQ_ANNOTATIONS: {
                    if (!phylogenyNode2.getNodeData().isHasSequence() || !phylogenyNode2.getNodeData().isHasSequence() || phylogenyNode2.getNodeData().getSequence().getAnnotations() == null) continue block15;
                    object = phylogenyNode2.getNodeData().getSequence().getAnnotations();
                    for (int i = 0; i < object.size(); ++i) {
                        arrayList.add(phylogenyNode2.getNodeData().getSequence().getAnnotation(i).toString());
                    }
                    continue block15;
                }
                case GO_TERM_IDS: {
                    Object object2;
                    if (!phylogenyNode2.getNodeData().isHasSequence() || !phylogenyNode2.getNodeData().isHasSequence() || phylogenyNode2.getNodeData().getSequence().getAnnotations() == null) continue block15;
                    object = phylogenyNode2.getNodeData().getSequence().getAnnotations();
                    for (int i = 0; i < object.size(); ++i) {
                        Annotation annotation = phylogenyNode2.getNodeData().getSequence().getAnnotation(i);
                        object2 = annotation.getRef();
                        if (!((String)object2).toUpperCase().startsWith("GO:")) continue;
                        arrayList.add((String)object2);
                    }
                    continue block15;
                }
                case UNKNOWN: {
                    TreePanelUtil.showExtDescNodeDataUserSelectedHelper(this.getControlPanel(), phylogenyNode2, arrayList);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown data element: " + (Object)((Object)this.getOptions().getExtDescNodeDataToReturn()));
                }
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = TreePanelUtil.nodeDataIntoStringBuffer(arrayList, this.getOptions(), stringBuilder);
        if (this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.CONSOLE || this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.BUFFER_ONLY) {
            if (this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.CONSOLE) {
                System.out.println(stringBuilder);
            }
            if (stringBuilder.length() < 1) {
                this.clearCurrentExternalNodesDataBuffer();
            } else {
                this.setCurrentExternalNodesDataBuffer(stringBuilder);
            }
        } else if (this.getConfiguration().getExtNodeDataReturnOn() == Configuration.EXT_NODE_DATA_RETURN_ON.WINODW) {
            if (stringBuilder.length() < 1) {
                TreePanelUtil.showInformationMessage(this, "No Appropriate Data (" + this.obtainTitleForExtDescNodeData() + ")", "Descendants of selected node do not contain selected data");
                this.clearCurrentExternalNodesDataBuffer();
            } else {
                this.setCurrentExternalNodesDataBuffer(stringBuilder);
                charSequence = this.getFoundNodes0() != null && !this.getFoundNodes0().isEmpty() ? (this.getOptions().getExtDescNodeDataToReturn() == NodeDataField.UNKNOWN ? "Data" : this.obtainTitleForExtDescNodeData()) + " for " + arrayList.size() + " nodes, unique entries: " + n : (this.getOptions().getExtDescNodeDataToReturn() == NodeDataField.UNKNOWN ? "Data" : this.obtainTitleForExtDescNodeData()) + " for " + arrayList.size() + "/" + phylogenyNode.getNumberOfExternalNodes() + " external descendats of node " + phylogenyNode + ", unique entries: " + n;
                object = stringBuilder.toString().trim();
                this.getMainPanel().getMainFrame().showTextFrame((String)object, (String)charSequence);
            }
        }
    }

    private final void showNodeDataPopup(MouseEvent mouseEvent, PhylogenyNode phylogenyNode) {
        try {
            if (phylogenyNode.getName().length() > 0 || phylogenyNode.getNodeData().isHasTaxonomy() && !TreePanelUtil.isTaxonomyEmpty(phylogenyNode.getNodeData().getTaxonomy()) || phylogenyNode.getNodeData().isHasSequence() && !TreePanelUtil.isSequenceEmpty(phylogenyNode.getNodeData().getSequence()) || phylogenyNode.getNodeData().isHasDate() || phylogenyNode.getNodeData().isHasDistribution() || phylogenyNode.getBranchData().isHasConfidences()) {
                Object object;
                boolean bl;
                this._popup_buffer.setLength(0);
                int n = 0;
                if (phylogenyNode.getName().length() > 0) {
                    n = (short)(n + 1);
                    this._popup_buffer.append(phylogenyNode.getName());
                }
                if (phylogenyNode.getNodeData().isHasTaxonomy() && !TreePanelUtil.isTaxonomyEmpty(phylogenyNode.getNodeData().getTaxonomy())) {
                    n = (short)(n + 1);
                    bl = false;
                    object = phylogenyNode.getNodeData().getTaxonomy();
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getTaxonomyCode())) {
                        this._popup_buffer.append("[");
                        this._popup_buffer.append(((Taxonomy)object).getTaxonomyCode());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getScientificName())) {
                        if (bl) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getScientificName());
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getCommonName())) {
                        if (bl) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getCommonName());
                        this._popup_buffer.append(")");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getAuthority())) {
                        if (bl) {
                            this._popup_buffer.append(" (");
                        } else {
                            this._popup_buffer.append("(");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getAuthority());
                        this._popup_buffer.append(")");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Taxonomy)object).getRank())) {
                        if (bl) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getRank());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (((Taxonomy)object).getSynonyms().size() > 0) {
                        if (bl) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append("[");
                        int n2 = 1;
                        for (String string : ((Taxonomy)object).getSynonyms()) {
                            if (!ForesterUtil.isEmpty(string)) {
                                bl = true;
                                this._popup_buffer.append(string);
                                if (n2 < ((Taxonomy)object).getSynonyms().size()) {
                                    this._popup_buffer.append(", ");
                                }
                            }
                            ++n2;
                        }
                        this._popup_buffer.append("]");
                    }
                    if (!bl && ((Taxonomy)object).getIdentifier() != null && !ForesterUtil.isEmpty(((Taxonomy)object).getIdentifier().getValue())) {
                        if (!ForesterUtil.isEmpty(((Taxonomy)object).getIdentifier().getProvider())) {
                            this._popup_buffer.append("[");
                            this._popup_buffer.append(((Taxonomy)object).getIdentifier().getProvider());
                            this._popup_buffer.append("] ");
                        }
                        this._popup_buffer.append(((Taxonomy)object).getIdentifier().getValue());
                    }
                }
                if (phylogenyNode.getNodeData().isHasSequence() && !TreePanelUtil.isSequenceEmpty(phylogenyNode.getNodeData().getSequence())) {
                    n = (short)(n + 1);
                    bl = false;
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    if (((Sequence)(object = phylogenyNode.getNodeData().getSequence())).getAccession() != null) {
                        this._popup_buffer.append("[");
                        if (!ForesterUtil.isEmpty(((Sequence)object).getAccession().getSource())) {
                            this._popup_buffer.append(((Sequence)object).getAccession().getSource());
                            this._popup_buffer.append(":");
                        }
                        this._popup_buffer.append(((Sequence)object).getAccession().getValue());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Sequence)object).getSymbol())) {
                        if (bl) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(((Sequence)object).getSymbol());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Sequence)object).getGeneName())) {
                        if (bl) {
                            this._popup_buffer.append(" [");
                        } else {
                            this._popup_buffer.append("[");
                        }
                        this._popup_buffer.append(((Sequence)object).getGeneName());
                        this._popup_buffer.append("]");
                        bl = true;
                    }
                    if (!ForesterUtil.isEmpty(((Sequence)object).getName())) {
                        if (bl) {
                            this._popup_buffer.append(" ");
                        }
                        this._popup_buffer.append(((Sequence)object).getName());
                    }
                }
                if (phylogenyNode.getNodeData().isHasDate()) {
                    n = (short)(n + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(phylogenyNode.getNodeData().getDate().asSimpleText());
                }
                if (phylogenyNode.getNodeData().isHasDistribution()) {
                    n = (short)(n + 1);
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(phylogenyNode.getNodeData().getDistribution().asSimpleText());
                }
                if (phylogenyNode.getBranchData().isHasConfidences()) {
                    List<Confidence> list = phylogenyNode.getBranchData().getConfidences();
                    for (Confidence confidence : list) {
                        n = (short)(n + 1);
                        if (this._popup_buffer.length() > 0) {
                            this._popup_buffer.append("\n");
                        }
                        if (!ForesterUtil.isEmpty(confidence.getType())) {
                            this._popup_buffer.append("[");
                            this._popup_buffer.append(confidence.getType());
                            this._popup_buffer.append("] ");
                        }
                        this._popup_buffer.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getValue(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
                        if (confidence.getStandardDeviation() == -2.147483647E9) continue;
                        this._popup_buffer.append(" (sd=");
                        this._popup_buffer.append(FORMATTER_CONFIDENCE.format(ForesterUtil.round(confidence.getStandardDeviation(), this.getOptions().getNumberOfDigitsAfterCommaForConfidenceValues())));
                        this._popup_buffer.append(")");
                    }
                }
                if (phylogenyNode.getNodeData().isHasProperties()) {
                    if (this._popup_buffer.length() > 0) {
                        this._popup_buffer.append("\n");
                    }
                    this._popup_buffer.append(phylogenyNode.getNodeData().getProperties().asText());
                }
                if (this._popup_buffer.length() > 0) {
                    if (!this.getConfiguration().isUseNativeUI()) {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(this.getTreeColorSet().getBranchColor()));
                        this._rollover_popup.setBackground(this.getTreeColorSet().getBackgroundColor());
                        if (this.isInFoundNodes0(phylogenyNode) && !this.isInFoundNodes1(phylogenyNode)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor0());
                        } else if (!this.isInFoundNodes0(phylogenyNode) && this.isInFoundNodes1(phylogenyNode)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor1());
                        } else if (this.isInFoundNodes0(phylogenyNode) && this.isInFoundNodes1(phylogenyNode)) {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getFoundColor0and1());
                        } else {
                            this._rollover_popup.setForeground(this.getTreeColorSet().getSequenceColor());
                        }
                    } else {
                        this._rollover_popup.setBorder(BorderFactory.createLineBorder(Color.BLACK));
                    }
                    this._rollover_popup.setText(this._popup_buffer.toString());
                    this._node_desc_popup = PopupFactory.getSharedInstance().getPopup(null, this._rollover_popup, mouseEvent.getLocationOnScreen().x + 10, mouseEvent.getLocationOnScreen().y - n * 20);
                    this._node_desc_popup.show();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void showNodeEditFrame(PhylogenyNode phylogenyNode) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(phylogenyNode, this._phylogeny, this, this._node_frame_index, "");
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    private final void showNodeFrame(PhylogenyNode phylogenyNode) {
        if (this._node_frame_index < 10) {
            this._node_frames[this._node_frame_index] = new NodeFrame(phylogenyNode, this._phylogeny, this, this._node_frame_index);
            ++this._node_frame_index;
        } else {
            JOptionPane.showMessageDialog(this, "too many node windows are open");
        }
    }

    private final void switchDisplaygetPhylogenyGraphicsType() {
        switch (this.getPhylogenyGraphicsType()) {
            case RECTANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.EURO_STYLE);
                break;
            }
            case EURO_STYLE: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.ROUNDED);
                break;
            }
            case ROUNDED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CURVED);
                break;
            }
            case CURVED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.TRIANGULAR);
                break;
            }
            case TRIANGULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CONVEX);
                break;
            }
            case CONVEX: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED);
                break;
            }
            case UNROOTED: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR);
                break;
            }
            case CIRCULAR: {
                this.setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                this.getOptions().setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE.RECTANGULAR);
                break;
            }
            default: {
                throw new RuntimeException("unkwnown display type: " + (Object)((Object)this.getPhylogenyGraphicsType()));
            }
        }
        if (this.getControlPanel().getDynamicallyHideData() != null) {
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
                this.getControlPanel().getDynamicallyHideData().setEnabled(false);
            } else {
                this.getControlPanel().getDynamicallyHideData().setEnabled(true);
            }
        }
        if (this.isPhyHasBranchLengths() && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().setDrawPhylogramEnabled(true);
        } else {
            this.getControlPanel().setDrawPhylogramEnabled(false);
        }
        this.getMainPanel().getMainFrame().setSelectedTypeInTypeMenu(this.getPhylogenyGraphicsType());
    }

    final void calcMaxDepth() {
        if (this._phylogeny != null) {
            this._circ_max_depth = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
        }
    }

    final void calcParametersForPainting(int n, int n2) {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            this.initNodeData();
            this.calculateLongestExtNodeInfo();
            if ((double)this.getLongestExtNodeInfo() > (double)n * 0.6 && (float)this.getTreeFontSet().getLargeFont().getSize() > 3.0f) {
                while ((double)this.getLongestExtNodeInfo() > (double)n * 0.7 && this.getTreeFontSet().getLargeFont().getSize() > 2) {
                    this.getMainPanel().getTreeFontSet().decreaseFontSize(this.getConfiguration().getMinBaseFontSize(), true);
                    this.calculateLongestExtNodeInfo();
                }
            } else {
                while ((double)this.getLongestExtNodeInfo() < (double)n * 0.6 && (float)this.getTreeFontSet().getLargeFont().getSize() <= (float)this.getTreeFontSet().getLargeFontMemory().getSize() - 1.0f) {
                    this.getMainPanel().getTreeFontSet().increaseFontSize();
                    this.calculateLongestExtNodeInfo();
                }
            }
            this._length_of_longest_text = this.calcLengthOfLongestText();
            int n3 = this._phylogeny.getRoot().getNumberOfExternalNodes();
            int n4 = PhylogenyMethods.calculateMaxDepthConsiderCollapsed(this._phylogeny) + 1;
            if (n3 == 1 && (n3 = n4) < 1) {
                n3 = 1;
            }
            this.updateOvSizes();
            float f = 0.0f;
            float f2 = 0.0f;
            if (!this.isNonLinedUpCladogram()) {
                f = (float)((double)(n - this.getLongestExtNodeInfo() - 20) / ((double)n3 + 3.0));
                f2 = (float)((double)this.getOvMaxWidth() / ((double)n3 + 3.0));
            } else {
                f = (n - this.getLongestExtNodeInfo() - 20) / (n4 + 1);
                f2 = this.getOvMaxWidth() / (float)(n4 + 1);
            }
            float f3 = (float)((double)(n2 - 20) / ((double)n3 * 2.0));
            if ((double)f < 0.0) {
                f = 0.0f;
            }
            if ((double)f2 < 0.0) {
                f2 = 0.0f;
            }
            if ((double)f3 < 0.0) {
                f3 = 0.0f;
            }
            this.setXdistance(f);
            this.setYdistance(f3);
            this.setOvXDistance(f2);
            double d = this._phylogeny.calculateHeight(!this._options.isCollapsedWithAverageHeigh());
            if (d > 0.0) {
                float f4 = (float)(((double)n - 40.0 - (double)this.getLongestExtNodeInfo() - (double)this.getXdistance()) / d);
                this.setXcorrectionFactor(f4 > 0.0f ? f4 : 0.0f);
                float f5 = (float)((double)(this.getOvMaxWidth() - this.getOvXDistance()) / d);
                this.setOvXcorrectionFactor(f5 > 0.0f ? f5 : 0.0f);
            } else {
                this.setXcorrectionFactor(0.0f);
                this.setOvXcorrectionFactor(0.0f);
            }
            this._circ_max_depth = n4;
            this.setUpUrtFactor();
            if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED || this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
                // empty if block
            }
        }
    }

    final void calculateLongestExtNodeInfo() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        int n = ForesterUtil.roundToInt((this.getSize().getWidth() - 40.0) * 0.95);
        if (n < 20) {
            n = 20;
        }
        int n2 = 30;
        int n3 = 0;
        this._longest_domain = 0;
        PhylogenyNode phylogenyNode = this._phylogeny.getFirstExternalNode();
        for (PhylogenyNode phylogenyNode2 : this._phylogeny.getExternalNodes()) {
            int n4;
            int n5 = 0;
            if (phylogenyNode2.isCollapse()) continue;
            StringBuilder stringBuilder = new StringBuilder();
            this.nodeDataAsSB(phylogenyNode2, stringBuilder);
            if (phylogenyNode2.getNodeData().isHasTaxonomy()) {
                this.nodeTaxonomyDataAsSB(phylogenyNode2.getNodeData().getTaxonomy(), stringBuilder);
            }
            if ((n4 = stringBuilder.length()) > n3) {
                n3 = n4;
                phylogenyNode = phylogenyNode2;
            }
            boolean bl = false;
            Graphics2D graphics2D = (Graphics2D)this.getGraphics();
            if (this.getControlPanel().isUseVisualStyles()) {
                bl = this.setFont(graphics2D, phylogenyNode2, false);
            }
            n5 = !bl ? this.getFontMetricsForLargeDefaultFont().stringWidth(stringBuilder.toString()) : this.getFontMetrics(graphics2D.getFont()).stringWidth(stringBuilder.toString());
            if (this.getControlPanel().isShowBinaryCharacters() && phylogenyNode2.getNodeData().isHasBinaryCharacters()) {
                n5 += this.getFontMetricsForLargeDefaultFont().stringWidth(phylogenyNode2.getNodeData().getBinaryCharacters().getGainedCharactersAsStringBuffer().toString());
            }
            if (this.getControlPanel().isShowVectorData() && phylogenyNode2.getNodeData().getVector() != null && phylogenyNode2.getNodeData().getVector().size() > 0) {
                n5 = this.getConfiguration() != null ? (n5 += this.getConfiguration().getVectorDataWidth() + 10) : (n5 += 130);
            }
            if (this.getControlPanel().isShowDomainArchitectures() && phylogenyNode2.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().getSequence().getDomainArchitecture() != null) {
                DomainArchitecture domainArchitecture = phylogenyNode2.getNodeData().getSequence().getDomainArchitecture();
                n5 = (int)((double)n5 + (this._domain_structure_width / ((RenderableDomainArchitecture)domainArchitecture).getOriginalSize().getWidth() * (double)domainArchitecture.getTotalLength() + 10.0));
                if (domainArchitecture.getTotalLength() > this._longest_domain) {
                    this._longest_domain = domainArchitecture.getTotalLength();
                }
            }
            if (this.getControlPanel().isShowMolSequences() && phylogenyNode2.getNodeData().isHasSequence() && phylogenyNode2.getNodeData().getSequence().isMolecularSequenceAligned() && !ForesterUtil.isEmpty(phylogenyNode2.getNodeData().getSequence().getMolecularSequence())) {
                n5 += 430;
            }
            if (n5 >= n) {
                this._longest_ext_node_info = n;
            }
            if (n5 <= n2) continue;
            n2 = n5;
        }
        this._ext_node_with_longest_txt_info = phylogenyNode;
        this._longest_ext_node_info = n2 >= n ? n : n2;
        this._length_of_longest_text = this.calcLengthOfLongestText();
    }

    final void calculateScaleDistance() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double d = this.getMaxDistanceToRoot();
        if (d > 0.0) {
            if (d <= 0.5) {
                this.setScaleDistance(0.01);
            } else if (d <= 5.0) {
                this.setScaleDistance(0.1);
            } else if (d <= 50.0) {
                this.setScaleDistance(1.0);
            } else if (d <= 500.0) {
                this.setScaleDistance(10.0);
            } else {
                this.setScaleDistance(100.0);
            }
        } else {
            this.setScaleDistance(0.0);
        }
        String string = String.valueOf(this.getScaleDistance());
        if (!ForesterUtil.isEmpty(this._phylogeny.getDistanceUnit())) {
            string = string + " [" + this._phylogeny.getDistanceUnit() + "]";
        }
        this.setScaleLabel(string);
    }

    final Color calculateSequenceBasedColor(Sequence sequence) {
        if (ForesterUtil.isEmpty(sequence.getName())) {
            return this.getTreeColorSet().getSequenceColor();
        }
        Color color = null;
        String string = sequence.getName();
        color = this.getControlPanel().getSequenceColors().get(string);
        if (color == null) {
            color = AptxUtil.calculateColorFromString(string, false);
            this.getControlPanel().getSequenceColors().put(string, color);
        }
        return color;
    }

    final Color calculateTaxonomyBasedColor(Taxonomy taxonomy) {
        if (this.getOptions().isColorByTaxonomicGroup()) {
            if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                Color color;
                boolean bl = false;
                String string = null;
                try {
                    string = TaxonomyUtil.getTaxGroupByTaxCode(taxonomy.getTaxonomyCode());
                }
                catch (Exception exception) {
                    bl = true;
                }
                if (!bl && !ForesterUtil.isEmpty(string) && (color = ForesterUtil.obtainColorDependingOnTaxonomyGroup(string)) != null) {
                    return color;
                }
            }
            return this.getTreeColorSet().getTaxonomyColor();
        }
        if (ForesterUtil.isEmpty(taxonomy.getTaxonomyCode()) && ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            return this.getTreeColorSet().getTaxonomyColor();
        }
        Color color = null;
        if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
            color = this.getControlPanel().getSpeciesColors().get(taxonomy.getTaxonomyCode());
        }
        if (color == null && !ForesterUtil.isEmpty(taxonomy.getScientificName())) {
            color = this.getControlPanel().getSpeciesColors().get(taxonomy.getScientificName());
        }
        if (color == null) {
            if (!ForesterUtil.isEmpty(taxonomy.getTaxonomyCode())) {
                color = AptxUtil.calculateColorFromString(taxonomy.getTaxonomyCode(), true);
                this.getControlPanel().getSpeciesColors().put(taxonomy.getTaxonomyCode(), color);
            } else {
                color = AptxUtil.calculateColorFromString(taxonomy.getScientificName(), true);
                this.getControlPanel().getSpeciesColors().put(taxonomy.getScientificName(), color);
            }
        }
        return color;
    }

    void clearCurrentExternalNodesDataBuffer() {
        this.setCurrentExternalNodesDataBuffer(new StringBuilder());
    }

    final void collapse(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot collapse in unrooted display type", "Attempt to collapse in unrooted display", 2);
            return;
        }
        if (!phylogenyNode.isExternal() && !phylogenyNode.isRoot()) {
            boolean bl = !phylogenyNode.isCollapse();
            TreePanelUtil.collapseSubtree(phylogenyNode, bl);
            this.updateSetOfCollapsedExternalNodes();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.calculateLongestExtNodeInfo();
            this.setNodeInPreorderToNull();
            this._control_panel.displayedPhylogenyMightHaveChanged(true);
            this.resetPreferredSize();
            this.updateOvSizes();
            this._main_panel.adjustJScrollPane();
            this.repaint();
        }
    }

    final void uncollapseAll(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot uncollapse in unrooted display type", "Attempt to uncollapse in unrooted display", 2);
            return;
        }
        if (!phylogenyNode.isExternal()) {
            TreePanelUtil.uncollapseSubtree(phylogenyNode);
            this.updateSetOfCollapsedExternalNodes();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.calculateLongestExtNodeInfo();
            this.setNodeInPreorderToNull();
            this._control_panel.displayedPhylogenyMightHaveChanged(true);
            this.resetPreferredSize();
            this.updateOvSizes();
            this._main_panel.adjustJScrollPane();
            this.repaint();
        }
    }

    final void collapseSpeciesSpecificSubtrees() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        TreePanelUtil.collapseSpeciesSpecificSubtrees(this._phylogeny);
        this.updateSetOfCollapsedExternalNodes();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.calculateLongestExtNodeInfo();
        this.setNodeInPreorderToNull();
        this.resetPreferredSize();
        this.resetDepthCollapseDepthValue();
        this.resetRankCollapseRankValue();
        this._main_panel.adjustJScrollPane();
        this.getControlPanel().showWhole();
        this.setArrowCursor();
    }

    final void colorRank(String string) {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        AptxUtil.removeBranchColors(this._phylogeny);
        int n = TreePanelUtil.colorPhylogenyAccordingToRanks(this._phylogeny, string, this);
        if (n > 0) {
            this._control_panel.setColorBranches(true);
            if (this._control_panel.getUseVisualStylesCb() != null) {
                this._control_panel.getUseVisualStylesCb().setSelected(true);
            }
            if (this._control_panel.getColorAccSpeciesCb() != null) {
                this._control_panel.getColorAccSpeciesCb().setSelected(false);
            }
            this._options.setColorLabelsSameAsParentBranch(true);
            if (this.getMainPanel().getMainFrame()._color_labels_same_as_parent_branch != null) {
                this.getMainPanel().getMainFrame()._color_labels_same_as_parent_branch.setSelected(true);
            }
            this._control_panel.repaint();
        }
        this.setArrowCursor();
        this.repaint();
        if (n > 0) {
            String string2 = "Taxonomy colorization via " + string + " completed:\n";
            string2 = n > 1 ? string2 + "colorized " + n + " subtrees" : string2 + "colorized one subtree";
            this.setEdited(true);
            JOptionPane.showMessageDialog(this, string2, "Taxonomy Rank-Colorization Completed (" + string + ")", 1);
        } else {
            String string3 = "Could not taxonomy rank-colorize any subtree via " + string + ".\n";
            string3 = string3 + "Possible solutions (given that suitable taxonomic information is present):\n";
            string3 = string3 + "select a different rank (e.g. phylum, genus, ...)\n";
            string3 = string3 + "  and/or\n";
            string3 = string3 + "execute:\n";
            string3 = string3 + "1. \"Obtain Detailed Taxonomic Information\" (Tools)\n";
            string3 = string3 + "2. \"Infer Ancestor Taxonomies\" (Analysis)";
            JOptionPane.showMessageDialog(this, string3, "Taxonomy Rank-Colorization Failed", 2);
        }
    }

    final void confColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        AptxUtil.removeBranchColors(this._phylogeny);
        TreePanelUtil.colorPhylogenyAccordingToConfidenceValues(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        this.setArrowCursor();
        this.repaint();
    }

    final void decreaseDomainStructureEvalueThresholdExp() {
        if (this._domain_structure_e_value_thr_exp > -20) {
            --this._domain_structure_e_value_thr_exp;
        }
    }

    final PhylogenyNode findNode(int n, int n2) {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return null;
        }
        int n3 = this.getOptions().getDefaultNodeShapeSize() / 2 + 2;
        PhylogenyNodeIterator phylogenyNodeIterator = this._phylogeny.iteratorPostorder();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!this._phylogeny.isRooted() && phylogenyNode.isRoot() && phylogenyNode.getNumberOfDescendants() <= 2 || !(phylogenyNode.getXcoord() - (float)n3 <= (float)n) || !(phylogenyNode.getXcoord() + (float)n3 >= (float)n) || !(phylogenyNode.getYcoord() - (float)n3 <= (float)n2) || !(phylogenyNode.getYcoord() + (float)n3 >= (float)n2)) continue;
            return phylogenyNode;
        }
        return null;
    }

    final Configuration getConfiguration() {
        return this._configuration;
    }

    final ControlPanel getControlPanel() {
        return this._control_panel;
    }

    String getCurrentExternalNodesDataBufferAsString() {
        return this._current_external_nodes_data_buffer.toString();
    }

    int getCurrentExternalNodesDataBufferChangeCounter() {
        return this._current_external_nodes_data_buffer_change_counter;
    }

    final int getDomainStructureEvalueThresholdExp() {
        return this._domain_structure_e_value_thr_exp;
    }

    final Set<Long> getFoundNodes0() {
        return this._found_nodes_0;
    }

    final Set<Long> getFoundNodes1() {
        return this._found_nodes_1;
    }

    List<PhylogenyNode> getFoundNodesAsListOfPhylogenyNodes() {
        PhylogenyNode phylogenyNode;
        ArrayList<PhylogenyNode> arrayList = new ArrayList<PhylogenyNode>();
        if (this.getFoundNodes0() != null) {
            for (Long l : this.getFoundNodes0()) {
                phylogenyNode = this._phylogeny.getNode(l);
                if (phylogenyNode == null) continue;
                arrayList.add(phylogenyNode);
            }
        }
        if (this.getFoundNodes1() != null) {
            for (Long l : this.getFoundNodes1()) {
                if (this.getFoundNodes0() != null && this.getFoundNodes0().contains(l) || (phylogenyNode = this._phylogeny.getNode(l)) == null) continue;
                arrayList.add(phylogenyNode);
            }
        }
        return arrayList;
    }

    final Color getGraphicsForNodeBoxWithColorForParentBranch(PhylogenyNode phylogenyNode) {
        if (this.getControlPanel().isUseVisualStyles() && PhylogenyMethods.getBranchColorValue(phylogenyNode) != null) {
            return PhylogenyMethods.getBranchColorValue(phylogenyNode);
        }
        return this.getTreeColorSet().getBranchColor();
    }

    final int getLongestExtNodeInfo() {
        return this._longest_ext_node_info;
    }

    final Options getOptions() {
        if (this._options == null) {
            this._options = this.getControlPanel().getOptions();
        }
        return this._options;
    }

    final Rectangle2D getOvRectangle() {
        return this._ov_rectangle;
    }

    final Rectangle getOvVirtualRectangle() {
        return this._ov_virtual_rectangle;
    }

    final Options.PHYLOGENY_GRAPHICS_TYPE getPhylogenyGraphicsType() {
        return this._graphics_type;
    }

    final Color getSequenceBasedColor(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.getNodeData().isHasSequence()) {
            return this.calculateSequenceBasedColor(phylogenyNode.getNodeData().getSequence());
        }
        return this.getTreeColorSet().getSequenceColor();
    }

    final double getStartingAngle() {
        return this._urt_starting_angle;
    }

    DescriptiveStatistics getStatisticsForExpressionValues() {
        return this._statistics_for_vector_data;
    }

    final Color getTaxonomyBasedColor(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal() && phylogenyNode.getNodeData().isHasTaxonomy()) {
            return this.calculateTaxonomyBasedColor(phylogenyNode.getNodeData().getTaxonomy());
        }
        return this.getTreeColorSet().getTaxonomyColor();
    }

    final File getTreeFile() {
        return this._treefile;
    }

    final float getXcorrectionFactor() {
        return this._x_correction_factor;
    }

    final float getXdistance() {
        return this._x_distance;
    }

    final float getYdistance() {
        return this._y_distance;
    }

    final void increaseDomainStructureEvalueThresholdExp() {
        if (this._domain_structure_e_value_thr_exp < 3) {
            ++this._domain_structure_e_value_thr_exp;
        }
    }

    /*
     * WARNING - void declaration
     */
    final void initNodeData() {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        double d = 0.0;
        for (PhylogenyNode object : this._phylogeny.getExternalNodes()) {
            void var5_6;
            double d2;
            if (!object.getNodeData().isHasSequence() || object.getNodeData().getSequence().getDomainArchitecture() == null) continue;
            Object var5_7 = null;
            if (!(object.getNodeData().getSequence().getDomainArchitecture() instanceof RenderableDomainArchitecture)) {
                RenderableDomainArchitecture renderableDomainArchitecture = new RenderableDomainArchitecture(object.getNodeData().getSequence().getDomainArchitecture(), object.getName());
                object.getNodeData().getSequence().setDomainArchitecture(renderableDomainArchitecture);
            } else {
                RenderableDomainArchitecture renderableDomainArchitecture = (RenderableDomainArchitecture)object.getNodeData().getSequence().getDomainArchitecture();
            }
            if (!this.getControlPanel().isShowDomainArchitectures() || !((d2 = var5_6.getOriginalSize().getWidth()) > d)) continue;
            d = d2;
        }
        if (this.getControlPanel().isShowDomainArchitectures()) {
            float f = (float)(this._domain_structure_width / d);
            for (PhylogenyNode phylogenyNode : this._phylogeny.getExternalNodes()) {
                if (!phylogenyNode.getNodeData().isHasSequence() || phylogenyNode.getNodeData().getSequence().getDomainArchitecture() == null) continue;
                RenderableDomainArchitecture renderableDomainArchitecture = (RenderableDomainArchitecture)phylogenyNode.getNodeData().getSequence().getDomainArchitecture();
                renderableDomainArchitecture.setRenderingFactorWidth(f * 0.9f);
                renderableDomainArchitecture.setParameter(this._domain_structure_e_value_thr_exp);
            }
        }
    }

    final boolean inOv(MouseEvent mouseEvent) {
        return mouseEvent.getX() > this.getVisibleRect().x + this.getOvXPosition() + 1 && (float)mouseEvent.getX() < (float)(this.getVisibleRect().x + this.getOvXPosition()) + this.getOvMaxWidth() - 1.0f && mouseEvent.getY() > this.getVisibleRect().y + this.getOvYPosition() + 1 && (float)mouseEvent.getY() < (float)(this.getVisibleRect().y + this.getOvYPosition()) + this.getOvMaxHeight() - 1.0f;
    }

    final boolean inOvRectangle(MouseEvent mouseEvent) {
        return (double)mouseEvent.getX() >= this.getOvRectangle().getX() - 1.0 && (double)mouseEvent.getX() <= this.getOvRectangle().getX() + this.getOvRectangle().getWidth() + 1.0 && (double)mouseEvent.getY() >= this.getOvRectangle().getY() - 1.0 && (double)mouseEvent.getY() <= this.getOvRectangle().getY() + this.getOvRectangle().getHeight() + 1.0;
    }

    final boolean isCanCollapse() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanUncollapseAll(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal() || this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            return false;
        }
        if (phylogenyNode.isCollapse()) {
            return true;
        }
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(phylogenyNode);
        while (preorderTreeIterator.hasNext()) {
            if (!preorderTreeIterator.next().isCollapse()) continue;
            return true;
        }
        return false;
    }

    final boolean isCanColorSubtree() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED;
    }

    final boolean isCanCopy() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    final boolean isCanCut(PhylogenyNode phylogenyNode) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && !phylogenyNode.isRoot();
    }

    final boolean isCanDelete() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable();
    }

    final boolean isCanPaste() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getOptions().isEditable() && this.getCutOrCopiedTree() != null && !this.getCutOrCopiedTree().isEmpty();
    }

    final boolean isCanReroot() {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this._subtree_index < 1;
    }

    final boolean isCanSubtree(PhylogenyNode phylogenyNode) {
        return this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && !phylogenyNode.isExternal() && (!phylogenyNode.isRoot() || this._subtree_index > 0);
    }

    final boolean isCurrentTreeIsSubtree() {
        return this._subtree_index > 0;
    }

    final boolean isEdited() {
        return this._edited;
    }

    final boolean isInOvRect() {
        return this._in_ov_rect;
    }

    final boolean isOvOn() {
        return this._ov_on;
    }

    final boolean isPhyHasBranchLengths() {
        return this._phy_has_branch_lengths;
    }

    final void midpointRoot() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        if (!this._phylogeny.isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        this.setNodeInPreorderToNull();
        this.setWaitCursor();
        PhylogenyMethods.midpointRoot(this._phylogeny);
        this.resetNodeIdToDistToLeafMap();
        this.setArrowCursor();
        this.setEdited(true);
        this.repaint();
    }

    final void mouseClicked(MouseEvent mouseEvent) {
        if (this.getOptions().isShowOverview() && this.isOvOn() && this.isInOv()) {
            double d = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
            double d2 = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
            double d3 = ((double)(mouseEvent.getX() - this.getVisibleRect().x - this.getOvXPosition()) - this.getOvRectangle().getWidth() / 2.0) * d;
            double d4 = ((double)(mouseEvent.getY() - this.getVisibleRect().y - this.getOvYPosition()) - this.getOvRectangle().getHeight() / 2.0) * d2;
            if (d3 < 0.0) {
                d3 = 0.0;
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            double d5 = this.getWidth() - this.getVisibleRect().width;
            double d6 = this.getHeight() - this.getVisibleRect().height;
            if (d3 > d5) {
                d3 = d5;
            }
            if (d4 > d6) {
                d4 = d6;
            }
            this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(new Point(ForesterUtil.roundToInt(d3), ForesterUtil.roundToInt(d4)));
            this.setInOvRect(true);
            this.repaint();
        } else {
            PhylogenyNode phylogenyNode = this.findNode(mouseEvent.getX(), mouseEvent.getY());
            if (phylogenyNode != null) {
                if (!phylogenyNode.isRoot() && phylogenyNode.getParent().isCollapse()) {
                    return;
                }
                this._highlight_node = phylogenyNode;
                if ((mouseEvent.getModifiersEx() & 0x40) != 0) {
                    if (this.getFoundNodes0() == null) {
                        this.setFoundNodes0(new HashSet<Long>());
                    }
                    if (this.getFoundNodes0().contains(phylogenyNode.getId())) {
                        this.getFoundNodes0().remove(phylogenyNode.getId());
                    } else {
                        this.getFoundNodes0().add(phylogenyNode.getId());
                    }
                } else if ((mouseEvent.getModifiersEx() & 0x80) != 0) {
                    this.displayNodePopupMenu(phylogenyNode, mouseEvent.getX(), mouseEvent.getY());
                } else if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    this.displayNodePopupMenu(phylogenyNode, mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.handleClickToAction(this._control_panel.getActionWhenNodeClicked(), phylogenyNode);
                }
            } else {
                this._highlight_node = null;
            }
        }
        this.repaint();
    }

    final void mouseDragInBrowserPanel(MouseEvent mouseEvent) {
        int n;
        this.setCursor(MOVE_CURSOR);
        Point point = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        point.x = (int)((float)point.x - ((float)mouseEvent.getX() - this.getLastDragPointX()));
        point.y = (int)((float)point.y - ((float)mouseEvent.getY() - this.getLastDragPointY()));
        if (point.x < 0) {
            point.x = 0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (point.x > n) {
                point.x = n;
            }
        }
        if (point.y < 0) {
            point.y = 0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (point.y > n) {
                point.y = n;
            }
        }
        if (this.isOvOn() || this.getOptions().isShowScale()) {
            this.repaint();
        }
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(point);
    }

    final void mouseDragInOvRectangle(MouseEvent mouseEvent) {
        int n;
        this.setCursor(HAND_CURSOR);
        double d = (double)this.getVisibleRect().width / this.getOvRectangle().getWidth();
        double d2 = (double)this.getVisibleRect().height / this.getOvRectangle().getHeight();
        Point point = this.getMainPanel().getCurrentScrollPane().getViewport().getViewPosition();
        double d3 = d * (double)mouseEvent.getX() - d * (double)this.getLastDragPointX();
        double d4 = d2 * (double)mouseEvent.getY() - d2 * (double)this.getLastDragPointY();
        point.x = ForesterUtil.roundToInt((double)point.x + d3);
        point.y = ForesterUtil.roundToInt((double)point.y + d4);
        if (point.x <= 0) {
            point.x = 0;
            d3 = 0.0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getHorizontalScrollBar().getVisibleAmount();
            if (point.x >= n) {
                d3 = 0.0;
                point.x = n;
            }
        }
        if (point.y <= 0) {
            d4 = 0.0;
            point.y = 0;
        } else {
            n = this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getMaximum() - this.getMainPanel().getCurrentScrollPane().getVerticalScrollBar().getVisibleAmount();
            if (point.y >= n) {
                d4 = 0.0;
                point.y = n;
            }
        }
        this.repaint();
        this.getMainPanel().getCurrentScrollPane().getViewport().setViewPosition(point);
        this.setLastMouseDragPointX((float)((double)mouseEvent.getX() + d3));
        this.setLastMouseDragPointY((float)((double)mouseEvent.getY() + d4));
    }

    final void mouseMoved(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
        if (this._current_external_nodes != null) {
            this._current_external_nodes = null;
            this.repaint();
        }
        if (this.getControlPanel().isNodeDescPopup() && this._node_desc_popup != null) {
            this._node_desc_popup.hide();
            this._node_desc_popup = null;
        }
        if (this.getOptions().isShowOverview() && this.isOvOn()) {
            if (this.inOvVirtualRectangle(mouseEvent)) {
                if (!this.isInOvRect()) {
                    this.setInOvRect(true);
                    this.repaint();
                }
            } else if (this.isInOvRect()) {
                this.setInOvRect(false);
                this.repaint();
            }
        }
        if (this.inOv(mouseEvent) && this.getOptions().isShowOverview() && this.isOvOn()) {
            if (!this.isInOv()) {
                this.setInOv(true);
            }
        } else {
            PhylogenyNode phylogenyNode;
            if (this.isInOv()) {
                this.setInOv(false);
            }
            if ((phylogenyNode = this.findNode(mouseEvent.getX(), mouseEvent.getY())) != null && (phylogenyNode.isRoot() || !phylogenyNode.getParent().isCollapse())) {
                if (this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.GET_EXT_DESC_DATA) {
                    for (PhylogenyNode phylogenyNode2 : phylogenyNode.getAllExternalDescendants()) {
                        this.addToCurrentExternalNodes(phylogenyNode2.getId());
                    }
                    this.setCursor(HAND_CURSOR);
                    this.repaint();
                } else if (this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.CUT_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.COPY_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.PASTE_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.DELETE_NODE_OR_SUBTREE || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.REROOT || this.getControlPanel().getActionWhenNodeClicked() == ControlPanel.NodeClickAction.ADD_NEW_NODE) {
                    this.setCursor(CUT_CURSOR);
                } else {
                    this.setCursor(HAND_CURSOR);
                    if (this.getControlPanel().isNodeDescPopup()) {
                        this.showNodeDataPopup(mouseEvent, phylogenyNode);
                    }
                }
            } else {
                this.setCursor(ARROW_CURSOR);
            }
        }
    }

    final void mouseReleasedInBrowserPanel(MouseEvent mouseEvent) {
        this.setCursor(ARROW_CURSOR);
    }

    final void multiplyUrtFactor(float f) {
        this._urt_factor *= f;
    }

    final void paintBranchCircular(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, Graphics2D graphics2D, boolean bl, boolean bl2, boolean bl3) {
        double d = this._urt_nodeid_angle_map.get(phylogenyNode2.getId());
        double d2 = this._root.getXcoord();
        double d3 = this._root.getYcoord();
        double d4 = d2 - (double)phylogenyNode.getXcoord();
        double d5 = d3 - (double)phylogenyNode.getYcoord();
        double d6 = Math.sqrt(d4 * d4 + d5 * d5);
        double d7 = this._urt_nodeid_angle_map.get(phylogenyNode.getId()) - d;
        this.assignGraphicsForBranchWithColorForParentBranch(phylogenyNode2, false, graphics2D, bl2, bl3);
        if ((phylogenyNode2.isFirstChildNode() || phylogenyNode2.isLastChildNode()) && (Math.abs(d6 * d7) > 1.5 || bl2 || bl3)) {
            double d8 = 2.0 * d6;
            this.drawArc(d2 - d6, d3 - d6, d8, d8, -d - d7, d7, graphics2D);
        }
        this.drawLine(phylogenyNode2.getXcoord(), phylogenyNode2.getYcoord(), d2 + Math.cos(d) * d6, d3 + Math.sin(d) * d6, graphics2D);
        this.paintNodeBox(phylogenyNode2.getXcoord(), phylogenyNode2.getYcoord(), phylogenyNode2, graphics2D, bl2, bl3);
        if (phylogenyNode2.isExternal()) {
            boolean bl4;
            boolean bl5 = bl4 = this.isInFoundNodes0(phylogenyNode2) || this.isInFoundNodes1(phylogenyNode2) || this.isInCurrentExternalNodes(phylogenyNode2);
            if (this._dynamic_hiding_factor > 1 && !bl4 && this._urt_nodeid_index_map.get(phylogenyNode2.getId()) % this._dynamic_hiding_factor != 1) {
                return;
            }
            this.paintNodeDataUnrootedCirc(graphics2D, phylogenyNode2, bl2, bl3, bl, 0.0, bl4);
        }
    }

    final void paintBranchCircularLite(PhylogenyNode phylogenyNode, PhylogenyNode phylogenyNode2, Graphics2D graphics2D) {
        double d = this._urt_nodeid_angle_map.get(phylogenyNode2.getId());
        double d2 = this._root.getXSecondary();
        double d3 = this._root.getYSecondary();
        double d4 = d2 - (double)phylogenyNode.getXSecondary();
        double d5 = d3 - (double)phylogenyNode.getYSecondary();
        double d6 = this._urt_nodeid_angle_map.get(phylogenyNode.getId()) - d;
        double d7 = Math.sqrt(d4 * d4 + d5 * d5);
        graphics2D.setColor(this.getTreeColorSet().getOvColor());
        if ((phylogenyNode2.isFirstChildNode() || phylogenyNode2.isLastChildNode()) && Math.abs(d6) > 0.02) {
            double d8 = 2.0 * d7;
            this.drawArc(d2 - d7, d3 - d7, d8, d8, -d - d6, d6, graphics2D);
        }
        this.drawLine(phylogenyNode2.getXSecondary(), phylogenyNode2.getYSecondary(), d2 + Math.cos(d) * d7, d3 + Math.sin(d) * d7, graphics2D);
        if (this.isInFoundNodes(phylogenyNode2) || this.isInCurrentExternalNodes(phylogenyNode2)) {
            graphics2D.setColor(this.getColorForFoundNode(phylogenyNode2));
            this.drawRectFilled((double)phylogenyNode2.getXSecondary() - 1.0, (double)phylogenyNode2.getYSecondary() - 1.0, 2.0, 2.0, graphics2D);
        }
    }

    final void paintCircular(Phylogeny phylogeny, double d, int n, int n2, int n3, Graphics2D graphics2D, boolean bl, boolean bl2) {
        int n4 = phylogeny.getNumberOfExternalNodes() - this._collapsed_external_nodeid_set.size();
        System.out.println("# collapsed external = " + this._collapsed_external_nodeid_set.size());
        this._root = phylogeny.getRoot();
        this._root.setXcoord(n);
        this._root.setYcoord(n2);
        boolean bl3 = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
        double d2 = d;
        int n5 = 0;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            if (!phylogenyNode.isCollapse()) {
                phylogenyNode.setXcoord((float)((double)n + (double)n3 * Math.cos(d2)));
                phylogenyNode.setYcoord((float)((double)n2 + (double)n3 * Math.sin(d2)));
                this._urt_nodeid_angle_map.put(phylogenyNode.getId(), d2);
                this._urt_nodeid_index_map.put(phylogenyNode.getId(), n5++);
                d2 += Math.PI * 2 / (double)n4;
                continue;
            }
            System.out.println("is collapse" + phylogenyNode.getName());
        }
        this.paintCirculars(phylogeny.getRoot(), phylogeny, n, n2, n3, bl3, graphics2D, bl, bl2);
        this.paintNodeBox(this._root.getXcoord(), this._root.getYcoord(), this._root, graphics2D, bl, bl2);
    }

    final void paintCircularLite(Phylogeny phylogeny, double d, int n, int n2, int n3, Graphics2D graphics2D) {
        int n4 = phylogeny.getNumberOfExternalNodes();
        this._root = phylogeny.getRoot();
        this._root.setXSecondary(n);
        this._root.setYSecondary(n2);
        double d2 = d;
        PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
        while (phylogenyNodeIterator.hasNext()) {
            PhylogenyNode phylogenyNode = phylogenyNodeIterator.next();
            phylogenyNode.setXSecondary((float)((double)n + (double)n3 * Math.cos(d2)));
            phylogenyNode.setYSecondary((float)((double)n2 + (double)n3 * Math.sin(d2)));
            this._urt_nodeid_angle_map.put(phylogenyNode.getId(), d2);
            d2 += Math.PI * 2 / (double)n4;
        }
        this.paintCircularsLite(phylogeny.getRoot(), phylogeny, n, n2, n3, graphics2D);
    }

    final void paintPhylogeny(Graphics2D graphics2D, boolean bl, boolean bl2, int n, int n2, int n3, int n4) {
        if (this._phylogeny == null || this._phylogeny.isEmpty()) {
            return;
        }
        if (this._control_panel.isShowSequenceRelations()) {
            this._query_sequence = this._control_panel.getSelectedQuerySequence();
        }
        if (!bl) {
            Rectangle rectangle = this.getVisibleRect();
            if (!this.getOptions().isBackgroundColorGradient() || this.getOptions().isPrintBlackAndWhite()) {
                graphics2D.setColor(this.getTreeColorSet().getBackgroundColor());
                if (!bl2) {
                    graphics2D.fill(rectangle);
                } else {
                    if (this.getOptions().isPrintBlackAndWhite()) {
                        graphics2D.setColor(Color.WHITE);
                    }
                    graphics2D.fillRect(n3, n4, n, n2);
                }
            } else if (!bl2) {
                graphics2D.setPaint(new GradientPaint(rectangle.x, rectangle.y, this.getTreeColorSet().getBackgroundColor(), rectangle.x, rectangle.y + rectangle.height, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                graphics2D.fill(rectangle);
            } else {
                graphics2D.setPaint(new GradientPaint(n3, n4, this.getTreeColorSet().getBackgroundColor(), n3, n4 + n2, this.getTreeColorSet().getBackgroundColorGradientBottom()));
                graphics2D.fillRect(n3, n4, n, n2);
            }
            this.setupStroke(graphics2D);
        } else {
            graphics2D.setStroke(new BasicStroke(this.getOptions().getPrintLineWidth()));
        }
        if (this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED && this.getPhylogenyGraphicsType() != Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            boolean bl3;
            this._external_node_index = 0;
            if (!this._phylogeny.isRooted()) {
                this._phylogeny.getRoot().setXcoord(20.0f);
            } else if (this._phylogeny.getRoot().getDistanceToParent() > 0.0 && this.getControlPanel().isDrawPhylogram()) {
                this._phylogeny.getRoot().setXcoord((float)(20.0 + this._phylogeny.getRoot().getDistanceToParent() * (double)this.getXcorrectionFactor()));
            } else {
                this._phylogeny.getRoot().setXcoord(20.0f + this.getXdistance());
            }
            this._phylogeny.getRoot().setYcoord(this.getYdistance() * (float)this._phylogeny.getRoot().getNumberOfExternalNodes() + 10.0f);
            int n5 = this.calcDynamicHidingFactor();
            if (this.getControlPanel().isDynamicallyHideData()) {
                if (n5 > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            if (this._nodes_in_preorder == null) {
                this._nodes_in_preorder = new PhylogenyNode[this._phylogeny.getNodeCount()];
                bl3 = false;
                PhylogenyNodeIterator phylogenyNodeIterator = this._phylogeny.iteratorPreorder();
                while (phylogenyNodeIterator.hasNext()) {
                    this._nodes_in_preorder[bl3++] = phylogenyNodeIterator.next();
                }
            }
            bl3 = n5 < 40 || bl2 || bl;
            for (PhylogenyNode phylogenyNode : this._nodes_in_preorder) {
                this.paintNodeRectangular(graphics2D, phylogenyNode, bl, this.getControlPanel().isDynamicallyHideData() && n5 > 1, n5, bl2, bl3);
            }
            if (this.getOptions().isShowScale() && this.getControlPanel().isDrawPhylogram() && this.getScaleDistance() > 0.0) {
                if (!bl2 && !bl) {
                    this.paintScale(graphics2D, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, bl, bl2);
                } else {
                    this.paintScale(graphics2D, n3, n4 + n2, bl, bl2);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !bl2 && !bl) {
                this.paintPhylogenyLite(graphics2D);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                this.getControlPanel().setDynamicHidingIsOn(false);
            }
            double d = this.getStartingAngle();
            boolean bl4 = this.getOptions().getNodeLabelDirection() == Options.NODE_LABEL_DIRECTION.RADIAL;
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData()) {
                this._dynamic_hiding_factor = (int)((double)this.getFontMetricsForLargeDefaultFont().getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / 62.83185307179586);
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintUnrooted(this._phylogeny.getRoot(), d, (float)(d + Math.PI * 2), bl4, graphics2D, bl, bl2);
            if (this.getOptions().isShowScale()) {
                if (!bl2 && !bl) {
                    this.paintScale(graphics2D, this.getVisibleRect().x, this.getVisibleRect().y + this.getVisibleRect().height, bl, bl2);
                } else {
                    this.paintScale(graphics2D, n3, n4 + n2, bl, bl2);
                }
            }
            if (this.getOptions().isShowOverview() && this.isOvOn() && !bl2 && !bl) {
                graphics2D.setColor(this.getTreeColorSet().getOvColor());
                this.paintUnrootedLite(this._phylogeny.getRoot(), d, d + Math.PI * 2, graphics2D, this.getUrtFactorOv() / ((float)this.getVisibleRect().width / this.getOvMaxWidth()));
                this.paintOvRectangle(graphics2D);
            }
        } else if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            int n6 = (int)(Math.min(this.getPreferredSize().getWidth(), this.getPreferredSize().getHeight()) / 2.0 - (double)(20 + this.getLongestExtNodeInfo()));
            int n7 = n6 + 20 + this.getLongestExtNodeInfo();
            this._dynamic_hiding_factor = 0;
            if (this.getControlPanel().isDynamicallyHideData() && n6 > 0) {
                this._dynamic_hiding_factor = (int)((double)this.getFontMetricsForLargeDefaultFont().getHeight() * 1.5 * (double)this.getPhylogeny().getNumberOfExternalNodes() / (Math.PI * 2 * (double)n6));
            }
            if (this.getControlPanel().getDynamicallyHideData() != null) {
                if (this._dynamic_hiding_factor > 1) {
                    this.getControlPanel().setDynamicHidingIsOn(true);
                } else {
                    this.getControlPanel().setDynamicHidingIsOn(false);
                }
            }
            this.paintCircular(this._phylogeny, this.getStartingAngle(), n7, n7, n6 > 0 ? n6 : 0, graphics2D, bl, bl2);
            if (this.getOptions().isShowOverview() && this.isOvOn() && !bl2 && !bl) {
                int n8 = (int)(this.getOvMaxHeight() < this.getOvMaxWidth() ? this.getOvMaxHeight() / 2.0f : this.getOvMaxWidth() / 2.0f);
                double d = 1.0;
                double d2 = 1.0;
                int n9 = this.getVisibleRect().x + this.getOvXPosition();
                int n10 = this.getVisibleRect().y + this.getOvYPosition();
                if (this.getWidth() > this.getHeight()) {
                    d = (double)this.getHeight() / (double)this.getWidth();
                    n9 = ForesterUtil.roundToInt((double)n9 / d);
                } else {
                    d2 = (double)this.getWidth() / (double)this.getHeight();
                    n10 = ForesterUtil.roundToInt((double)n10 / d2);
                }
                this._at = graphics2D.getTransform();
                graphics2D.scale(d, d2);
                this.paintCircularLite(this._phylogeny, this.getStartingAngle(), n9 + n8, n10 + n8, (int)((double)n8 - (double)this.getLongestExtNodeInfo() / ((double)this.getVisibleRect().width / this.getOvRectangle().getWidth())), graphics2D);
                graphics2D.setTransform(this._at);
                this.paintOvRectangle(graphics2D);
            }
        }
    }

    final void recalculateMaxDistanceToRoot() {
        this._max_distance_to_root = PhylogenyMethods.calculateMaxDistanceToRoot(this.getPhylogeny());
        if (this.getPhylogeny().getRoot().getDistanceToParent() > 0.0) {
            this._max_distance_to_root += this.getPhylogeny().getRoot().getDistanceToParent();
        }
    }

    final void removeAllEditNodeJFrames() {
        for (int i = 0; i <= 9; ++i) {
            if (this._node_frames[i] == null) continue;
            this._node_frames[i].dispose();
            this._node_frames[i] = null;
        }
        this._node_frame_index = 0;
    }

    final void removeEditNodeFrame(int n) {
        --this._node_frame_index;
        this._node_frames[n] = null;
        if (n < this._node_frame_index) {
            for (int i = 0; i < this._node_frame_index - 1; ++i) {
                this._node_frames[i] = this._node_frames[i + 1];
            }
            this._node_frames[this._node_frame_index] = null;
        }
    }

    final void reRoot(PhylogenyNode phylogenyNode) {
        if (!this.getPhylogeny().isRerootable()) {
            JOptionPane.showMessageDialog(this, "This is not rerootable", "Not rerootable", 2);
            return;
        }
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot reroot in unrooted display type", "Attempt to reroot tree in unrooted display", 2);
            return;
        }
        this.getPhylogeny().reRoot(phylogenyNode);
        this.getPhylogeny().recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setNodeInPreorderToNull();
        this.resetPreferredSize();
        this.getMainPanel().adjustJScrollPane();
        this.setEdited(true);
        this.repaint();
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.CIRCULAR) {
            this.getControlPanel().showWhole();
        }
    }

    final void resetNodeIdToDistToLeafMap() {
        this._nodeid_dist_to_leaf = new HashMap();
    }

    final void resetPreferredSize() {
        if (this.getPhylogeny() == null || this.getPhylogeny().isEmpty()) {
            return;
        }
        int n = 0;
        int n2 = 0;
        n2 = 20 + ForesterUtil.roundToInt(this.getYdistance() * (float)this.getPhylogeny().getRoot().getNumberOfExternalNodes() * 2.0f);
        n = this.getControlPanel().isDrawPhylogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt((double)this.getXcorrectionFactor() * this.getPhylogeny().calculateHeight(!this._options.isCollapsedWithAverageHeigh()) + (double)this.getXdistance()) : (!this.isNonLinedUpCladogram() ? 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(this.getPhylogeny().getRoot().getNumberOfExternalNodes() + 2)) : 20 + this.getLongestExtNodeInfo() + ForesterUtil.roundToInt(this.getXdistance() * (float)(PhylogenyMethods.calculateMaxDepth(this.getPhylogeny()) + 1)));
        this.setPreferredSize(new Dimension(n, n2));
    }

    final void selectNode(PhylogenyNode phylogenyNode) {
        if (this.getFoundNodes0() != null && this.getFoundNodes0().contains(phylogenyNode.getId())) {
            this.getFoundNodes0().remove(phylogenyNode.getId());
            this.getControlPanel().setSearchFoundCountsOnLabel0(this.getFoundNodes0().size());
            if (this.getFoundNodes0().size() < 1) {
                this.getControlPanel().searchReset0();
            }
        } else {
            this.getControlPanel().getSearchFoundCountsLabel0().setVisible(true);
            this.getControlPanel().getSearchResetButton0().setEnabled(true);
            this.getControlPanel().getSearchResetButton0().setVisible(true);
            if (this.getFoundNodes0() == null) {
                this.setFoundNodes0(new HashSet<Long>());
            }
            this.getFoundNodes0().add(phylogenyNode.getId());
            this.getControlPanel().setSearchFoundCountsOnLabel0(this.getFoundNodes0().size());
        }
    }

    final void setArrowCursor() {
        this.setCursor(ARROW_CURSOR);
        this.repaint();
    }

    final void setControlPanel(ControlPanel controlPanel) {
        this._control_panel = controlPanel;
    }

    void setCurrentExternalNodesDataBuffer(StringBuilder stringBuilder) {
        this.increaseCurrentExternalNodesDataBufferChangeCounter();
        this._current_external_nodes_data_buffer = stringBuilder;
    }

    final void setFoundNodes0(Set<Long> set) {
        this._found_nodes_0 = set;
    }

    final void setFoundNodes1(Set<Long> set) {
        this._found_nodes_1 = set;
    }

    final void setInOvRect(boolean bl) {
        this._in_ov_rect = bl;
    }

    final void setLargeFonts() {
        this.getTreeFontSet().largeFonts();
    }

    final void setLastMouseDragPointX(float f) {
        this._last_drag_point_x = f;
    }

    final void setLastMouseDragPointY(float f) {
        this._last_drag_point_y = f;
    }

    final void setMediumFonts() {
        this.getTreeFontSet().mediumFonts();
    }

    final void setNodeInPreorderToNull() {
        this._nodes_in_preorder = null;
    }

    final void setOvOn(boolean bl) {
        this._ov_on = bl;
    }

    final void setPhylogenyGraphicsType(Options.PHYLOGENY_GRAPHICS_TYPE pHYLOGENY_GRAPHICS_TYPE) {
        this._graphics_type = pHYLOGENY_GRAPHICS_TYPE;
        this.setTextAntialias();
    }

    final void setSmallFonts() {
        this.getTreeFontSet().smallFonts();
    }

    final void setStartingAngle(double d) {
        this._urt_starting_angle = d;
    }

    void setStatisticsForExpressionValues(DescriptiveStatistics descriptiveStatistics) {
        this._statistics_for_vector_data = descriptiveStatistics;
    }

    final void setSuperTinyFonts() {
        this.getTreeFontSet().superTinyFonts();
    }

    final void setTextAntialias() {
        if (this._phylogeny != null && !this._phylogeny.isEmpty()) {
            if (this._phylogeny.getNumberOfExternalNodes() <= 2000) {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            } else {
                this._rendering_hints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
            }
        }
        if (this.getMainPanel().getOptions().isAntialiasScreen()) {
            this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
        } else {
            this._rendering_hints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            this._rendering_hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    final void setTinyFonts() {
        this.getTreeFontSet().tinyFonts();
    }

    final void setTreeFile(File file) {
        this._treefile = file;
    }

    final void setXcorrectionFactor(float f) {
        this._x_correction_factor = f;
    }

    final void setXdistance(float f) {
        this._x_distance = f;
    }

    final void setYdistance(float f) {
        this._y_distance = f;
    }

    final void sortDescendants(PhylogenyNode phylogenyNode) {
        if (!phylogenyNode.isExternal()) {
            PhylogenyMethods.DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME;
            if (this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCode()) {
                dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY;
            } else if (this.getControlPanel().isShowSeqNames() || this.getControlPanel().isShowSeqSymbols() || this.getControlPanel().isShowGeneNames()) {
                dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.SEQUENCE;
            }
            PhylogenyMethods.sortNodeDescendents(phylogenyNode, dESCENDANT_SORT_PRIORITY);
            this.setNodeInPreorderToNull();
            this._phylogeny.externalNodesHaveChanged();
            this._phylogeny.clearHashIdToNodeMap();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.setEdited(true);
        }
        this.repaint();
    }

    final void subTree(PhylogenyNode phylogenyNode) {
        if (this.getPhylogenyGraphicsType() == Options.PHYLOGENY_GRAPHICS_TYPE.UNROOTED) {
            JOptionPane.showMessageDialog(this, "Cannot get a sub/super tree in unrooted display", "Attempt to get sub/super tree in unrooted display", 2);
            return;
        }
        if (phylogenyNode.isExternal()) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of a external node", "Attempt to get subtree of external node", 2);
            return;
        }
        if (phylogenyNode.isRoot() && !this.isCurrentTreeIsSubtree()) {
            JOptionPane.showMessageDialog(this, "Cannot get a subtree of the root node", "Attempt to get subtree of root node", 2);
            return;
        }
        this.setNodeInPreorderToNull();
        if (!phylogenyNode.isExternal() && !phylogenyNode.isRoot() && this._subtree_index <= 99) {
            this._sub_phylogenies[this._subtree_index] = this._phylogeny;
            this._sub_phylogenies_temp_roots[this._subtree_index] = phylogenyNode;
            ++this._subtree_index;
            this._phylogeny = TreePanelUtil.subTree(phylogenyNode, this._phylogeny);
            if (this._phylogeny.getRoot().isCollapse()) {
                this._phylogeny.getRoot().setCollapse(false);
            }
            this._phylogeny.externalNodesHaveChanged();
            this._phylogeny.clearHashIdToNodeMap();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.updateSubSuperTreeButton();
            this.getMainPanel().getControlPanel().search0();
            this.getMainPanel().getControlPanel().search1();
            this.resetRankCollapseRankValue();
            this.resetDepthCollapseDepthValue();
            this.getMainPanel().getControlPanel().updateDomainStructureEvaluethresholdDisplay();
            this.getMainPanel().getControlPanel().updateDepthCollapseDepthDisplay();
            this.getMainPanel().getControlPanel().updateRankCollapseRankDisplay();
        } else if (phylogenyNode.isRoot() && this.isCurrentTreeIsSubtree()) {
            this.superTree();
        }
        this._main_panel.getControlPanel().showWhole();
        this.repaint();
    }

    final void superTree() {
        this.setNodeInPreorderToNull();
        PhylogenyNode phylogenyNode = this._sub_phylogenies_temp_roots[this._subtree_index - 1];
        for (PhylogenyNode phylogenyNode2 : phylogenyNode.getDescendants()) {
            phylogenyNode2.setParent(phylogenyNode);
        }
        this._sub_phylogenies[this._subtree_index] = null;
        this._sub_phylogenies_temp_roots[this._subtree_index] = null;
        this._phylogeny = this._sub_phylogenies[--this._subtree_index];
        this._phylogeny.externalNodesHaveChanged();
        this._phylogeny.clearHashIdToNodeMap();
        this._phylogeny.recalculateNumberOfExternalDescendants(true);
        this.getMainPanel().getControlPanel().search0();
        this.getMainPanel().getControlPanel().search1();
        this.resetRankCollapseRankValue();
        this.resetDepthCollapseDepthValue();
        this.getMainPanel().getControlPanel().updateDomainStructureEvaluethresholdDisplay();
        this.getMainPanel().getControlPanel().updateDepthCollapseDepthDisplay();
        this.getMainPanel().getControlPanel().updateRankCollapseRankDisplay();
        this.updateSubSuperTreeButton();
    }

    final void orderSubtree(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal()) {
            return;
        }
        PhylogenyMethods.DESCENDANT_SORT_PRIORITY dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.NODE_NAME;
        if (this.getControlPanel().isShowTaxonomyScientificNames() || this.getControlPanel().isShowTaxonomyCode()) {
            dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.TAXONOMY;
        } else if (this.getControlPanel().isShowSeqNames() || this.getControlPanel().isShowSeqSymbols() || this.getControlPanel().isShowGeneNames()) {
            dESCENDANT_SORT_PRIORITY = PhylogenyMethods.DESCENDANT_SORT_PRIORITY.SEQUENCE;
        }
        PhylogenyMethods.orderAppearanceX(phylogenyNode, true, dESCENDANT_SORT_PRIORITY);
        this.setNodeInPreorderToNull();
        this.getPhylogeny().externalNodesHaveChanged();
        this.getPhylogeny().clearHashIdToNodeMap();
        this.getPhylogeny().recalculateNumberOfExternalDescendants(true);
        this.resetNodeIdToDistToLeafMap();
        this.setEdited(true);
        this.getControlPanel().displayedPhylogenyMightHaveChanged(true);
        this.repaint();
    }

    final void swap(PhylogenyNode phylogenyNode) {
        if (phylogenyNode.isExternal() || phylogenyNode.getNumberOfDescendants() < 2) {
            return;
        }
        if (phylogenyNode.getNumberOfDescendants() > 2) {
            JOptionPane.showMessageDialog(this, "Cannot swap descendants of nodes with more than 2 descendants", "Cannot swap descendants", 0);
            return;
        }
        if (!phylogenyNode.isExternal()) {
            phylogenyNode.swapChildren();
            this.setNodeInPreorderToNull();
            this._phylogeny.externalNodesHaveChanged();
            this._phylogeny.clearHashIdToNodeMap();
            this._phylogeny.recalculateNumberOfExternalDescendants(true);
            this.resetNodeIdToDistToLeafMap();
            this.setEdited(true);
        }
        this.repaint();
    }

    final void taxColor() {
        if (this._phylogeny == null || this._phylogeny.getNumberOfExternalNodes() < 2) {
            return;
        }
        this.setWaitCursor();
        TreePanelUtil.colorPhylogenyAccordingToExternalTaxonomy(this._phylogeny, this);
        this._control_panel.setColorBranches(true);
        if (this._control_panel.getUseVisualStylesCb() != null) {
            this._control_panel.getUseVisualStylesCb().setSelected(true);
        }
        this.setEdited(true);
        this.setArrowCursor();
        this.repaint();
    }

    final void updateOvSettings() {
        switch (this.getOptions().getOvPlacement()) {
            case LOWER_LEFT: {
                this.setOvXPosition(10);
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case LOWER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().height - 10) - this.getOvMaxHeight()));
                this.setOvYStart(ForesterUtil.roundToInt((float)this.getOvYPosition() + this.getOvMaxHeight() / 2.0f));
                break;
            }
            case UPPER_RIGHT: {
                this.setOvXPosition(ForesterUtil.roundToInt((float)(this.getVisibleRect().width - 10) - this.getOvMaxWidth()));
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
                break;
            }
            default: {
                this.setOvXPosition(10);
                this.setOvYPosition(10);
                this.setOvYStart(ForesterUtil.roundToInt(10.0f + this.getOvMaxHeight() / 2.0f));
            }
        }
    }

    final void updateOvSizes() {
        if ((double)this.getWidth() > 1.05 * (double)this.getVisibleRect().width || (double)this.getHeight() > 1.05 * (double)this.getVisibleRect().height) {
            this.setOvOn(true);
            float f = this.getLongestExtNodeInfo();
            float f2 = this.getOvMaxWidth() / (float)this.getWidth();
            int n = this._phylogeny.getRoot().getNumberOfExternalNodes();
            this.setOvYDistance(this.getOvMaxHeight() / (float)(2 * n));
            float f3 = 0.0f;
            f3 = !this.isNonLinedUpCladogram() ? (this.getOvMaxWidth() - f) / (float)n : (this.getOvMaxWidth() - (f *= f2)) / (float)PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            float f4 = (float)((double)this.getOvMaxWidth() / ((double)n * 2.0));
            if ((double)f3 < 0.0) {
                f3 = 0.0f;
            }
            if ((double)f4 < 0.0) {
                f4 = 0.0f;
            }
            this.setOvXDistance(f3);
            double d = this._phylogeny.calculateHeight(!this._options.isCollapsedWithAverageHeigh());
            if (d > 0.0) {
                float f5 = (float)((double)(this.getOvMaxWidth() - f - this.getOvXDistance()) / d);
                this.setOvXcorrectionFactor(f5 > 0.0f ? f5 : 0.0f);
            } else {
                this.setOvXcorrectionFactor(0.0f);
            }
        } else {
            this.setOvOn(false);
        }
    }

    void updateSetOfCollapsedExternalNodes() {
        Phylogeny phylogeny = this.getPhylogeny();
        this._collapsed_external_nodeid_set.clear();
        if (phylogeny != null) {
            PhylogenyNodeIterator phylogenyNodeIterator = phylogeny.iteratorExternalForward();
            block0: while (phylogenyNodeIterator.hasNext()) {
                PhylogenyNode phylogenyNode;
                PhylogenyNode phylogenyNode2 = phylogenyNode = phylogenyNodeIterator.next();
                while (!phylogenyNode2.isRoot()) {
                    if (phylogenyNode2.isCollapse()) {
                        this._collapsed_external_nodeid_set.add(phylogenyNode.getId());
                        phylogenyNode.setCollapse(true);
                        continue block0;
                    }
                    phylogenyNode2 = phylogenyNode2.getParent();
                }
            }
        }
    }

    final void updateSubSuperTreeButton() {
        if (this._subtree_index < 1) {
            this.getControlPanel().deactivateButtonToReturnToSuperTree();
        } else {
            this.getControlPanel().activateButtonToReturnToSuperTree(this._subtree_index);
        }
    }

    final void updateButtonToUncollapseAll() {
        if (PhylogenyMethods.isHasCollapsedNodes(this._phylogeny)) {
            this.getControlPanel().activateButtonToUncollapseAll();
        } else {
            this.getControlPanel().deactivateButtonToUncollapseAll();
        }
    }

    final void zoomInDomainStructure() {
        if (this._domain_structure_width < 2000.0) {
            this._domain_structure_width *= 1.2;
        }
    }

    final void zoomOutDomainStructure() {
        if (this._domain_structure_width > 20.0) {
            this._domain_structure_width *= 0.8;
        }
    }

    private static final void colorizeNodesHelper(Color color, PhylogenyNode phylogenyNode) {
        if (phylogenyNode.getNodeData().getNodeVisualData() == null) {
            phylogenyNode.getNodeData().setNodeVisualData(new NodeVisualData());
        }
        phylogenyNode.getNodeData().getNodeVisualData().setFontColor(new Color(color.getRed(), color.getGreen(), color.getBlue()));
    }

    private static final void drawString(String string, float f, float f2, Graphics2D graphics2D) {
        graphics2D.drawString(string, f, f2);
    }

    private final void drawStringX(String string, float f, float f2, Graphics2D graphics2D) {
        if (this.getAttributedStringMap() == null) {
            AttributedString attributedString = new AttributedString(string);
            attributedString.addAttribute(TextAttribute.FONT, graphics2D.getFont());
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 1, 3);
            attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, 3, 4);
            attributedString.addAttribute(TextAttribute.FOREGROUND, Color.BLUE, 1, 2);
            attributedString.addAttribute(TextAttribute.FOREGROUND, Color.PINK, 3, 5);
            attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, 2, 4);
            graphics2D.drawString(attributedString.getIterator(), f, f2);
        } else {
            graphics2D.drawString(string, f, f2);
        }
    }

    private final Map<String, AttributedString> getAttributedStringMap() {
        return this._attributed_string_map;
    }

    private final void setAttributedStringMap(Map<String, AttributedString> map) {
        this._attributed_string_map = map;
    }

    private static final boolean plusPressed(int n) {
        return n == 107 || n == 521 || n == 61 || n == 59 || n == 49;
    }

    public void decreaseDepthCollapseLevel() {
        if (this._phylogeny != null && this._phylogeny.getNumberOfExternalNodes() > 2) {
            if (this._depth_collapse_level <= 1) {
                this._depth_collapse_level = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
                this.uncollapseAll();
            } else {
                --this._depth_collapse_level;
                PhylogenyMethods.collapseToDepth(this._phylogeny, this._depth_collapse_level);
            }
        }
    }

    public void increaseDepthCollapseLevel() {
        if (this._phylogeny != null && this._phylogeny.getNumberOfExternalNodes() > 2) {
            int n = PhylogenyMethods.calculateMaxDepth(this._phylogeny);
            this._depth_collapse_level = this._depth_collapse_level >= n ? 1 : ++this._depth_collapse_level;
            PhylogenyMethods.collapseToDepth(this._phylogeny, this._depth_collapse_level);
        }
    }

    public void decreaseRankCollapseLevel() {
        String[] stringArray;
        if (this._phylogeny != null && this._phylogeny.getNumberOfExternalNodes() > 2 && (stringArray = PhylogenyMethods.obtainPresentRanksSorted(this._phylogeny)).length > 1) {
            if (this._rank_collapse_level <= 0) {
                this._rank_collapse_level = stringArray.length - 1;
                this.uncollapseAll();
            } else {
                --this._rank_collapse_level;
                PhylogenyMethods.collapseToRank(this._phylogeny, TreePanel.mapToAbsoluteRankLevel(stringArray, this._rank_collapse_level));
            }
        }
    }

    public void increaseRankCollapseLevel() {
        String[] stringArray;
        if (this._phylogeny != null && this._phylogeny.getNumberOfExternalNodes() > 2 && (stringArray = PhylogenyMethods.obtainPresentRanksSorted(this._phylogeny)).length > 1) {
            if (this._rank_collapse_level >= stringArray.length - 1) {
                this._rank_collapse_level = 0;
                PhylogenyMethods.collapseToRank(this._phylogeny, TreePanel.mapToAbsoluteRankLevel(stringArray, this._rank_collapse_level));
            } else if (this._rank_collapse_level == stringArray.length - 2) {
                ++this._rank_collapse_level;
                this.uncollapseAll();
            } else {
                ++this._rank_collapse_level;
                PhylogenyMethods.collapseToRank(this._phylogeny, TreePanel.mapToAbsoluteRankLevel(stringArray, this._rank_collapse_level));
            }
        }
    }

    private static final int mapToAbsoluteRankLevel(String[] stringArray, int n) {
        String string = stringArray[n];
        if (!TaxonomyUtil.RANK_TO_INT.containsKey(string)) {
            throw new IllegalStateException("unexpected exception: cannot find rank " + string);
        }
        return TaxonomyUtil.RANK_TO_INT.get(string);
    }

    private final void uncollapseAll() {
        PreorderTreeIterator preorderTreeIterator = new PreorderTreeIterator(this._phylogeny);
        while (preorderTreeIterator.hasNext()) {
            preorderTreeIterator.next().setCollapse(false);
        }
    }

    final int resetDepthCollapseDepthValue() {
        this._depth_collapse_level = -1;
        return -1;
    }

    final int getDepthCollapseDepthValue() {
        return this._depth_collapse_level;
    }

    final void setDepthCollapseDepthValue(int n) {
        this._depth_collapse_level = n;
    }

    final int resetRankCollapseRankValue() {
        this._rank_collapse_level = -1;
        return -1;
    }

    final int getRankCollapseRankValue() {
        return this._rank_collapse_level;
    }

    final void setRankCollapseRankValue(int n) {
        this._rank_collapse_level = n;
    }

    static {
        POPUP_FONT = new Font(Configuration.getDefaultFontFamilyName(), 0, 12);
        STROKE_0025 = new BasicStroke(0.025f);
        STROKE_005 = new BasicStroke(0.05f);
        STROKE_01 = new BasicStroke(0.1f);
        STROKE_025 = new BasicStroke(0.25f);
        STROKE_05 = new BasicStroke(0.5f);
        STROKE_075 = new BasicStroke(0.75f);
        STROKE_1 = new BasicStroke(1.0f);
        STROKE_2 = new BasicStroke(2.0f);
        STROKE_01_DASHED = new BasicStroke(0.1f, 2, 1, 0.0f, new float[]{2.0f}, 0.0f);
        STROKE_005_DASHED = new BasicStroke(0.05f, 2, 1, 0.0f, new float[]{2.0f}, 0.0f);
        STROKE_001_DASHED = new BasicStroke(0.01f, 2, 1, 0.0f, new float[]{2.0f}, 0.0f);
        SHOW_ONLY_THIS_CONF_TYPE = null;
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        FORMATTER_CONFIDENCE = new DecimalFormat("#.###", decimalFormatSymbols);
        FORMATTER_BRANCH_LENGTH = new DecimalFormat("#.###", decimalFormatSymbols);
    }

    private final class SubtreeColorizationActionListener
    implements ActionListener {
        List<PhylogenyNode> _additional_nodes = null;
        JColorChooser _chooser = null;
        PhylogenyNode _node = null;

        SubtreeColorizationActionListener(JColorChooser jColorChooser, PhylogenyNode phylogenyNode) {
            this._chooser = jColorChooser;
            this._node = phylogenyNode;
        }

        SubtreeColorizationActionListener(JColorChooser jColorChooser, PhylogenyNode phylogenyNode, List<PhylogenyNode> list) {
            this._chooser = jColorChooser;
            this._node = phylogenyNode;
            this._additional_nodes = list;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Color color = this._chooser.getColor();
            if (color != null) {
                TreePanel.this.colorizeSubtree(color, this._node, this._additional_nodes);
            }
        }
    }

    private final class NodeColorizationActionListener
    implements ActionListener {
        List<PhylogenyNode> _additional_nodes = null;
        JColorChooser _chooser = null;
        PhylogenyNode _node = null;

        NodeColorizationActionListener(JColorChooser jColorChooser, PhylogenyNode phylogenyNode) {
            this._chooser = jColorChooser;
            this._node = phylogenyNode;
        }

        NodeColorizationActionListener(JColorChooser jColorChooser, PhylogenyNode phylogenyNode, List<PhylogenyNode> list) {
            this._chooser = jColorChooser;
            this._node = phylogenyNode;
            this._additional_nodes = list;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Color color = this._chooser.getColor();
            if (color != null) {
                TreePanel.this.colorizeNodes(color, this._node, this._additional_nodes);
            }
        }
    }
}

