/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.forester.go.PfamToGoMapping;
import org.forester.go.PfamToGoParser;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public class pfam_go {
    private static final String ALLOW_DUPLICATES_OPTION = "d";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String PRG_NAME = "pfam_go";
    private static final String PRG_VERSION = "1.10";
    private static final String PRG_DATE = "2011.06.26";
    private static final String E_MAIL = "czmasek@burnham.org";
    private static final String WWW = "www.phylosoft.org";

    private static void process(File file, List<PfamToGoMapping> list, boolean bl) throws IOException {
        BufferedReader bufferedReader = ForesterUtil.obtainReader(file);
        String string = "";
        int n = 0;
        int n2 = 0;
        AbstractCollection abstractCollection = null;
        abstractCollection = bl ? new ArrayList() : new HashSet();
        while ((string = bufferedReader.readLine()) != null) {
            if (ForesterUtil.isEmpty(string = string.trim()) || string.startsWith("##")) continue;
            if (string.startsWith("#")) {
                abstractCollection.clear();
                string = string.replace('#', '>');
                System.out.println(string);
                continue;
            }
            if (bl || !abstractCollection.contains(string)) {
                abstractCollection.add(string);
                boolean bl2 = false;
                for (PfamToGoMapping pfamToGoMapping : list) {
                    if (!pfamToGoMapping.getKey().equals(string)) continue;
                    System.out.println(pfamToGoMapping.getValue());
                    bl2 = true;
                }
                if (bl2) {
                    ++n;
                    continue;
                }
                ++n2;
                continue;
            }
            System.err.println("# duplicate domain: " + string);
        }
        System.out.println("# pfams with mapping to GO   : " + n);
        System.out.println("# pfams without mapping to GO: " + n2);
        bufferedReader.close();
    }

    public static void main(String[] stringArray) {
        String string;
        CommandLineArguments commandLineArguments = null;
        try {
            commandLineArguments = new CommandLineArguments(stringArray);
        }
        catch (Exception exception) {
            ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
        }
        if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2) || stringArray.length == 0) {
            pfam_go.printHelp();
            System.exit(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(ALLOW_DUPLICATES_OPTION);
        if (commandLineArguments.getNumberOfNames() != 2 && commandLineArguments.getNumberOfNames() != 3) {
            pfam_go.printHelp();
            System.exit(-1);
        }
        if ((string = commandLineArguments.validateAllowedOptionsAsString(arrayList)).length() > 0) {
            ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
        }
        File file = commandLineArguments.getFile(0);
        File file2 = commandLineArguments.getFile(1);
        boolean bl = false;
        if (commandLineArguments.isOptionSet(ALLOW_DUPLICATES_OPTION)) {
            bl = true;
        }
        PfamToGoParser pfamToGoParser = new PfamToGoParser(file);
        List<PfamToGoMapping> list = null;
        try {
            list = pfamToGoParser.parse();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            pfam_go.process(file2, list, bl);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.out.println();
    }

    private static void printHelp() {
        ForesterUtil.printProgramInformation(PRG_NAME, PRG_VERSION, PRG_DATE, E_MAIL, WWW);
        System.out.println("Usage:");
        System.out.println();
        System.out.println("pfam_go [-d to allow duplicates] <pfam2go file> <file with pfams>");
        System.out.println();
        System.out.println();
    }
}

