/*
 * Decompiled with CFR 0.152.
 */
package org.forester.application;

import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.forester.clade_analysis.AnalysisSingle;
import org.forester.clade_analysis.ResultSingle;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.util.CommandLineArguments;
import org.forester.util.ForesterUtil;

public final class cladinatorOLD {
    private static final String PRG_NAME = "cladinator";
    private static final String PRG_VERSION = "0.101";
    private static final String PRG_DATE = "170810";
    private static final String PRG_DESC = "clades within clades -- analysis of pplacer type outputs";
    private static final String E_MAIL = "phyloxml@gmail.com";
    private static final String WWW = "https://sites.google.com/site/cmzmasek/home/software/forester";
    private static final String HELP_OPTION_1 = "help";
    private static final String HELP_OPTION_2 = "h";
    private static final String SEP_OPTION = "s";
    private static final DecimalFormat df2 = new DecimalFormat("0.0#");

    public static void main(String[] stringArray) {
        try {
            Object object;
            ForesterUtil.printProgramInformation(PRG_NAME, PRG_DESC, PRG_VERSION, PRG_DATE, E_MAIL, WWW, ForesterUtil.getForesterLibraryInformation());
            CommandLineArguments commandLineArguments = null;
            try {
                commandLineArguments = new CommandLineArguments(stringArray);
            }
            catch (Exception exception) {
                ForesterUtil.fatalError(PRG_NAME, exception.getMessage());
            }
            if (commandLineArguments.isOptionSet(HELP_OPTION_1) || commandLineArguments.isOptionSet(HELP_OPTION_2)) {
                System.out.println();
                cladinatorOLD.print_help();
                System.exit(0);
            } else if (stringArray.length != 2 && stringArray.length != 3) {
                System.out.println();
                System.out.println("Wrong number of arguments.");
                System.out.println();
                cladinatorOLD.print_help();
                System.exit(-1);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(SEP_OPTION);
            String string = commandLineArguments.validateAllowedOptionsAsString(arrayList);
            if (string.length() > 0) {
                ForesterUtil.fatalError(PRG_NAME, "unknown option(s): " + string);
            }
            String string2 = commandLineArguments.isOptionSet(SEP_OPTION) ? commandLineArguments.getOptionValue(SEP_OPTION) : null;
            File file = commandLineArguments.getFile(0);
            String string3 = commandLineArguments.getName(1);
            System.out.println("Input tree: " + file);
            System.out.println("Query     : " + string3);
            if (!ForesterUtil.isEmpty(string2)) {
                System.out.println("Separator : " + string2);
            } else {
                System.out.println("Separator : none");
            }
            Phylogeny phylogeny = null;
            try {
                object = ParserBasedPhylogenyFactory.getInstance();
                PhylogenyParser phylogenyParser = ParserUtils.createParserDependingOnFileType(file, true);
                phylogeny = object.create(file, phylogenyParser)[0];
            }
            catch (IOException iOException) {
                System.out.println("\nCould not read \"" + file + "\" [" + iOException.getMessage() + "]\n");
                System.exit(-1);
            }
            object = AnalysisSingle.execute(phylogeny, string3, string2);
            System.out.println();
            System.out.println("Result:");
            System.out.println("Query                        : " + string3);
            System.out.print("Greatest Common Prefix       : " + ((ResultSingle)object).getGreatestCommonPrefix());
            if (!ForesterUtil.isEmpty(((ResultSingle)object).getGreatestCommonPrefix()) && !ForesterUtil.isEmpty(((ResultSingle)object).getGreatestCommonCladeSubtreeConfidence())) {
                System.out.println("\t(" + ((ResultSingle)object).getGreatestCommonCladeSubtreeConfidence() + ")");
            } else {
                System.out.println();
            }
            System.out.print("Greatest Common Prefix Up    : " + ((ResultSingle)object).getGreatestCommonPrefixUp());
            if (!ForesterUtil.isEmpty(((ResultSingle)object).getGreatestCommonPrefixUp()) && !ForesterUtil.isEmpty(((ResultSingle)object).getGreatestCommonCladeUpSubtreeConfidence())) {
                System.out.println("\t(" + ((ResultSingle)object).getGreatestCommonCladeUpSubtreeConfidence() + ")");
            } else {
                System.out.println();
            }
            System.out.print("Greatest Common Prefix Down  : " + ((ResultSingle)object).getGreatestCommonPrefixDown());
            if (!ForesterUtil.isEmpty(((ResultSingle)object).getGreatestCommonPrefixDown()) && !ForesterUtil.isEmpty(((ResultSingle)object).getGreatestCommonCladeDownSubtreeConfidence())) {
                System.out.println("\t(" + ((ResultSingle)object).getGreatestCommonCladeDownSubtreeConfidence() + ")");
            } else {
                System.out.println();
            }
            System.out.println("Least Encompassing Clade size: " + ((ResultSingle)object).getLeastEncompassingCladeSize() + " external nodes");
            double d = 100.0 * (double)((ResultSingle)object).getLeastEncompassingCladeSize() / (double)((ResultSingle)object).getTreeSize();
            System.out.println("Least Encompassing Clade size: " + df2.format(d) + "%");
            System.out.println("Total tree size              : " + ((ResultSingle)object).getTreeSize() + " external nodes");
            if (((ResultSingle)object).getWarnings().size() > 0) {
                System.out.println("Warnings:");
                for (String string4 : ((ResultSingle)object).getWarnings()) {
                    System.out.println(string4);
                }
            }
            System.out.println();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ForesterUtil.fatalError(PRG_NAME, illegalArgumentException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            ForesterUtil.fatalError(PRG_NAME, "Unexpected errror!");
        }
    }

    private static final void print_help() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("cladinator [options] <gene tree file> <query>");
        System.out.println();
        System.out.println(" options:");
        System.out.println("  -s=<separator>: the separator to be used");
        System.out.println();
        System.out.println("Example:");
        System.out.println();
        System.out.println(" cladinator -s=. my_tree.xml A.1.1.1");
        System.out.println();
    }
}

