/*
 * Decompiled with CFR 0.152.
 */
package com.approximatrix.charting.render;

import com.approximatrix.charting.coordsystem.CoordSystem;
import com.approximatrix.charting.model.ChartDataModel;
import com.approximatrix.charting.model.ScatterDataModel;
import com.approximatrix.charting.render.AbstractChartRenderer;
import com.approximatrix.charting.render.RowColorModel;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class ScatterChartRenderer
extends AbstractChartRenderer {
    protected double shapeSize = 10.0;

    public ScatterChartRenderer(CoordSystem cs, ChartDataModel model) {
        super(cs, model);
    }

    @Override
    public boolean renderChart(Graphics2D g) {
        ScatterDataModel m = (ScatterDataModel)this.getChartDataModel();
        RowColorModel rcm = this.getRowColorModel();
        AffineTransform yaxis1 = this.getTransform(0);
        int datasetcount = m.getDataSetNumber();
        int set = 0;
        while (set < datasetcount && !this.getStopFlag()) {
            if (m.getSeriesLine(set)) {
                this.drawline(m, rcm, yaxis1, set, g);
            }
            if (m.getSeriesMarker(set)) {
                this.drawmarkers(m, rcm, yaxis1, set, g);
            }
            ++set;
        }
        boolean completed = !this.getStopFlag();
        this.resetStopFlag();
        return completed;
    }

    private void drawline(ScatterDataModel m, RowColorModel rcm, AffineTransform yaxis1, int set, Graphics2D g) {
        Point2D paint = null;
        Point2D oldpaint = null;
        boolean numericalcolumns = m.isColumnNumeric();
        float modelVal = 0.0f;
        int value = 0;
        while (value < m.getDataSetLength(set)) {
            modelVal = m.getValueAt(set, value).floatValue();
            if (modelVal != modelVal || modelVal == Float.NEGATIVE_INFINITY || modelVal == Float.POSITIVE_INFINITY) {
                oldpaint = null;
            } else {
                Point2D.Float val = numericalcolumns ? new Point2D.Float(((Number)m.getColumnValueAt(set, value)).floatValue(), modelVal) : new Point2D.Float(value, modelVal);
                oldpaint = paint;
                if (yaxis1.transform(val, null) != null) {
                    paint = yaxis1.transform(val, null);
                    g.setColor(rcm.getColor(set));
                    if (oldpaint != null) {
                        g.drawLine((int)oldpaint.getX(), (int)oldpaint.getY(), (int)paint.getX(), (int)paint.getY());
                    }
                }
            }
            ++value;
        }
    }

    private void drawmarkers(ScatterDataModel m, RowColorModel rcm, AffineTransform yaxis1, int set, Graphics2D g) {
        Point2D.Float paint = new Point2D.Float(0.0f, 0.0f);
        boolean numericalcolumns = m.isColumnNumeric();
        float modelVal = 0.0f;
        int value = 0;
        while (value < m.getDataSetLength(set)) {
            modelVal = m.getValueAt(set, value).floatValue();
            if (modelVal == modelVal) {
                Point2D.Float val = numericalcolumns ? new Point2D.Float(((Number)m.getColumnValueAt(set, value)).floatValue(), modelVal) : new Point2D.Float(value, modelVal);
                yaxis1.transform(val, paint);
                if (paint != null) {
                    g.setColor(rcm.getColor(set));
                    RectangularShape shape = rcm.getShape(set);
                    shape.setFrame(((Point2D)paint).getX() - this.shapeSize / 2.0, ((Point2D)paint).getY() - this.shapeSize / 2.0, this.shapeSize, this.shapeSize);
                    g.fill(shape);
                }
            }
            ++value;
        }
    }
}

