/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.external.PushToApplication;

public class PushToApplicationAction
extends AbstractAction
implements Runnable {
    private PushToApplication operation;
    private JabRefFrame frame;
    private BasePanel panel;
    private BibtexEntry[] entries;

    public PushToApplicationAction(JabRefFrame frame, PushToApplication operation) {
        this.frame = frame;
        this.putValue("SmallIcon", operation.getIcon());
        this.putValue("Name", operation.getName());
        this.putValue("ShortDescription", operation.getTooltip());
        if (operation.getKeyStrokeName() != null) {
            this.putValue("AcceleratorKey", Globals.prefs.getKey(operation.getKeyStrokeName()));
        }
        this.operation = operation;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.panel = this.frame.basePanel();
        if (this.panel == null) {
            return;
        }
        this.entries = this.panel.getSelectedEntries();
        if (this.entries.length == 0) {
            JOptionPane.showMessageDialog(this.frame, Globals.lang("This operation requires one or more entries to be selected."), (String)this.getValue("Name"), 0);
            return;
        }
        if (this.operation.requiresBibtexKeys()) {
            for (int i = 0; i < this.entries.length; ++i) {
                if (this.entries[i].getCiteKey() != null && this.entries[i].getCiteKey().trim().length() != 0) continue;
                JOptionPane.showMessageDialog(this.frame, Globals.lang("This operation requires all selected entries to have BibTex keys defined."), (String)this.getValue("Name"), 0);
                return;
            }
        }
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        this.operation.pushEntries(this.panel.database(), this.entries, this.getKeyString(this.entries), this.panel.metaData());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PushToApplicationAction.this.operation.operationCompleted(PushToApplicationAction.this.panel);
            }
        });
    }

    protected String getKeyString(BibtexEntry[] entries) {
        StringBuffer result = new StringBuffer();
        String citeKey = "";
        boolean first = true;
        for (int i = 0; i < entries.length; ++i) {
            BibtexEntry bes = entries[i];
            citeKey = bes.getField("bibtexkey");
            if (citeKey == null || citeKey.equals("")) continue;
            if (first) {
                result.append(citeKey);
                first = false;
                continue;
            }
            result.append(",").append(citeKey);
        }
        return result.toString();
    }
}

