/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.CallBack;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;
import spin.Spin;

public class DuplicateSearch
extends Thread {
    BasePanel panel;
    BibtexEntry[] bes;
    final Vector<BibtexEntry[]> duplicates = new Vector();
    boolean autoRemoveExactDuplicates = false;

    public DuplicateSearch(BasePanel bp) {
        this.panel = bp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        final NamedCompound ce = new NamedCompound(Globals.lang("duplicate removal"));
        int duplicateCounter = 0;
        this.autoRemoveExactDuplicates = false;
        this.panel.output(Globals.lang("Searching for duplicates..."));
        Object[] keys = this.panel.database.getKeySet().toArray();
        if (keys == null || keys.length < 2) {
            return;
        }
        this.bes = new BibtexEntry[keys.length];
        for (int i = 0; i < keys.length; ++i) {
            this.bes[i] = this.panel.database.getEntryById((String)keys[i]);
        }
        SearcherThread st = new SearcherThread();
        st.setPriority(1);
        st.start();
        int current = 0;
        final ArrayList<BibtexEntry> toRemove = new ArrayList<BibtexEntry>();
        while (!st.finished() || current < this.duplicates.size()) {
            if (current >= this.duplicates.size()) {
                Vector<BibtexEntry[]> vector = this.duplicates;
                synchronized (vector) {
                    try {
                        this.duplicates.wait();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            BibtexEntry[] be = this.duplicates.get(current);
            ++current;
            if (toRemove.contains(be[0]) || toRemove.contains(be[1])) continue;
            boolean askAboutExact = false;
            if (DuplicateCheck.compareEntriesStrictly(be[0], be[1]) > 1.0) {
                if (this.autoRemoveExactDuplicates) {
                    toRemove.add(be[1]);
                    ++duplicateCounter;
                    continue;
                }
                askAboutExact = true;
            }
            DuplicateCallBack cb = new DuplicateCallBack(this.panel.frame, be[0], be[1], askAboutExact ? 4 : 1);
            ((CallBack)Spin.over(cb)).update();
            ++duplicateCounter;
            int answer = cb.getSelected();
            if (answer == 1 || answer == 3) {
                toRemove.add(be[1]);
                if (answer != 3) continue;
                this.autoRemoveExactDuplicates = true;
                continue;
            }
            if (answer == 2) {
                toRemove.add(be[0]);
                continue;
            }
            if (answer != 5) continue;
            st.setFinished();
            current = Integer.MAX_VALUE;
            --duplicateCounter;
        }
        final int dupliC = duplicateCounter;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (toRemove.size() > 0) {
                    for (BibtexEntry entry : toRemove) {
                        DuplicateSearch.this.panel.database.removeEntry(entry.getId());
                        ce.addEdit(new UndoableRemoveEntry(DuplicateSearch.this.panel.database, entry, DuplicateSearch.this.panel));
                    }
                    DuplicateSearch.this.panel.markBaseChanged();
                }
                DuplicateSearch.this.panel.output(Globals.lang("Duplicate pairs found") + ": " + DuplicateSearch.this.duplicates.size() + " " + Globals.lang("pairs processed") + ": " + dupliC);
                ce.end();
                DuplicateSearch.this.panel.undoManager.addEdit(ce);
            }
        });
    }

    class DuplicateCallBack
    implements CallBack {
        private int reply = -1;
        DuplicateResolverDialog diag;
        private JabRefFrame frame;
        private BibtexEntry one;
        private BibtexEntry two;
        private int dialogType;

        public DuplicateCallBack(JabRefFrame frame, BibtexEntry one, BibtexEntry two, int dialogType) {
            this.frame = frame;
            this.one = one;
            this.two = two;
            this.dialogType = dialogType;
        }

        public int getSelected() {
            return this.reply;
        }

        @Override
        public void update() {
            this.diag = new DuplicateResolverDialog(this.frame, this.one, this.two, this.dialogType);
            this.diag.setVisible(true);
            this.diag.dispose();
            this.reply = this.diag.getSelected();
        }
    }

    class SearcherThread
    extends Thread {
        private boolean finished = false;

        SearcherThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            for (int i = 0; i < DuplicateSearch.this.bes.length - 1 && !this.finished; ++i) {
                for (int j = i + 1; j < DuplicateSearch.this.bes.length && !this.finished; ++j) {
                    boolean eq = DuplicateCheck.isDuplicate(DuplicateSearch.this.bes[i], DuplicateSearch.this.bes[j]);
                    if (!eq) continue;
                    Vector<BibtexEntry[]> vector = DuplicateSearch.this.duplicates;
                    synchronized (vector) {
                        DuplicateSearch.this.duplicates.add(new BibtexEntry[]{DuplicateSearch.this.bes[i], DuplicateSearch.this.bes[j]});
                        DuplicateSearch.this.duplicates.notifyAll();
                        continue;
                    }
                }
            }
            this.finished = true;
            Vector<BibtexEntry[]> vector = DuplicateSearch.this.duplicates;
            synchronized (vector) {
                DuplicateSearch.this.duplicates.notifyAll();
            }
        }

        public boolean finished() {
            return this.finished;
        }

        public void setFinished() {
            this.finished = true;
        }
    }
}

